/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.OperationListener;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SafeStAXStreamBuilderKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0001/BO\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u0004\u0018\u00010\u0012J\u000e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001aJ\n\u0010(\u001a\u0004\u0018\u00010)H\u0014J\u0018\u0010*\u001a\u00020\u001e2\u000e\u0010+\u001a\n\u0018\u00010,j\u0004\u0018\u0001`-H\u0002J\b\u0010.\u001a\u00020\u0005H\u0016R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001b\u00a8\u00060"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "file", "Ljava/nio/file/Path;", "fileSpec", "", "rootElementName", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "listener", "Lcom/intellij/configurationStore/OperationListener;", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;Lcom/intellij/configurationStore/OperationListener;)V", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "blockSaving", "value", "getFile", "()Ljava/nio/file/Path;", "isUseXmlProlog", "", "()Z", "isUseUnixLineSeparator", "setFile", "", "virtualFile", "ioFileIfChanged", "createSaveSession", "Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSessionProducer;", "states", "Lcom/intellij/configurationStore/StateMap;", "getVirtualFile", "preloadStorageData", "isEmpty", "loadLocalData", "Lorg/jdom/Element;", "processReadException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "toString", "FileSaveSessionProducer", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFileBasedStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileBasedStorage.kt\ncom/intellij/configurationStore/FileBasedStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,369:1\n60#2,5:370\n60#2,5:375\n*S KotlinDebug\n*F\n+ 1 FileBasedStorage.kt\ncom/intellij/configurationStore/FileBasedStorage\n*L\n165#1:370,5\n170#1:375,5\n*E\n"})
public abstract class FileBasedStorage
extends XmlElementStorage {
    @Nullable
    private volatile VirtualFile cachedVirtualFile;
    @Nullable
    private LineSeparator lineSeparator;
    @Nullable
    private String blockSaving;
    @NotNull
    private volatile Path file;

    public FileBasedStorage(@NotNull Path file, @NotNull String fileSpec, @Nullable String rootElementName, @Nullable PathMacroSubstitutor pathMacroManager, @NotNull RoamingType roamingType, @Nullable StreamProvider provider, @Nullable OperationListener listener) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        super(fileSpec, rootElementName, pathMacroManager, roamingType, provider, listener);
        this.file = file;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode() && StringsKt.startsWith$default((CharSequence)((Object)file).toString(), (char)'$', (boolean)false, (int)2, null)) {
            throw new AssertionError((Object)("It seems like some macros were not expanded for path: " + file));
        }
    }

    public /* synthetic */ FileBasedStorage(Path path, String string, String string2, PathMacroSubstitutor pathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, OperationListener operationListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            pathMacroSubstitutor = null;
        }
        if ((n & 0x20) != 0) {
            streamProvider = null;
        }
        if ((n & 0x40) != 0) {
            operationListener = null;
        }
        this(path, string, string2, pathMacroSubstitutor, roamingType, streamProvider, operationListener);
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    protected boolean isUseXmlProlog() {
        return false;
    }

    private final boolean isUseUnixLineSeparator() {
        return !this.isUseXmlProlog();
    }

    public final void setFile(@Nullable VirtualFile virtualFile, @Nullable Path ioFileIfChanged) {
        this.cachedVirtualFile = virtualFile;
        if (ioFileIfChanged != null) {
            this.file = ioFileIfChanged;
        }
    }

    @Override
    @NotNull
    protected FileSaveSessionProducer createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        return new FileSaveSessionProducer(states, this);
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        VirtualFile result = this.cachedVirtualFile;
        if (result == null && (result = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(this.file)) != null && result.isValid()) {
            result.setCharset(Charsets.UTF_8, null, false);
            this.cachedVirtualFile = result;
        }
        return result;
    }

    public final void preloadStorageData(boolean isEmpty) {
        if (isEmpty) {
            this.storageDataRef.set(StateMap.EMPTY);
        } else {
            this.getStorageData();
        }
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        this.blockSaving = null;
        try {
            BasicFileAttributes attributes = null;
            try {
                attributes = Files.readAttributes(this.file, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (NoSuchFileException noSuchFileException) {
                Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Document was not loaded for " + this.fileSpec + ", doesn't exist", t$iv);
                }
                return null;
            }
            if (!attributes.isRegularFile()) {
                Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Document was not loaded for " + this.fileSpec + ", not a file", t$iv);
                }
                return null;
            }
            if (attributes.size() == 0L) {
                this.processReadException(null);
                return null;
            }
            if (this.isUseUnixLineSeparator()) {
                this.lineSeparator = LineSeparator.LF;
                return SafeStAXStreamBuilderKt.buildNsUnawareJdom((Path)this.file);
            }
            Pair<Element, LineSeparator> pair = FileBasedStorageKt.loadDataAndDetectLineSeparator(this.file);
            Element element = (Element)pair.component1();
            LineSeparator separator = (LineSeparator)pair.component2();
            LineSeparator lineSeparator = separator;
            if (lineSeparator == null) {
                LineSeparator lineSeparator2 = this.isUseXmlProlog() ? LineSeparator.getSystemLineSeparator() : LineSeparator.LF;
                Intrinsics.checkNotNull((Object)lineSeparator2);
                lineSeparator = lineSeparator2;
            }
            this.lineSeparator = lineSeparator;
            return element;
        }
        catch (JDOMException e) {
            this.processReadException((Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            this.processReadException(e);
        }
        catch (IOException e) {
            this.processReadException(e);
        }
        return null;
    }

    private final void processReadException(Exception e) {
        Application app;
        this.blockSaving = e != null && (Intrinsics.areEqual((Object)this.fileSpec, (Object)"$PROJECT_FILE$") || StringsKt.startsWith$default((String)this.fileSpec, (String)"$PROJECT_CONFIG_DIR$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this.fileSpec, (Object)"$MODULE_FILE$") || Intrinsics.areEqual((Object)this.fileSpec, (Object)"$WORKSPACE_FILE$")) ? e.toString() : null;
        if (e != null) {
            ComponentStoreImplKt.LOG.warn("Cannot read " + this, (Throwable)e);
        }
        if (!(app = ApplicationManager.getApplication()).isUnitTestMode() && !app.isHeadlessEnvironment()) {
            Exception exception = e;
            String reason = exception != null ? exception.getMessage() : ConfigurationStoreBundle.message("notification.load.settings.error.reason.truncated", new Object[0]);
            Object[] objectArray = this.blockSaving == null ? ConfigurationStoreBundle.message("notification.load.settings.action.content.will.be.recreated", new Object[0]) : ConfigurationStoreBundle.message("notification.load.settings.action.please.correct.file.content", new Object[0]);
            Intrinsics.checkNotNull((Object)objectArray);
            Object[] action = objectArray;
            objectArray = new Object[]{this.file};
            new Notification("System Messages", ConfigurationStoreBundle.message("notification.load.settings.title", new Object[0]), ConfigurationStoreBundle.message("notification.load.settings.content", objectArray) + ": " + reason + "\n" + (String)action, NotificationType.WARNING).notify(null);
        }
    }

    @NotNull
    public String toString() {
        return "FileBasedStorage(file=" + this.file + ", fileSpec=" + this.fileSpec + ", isBlockSavingTheContent=" + this.blockSaving + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0015\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0014J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSessionProducer;", "Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSessionProducer;", "Lcom/intellij/configurationStore/FileBasedStorage;", "storageData", "Lcom/intellij/configurationStore/StateMap;", "storage", "<init>", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/FileBasedStorage;)V", "isSaveAllowed", "", "remove", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "saveLocally", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "getOrCacheLineSeparator", "Lcom/intellij/util/LineSeparator;", "intellij.platform.configurationStore.impl"})
    @ApiStatus.Internal
    protected static class FileSaveSessionProducer
    extends XmlElementStorage.XmlElementStorageSaveSessionProducer<FileBasedStorage> {
        public FileSaveSessionProducer(@NotNull StateMap storageData, @NotNull FileBasedStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storageData, (String)"storageData");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            super(storageData, (XmlElementStorage)storage);
        }

        @Override
        protected final boolean isSaveAllowed() {
            boolean bl;
            if (!super.isSaveAllowed()) {
                bl = false;
            } else if (((FileBasedStorage)this.storage).blockSaving != null) {
                ComponentStoreImplKt.LOG.warn("Save blocked for " + this.storage);
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }

        @Override
        protected void remove(@Nullable List<VFileEvent> events) {
            VirtualFile virtualFile = events == null ? null : ((FileBasedStorage)this.storage).getVirtualFile();
            Files.deleteIfExists(((FileBasedStorage)this.storage).getFile());
            ((FileBasedStorage)this.storage).cachedVirtualFile = null;
            if (events != null && virtualFile != null && virtualFile.isValid()) {
                events.add((VFileEvent)new VFileDeleteEvent((Object)this, virtualFile));
            }
        }

        @Override
        protected void saveLocally(@NotNull DataWriter dataWriter, @Nullable List<VFileEvent> events) {
            Intrinsics.checkNotNullParameter((Object)dataWriter, (String)"dataWriter");
            LineSeparator lineSeparator = this.getOrCacheLineSeparator();
            VirtualFile virtualFile = events == null ? null : ((FileBasedStorage)this.storage).getVirtualFile();
            FileBasedStorageKt.writeFile(((FileBasedStorage)this.storage).getFile(), (StorageManagerFileWriteRequestor)this, dataWriter, lineSeparator, ((FileBasedStorage)this.storage).isUseXmlProlog());
            if (events != null) {
                if (virtualFile == null) {
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(((FileBasedStorage)this.storage).getFile().getParent());
                    if (virtualFile2 != null) {
                        VirtualFile dir = virtualFile2;
                        boolean bl = false;
                        events.add((VFileEvent)FileBasedStorageKt.creationEvent(((FileBasedStorage)this.storage).getFile(), dir));
                    }
                } else {
                    events.add((VFileEvent)FileBasedStorageKt.updatingEvent(((FileBasedStorage)this.storage).getFile(), virtualFile));
                }
            }
        }

        private final LineSeparator getOrCacheLineSeparator() {
            LineSeparator lineSeparator = ((FileBasedStorage)this.storage).lineSeparator;
            if (lineSeparator == null) {
                LineSeparator lineSeparator2;
                if (((FileBasedStorage)this.storage).isUseUnixLineSeparator()) {
                    lineSeparator2 = LineSeparator.LF;
                } else {
                    LineSeparator lineSeparator3 = LineSeparator.getSystemLineSeparator();
                    lineSeparator2 = lineSeparator3;
                    Intrinsics.checkNotNullExpressionValue((Object)lineSeparator3, (String)"getSystemLineSeparator(...)");
                }
                lineSeparator = lineSeparator2;
                ((FileBasedStorage)this.storage).lineSeparator = lineSeparator;
            }
            return lineSeparator;
        }
    }
}

