/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.defaults;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.platform.backend.workspace.GlobalWorkspaceModelCache;
import com.intellij.util.ApplicationKt;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\n\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/configurationStore/defaults/DefaultSettingsHelper;", "", "<init>", "()V", "restoreDefaultSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "confirmRestoringDefaultSettings", "", "confirmRestoringDefaultSettingsOnFrontendAndBackend", "remoteBackupPath", "", "initiateRestoringDefaultSettings", "restart", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "confirmRestoringDefaultSettingsImpl", "message", "getNextBackupPath", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
public final class DefaultSettingsHelper {
    @NotNull
    public static final DefaultSettingsHelper INSTANCE = new DefaultSettingsHelper();

    private DefaultSettingsHelper() {
    }

    public final void restoreDefaultSettings(@Nullable Project project) {
        if (this.confirmRestoringDefaultSettings(project)) {
            this.initiateRestoringDefaultSettings();
            DefaultSettingsHelper.restart$default(this, null, 1, null);
        }
    }

    public final boolean confirmRestoringDefaultSettings(@Nullable Project project) {
        Object[] objectArray = new Object[]{this.getNextBackupPath()};
        String string = ConfigurationStoreBundle.message("restore.default.settings.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.confirmRestoringDefaultSettingsImpl(project, string);
    }

    public final boolean confirmRestoringDefaultSettingsOnFrontendAndBackend(@Nullable Project project, @NotNull String remoteBackupPath) {
        Intrinsics.checkNotNullParameter((Object)remoteBackupPath, (String)"remoteBackupPath");
        Object[] objectArray = new Object[]{this.getNextBackupPath(), remoteBackupPath};
        String string = ConfigurationStoreBundle.message("restore.default.settings.confirmation.message.controller", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.confirmRestoringDefaultSettingsImpl(project, string);
    }

    public final void initiateRestoringDefaultSettings() {
        block0: {
            CustomConfigMigrationOption.writeConfigMarkerFile$default((CustomConfigMigrationOption)((CustomConfigMigrationOption)CustomConfigMigrationOption.StartWithCleanConfig.INSTANCE), null, (int)1, null);
            GlobalWorkspaceModelCache globalWorkspaceModelCache = GlobalWorkspaceModelCache.Companion.getInstance();
            if (globalWorkspaceModelCache == null) break block0;
            globalWorkspaceModelCache.invalidateCaches();
        }
    }

    public final void restart(@NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        ApplicationKt.getApplication().invokeLater(DefaultSettingsHelper::restart$lambda$0, modalityState);
    }

    public static /* synthetic */ void restart$default(DefaultSettingsHelper defaultSettingsHelper, ModalityState modalityState, int n, Object object) {
        if ((n & 1) != 0) {
            ModalityState modalityState2 = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"defaultModalityState(...)");
            modalityState = modalityState2;
        }
        defaultSettingsHelper.restart(modalityState);
    }

    private final boolean confirmRestoringDefaultSettingsImpl(Project project, @NlsContexts.DialogMessage String message) {
        String string = ApplicationManager.getApplication().isRestartCapable() ? ConfigurationStoreBundle.message("restore.default.settings.confirmation.button.restart", new Object[0]) : ConfigurationStoreBundle.message("restore.default.settings.confirmation.button.shutdown", new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        String restartButtonText = string;
        return Messages.showYesNoDialog((Project)project, (String)message, (String)ConfigurationStoreBundle.message("restore.default.settings.confirmation.title", new Object[0]), (String)restartButtonText, (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon()) == 0;
    }

    private final String getNextBackupPath() {
        Path path = PathManager.getOriginalConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getOriginalConfigDir(...)");
        return ((Object)ConfigBackup.Companion.getNextBackupPath$default((ConfigBackup.Companion)ConfigBackup.Companion, (Path)path, null, (int)2, null)).toString();
    }

    private static final void restart$lambda$0() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        ((ApplicationEx)application).restart(true);
    }
}

