/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStore;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0013\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0096\u0002J\u001b\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010$H\u0096\u0002J#\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010$2\u0006\u0010)\u001a\u00020\u000bH\u0096\u0002J\u0018\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0+2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010,\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0002\u0010-J\u0018\u0010.\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0015\"\u0004\b\u0018\u0010\u0019R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\r\u00a8\u0006/"}, d2={"Lcom/intellij/ide/passwordSafe/impl/BasePasswordSafe;", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "settings", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "getSettings", "()Lcom/intellij/credentialStore/PasswordSafeSettings;", "value", "", "isRememberPasswordByDefault", "()Z", "setRememberPasswordByDefault", "(Z)V", "_currentProvider", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/intellij/credentialStore/CredentialStore;", "currentProviderIfComputed", "getCurrentProviderIfComputed", "()Lcom/intellij/credentialStore/CredentialStore;", "currentProvider", "getCurrentProvider", "setCurrentProvider", "(Lcom/intellij/credentialStore/CredentialStore;)V", "closeCurrentStore", "", "isSave", "isEvenMemoryOnly", "createMainKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "memoryHelperProvider", "Lkotlin/Lazy;", "isMemoryOnly", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "credentials", "memoryOnly", "getAsync", "Lorg/jetbrains/concurrency/Promise;", "save", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isPasswordStoredOnlyInMemory", "intellij.platform.credentialStore.impl"})
@ApiStatus.Internal
public abstract class BasePasswordSafe
extends PasswordSafe {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final SynchronizedClearableLazy<CredentialStore> _currentProvider;
    @NotNull
    private final Lazy<CredentialStore> memoryHelperProvider;

    public BasePasswordSafe(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this._currentProvider = new SynchronizedClearableLazy(() -> BasePasswordSafe._currentProvider$lambda$0(this));
        this.memoryHelperProvider = LazyKt.lazy(BasePasswordSafe::memoryHelperProvider$lambda$0);
    }

    @NotNull
    protected abstract PasswordSafeSettings getSettings();

    public boolean isRememberPasswordByDefault() {
        return this.getSettings().getState().isRememberPasswordByDefault();
    }

    public void setRememberPasswordByDefault(boolean value) {
        this.getSettings().getState().setRememberPasswordByDefault(value);
    }

    private final CredentialStore getCurrentProviderIfComputed() {
        return this._currentProvider.isInitialized() ? (CredentialStore)this._currentProvider.getValue() : null;
    }

    @NotNull
    public final CredentialStore getCurrentProvider() {
        return (CredentialStore)this._currentProvider.getValue();
    }

    public final void setCurrentProvider(@NotNull CredentialStore value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._currentProvider.setValue((Object)value);
    }

    public final void closeCurrentStore(boolean isSave, boolean isEvenMemoryOnly) {
        CredentialStore credentialStore = this.getCurrentProviderIfComputed();
        if (credentialStore == null) {
            return;
        }
        CredentialStore store = credentialStore;
        if (!isEvenMemoryOnly && store instanceof InMemoryCredentialStore) {
            return;
        }
        this._currentProvider.drop();
        if (isSave && store instanceof KeePassCredentialStore) {
            try {
                ((KeePassCredentialStore)store).save(this.createMainKeyEncryptionSpec());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                PasswordSafeImplKt.access$getLOG().warn((Throwable)e);
            }
        } else if (store instanceof Closeable) {
            ((Closeable)store).close();
        }
    }

    private final EncryptionSpec createMainKeyEncryptionSpec() {
        String pgpKey = this.getSettings().getState().getPgpKeyId();
        return pgpKey == null ? new EncryptionSpec(EncryptionSupportKt.getDefaultEncryptionType(), null) : new EncryptionSpec(EncryptionType.PGP_KEY, pgpKey);
    }

    public boolean isMemoryOnly() {
        return this.getSettings().getProviderType() == ProviderType.MEMORY_ONLY;
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        SlowOperations.assertNonCancelableSlowOperationsAreAllowed();
        Credentials value = this.getCurrentProvider().get(attributes);
        if ((value == null || (charSequence = (CharSequence)value.getPassword()) == null || charSequence.length() == 0) && this.memoryHelperProvider.isInitialized() && (charSequence = ((CredentialStore)this.memoryHelperProvider.getValue()).get(attributes)) != null) {
            CharSequence it = charSequence;
            boolean bl = false;
            return it;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        SlowOperations.assertNonCancelableSlowOperationsAreAllowed();
        this.getCurrentProvider().set(attributes, credentials);
        if (attributes.isPasswordMemoryOnly()) {
            Credentials credentials2 = credentials;
            CharSequence charSequence = (CharSequence)(credentials2 != null ? credentials2.getPassword() : null);
            if (!(charSequence == null || charSequence.length() == 0)) {
                ((CredentialStore)this.memoryHelperProvider.getValue()).set(new CredentialAttributes(attributes.getServiceName(), attributes.getUserName()), credentials);
                return;
            }
        }
        if (!this.memoryHelperProvider.isInitialized()) return;
        ((CredentialStore)this.memoryHelperProvider.getValue()).set(attributes, null);
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials, boolean memoryOnly) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (memoryOnly) {
            ((CredentialStore)this.memoryHelperProvider.getValue()).set(attributes.isPasswordMemoryOnly() ? new CredentialAttributes(attributes.getServiceName(), attributes.getUserName()) : attributes, credentials);
            this.getCurrentProvider().set(attributes, null);
        } else {
            this.set(attributes, credentials);
        }
    }

    @NotNull
    public Promise<Credentials> getAsync(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return Promises.asPromise((CompletableFuture)FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Credentials>, Object>(this, attributes, null){
            int label;
            final /* synthetic */ BasePasswordSafe this$0;
            final /* synthetic */ CredentialAttributes $attributes;
            {
                this.this$0 = $receiver;
                this.$attributes = $attributes;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return this.this$0.get(this.$attributes);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Credentials> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null)));
    }

    @Nullable
    public final Object save(@NotNull Continuation<? super Unit> $completion) {
        CredentialStore credentialStore = this.getCurrentProviderIfComputed();
        KeePassCredentialStore keePassCredentialStore = credentialStore instanceof KeePassCredentialStore ? (KeePassCredentialStore)credentialStore : null;
        if (keePassCredentialStore == null) {
            return Unit.INSTANCE;
        }
        KeePassCredentialStore keePassCredentialStore2 = keePassCredentialStore;
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(keePassCredentialStore2, this, null){
            int label;
            final /* synthetic */ KeePassCredentialStore $keePassCredentialStore;
            final /* synthetic */ BasePasswordSafe this$0;
            {
                this.$keePassCredentialStore = $keePassCredentialStore;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$keePassCredentialStore.save(BasePasswordSafe.access$createMainKeyEncryptionSpec(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public boolean isPasswordStoredOnlyInMemory(@NotNull CredentialAttributes attributes, @NotNull Credentials credentials) {
        boolean bl;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        if (this.isMemoryOnly() || (charSequence = (CharSequence)credentials.getPassword()) == null || charSequence.length() == 0) {
            return true;
        }
        if (!this.memoryHelperProvider.isInitialized()) {
            return false;
        }
        Credentials credentials2 = ((CredentialStore)this.memoryHelperProvider.getValue()).get(attributes);
        if (credentials2 != null) {
            Credentials it = credentials2;
            boolean bl2 = false;
            CharSequence charSequence2 = (CharSequence)it.getPassword();
            bl = !(charSequence2 == null || charSequence2.length() == 0);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final CredentialStore _currentProvider$lambda$0(BasePasswordSafe this$0) {
        return PasswordSafeImplKt.access$computeProvider(this$0.getSettings());
    }

    private static final InMemoryCredentialStore memoryHelperProvider$lambda$0() {
        return new InMemoryCredentialStore();
    }

    public static final /* synthetic */ EncryptionSpec access$createMainKeyEncryptionSpec(BasePasswordSafe $this) {
        return $this.createMainKeyEncryptionSpec();
    }
}

