/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.KWallet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.text.StringKt;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.errors.NoReply;
import org.freedesktop.dbus.errors.ServiceUnknown;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\fH\u0002J%\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0082\bJ\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0002J\u001b\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/credentialStore/KWalletCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "Ljava/io/Closeable;", "connection", "Lorg/freedesktop/dbus/connections/impl/DBusConnection;", "kWallet", "Lcom/intellij/credentialStore/KWallet;", "<init>", "(Lorg/freedesktop/dbus/connections/impl/DBusConnection;Lcom/intellij/credentialStore/KWallet;)V", "appId", "", "cachedWalletId", "", "cachedWalletName", "suggestedCreation", "getWalletId", "handleError", "", "run", "Lkotlin/Function0;", "handle", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "credentials", "close", "Companion", "intellij.platform.credentialStore.impl"})
@SourceDebugExtension(value={"SMAP\nlinuxKWalletLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 linuxKWalletLibrary.kt\ncom/intellij/credentialStore/KWalletCredentialStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n76#1,7:134\n76#1,7:141\n1#2:133\n*S KotlinDebug\n*F\n+ 1 linuxKWalletLibrary.kt\ncom/intellij/credentialStore/KWalletCredentialStore\n*L\n85#1:134,7\n97#1:141,7\n*E\n"})
public final class KWalletCredentialStore
implements CredentialStore,
Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DBusConnection connection;
    @NotNull
    private final KWallet kWallet;
    @NotNull
    private final String appId;
    private int cachedWalletId;
    @Nullable
    private String cachedWalletName;
    @Nullable
    private String suggestedCreation;

    private KWalletCredentialStore(DBusConnection connection, KWallet kWallet) {
        this.connection = connection;
        this.kWallet = kWallet;
        this.appId = KWalletCredentialStore.Companion.appName();
        this.cachedWalletId = -1;
    }

    private final int getWalletId() {
        boolean isNew;
        String walletName;
        if (this.cachedWalletId != -1 && this.kWallet.isOpen(this.cachedWalletId)) {
            boolean bl;
            String string = this.cachedWalletName;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = this.kWallet.users(it).contains(this.appId);
            } else {
                bl = false;
            }
            if (bl) {
                return this.cachedWalletId;
            }
        }
        this.cachedWalletName = walletName = this.kWallet.localWallet();
        List<String> wallets = this.kWallet.wallets();
        boolean bl = isNew = !CollectionsKt.contains((Iterable)wallets, (Object)walletName);
        if (walletName == null || isNew && Intrinsics.areEqual((Object)this.suggestedCreation, (Object)walletName)) {
            return -1;
        }
        this.cachedWalletId = this.kWallet.open(walletName, 0L, this.appId);
        if (isNew) {
            this.suggestedCreation = walletName;
        }
        return this.cachedWalletId;
    }

    private final void handleError(Function0<Unit> run, Function0<Unit> handle) {
        boolean $i$f$handleError = false;
        try {
            run.invoke();
        }
        catch (NoReply noReply) {
            handle.invoke();
        }
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        KWalletCredentialStore this_$iv = this;
        boolean $i$f$handleError = false;
        try {
            boolean bl = false;
            int walletId = this.getWalletId();
            if (walletId == -1) {
                return CredentialAttributesKt.getACCESS_TO_KEY_CHAIN_DENIED();
            }
            String userName = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
            String string = attributes.getServiceName();
            String string2 = userName;
            if (string2 == null) {
                string2 = "*";
            }
            Map<String, Variant<String>> passwords = this.kWallet.readPasswordList(walletId, string, string2, this.appId);
            Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((Iterable)passwords.entrySet());
            if (entry == null) {
                return null;
            }
            Map.Entry e = entry;
            return new Credentials((String)e.getKey(), (String)((Variant)e.getValue()).getValue());
        }
        catch (NoReply noReply) {
            boolean bl = false;
            return CredentialAttributesKt.getCANNOT_UNLOCK_KEYCHAIN();
        }
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        KWalletCredentialStore this_$iv = this;
        boolean $i$f$handleError = false;
        try {
            String accountName;
            boolean bl = false;
            int walletId = this.getWalletId();
            if (walletId == -1) {
                return;
            }
            String string = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
            if (string == null) {
                Credentials credentials2 = credentials;
                string = accountName = credentials2 != null ? credentials2.getUserName() : null;
            }
            if (CredentialAttributesKt.isEmpty((Credentials)credentials)) {
                this.kWallet.removeFolder(walletId, attributes.getServiceName(), this.appId);
            } else {
                Object object;
                String string2 = attributes.getServiceName();
                String string3 = accountName;
                if (string3 == null) {
                    string3 = "";
                }
                if ((object = credentials) == null || (object = object.getPassword()) == null || (object = object.toString()) == null) {
                    object = "";
                }
                this.kWallet.writePassword(walletId, string2, string3, (String)object, this.appId);
            }
        }
        catch (NoReply noReply) {
            boolean bl = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Closeable closeable = (Closeable)this.connection;
        Throwable throwable = null;
        try {
            DBusConnection it = (DBusConnection)closeable;
            boolean bl = false;
            if (this.cachedWalletId != -1) {
                this.kWallet.close(this.cachedWalletId, false, this.appId);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public /* synthetic */ KWalletCredentialStore(DBusConnection connection, KWallet kWallet, DefaultConstructorMarker $constructor_marker) {
        this(connection, kWallet);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/credentialStore/KWalletCredentialStore$Companion;", "", "<init>", "()V", "appName", "", "create", "Lcom/intellij/credentialStore/KWalletCredentialStore;", "intellij.platform.credentialStore.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String appName() {
            Application app = ApplicationManager.getApplication();
            String appName = app == null || app.isUnitTestMode() ? null : ApplicationInfo.getInstance().getFullApplicationName();
            String string = appName;
            if (string == null) {
                string = "IDEA tests";
            }
            return string;
        }

        @Nullable
        public final KWalletCredentialStore create() {
            try {
                DBusConnection connection = DBusConnectionBuilder.forSessionBus().build();
                try {
                    KWallet wallet = (KWallet)connection.getRemoteObject("org.kde.kwalletd5", "/modules/kwalletd5", KWallet.class, true);
                    wallet.localWallet();
                    Intrinsics.checkNotNull((Object)connection);
                    Intrinsics.checkNotNull((Object)wallet);
                    return new KWalletCredentialStore(connection, wallet, null);
                }
                catch (ServiceUnknown e) {
                    CredentialStoreKt.getLOG().info("No KWallet service", (Throwable)e);
                }
                catch (DBusException e) {
                    CredentialStoreKt.getLOG().warn("Failed to connect to KWallet", (Throwable)e);
                }
                catch (RuntimeException e) {
                    CredentialStoreKt.getLOG().warn("Failed to connect to KWallet", (Throwable)e);
                }
                connection.close();
            }
            catch (DBusException e) {
                CredentialStoreKt.getLOG().warn("Failed to connect to D-Bus", (Throwable)e);
            }
            catch (RuntimeException e) {
                CredentialStoreKt.getLOG().warn("Failed to connect to D-Bus", (Throwable)e);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

