/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxEntryKt;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.credentialStore.kdbx.ProtectedValueKt;
import com.intellij.credentialStore.kdbx.SecureString;
import com.intellij.credentialStore.kdbx.StringProtectedByStreamCipher;
import com.intellij.credentialStore.kdbx.UnsavedProtectedValue;
import com.intellij.util.text.StringKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J$\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0011H\u0002J\b\u0010%\u001a\u00020&H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R(\u0010\u0017\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R(\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0010\u001a\u0004\u0018\u00010\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxEntry;", "", "entryElement", "Lorg/jdom/Element;", "database", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "group", "Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "<init>", "(Lorg/jdom/Element;Lcom/intellij/credentialStore/kdbx/KeePassDatabase;Lcom/intellij/credentialStore/kdbx/KdbxGroup;)V", "getEntryElement$intellij_platform_credentialStore_impl", "()Lorg/jdom/Element;", "getGroup$intellij_platform_credentialStore_impl", "()Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "setGroup$intellij_platform_credentialStore_impl", "(Lcom/intellij/credentialStore/kdbx/KdbxGroup;)V", "value", "", "title", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "userName", "getUserName", "setUserName", "getProperty", "propertyName", "setProperty", "Lcom/intellij/credentialStore/kdbx/SecureString;", "password", "getPassword", "()Lcom/intellij/credentialStore/kdbx/SecureString;", "setPassword", "(Lcom/intellij/credentialStore/kdbx/SecureString;)V", "getOrCreatePropertyElement", "name", "touch", "", "intellij.platform.credentialStore.impl"})
public final class KdbxEntry {
    @NotNull
    private final Element entryElement;
    @NotNull
    private final KeePassDatabase database;
    @Nullable
    private volatile KdbxGroup group;

    public KdbxEntry(@NotNull Element entryElement, @NotNull KeePassDatabase database, @Nullable KdbxGroup group) {
        Intrinsics.checkNotNullParameter((Object)entryElement, (String)"entryElement");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.entryElement = entryElement;
        this.database = database;
        this.group = group;
    }

    @NotNull
    public final Element getEntryElement$intellij_platform_credentialStore_impl() {
        return this.entryElement;
    }

    @Nullable
    public final KdbxGroup getGroup$intellij_platform_credentialStore_impl() {
        return this.group;
    }

    public final void setGroup$intellij_platform_credentialStore_impl(@Nullable KdbxGroup kdbxGroup) {
        this.group = kdbxGroup;
    }

    @Nullable
    public final String getTitle() {
        return this.getProperty("Title");
    }

    public final void setTitle(@Nullable String value) {
        this.setProperty(this.entryElement, value, "Title");
    }

    @Nullable
    public final String getUserName() {
        return this.getProperty("UserName");
    }

    public final void setUserName(@Nullable String value) {
        this.setProperty(this.entryElement, value, "UserName");
    }

    private final synchronized String getProperty(String propertyName) {
        Element valueElement;
        Element element = KdbxEntryKt.access$getPropertyElement(this.entryElement, propertyName);
        Object object = valueElement = element != null ? element.getChild("Value") : null;
        if (valueElement == null) {
            return null;
        }
        String value = StringKt.nullize$default((String)valueElement.getText(), (boolean)false, (int)1, null);
        if (ProtectedValueKt.isValueProtected(valueElement)) {
            throw new UnsupportedOperationException(propertyName + " protection is not supported");
        }
        return value;
    }

    private final synchronized Element setProperty(Element entryElement, String value, String propertyName) {
        Element valueElement;
        String normalizedValue = StringKt.nullize$default((String)value, (boolean)false, (int)1, null);
        Element propertyElement = KdbxEntryKt.access$getPropertyElement(entryElement, propertyName);
        if (propertyElement == null) {
            if (normalizedValue == null) {
                return null;
            }
            propertyElement = KdbxEntryKt.access$createPropertyElement(entryElement, propertyName);
        }
        if (Intrinsics.areEqual((Object)StringKt.nullize$default((String)(valueElement = propertyElement.getOrCreateChild("Value")).getText(), (boolean)false, (int)1, null), (Object)normalizedValue)) {
            return null;
        }
        valueElement.setText(value);
        if (entryElement == this.entryElement) {
            this.touch();
        }
        return valueElement;
    }

    @Nullable
    public final synchronized SecureString getPassword() {
        Element element = KdbxEntryKt.access$getPropertyElement(this.entryElement, "Password");
        if (element == null || (element = element.getChild("Value")) == null) {
            return null;
        }
        Element valueElement = element;
        List list = valueElement.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Content content = (Content)CollectionsKt.firstOrNull((List)list);
        if (content == null) {
            return null;
        }
        Content value = content;
        if (value instanceof SecureString) {
            return (SecureString)value;
        }
        valueElement.setAttribute("Protected", "True");
        String string = value.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        UnsavedProtectedValue result = new UnsavedProtectedValue(this.database.protectValue$intellij_platform_credentialStore_impl(string));
        valueElement.setContent((Content)result);
        return result;
    }

    public final synchronized void setPassword(@Nullable SecureString value) {
        if (value == null) {
            Iterator iterator;
            Iterator iterator2 = iterator = this.entryElement.getChildren("String").iterator();
            while (iterator2.hasNext()) {
                Element element = (Element)iterator2.next();
                if (!Intrinsics.areEqual((Object)element.getChildText("Key"), (Object)"Password")) continue;
                iterator.remove();
                this.touch();
            }
            return;
        }
        Element valueElement = this.getOrCreatePropertyElement("Password").getOrCreateChild("Value");
        valueElement.setAttribute("Protected", "True");
        List list = valueElement.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Content oldValue = (Content)CollectionsKt.firstOrNull((List)list);
        if (oldValue == value) {
            return;
        }
        valueElement.setContent((Content)new UnsavedProtectedValue((StringProtectedByStreamCipher)value));
        this.touch();
    }

    private final Element getOrCreatePropertyElement(String name) {
        Element element = KdbxEntryKt.access$getPropertyElement(this.entryElement, name);
        if (element == null) {
            element = KdbxEntryKt.access$createPropertyElement(this.entryElement, name);
        }
        return element;
    }

    private final synchronized void touch() {
        this.entryElement.getOrCreateChild("Times").getOrCreateChild("LastModificationTime").setText(KeePassDatabaseKt.formattedNow());
        this.database.setDirty$intellij_platform_credentialStore_impl(true);
    }
}

