/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupport;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.keePass.MainKey;
import com.intellij.credentialStore.keePass.MainKeyKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0006\u0010\u0010\u001a\u00020\u000fR\u0010\u0010\u0002\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/credentialStore/keePass/MainKeyFileStorage;", "", "passwordFile", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "load", "", "decryptMainKey", "data", "save", "", "key", "Lcom/intellij/credentialStore/keePass/MainKey;", "readMainKeyIsAutoGeneratedMetadata", "", "isAutoGenerated", "intellij.platform.credentialStore.impl"})
public final class MainKeyFileStorage {
    @JvmField
    @NotNull
    public final Path passwordFile;

    public MainKeyFileStorage(@NotNull Path passwordFile) {
        Intrinsics.checkNotNullParameter((Object)passwordFile, (String)"passwordFile");
        this.passwordFile = passwordFile;
    }

    @Nullable
    public final byte[] load() {
        byte[] data = null;
        boolean isOld = false;
        try {
            byte[] byArray = Files.readAllBytes(this.passwordFile);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            data = byArray;
        }
        catch (NoSuchFileException noSuchFileException) {
            try {
                Path path = this.passwordFile.getParent().resolve("pdb.pwd");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                byte[] byArray = Files.readAllBytes(path);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                data = byArray;
            }
            catch (NoSuchFileException noSuchFileException2) {
                return null;
            }
            isOld = true;
        }
        try {
            byte[] decrypted = null;
            if (isOld) {
                decrypted = EncryptionSupportKt.createBuiltInOrCrypt32EncryptionSupport(SystemInfo.isWindows).decrypt(data);
                ArraysKt.fill$default((byte[])data, (byte)0, (int)0, (int)0, (int)6, null);
            } else {
                byte[] byArray = this.decryptMainKey(data);
                if (byArray == null) {
                    return null;
                }
                decrypted = byArray;
            }
            ArraysKt.fill$default((byte[])data, (byte)0, (int)0, (int)0, (int)6, null);
            return decrypted;
        }
        catch (Exception e) {
            CredentialStoreKt.getLOG().warn("Cannot decrypt main key, file content:\n" + (isOld ? Base64.getEncoder().encodeToString(data) : new String(data, Charsets.UTF_8)), (Throwable)e);
            return null;
        }
    }

    private final byte[] decryptMainKey(byte[] data) {
        EncryptionType encryptionType = null;
        byte[] value = null;
        for (NodeTuple node : MainKeyKt.access$createMainKeyReader(data)) {
            String propertyValue;
            Node keyNode = node.getKeyNode();
            Node valueNode = node.getValueNode();
            if (!(keyNode instanceof ScalarNode) || !(valueNode instanceof ScalarNode) || ((ScalarNode)valueNode).getValue() == null) continue;
            String string = ((ScalarNode)keyNode).getValue();
            if (Intrinsics.areEqual((Object)string, (Object)"encryption")) {
                String string2 = propertyValue.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                encryptionType = EncryptionType.valueOf(string2);
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"value")) continue;
            value = Base64.getDecoder().decode(propertyValue);
        }
        if (encryptionType == null) {
            CredentialStoreKt.getLOG().error("encryption type not specified in " + this.passwordFile + ", default one will be used (file content:\n" + new String(data, Charsets.UTF_8) + ")");
            encryptionType = EncryptionSupportKt.getDefaultEncryptionType();
        }
        if (value == null) {
            CredentialStoreKt.getLOG().error("password not specified in " + this.passwordFile + ", automatically generated will be used (file content:\n" + new String(data, Charsets.UTF_8) + ")");
            return null;
        }
        return EncryptionSupportKt.createEncryptionSupport(new EncryptionSpec(encryptionType, null)).decrypt(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@Nullable MainKey key) {
        Closeable it;
        if (key == null) {
            PathKt.delete$default((Path)this.passwordFile, (boolean)false, (int)1, null);
            return;
        }
        Base64.Encoder encoder = Base64.getEncoder();
        EncryptionSupport encryptionSupport = EncryptionSupportKt.createEncryptionSupport(key.getEncryptionSpec());
        byte[] byArray = key.getValue();
        Intrinsics.checkNotNull((Object)byArray);
        byte[] encodedValue = encoder.encode(encryptionSupport.encrypt(byArray));
        key.clear();
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        EncryptionType encryptionType = key.getEncryptionSpec().getType();
        Closeable closeable = (OutputStream)out;
        Object object = Charsets.UTF_8;
        closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        object = null;
        try {
            it = (OutputStreamWriter)closeable;
            boolean bl = false;
            ((OutputStreamWriter)it).append("encryption: ").append(encryptionType.name()).append('\n');
            ((OutputStreamWriter)it).append("isAutoGenerated: ").append(String.valueOf(key.isAutoGenerated())).append('\n');
            it = ((OutputStreamWriter)it).append("value: !!binary ");
        }
        catch (Throwable bl) {
            object = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        closeable = PathKt.safeOutputStream((Path)this.passwordFile);
        object = null;
        try {
            it = closeable;
            boolean bl = false;
            ((OutputStream)it).write(out.getInternalBuffer(), 0, out.size());
            ((OutputStream)it).write(encodedValue);
            Intrinsics.checkNotNull((Object)encodedValue);
            ArraysKt.fill$default((byte[])encodedValue, (byte)0, (int)0, (int)0, (int)6, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    private final boolean readMainKeyIsAutoGeneratedMetadata(byte[] data) {
        boolean isAutoGenerated = true;
        for (NodeTuple node : MainKeyKt.access$createMainKeyReader(data)) {
            String propertyValue;
            Node keyNode = node.getKeyNode();
            Node valueNode = node.getValueNode();
            if (!(keyNode instanceof ScalarNode) || !(valueNode instanceof ScalarNode) || ((ScalarNode)valueNode).getValue() == null || !Intrinsics.areEqual((Object)((ScalarNode)keyNode).getValue(), (Object)"isAutoGenerated")) continue;
            isAutoGenerated = Boolean.parseBoolean(propertyValue) || Intrinsics.areEqual((Object)propertyValue, (Object)"yes");
        }
        return isAutoGenerated;
    }

    public final boolean isAutoGenerated() {
        try {
            byte[] byArray = Files.readAllBytes(this.passwordFile);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            return this.readMainKeyIsAutoGeneratedMetadata(byArray);
        }
        catch (NoSuchFileException noSuchFileException) {
            return true;
        }
    }
}

