/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.kdbx.IncorrectMainPasswordException;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.keePass.BaseKeePassCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.MainKey;
import com.intellij.credentialStore.keePass.MainKeyFileStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0017H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0007X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\r\u00a8\u0006#"}, d2={"Lcom/intellij/credentialStore/keePass/KeePassCredentialStore;", "Lcom/intellij/credentialStore/keePass/BaseKeePassCredentialStore;", "dbFile", "Ljava/nio/file/Path;", "mainKeyStorage", "Lcom/intellij/credentialStore/keePass/MainKeyFileStorage;", "preloadedDb", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/credentialStore/keePass/MainKeyFileStorage;Lcom/intellij/credentialStore/kdbx/KeePassDatabase;)V", "mainKeyFile", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getDbFile$intellij_platform_credentialStore_impl", "()Ljava/nio/file/Path;", "isNeedToSave", "Ljava/util/concurrent/atomic/AtomicBoolean;", "db", "getDb", "()Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "setDb", "(Lcom/intellij/credentialStore/kdbx/KeePassDatabase;)V", "getMainKeyFile", "reload", "", "save", "mainKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "deleteFileStorage", "clear", "setMainPassword", "mainKey", "Lcom/intellij/credentialStore/keePass/MainKey;", "secureRandom", "Ljava/security/SecureRandom;", "markDirty", "intellij.platform.credentialStore.impl"})
@SourceDebugExtension(value={"SMAP\nKeePassCredentialStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeePassCredentialStore.kt\ncom/intellij/credentialStore/keePass/KeePassCredentialStore\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,146:1\n13#2:147\n*S KotlinDebug\n*F\n+ 1 KeePassCredentialStore.kt\ncom/intellij/credentialStore/keePass/KeePassCredentialStore\n*L\n92#1:147\n*E\n"})
public final class KeePassCredentialStore
extends BaseKeePassCredentialStore {
    @NotNull
    private final Path dbFile;
    @NotNull
    private final MainKeyFileStorage mainKeyStorage;
    @NotNull
    private final AtomicBoolean isNeedToSave;
    @NotNull
    private KeePassDatabase db;

    public KeePassCredentialStore(@NotNull Path dbFile, @NotNull MainKeyFileStorage mainKeyStorage, @Nullable KeePassDatabase preloadedDb) {
        KeePassDatabase keePassDatabase;
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)mainKeyStorage, (String)"mainKeyStorage");
        super(null);
        this.dbFile = dbFile;
        this.mainKeyStorage = mainKeyStorage;
        if (preloadedDb == null) {
            this.isNeedToSave = new AtomicBoolean(false);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(this.dbFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                byte[] byArray = this.mainKeyStorage.load();
                if (byArray == null) {
                    throw new IncorrectMainPasswordException(true);
                }
                byte[] mainPassword = byArray;
                keePassDatabase = KdbxKt.loadKdbx(this.dbFile, KdbxPassword.Companion.createAndClear(mainPassword));
            } else {
                keePassDatabase = new KeePassDatabase(null, 1, null);
            }
        } else {
            this.isNeedToSave = new AtomicBoolean(true);
            keePassDatabase = preloadedDb;
        }
        this.db = keePassDatabase;
    }

    public /* synthetic */ KeePassCredentialStore(Path path, MainKeyFileStorage mainKeyFileStorage, KeePassDatabase keePassDatabase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            keePassDatabase = null;
        }
        this(path, mainKeyFileStorage, keePassDatabase);
    }

    @NotNull
    public final Path getDbFile$intellij_platform_credentialStore_impl() {
        return this.dbFile;
    }

    public KeePassCredentialStore(@NotNull Path dbFile, @NotNull Path mainKeyFile) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)mainKeyFile, (String)"mainKeyFile");
        this(dbFile, new MainKeyFileStorage(mainKeyFile), null);
    }

    @Override
    @NotNull
    protected KeePassDatabase getDb() {
        return this.db;
    }

    protected void setDb(@NotNull KeePassDatabase keePassDatabase) {
        Intrinsics.checkNotNullParameter((Object)keePassDatabase, (String)"<set-?>");
        this.db = keePassDatabase;
    }

    @NotNull
    public final Path getMainKeyFile() {
        return this.mainKeyStorage.passwordFile;
    }

    @TestOnly
    public final synchronized void reload() {
        byte[] byArray = this.mainKeyStorage.load();
        Intrinsics.checkNotNull((Object)byArray);
        byte[] key = byArray;
        KdbxPassword kdbxPassword = new KdbxPassword(key);
        ArraysKt.fill$default((byte[])key, (byte)0, (int)0, (int)0, (int)6, null);
        this.setDb(KdbxKt.loadKdbx(this.dbFile, kdbxPassword));
        this.isNeedToSave.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void save(@NotNull EncryptionSpec mainKeyEncryptionSpec) {
        Intrinsics.checkNotNullParameter((Object)mainKeyEncryptionSpec, (String)"mainKeyEncryptionSpec");
        if (!this.isNeedToSave.compareAndSet(true, false) && !this.getDb().isDirty()) {
            return;
        }
        try {
            SecureRandom secureRandom = CredentialStoreKt.createSecureRandom();
            byte[] mainKey = this.mainKeyStorage.load();
            KdbxPassword kdbxPassword = null;
            if (mainKey == null) {
                MainKey key = KeePassCredentialStoreKt.generateRandomMainKey(mainKeyEncryptionSpec, secureRandom);
                byte[] byArray = key.getValue();
                Intrinsics.checkNotNull((Object)byArray);
                kdbxPassword = new KdbxPassword(byArray);
                this.mainKeyStorage.save(key);
            } else {
                kdbxPassword = new KdbxPassword(mainKey);
                ArraysKt.fill$default((byte[])mainKey, (byte)0, (int)0, (int)0, (int)6, null);
            }
            Closeable closeable = PathKt.safeOutputStream((Path)this.dbFile);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                this.getDb().save$intellij_platform_credentialStore_impl(kdbxPassword, it, secureRandom);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            this.isNeedToSave.set(true);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KeePassCredentialStore.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot save password database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void deleteFileStorage() {
        try {
            PathKt.delete$default((Path)this.dbFile, (boolean)false, (int)1, null);
        }
        finally {
            this.mainKeyStorage.save(null);
        }
    }

    public final void clear() {
        this.getDb().getRootGroup$intellij_platform_credentialStore_impl().removeGroup("IntelliJ Platform");
        this.isNeedToSave.set(this.getDb().isDirty());
    }

    @TestOnly
    public final void setMainPassword(@NotNull MainKey mainKey, @NotNull SecureRandom secureRandom) {
        Intrinsics.checkNotNullParameter((Object)mainKey, (String)"mainKey");
        Intrinsics.checkNotNullParameter((Object)secureRandom, (String)"secureRandom");
        KeePassCredentialStoreKt.saveDatabase(this.dbFile, this.getDb(), mainKey, this.mainKeyStorage, secureRandom);
    }

    @Override
    protected void markDirty() {
        this.isNeedToSave.set(true);
    }
}

