/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.windows;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.Crypt32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinCrypt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class WindowsCryptUtils {
    private WindowsCryptUtils() {
    }

    public static byte @NotNull [] protect(byte @NotNull [] data) {
        if (data == null) {
            WindowsCryptUtils.$$$reportNull$$$0(0);
        }
        if (data.length == 0) {
            if (data == null) {
                WindowsCryptUtils.$$$reportNull$$$0(1);
            }
            return data;
        }
        WinCrypt.DATA_BLOB in = WindowsCryptUtils.prepareInput(data);
        WinCrypt.DATA_BLOB.ByReference out = new WinCrypt.DATA_BLOB.ByReference();
        boolean rc = Crypt32.INSTANCE.CryptProtectData(in, "Master Key", null, null, null, 0, (WinCrypt.DATA_BLOB)out);
        byte[] byArray = WindowsCryptUtils.getBytes((WinCrypt.DATA_BLOB)out, rc);
        if (byArray == null) {
            WindowsCryptUtils.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    public static byte @NotNull [] unprotect(byte[] data) {
        if (data.length == 0) {
            if (data == null) {
                WindowsCryptUtils.$$$reportNull$$$0(3);
            }
            return data;
        }
        WinCrypt.DATA_BLOB in = WindowsCryptUtils.prepareInput(data);
        WinCrypt.DATA_BLOB.ByReference out = new WinCrypt.DATA_BLOB.ByReference();
        boolean rc = Crypt32.INSTANCE.CryptUnprotectData(in, null, null, null, null, 0, (WinCrypt.DATA_BLOB)out);
        byte[] byArray = WindowsCryptUtils.getBytes((WinCrypt.DATA_BLOB)out, rc);
        if (byArray == null) {
            WindowsCryptUtils.$$$reportNull$$$0(4);
        }
        return byArray;
    }

    private static WinCrypt.DATA_BLOB prepareInput(byte[] data) {
        Memory input = new Memory((long)data.length);
        input.write(0L, data, 0, data.length);
        WinCrypt.DATA_BLOB.ByReference in = new WinCrypt.DATA_BLOB.ByReference();
        in.cbData = data.length;
        in.pbData = input;
        return in;
    }

    private static byte[] getBytes(WinCrypt.DATA_BLOB out, boolean rc) {
        if (!rc) {
            throw new RuntimeException("CryptProtectData failed: " + Kernel32.INSTANCE.GetLastError());
        }
        byte[] output = new byte[out.cbData];
        out.pbData.read(0L, output, 0, output.length);
        Kernel32.INSTANCE.LocalFree(out.pbData);
        return output;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/credentialStore/windows/WindowsCryptUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/credentialStore/windows/WindowsCryptUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "protect";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unprotect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "protect";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

