/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.NativeCredentialStoreWrapperKt;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.concurrency.QueueProcessor;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\nJ\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0096\u0002J\u001b\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0018\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u0012\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/credentialStore/NativeCredentialStoreWrapper;", "Lcom/intellij/credentialStore/CredentialStore;", "Ljava/io/Closeable;", "store", "queueProcessor", "Lcom/intellij/util/concurrency/QueueProcessor;", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/credentialStore/CredentialStore;Lcom/intellij/util/concurrency/QueueProcessor;)V", "(Lcom/intellij/credentialStore/CredentialStore;)V", "fallbackStore", "Lkotlin/Lazy;", "Lcom/intellij/credentialStore/keePass/InMemoryCredentialStore;", "postponedCredentials", "deniedItems", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/credentialStore/CredentialAttributes;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "set", "credentials", "close", "intellij.platform.credentialStore.impl"})
final class NativeCredentialStoreWrapper
implements CredentialStore,
Closeable {
    @NotNull
    private final CredentialStore store;
    @NotNull
    private final QueueProcessor<Function0<Unit>> queueProcessor;
    @NotNull
    private final Lazy<InMemoryCredentialStore> fallbackStore;
    @NotNull
    private final InMemoryCredentialStore postponedCredentials;
    @NotNull
    private final Cache<CredentialAttributes, Boolean> deniedItems;

    public NativeCredentialStoreWrapper(@NotNull CredentialStore store, @NotNull QueueProcessor<Function0<Unit>> queueProcessor) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter(queueProcessor, (String)"queueProcessor");
        this.store = store;
        this.queueProcessor = queueProcessor;
        this.fallbackStore = LazyKt.lazy(NativeCredentialStoreWrapper::fallbackStore$lambda$0);
        this.postponedCredentials = new InMemoryCredentialStore();
        Cache cache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.deniedItems = cache;
    }

    public NativeCredentialStoreWrapper(@NotNull CredentialStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this(store, (QueueProcessor<Function0<Unit>>)new QueueProcessor(arg_0 -> NativeCredentialStoreWrapper._init_$lambda$1(NativeCredentialStoreWrapper::_init_$lambda$0, arg_0)));
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Credentials credentials = this.postponedCredentials.get(attributes);
        if (credentials != null) {
            Credentials it = credentials;
            boolean bl = false;
            return Intrinsics.areEqual((Object)it, (Object)NativeCredentialStoreWrapperKt.access$getREMOVED_CREDENTIALS$p()) ? null : it;
        }
        if (attributes.getCacheDeniedItems() && this.deniedItems.getIfPresent((Object)attributes) != null) {
            CredentialStoreKt.getLOG().warn("User denied access to " + attributes);
            return CredentialAttributesKt.getACCESS_TO_KEY_CHAIN_DENIED();
        }
        CredentialStore store = this.fallbackStore.isInitialized() ? (CredentialStore)this.fallbackStore.getValue() : this.store;
        try {
            Credentials value = store.get(attributes);
            if (attributes.getCacheDeniedItems() && value == CredentialAttributesKt.getACCESS_TO_KEY_CHAIN_DENIED()) {
                this.deniedItems.put((Object)attributes, (Object)true);
            }
            return value;
        }
        catch (UnsatisfiedLinkError e) {
            store = (CredentialStore)this.fallbackStore.getValue();
            NativeCredentialStoreWrapperKt.access$notifyUnsatisfiedLinkError(e);
            return ((InMemoryCredentialStore)store).get(attributes);
        }
        catch (Throwable e) {
            CredentialStoreKt.getLOG().error(e);
            return null;
        }
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (this.fallbackStore.isInitialized()) {
            ((InMemoryCredentialStore)this.fallbackStore.getValue()).set(attributes, credentials);
            return;
        }
        Credentials credentials2 = credentials;
        if (credentials2 == null) {
            credentials2 = NativeCredentialStoreWrapperKt.access$getREMOVED_CREDENTIALS$p();
        }
        Credentials postponed = credentials2;
        this.postponedCredentials.set(attributes, postponed);
        this.queueProcessor.add(() -> NativeCredentialStoreWrapper.set$lambda$0(this, attributes, credentials, postponed));
    }

    @Override
    public void close() {
        if (this.store instanceof Closeable) {
            this.queueProcessor.waitFor();
            ((Closeable)this.store).close();
        }
    }

    private static final Unit _init_$lambda$0(Function0 it) {
        it.invoke();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final InMemoryCredentialStore fallbackStore$lambda$0() {
        return new InMemoryCredentialStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit set$lambda$0(NativeCredentialStoreWrapper this$0, CredentialAttributes $attributes, Credentials $credentials, Credentials $postponed) {
        try {
            CredentialStore store = this$0.fallbackStore.isInitialized() ? (CredentialStore)this$0.fallbackStore.getValue() : this$0.store;
            try {
                store.set($attributes, $credentials);
            }
            catch (UnsatisfiedLinkError e) {
                store = (CredentialStore)this$0.fallbackStore.getValue();
                NativeCredentialStoreWrapperKt.access$notifyUnsatisfiedLinkError(e);
                ((InMemoryCredentialStore)store).set($attributes, $credentials);
            }
            catch (Throwable e) {
                CredentialStoreKt.getLOG().error(e);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        finally {
            Credentials currentPostponed = this$0.postponedCredentials.get($attributes);
            if (Intrinsics.areEqual((Object)$postponed, (Object)currentPostponed)) {
                this$0.postponedCredentials.set($attributes, null);
            }
        }
        return Unit.INSTANCE;
    }
}

