/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.HiddenFramesStackFrame;
import com.intellij.xdebugger.impl.frame.XStackFrameWithCustomBackgroundColor;
import com.intellij.xdebugger.impl.frame.XStackFrameWithSeparatorAbove;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class HiddenStackFramesItem
extends XStackFrame
implements XStackFrameWithCustomBackgroundColor,
XStackFrameWithSeparatorAbove,
HiddenFramesStackFrame {
    final List<XStackFrame> hiddenFrames;

    public HiddenStackFramesItem(List<XStackFrame> hiddenFrames) {
        this.hiddenFrames = List.copyOf(hiddenFrames);
        if (hiddenFrames.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            HiddenStackFramesItem.$$$reportNull$$$0(0);
        }
        component.append(XDebuggerBundle.message((String)"label.folded.frames", (Object[])new Object[]{this.hiddenFrames.size()}), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        component.setIcon(EmptyIcon.ICON_16);
    }

    @Nullable
    public Color getBackgroundColor() {
        return null;
    }

    @NotNull
    public List<XStackFrame> getHiddenFrames() {
        List<XStackFrame> list = this.hiddenFrames;
        if (list == null) {
            HiddenStackFramesItem.$$$reportNull$$$0(1);
        }
        return list;
    }

    private Optional<XStackFrameWithSeparatorAbove> findFrameWithSeparator() {
        Optional<XStackFrameWithSeparatorAbove> optional;
        XStackFrame xStackFrame = this.hiddenFrames.get(0);
        if (xStackFrame instanceof XStackFrameWithSeparatorAbove) {
            XStackFrameWithSeparatorAbove frame = (XStackFrameWithSeparatorAbove)xStackFrame;
            optional = Optional.of(frame);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public boolean hasSeparatorAbove() {
        return this.findFrameWithSeparator().map(XStackFrameWithSeparatorAbove::hasSeparatorAbove).orElse(false);
    }

    public String getCaptionAboveOf() {
        return this.findFrameWithSeparator().map(XStackFrameWithSeparatorAbove::getCaptionAboveOf).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/frame/HiddenStackFramesItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/HiddenStackFramesItem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHiddenFrames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

