/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach.osHandlers;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.osHandlers.GenericAttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.LinuxAttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.MacAttachOSHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AttachOSHandler {
    private static final Logger LOG = Logger.getInstance(AttachOSHandler.class);
    @NotNull
    private final OSType myOSType;
    @NotNull
    protected final EnvironmentAwareHost myHost;

    public AttachOSHandler(@NotNull EnvironmentAwareHost host, @NotNull OSType osType) {
        if (host == null) {
            AttachOSHandler.$$$reportNull$$$0(0);
        }
        if (osType == null) {
            AttachOSHandler.$$$reportNull$$$0(1);
        }
        this.myHost = host;
        this.myOSType = osType;
    }

    @NotNull
    public OSType getOSType() {
        OSType oSType = this.myOSType;
        if (oSType == null) {
            AttachOSHandler.$$$reportNull$$$0(2);
        }
        return oSType;
    }

    @NotNull
    public static AttachOSHandler getAttachOsHandler(@NotNull EnvironmentAwareHost host) {
        if (host == null) {
            AttachOSHandler.$$$reportNull$$$0(3);
        }
        try {
            OSType osType = AttachOSHandler.computeOsType(host);
            if (osType == OSType.LINUX) {
                return new LinuxAttachOSHandler(host);
            }
            if (osType == OSType.MACOSX) {
                return new MacAttachOSHandler(host);
            }
            if (osType == OSType.WINDOWS) {
                return new GenericAttachOSHandler(host, OSType.WINDOWS);
            }
        }
        catch (ExecutionException e) {
            LOG.warn("Error while obtaining host operating system", (Throwable)e);
        }
        return new GenericAttachOSHandler(host, OSType.UNKNOWN);
    }

    @NotNull
    private static OSType localComputeOsType() {
        if (SystemInfo.isLinux) {
            OSType oSType = OSType.LINUX;
            if (oSType == null) {
                AttachOSHandler.$$$reportNull$$$0(4);
            }
            return oSType;
        }
        if (SystemInfo.isMac) {
            OSType oSType = OSType.MACOSX;
            if (oSType == null) {
                AttachOSHandler.$$$reportNull$$$0(5);
            }
            return oSType;
        }
        if (SystemInfo.isWindows) {
            OSType oSType = OSType.WINDOWS;
            if (oSType == null) {
                AttachOSHandler.$$$reportNull$$$0(6);
            }
            return oSType;
        }
        OSType oSType = OSType.UNKNOWN;
        if (oSType == null) {
            AttachOSHandler.$$$reportNull$$$0(7);
        }
        return oSType;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private static OSType computeOsType(@NotNull EnvironmentAwareHost host) throws ExecutionException {
        if (host == null) {
            AttachOSHandler.$$$reportNull$$$0(8);
        }
        if (host instanceof LocalAttachHost) {
            return AttachOSHandler.localComputeOsType();
        }
        try {
            getOsCommandLine = new GeneralCommandLine(new String[]{"uname", "-s"});
            unameOutput = host.getProcessOutput(getOsCommandLine);
            AttachOSHandler.LOG.debug("`uname -s` output: ", new Object[]{unameOutput});
            var4_5 = osString = unameOutput.getStdout().trim();
            var5_6 = -1;
            switch (var4_5.hashCode()) {
                case 73425108: {
                    if (!var4_5.equals("Linux")) break;
                    var5_6 = 0;
                    break;
                }
                case 2039877703: {
                    if (!var4_5.equals("Darwin")) break;
                    var5_6 = 1;
                }
            }
            switch (var5_6) {
                case 0: {
                    v0 = OSType.LINUX;
                    ** break;
                }
                case 1: {
                    v0 = OSType.MACOSX;
                    ** break;
                }
                default: {
                    v0 = OSType.UNKNOWN;
                }
            }
        }
        catch (ExecutionException ex) {
            throw new ExecutionException(XDebuggerBundle.message((String)"dialog.message.error.while.calculating.remote.operating.system", (Object[])new Object[0]), (Throwable)ex);
        }
lbl30:
        // 3 sources

        if (v0 == null) {
            AttachOSHandler.$$$reportNull$$$0(9);
        }
        return v0;
    }

    public String toString() {
        return "AttachOSHandler{myOSType=" + String.valueOf((Object)this.myOSType) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/attach/osHandlers/AttachOSHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/attach/osHandlers/AttachOSHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "localComputeOsType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOsType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttachOsHandler";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeOsType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }

    public static enum OSType {
        LINUX,
        MACOSX,
        WINDOWS,
        UNKNOWN;

    }
}

