/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.ColorState;
import com.intellij.xdebugger.impl.frame.VirtualFileColor;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH'R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/xdebugger/impl/frame/XStackFramesListColorsCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "colorsManager", "Lcom/intellij/ui/FileColorManager;", "getColorsManager", "()Lcom/intellij/ui/FileColorManager;", "get", "Ljava/awt/Color;", "stackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "Monolith", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public abstract class XStackFramesListColorsCache {
    @NotNull
    private final FileColorManager colorsManager;

    public XStackFramesListColorsCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileColorManager fileColorManager = FileColorManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)fileColorManager, (String)"getInstance(...)");
        this.colorsManager = fileColorManager;
    }

    @NotNull
    protected final FileColorManager getColorsManager() {
        return this.colorsManager;
    }

    @RequiresEdt
    @Nullable
    public abstract Color get(@NotNull XStackFrame var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/xdebugger/impl/frame/XStackFramesListColorsCache$Monolith;", "Lcom/intellij/xdebugger/impl/frame/XStackFramesListColorsCache;", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "framesList", "Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList;", "<init>", "(Lcom/intellij/xdebugger/impl/XDebugSessionImpl;Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList;)V", "myFileColors", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/xdebugger/impl/frame/ColorState;", "myCurrentlyComputingFiles", "Ljava/util/concurrent/atomic/AtomicInteger;", "get", "Ljava/awt/Color;", "stackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "intellij.platform.debugger.impl"})
    public static final class Monolith
    extends XStackFramesListColorsCache {
        @NotNull
        private final XDebugSessionImpl session;
        @NotNull
        private final Map<VirtualFile, ColorState> myFileColors;
        @NotNull
        private final AtomicInteger myCurrentlyComputingFiles;

        public Monolith(@NotNull XDebugSessionImpl session, @NotNull XDebuggerFramesList framesList) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)framesList), (String)"framesList");
            super(session.getProject());
            this.session = session;
            this.myFileColors = new LinkedHashMap();
            this.myCurrentlyComputingFiles = new AtomicInteger(0);
            BuildersKt.launch$default((CoroutineScope)this.session.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, framesList, null){
                int label;
                final /* synthetic */ Monolith this$0;
                final /* synthetic */ XDebuggerFramesList $framesList;
                {
                    this.this$0 = $receiver;
                    this.$framesList = $framesList;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.session.getFileColorsComputer().getFileColors().collect(new FlowCollector(){

                                public final Object emit(VirtualFileColor virtualFileColor, Continuation<? super Unit> $completion) {
                                    VirtualFile file = virtualFileColor.component1();
                                    ColorState colorState = virtualFileColor.component2();
                                    ColorState oldState = this$0.myFileColors.put(file, colorState);
                                    if (colorState instanceof ColorState.Computing) {
                                        this$0.myCurrentlyComputingFiles.incrementAndGet();
                                    } else if (oldState == ColorState.Computing.INSTANCE && this$0.myCurrentlyComputingFiles.decrementAndGet() == 0) {
                                        $framesList.repaint();
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) throw new KotlinNothingValueException();
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Override
        @Nullable
        public Color get(@NotNull XStackFrame stackFrame) {
            VirtualFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
            XSourcePosition xSourcePosition = stackFrame.getSourcePosition();
            Object object = virtualFile = xSourcePosition != null ? xSourcePosition.getFile() : null;
            if (virtualFile == null) {
                return this.getColorsManager().getScopeColor("Non-Project Files");
            }
            ColorState res = this.myFileColors.get(virtualFile);
            if (res != null) {
                return res.getColor();
            }
            this.session.getFileColorsComputer().sendRequest(virtualFile);
            return null;
        }
    }
}

