/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.actions.CreateAction;
import com.intellij.execution.runners.ExecutionEnvironmentProxy;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutViewOptions;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.customization.CustomActionsListener;
import com.intellij.ide.ui.customization.DefaultActionGroupWithDelegate;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebugSessionTabNewUIKt;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0006\u0010\u0011\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0014R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/xdebugger/impl/ui/XDebugSessionTabNewUI;", "Lcom/intellij/xdebugger/impl/ui/XDebugSessionTab;", "session", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "icon", "Ljavax/swing/Icon;", "environmentProxy", "Lcom/intellij/execution/runners/ExecutionEnvironmentProxy;", "<init>", "(Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;Ljavax/swing/Icon;Lcom/intellij/execution/runners/ExecutionEnvironmentProxy;)V", "mySingleContentSupplier", "Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;", "toolbarGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "initDebuggerTab", "", "initToolbars", "updateToolbars", "isSingleContent", "", "getSupplier", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public class XDebugSessionTabNewUI
extends XDebugSessionTab {
    @Nullable
    private SingleContentSupplier mySingleContentSupplier;
    @Nullable
    private DefaultActionGroup toolbarGroup;

    public XDebugSessionTabNewUI(@NotNull XDebugSessionProxy session, @Nullable Icon icon, @Nullable ExecutionEnvironmentProxy environmentProxy) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, icon, environmentProxy, false);
    }

    @Override
    protected void initDebuggerTab(@NotNull XDebugSessionProxy session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.getUi().getDefaults().initTabDefaults(0, XDebuggerBundle.message((String)"xdebugger.threads.vars.tab.title", (Object[])new Object[0]), null);
        this.createDefaultTabs(session);
        XDebugSessionTabNewUIKt.addDebugToolwindowActions(session.getProject());
        CustomActionsListener.Companion.subscribe((Disposable)this, new CustomActionsListener(this, session){
            final /* synthetic */ XDebugSessionTabNewUI this$0;
            final /* synthetic */ XDebugSessionProxy $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
            }

            public void schemaChanged() {
                if (this.this$0.isSingleContent()) {
                    this.this$0.updateToolbars();
                } else {
                    this.this$0.initToolbars(this.$session);
                }
            }
        });
    }

    @Override
    protected void initToolbars(@NotNull XDebugSessionProxy session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        boolean isVerticalToolbar = Registry.Companion.get("debugger.new.tool.window.layout.toolbar").isOptionEnabled("Vertical");
        RunnerLayoutUi runnerLayoutUi = this.myUi;
        RunnerLayoutUiImpl runnerLayoutUiImpl = runnerLayoutUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)runnerLayoutUi : null;
        if (runnerLayoutUiImpl != null) {
            RunnerLayoutUi it = runnerLayoutUi = runnerLayoutUiImpl;
            boolean bl = false;
            it.setLeftToolbarVisible(isVerticalToolbar);
            if (Registry.Companion.is("debugger.toolbar.before.tabs", true)) {
                it.setTopLeftActionsBefore(true);
            }
        }
        DefaultActionGroupWithDelegate toolbar = new DefaultActionGroupWithDelegate(XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.TopToolbar3"));
        if (this.isSingleContent()) {
            this.mySingleContentSupplier = (SingleContentSupplier)new RunTab.RunTabSupplier(this, toolbar, isVerticalToolbar){
                final /* synthetic */ boolean $isVerticalToolbar;
                {
                    this.$isVerticalToolbar = $isVerticalToolbar;
                    super((RunTab)$receiver, (ActionGroup)$toolbar);
                }

                public ActionGroup getToolbarActions() {
                    return this.$isVerticalToolbar ? ActionGroup.EMPTY_GROUP : super.getToolbarActions();
                }

                public String getMainToolbarPlace() {
                    return "DebuggerToolbar";
                }

                public String getContentToolbarPlace() {
                    return "DebuggerToolbar";
                }
            };
        }
        this.toolbarGroup = (DefaultActionGroup)toolbar;
        this.updateToolbars();
        LayoutViewOptions layoutViewOptions = isVerticalToolbar ? this.myUi.getOptions().setLeftToolbar((ActionGroup)toolbar, "DebuggerToolbar") : this.myUi.getOptions().setTopLeftToolbar((ActionGroup)toolbar, "DebuggerToolbar");
    }

    public final void updateToolbars() {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup defaultActionGroup2 = this.toolbarGroup;
        if (defaultActionGroup2 == null) {
            return;
        }
        DefaultActionGroup toolbar = defaultActionGroup2;
        XDebugSessionProxy session = this.mySession;
        toolbar.removeAll();
        ActionGroup headerGroup = XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.TopToolbar3");
        RunContentBuilder.addAvoidingDuplicates((DefaultActionGroup)toolbar, (ActionGroup)headerGroup);
        MoreActionGroup more = RunContentBuilder.createToolbarMoreActionGroup((ActionGroup)((ActionGroup)toolbar));
        ActionGroup moreGroup = XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.TopToolbar3.Extra");
        RunContentBuilder.addAvoidingDuplicates((DefaultActionGroup)((DefaultActionGroup)more), (ActionGroup)moreGroup);
        more.addSeparator();
        if (session != null) {
            RunContentBuilder.addActionsWithConstraints(session.getRestartActions(), (Constraints)new Constraints(Anchor.AFTER, "Rerun"), (DefaultActionGroup)toolbar, (DefaultActionGroup)((DefaultActionGroup)more));
            RunContentBuilder.addActionsWithConstraints(session.getExtraActions(), (Constraints)new Constraints(Anchor.AFTER, "Stop"), (DefaultActionGroup)toolbar, (DefaultActionGroup)((DefaultActionGroup)more));
            RunContentBuilder.addActionsWithConstraints((List)CollectionsKt.asReversed(session.getExtraStopActions()), (Constraints)new Constraints(Anchor.AFTER, "Stop"), (DefaultActionGroup)toolbar, (DefaultActionGroup)((DefaultActionGroup)more));
        }
        more.addSeparator();
        DefaultActionGroup $this$updateToolbars_u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$updateToolbars_u24lambda_u240.getTemplatePresentation().setText(ActionsBundle.message((String)"group.XDebugger.settings.text", (Object[])new Object[0]));
        $this$updateToolbars_u24lambda_u240.getTemplatePresentation().setIcon(AllIcons.General.Settings);
        $this$updateToolbars_u24lambda_u240.setPopup(true);
        AnAction[] anActionArray = this.myUi.getOptions().getSettingsActionsList();
        $this$updateToolbars_u24lambda_u240.addAll(Arrays.copyOf(anActionArray, anActionArray.length));
        DefaultActionGroup gear = defaultActionGroup;
        if (session != null) {
            this.registerAdditionalActions((DefaultActionGroup)more, toolbar, gear);
        }
        more.add((AnAction)gear, new Constraints(Anchor.BEFORE, ""));
        more.add((AnAction)new CreateAction(), new Constraints(Anchor.BEFORE, ""));
        toolbar.add((AnAction)more, new Constraints(Anchor.BEFORE, ""));
    }

    public boolean isSingleContent() {
        return Registry.Companion.is("debugger.new.tool.window.layout.single.content", false);
    }

    @Nullable
    protected SingleContentSupplier getSupplier() {
        return this.mySingleContentSupplier;
    }
}

