/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerInstanceTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeWithHistoryPanel;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XInspectDialog
extends DialogWrapper {
    private final DebuggerTreeWithHistoryPanel myDebuggerTreePanel;
    private final boolean myRebuildOnSessionEvents;

    public XInspectDialog(@NotNull Project project, XDebuggerEditorsProvider editorsProvider, XSourcePosition sourcePosition, @NotNull String name, @NotNull XValue value, XValueMarkers<?, ?> markers, @Nullable XDebugSessionProxy session, boolean rebuildOnSessionEvents) {
        if (project == null) {
            XInspectDialog.$$$reportNull$$$0(0);
        }
        if (name == null) {
            XInspectDialog.$$$reportNull$$$0(1);
        }
        if (value == null) {
            XInspectDialog.$$$reportNull$$$0(2);
        }
        super(project, false);
        this.myRebuildOnSessionEvents = rebuildOnSessionEvents;
        this.setTitle(XDebuggerBundle.message((String)"inspect.value.dialog.title", (Object[])new Object[]{name}));
        this.setModal(false);
        XInstanceEvaluator instanceEvaluator = value.getInstanceEvaluator();
        if (instanceEvaluator != null && this.myRebuildOnSessionEvents && session != null) {
            Pair initialItem = Pair.create((Object)instanceEvaluator, (Object)name);
            XDebuggerInstanceTreeCreator creator = new XDebuggerInstanceTreeCreator(project, editorsProvider, sourcePosition, markers, session);
            this.myDebuggerTreePanel = new DebuggerTreeWithHistoryPanel<Pair<XInstanceEvaluator, String>>(initialItem, creator, project, this.myDisposable);
        } else {
            Pair initialItem = Pair.create((Object)value, (Object)name);
            XDebuggerTreeCreator creator = new XDebuggerTreeCreator(project, editorsProvider, sourcePosition, markers);
            this.myDebuggerTreePanel = new DebuggerTreeWithHistoryPanel<Pair<XValue, String>>(initialItem, creator, project, this.myDisposable);
        }
        if (session != null) {
            session.addSessionListener(new XDebugSessionListener(){

                public void sessionPaused() {
                    if (XInspectDialog.this.myRebuildOnSessionEvents) {
                        XInspectDialog.this.myDebuggerTreePanel.rebuild();
                    }
                }
            }, this.myDisposable);
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myDebuggerTreePanel.getMainPanel();
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "#xdebugger.XInspectDialog";
    }

    @NotNull
    public XDebuggerTree getTree() {
        XDebuggerTree xDebuggerTree = this.myDebuggerTreePanel.getTree();
        if (xDebuggerTree == null) {
            XInspectDialog.$$$reportNull$$$0(3);
        }
        return xDebuggerTree;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDebuggerTreePanel.getTree();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/XInspectDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XInspectDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

