/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.RunToCursorService;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/xdebugger/impl/DefaultRunToCursorService;", "Lcom/intellij/xdebugger/impl/RunToCursorService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "shouldShowInlay", "", "isAtExecution", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "canRunToCursor", "editor", "Lcom/intellij/openapi/editor/Editor;", "lineNumber", "(Lcom/intellij/openapi/editor/Editor;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRunToCursorState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunToCursorState.kt\ncom/intellij/xdebugger/impl/DefaultRunToCursorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1761#2,3:43\n*S KotlinDebug\n*F\n+ 1 RunToCursorState.kt\ncom/intellij/xdebugger/impl/DefaultRunToCursorService\n*L\n39#1:43,3\n*E\n"})
public class DefaultRunToCursorService
implements RunToCursorService {
    @NotNull
    private final Project project;

    public DefaultRunToCursorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Override
    public boolean shouldShowInlay() {
        XDebugSessionImpl session = (XDebugSessionImpl)XDebuggerManager.getInstance((Project)this.project).getCurrentSession();
        return session != null && session.isPaused() && !session.isReadOnly();
    }

    @Override
    public boolean isAtExecution(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        XDebugSession session = XDebuggerManager.getInstance((Project)this.project).getCurrentSession();
        XDebugSession xDebugSession = session;
        if (xDebugSession == null || (xDebugSession = xDebugSession.getCurrentPosition()) == null) {
            return false;
        }
        XDebugSession position = xDebugSession;
        return Intrinsics.areEqual((Object)position.getFile(), (Object)file) && position.getLine() == line;
    }

    @Override
    @Nullable
    public Object canRunToCursor(@NotNull Editor editor, int lineNumber, @NotNull Continuation<? super Boolean> $completion) {
        return DefaultRunToCursorService.canRunToCursor$suspendImpl(this, editor, lineNumber, $completion);
    }

    static /* synthetic */ Object canRunToCursor$suspendImpl(DefaultRunToCursorService $this, Editor editor, int lineNumber, Continuation<? super Boolean> $completion) {
        return CoroutinesKt.readAction(() -> DefaultRunToCursorService.canRunToCursor$lambda$0(editor, lineNumber, $this), $completion);
    }

    private static final boolean canRunToCursor$lambda$0(Editor $editor, int $lineNumber, DefaultRunToCursorService this$0) {
        boolean bl;
        block4: {
            XSourcePositionImpl xSourcePositionImpl = XSourcePositionImpl.create(FileDocumentManager.getInstance().getFile($editor.getDocument()), $lineNumber);
            if (xSourcePositionImpl == null) {
                return false;
            }
            XSourcePositionImpl position = xSourcePositionImpl;
            List<XLineBreakpointType<?>> types = XBreakpointUtil.getAvailableLineBreakpointTypes(this$0.project, position, $editor);
            Iterable $this$any$iv = types;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    XLineBreakpointType it = (XLineBreakpointType)element$iv;
                    boolean bl2 = false;
                    if (!(it.getEnabledIcon() == AllIcons.Debugger.Db_set_breakpoint)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

