/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.ConfigurationState;
import com.intellij.xdebugger.impl.InlineWatchState;
import com.intellij.xdebugger.impl.WatchState;
import com.intellij.xdebugger.impl.WatchesManagerState;
import com.intellij.xdebugger.impl.XAlwaysEvaluatedWatch;
import com.intellij.xdebugger.impl.XWatch;
import com.intellij.xdebugger.impl.XWatchImpl;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchInplaceEditor;
import com.intellij.xdebugger.impl.inline.XInlineWatchesView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class XDebuggerWatchesManager {
    private final Map<String, List<XWatch>> watches;
    private final Map<String, Set<InlineWatch>> inlineWatches;
    private final MergingUpdateQueue myInlinesUpdateQueue;
    private final Project myProject;

    public XDebuggerWatchesManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(1);
        }
        this.watches = new ConcurrentHashMap<String, List<XWatch>>();
        this.inlineWatches = new ConcurrentHashMap<String, Set<InlineWatch>>();
        this.myProject = project;
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        editorEventMulticaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)project);
        this.myProject.getMessageBus().connect().subscribe(FileDocumentManagerListener.TOPIC, (Object)new FileDocumentManagerListener(){

            public void fileContentLoaded(@NotNull VirtualFile file, @NotNull Document document) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                XDebuggerWatchesManager.this.getDocumentInlines(document).forEach(InlineWatch::setMarker);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/XDebuggerWatchesManager$1";
                objectArray[2] = "fileContentLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myInlinesUpdateQueue = MergingUpdateQueue.Companion.edtMergingUpdateQueue("XInlineWatches", 300, coroutineScope);
    }

    @NotNull
    public List<XWatch> getWatchEntries(String configurationName) {
        List list = ContainerUtil.notNullize(this.watches.get(configurationName));
        if (list == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setWatchEntries(@NotNull String configurationName, @NotNull List<XWatch> watchList) {
        if (configurationName == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(3);
        }
        if (watchList == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(4);
        }
        if (watchList.isEmpty()) {
            this.watches.remove(configurationName);
        } else {
            this.watches.put(configurationName, watchList);
        }
    }

    @Deprecated
    @NotNull
    public List<XExpression> getWatches(String configurationName) {
        List list = ContainerUtil.map((Collection)ContainerUtil.notNullize(this.watches.get(configurationName)), XWatch::getExpression);
        if (list == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Deprecated
    public void setWatches(@NotNull String configurationName, @NotNull List<XExpression> expressions) {
        if (configurationName == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(6);
        }
        if (expressions == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(7);
        }
        if (expressions.isEmpty()) {
            this.watches.remove(configurationName);
        } else {
            this.watches.put(configurationName, ContainerUtil.map(expressions, XWatchImpl::new));
        }
    }

    public List<InlineWatch> getInlineWatches() {
        return this.inlineWatches.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
    }

    @ApiStatus.Internal
    @NotNull
    public WatchesManagerState saveState(@NotNull WatchesManagerState state) {
        if (state == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(8);
        }
        List<ConfigurationState> expressions = state.getExpressions();
        expressions.clear();
        this.watches.forEach((key, value) -> expressions.add(new ConfigurationState((String)key, (List<? extends XWatch>)value)));
        List<InlineWatchState> inlineExpressionStates = state.getInlineExpressionStates();
        inlineExpressionStates.clear();
        this.inlineWatches.values().stream().flatMap(l -> l.stream()).forEach(value -> inlineExpressionStates.add(new InlineWatchState(value.getExpression(), value.getLine(), value.getPosition().getFile().getUrl())));
        WatchesManagerState watchesManagerState = state;
        if (watchesManagerState == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(9);
        }
        return watchesManagerState;
    }

    public void clearContext() {
        this.watches.clear();
        this.inlineWatches.clear();
    }

    @ApiStatus.Internal
    public void loadState(@NotNull WatchesManagerState state) {
        if (state == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(10);
        }
        this.clearContext();
        for (ConfigurationState configurationState : state.getExpressions()) {
            List<WatchState> expressionStates = configurationState.getExpressionStates();
            if (ContainerUtil.isEmpty(expressionStates)) continue;
            this.watches.put(configurationState.getName(), ContainerUtil.mapNotNull(expressionStates, watchState -> {
                XExpression expression = watchState.toXExpression();
                if (expression == null) {
                    return null;
                }
                if (!watchState.getCanBePaused()) {
                    return new XAlwaysEvaluatedWatch(expression);
                }
                XWatchImpl watch = new XWatchImpl(expression);
                watch.setPaused(watchState.isPaused());
                return watch;
            }));
        }
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        XDebuggerUtil debuggerUtil = XDebuggerUtil.getInstance();
        for (InlineWatchState inlineWatchState : state.getInlineExpressionStates()) {
            if (inlineWatchState.getFileUrl() == null || inlineWatchState.getWatchState() == null) continue;
            VirtualFile file = fileManager.findFileByUrl(inlineWatchState.getFileUrl());
            XSourcePosition position = debuggerUtil.createPosition(file, inlineWatchState.getLine());
            XExpression expression = inlineWatchState.getWatchState().toXExpression();
            if (position == null || expression == null) continue;
            InlineWatch watch = new InlineWatch(expression, position);
            this.inlineWatches.computeIfAbsent(inlineWatchState.getFileUrl(), k -> new HashSet()).add(watch);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (InlineWatch i : ContainerUtil.flatten(this.inlineWatches.values())) {
                ReadAction.nonBlocking(() -> {
                    if (!i.setMarker()) {
                        this.inlineWatches.get(i.getPosition().getFile().getUrl()).remove(i);
                    }
                }).executeSynchronously();
            }
        });
    }

    public void showInplaceEditor(@NotNull XSourcePosition presentationPosition, @NotNull Editor mainEditor, @NotNull XDebugSessionProxy session, @Nullable XExpression expression) {
        if (presentationPosition == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(11);
        }
        if (mainEditor == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(12);
        }
        if (session == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(13);
        }
        InlineWatchInplaceEditor inplaceEditor = new InlineWatchInplaceEditor(presentationPosition, session, mainEditor, expression);
        inplaceEditor.show();
    }

    public void inlineWatchesRemoved(List<InlineWatch> removed, XInlineWatchesView watchesView) {
        this.inlineWatches.values().forEach(set -> removed.forEach(set::remove));
        this.getWatchesViews().filter(v -> v != watchesView).forEach(view -> view.removeInlineWatches(removed));
    }

    @RequiresEdt
    public void addInlineWatchExpression(@NotNull XExpression expression, int index, XSourcePosition position, boolean navigateToWatchNode) {
        if (expression == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        InlineWatch watch = new InlineWatch(expression, position);
        watch.setMarker();
        String fileUrl = position.getFile().getUrl();
        this.inlineWatches.computeIfAbsent(fileUrl, k -> new HashSet()).add(watch);
        this.getWatchesViews().forEach(view -> view.addInlineWatchExpression(watch, index, navigateToWatchNode));
    }

    private void updateInlines(@NotNull Document document) {
        Collection<InlineWatch> inlines;
        if (document == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(15);
        }
        if ((inlines = this.getDocumentInlines(document)).isEmpty()) {
            return;
        }
        HashSet<InlineWatch> toRemove = new HashSet<InlineWatch>();
        for (InlineWatch inlineWatch : inlines) {
            if (inlineWatch.updatePosition()) continue;
            toRemove.add(inlineWatch);
        }
        this.removeInlines(toRemove);
    }

    private void removeInlines(Collection<InlineWatch> remove) {
        for (InlineWatch watch : remove) {
            this.inlineWatches.get(watch.getPosition().getFile().getUrl()).remove(watch);
        }
        this.getWatchesViews().forEach(view -> view.removeInlineWatches(remove));
    }

    private Stream<XInlineWatchesView> getWatchesViews() {
        return XDebugManagerProxy.getInstance().getSessions(this.myProject).stream().map(XDebugSessionProxy::getSessionTab).filter(t -> t != null && t.getWatchesView() instanceof XInlineWatchesView).map(t -> (XInlineWatchesView)((Object)t.getWatchesView()));
    }

    @NotNull
    public Collection<InlineWatch> getDocumentInlines(Document document) {
        Set<InlineWatch> inlineWatches;
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file != null && (inlineWatches = this.inlineWatches.get(file.getUrl())) != null) {
            return new ArrayList<InlineWatch>(inlineWatches);
        }
        List<InlineWatch> list = Collections.emptyList();
        if (list == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 9, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerWatchesManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationPosition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainEditor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerWatchesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchEntries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatches";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentInlines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setWatchEntries";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setWatches";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showInplaceEditor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addInlineWatchExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateInlines";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 9, 16 -> new IllegalStateException(string);
        };
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Document document;
            Collection<InlineWatch> inlines;
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (!(inlines = XDebuggerWatchesManager.this.getDocumentInlines(document = e.getDocument())).isEmpty()) {
                XDebuggerWatchesManager.this.myInlinesUpdateQueue.queue(Update.create((Object)document, () -> XDebuggerWatchesManager.this.updateInlines(document)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/XDebuggerWatchesManager$MyDocumentListener", "documentChanged"));
        }
    }
}

