/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ModalityUiUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointProxy;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Point;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AddLineBreakpointAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddLineBreakpointAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        XSourcePosition position = AddLineBreakpointAction.getLineBreakpointPosition(e);
        assert (position != null);
        String selection = editor.getSelectionModel().getSelectedText();
        XBreakpointUtil.toggleLineBreakpointProxy(project, position, false, editor, false, false, true).thenAccept(bp -> {
            if (bp != null && this.editBreakpointSettings((XLineBreakpointProxy)bp, selection)) {
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                    EditorGutterComponentEx gutter = (EditorGutterComponentEx)editor.getGutter();
                    int x = -gutter.getWidth() + gutter.getLineNumberAreaOffset() + gutter.getLineNumberAreaWidth() / 2;
                    int y = editor.offsetToXY((int)position.getOffset()).y + editor.getLineHeight() / 2;
                    DebuggerUIUtil.showXBreakpointEditorBalloon(project, new Point(x, y), editor.getContentComponent(), false, bp);
                });
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddLineBreakpointAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(ExperimentalUI.isNewUI() && AddLineBreakpointAction.getLineBreakpointPosition(e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddLineBreakpointAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @Nullable
    private static XSourcePosition getLineBreakpointPosition(AnActionEvent e) {
        EditorGutter gutter;
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && editor != null && file != null && (gutter = editor.getGutter()) instanceof EditorGutterComponentEx) {
            Object lineNumber = ((EditorGutterComponentEx)gutter).getClientProperty((Object)"active.line.number");
            if (!(lineNumber instanceof Integer)) {
                lineNumber = e.getData(XDebuggerManagerImpl.ACTIVE_LINE_NUMBER);
            }
            if (lineNumber != null) {
                LogicalPosition pos = new LogicalPosition(((Integer)lineNumber).intValue(), 0);
                return XSourcePositionImpl.createByOffset(file, editor.logicalPositionToOffset(pos));
            }
        }
        return null;
    }

    @ApiStatus.OverrideOnly
    protected boolean editBreakpointSettings(XLineBreakpointProxy bp, @Nullable String editorSelection) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/handlers/AddLineBreakpointAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/AddLineBreakpointAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class WithLogging
    extends AddLineBreakpointAction
    implements ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
        @Override
        protected boolean editBreakpointSettings(XLineBreakpointProxy bp, @Nullable String editorSelection) {
            bp.setSuspendPolicy(SuspendPolicy.NONE);
            if (editorSelection != null) {
                bp.setLogExpressionEnabled(true);
                bp.setLogExpressionObject(XExpressionImpl.fromText(editorSelection));
            } else {
                bp.setLogMessage(true);
            }
            return true;
        }
    }

    public static class WithCondition
    extends AddLineBreakpointAction
    implements ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
        @Override
        protected boolean editBreakpointSettings(XLineBreakpointProxy bp, @Nullable String editorSelection) {
            bp.setConditionEnabled(true);
            bp.setConditionExpression(XExpressionImpl.fromText(editorSelection));
            return true;
        }
    }
}

