/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerToggleActionHandler;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XDebuggerMuteBreakpointsHandler
extends XDebuggerToggleActionHandler {
    @Override
    protected boolean isEnabled(@Nullable XDebugSessionProxy session, AnActionEvent event) {
        return session == null || !session.isReadOnly();
    }

    @Override
    protected boolean isSelected(@Nullable XDebugSessionProxy session, AnActionEvent event) {
        if (session != null) {
            return session.areBreakpointsMuted();
        }
        XDebugSessionData sessionData = DebuggerUIUtil.getSessionData(event);
        return sessionData != null && sessionData.isBreakpointsMuted();
    }

    @Override
    protected void setSelected(@Nullable XDebugSessionProxy session, AnActionEvent event, boolean state) {
        if (session != null) {
            session.muteBreakpoints(state);
            return;
        }
        XDebugSessionData data = DebuggerUIUtil.getSessionData(event);
        if (data != null) {
            data.setBreakpointsMuted(state);
        }
    }
}

