/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.CommonBundle;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.shared.XDebuggerUtilImplShared;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.FrontendXLineBreakpointVariant;
import com.intellij.xdebugger.impl.FrontendXLineBreakpointVariantKt;
import com.intellij.xdebugger.impl.VariantChoiceData;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XLineBreakpointInstallationInfo;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointTypeProxyKt;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointHighlighterRange;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointTypeProxy;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroupingRule;
import com.intellij.xdebugger.impl.evaluate.ValueLookupManagerController;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public class XDebuggerUtilImpl
extends XDebuggerUtil {
    private static final Logger LOG = Logger.getInstance(XDebuggerUtilImpl.class);
    private static final Ref<Boolean> SHOW_BREAKPOINT_AD = new Ref((Object)true);
    public static final DataKey<Integer> LINE_NUMBER = DataKey.create((String)"x.debugger.line.number");
    public static final DataKey<Integer> OFFSET = DataKey.create((String)"x.debugger.offset");

    public XLineBreakpointType<?>[] getLineBreakpointTypes() {
        return (XLineBreakpointType[])XBreakpointUtil.breakpointTypes().select(XLineBreakpointType.class).toArray(XLineBreakpointType[]::new);
    }

    public void toggleLineBreakpoint(@NotNull Project project, @NotNull VirtualFile file, int line, boolean temporary) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(0);
        }
        if (file == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(1);
        }
        this.toggleAndReturnLineBreakpoint(project, file, line, temporary);
    }

    @Nullable
    private XLineBreakpointType<?> getBreakpointTypeByPosition(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(2);
        }
        if (file == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(3);
        }
        XLineBreakpointType<?> typeWinner = null;
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file, line, project) || typeWinner != null && type.getPriority() <= typeWinner.getPriority()) continue;
            typeWinner = type;
        }
        return typeWinner;
    }

    public @NotNull Promise<@Nullable XLineBreakpoint> toggleAndReturnLineBreakpoint(@NotNull Project project, @NotNull VirtualFile file, int line, boolean temporary) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(4);
        }
        if (file == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XLineBreakpointType<?> typeWinner = this.getBreakpointTypeByPosition(project, file, line);
        if (typeWinner != null) {
            Promise<XLineBreakpoint> promise = this.toggleAndReturnLineBreakpoint(project, typeWinner, file, line, temporary);
            if (promise == null) {
                XDebuggerUtilImpl.$$$reportNull$$$0(6);
            }
            return promise;
        }
        Promise promise = Promises.rejectedPromise((Throwable)new RuntimeException("Cannot find appropriate breakpoint type"));
        if (promise == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(7);
        }
        return promise;
    }

    public boolean canPutBreakpointAt(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(8);
        }
        if (file == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(9);
        }
        return ContainerUtil.exists((Object[])this.getLineBreakpointTypes(), type -> type.canPutAt(file, line, project));
    }

    public <P extends XBreakpointProperties> void toggleLineBreakpoint(@NotNull Project project, @NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file, int line, boolean temporary) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(10);
        }
        if (type == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(11);
        }
        if (file == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(12);
        }
        this.toggleAndReturnLineBreakpoint(project, type, file, line, temporary);
    }

    public <P extends XBreakpointProperties> @NotNull Promise<@Nullable XLineBreakpoint> toggleAndReturnLineBreakpoint(@NotNull Project project, @NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file, int line, boolean temporary) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(13);
        }
        if (type == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(14);
        }
        if (file == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(15);
        }
        XSourcePositionImpl position = XSourcePositionImpl.create(file, line);
        return XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project, Collections.singletonList(type), position, false, temporary, null, true);
    }

    public static List<? extends XLineBreakpointType.XLineBreakpointVariant> getLineBreakpointVariantsSync(@NotNull Project project, @NotNull List<? extends XLineBreakpointType> types, @NotNull XSourcePosition position) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(16);
        }
        if (types == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(17);
        }
        if (position == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(18);
        }
        if (types.isEmpty()) {
            throw new IllegalArgumentException("non-empty types are expected");
        }
        boolean multipleTypes = types.size() > 1;
        SmartList allVariants = new SmartList();
        for (XLineBreakpointType xLineBreakpointType : types) {
            List variants = xLineBreakpointType.computeVariants(project, position);
            if (variants.isEmpty() && multipleTypes) {
                allVariants.add(XDebuggerUtilImpl.createDefaultBreakpointVariant(position, xLineBreakpointType));
                continue;
            }
            allVariants.addAll(variants);
        }
        if (allVariants.isEmpty()) {
            assert (!multipleTypes);
            return Collections.singletonList(XDebuggerUtilImpl.createDefaultBreakpointVariant(position, types.get(0)));
        }
        return allVariants;
    }

    public static Promise<List<? extends XLineBreakpointType.XLineBreakpointVariant>> getLineBreakpointVariants(@NotNull Project project, @NotNull List<? extends XLineBreakpointType> types, @NotNull XSourcePosition position) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(19);
        }
        if (types == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(20);
        }
        if (position == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(21);
        }
        if (types.isEmpty()) {
            return Promises.rejectedPromise((String)"non-empty types are expected");
        }
        boolean multipleTypes = types.size() > 1;
        SmartList promises = new SmartList();
        for (XLineBreakpointType xLineBreakpointType : types) {
            promises.add(xLineBreakpointType.computeVariantsAsync(project, position).then(o -> {
                if (((List)o).isEmpty() && multipleTypes) {
                    return Collections.singletonList(XDebuggerUtilImpl.createDefaultBreakpointVariant(position, type));
                }
                return o;
            }));
        }
        return Promises.collectResults((Collection)promises).then(v -> {
            List variants = StreamEx.of((Collection)v).toFlatList(l -> l);
            if (variants.isEmpty()) {
                assert (!multipleTypes);
                return Collections.singletonList(XDebuggerUtilImpl.createDefaultBreakpointVariant(position, (XLineBreakpointType)types.get(0)));
            }
            return variants;
        });
    }

    @NotNull
    private static XLineBreakpointType.XLineBreakpointAllVariant createDefaultBreakpointVariant(@NotNull XSourcePosition position, final XLineBreakpointType type) {
        if (position == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(22);
        }
        XLineBreakpointType xLineBreakpointType = type;
        Objects.requireNonNull(xLineBreakpointType);
        return new XLineBreakpointType.XLineBreakpointAllVariant(xLineBreakpointType, position){
            {
                XLineBreakpointType xLineBreakpointType2 = x0;
                Objects.requireNonNull(xLineBreakpointType2);
                super(xLineBreakpointType2, arg0);
            }

            @NotNull
            public String getText() {
                String string = StringUtil.notNullize((String)StringUtil.unpluralize((String)type.getTitle()), (String)type.getTitle());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = type.getEnabledIcon();
                if (icon == null) {
                    1.$$$reportNull$$$0(1);
                }
                return icon;
            }

            public boolean isMultiVariant() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/xdebugger/impl/XDebuggerUtilImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static int getIndexOfBestMatchingInlineVariant(int caretOffset, List<? extends FrontendXLineBreakpointVariant> variants) {
        assert (!variants.isEmpty());
        TextRange bestRange = null;
        int bestIndex = -1;
        for (int i = 0; i < variants.size(); ++i) {
            FrontendXLineBreakpointVariant variant = variants.get(i);
            TextRange range = variant.getHighlightRange();
            if (range == null || !range.contains(caretOffset) || bestRange != null && bestRange.getLength() <= range.getLength()) continue;
            bestRange = range;
            bestIndex = i;
        }
        return bestIndex == -1 ? 0 : bestIndex;
    }

    @NotNull
    private static <T> T getBestMatchingBreakpoint(int caretOffset, Iterator<@NotNull T> breakpoints, Function<T, @Nullable TextRange> rangeProvider) {
        T bestBreakpoint = null;
        int bestDistance = Integer.MAX_VALUE;
        int bestRangeLength = Integer.MAX_VALUE;
        while (breakpoints.hasNext()) {
            int distance;
            int rangeLength;
            T b = breakpoints.next();
            TextRange range = rangeProvider.apply(b);
            int n = rangeLength = range != null ? range.getLength() : Integer.MAX_VALUE;
            int n2 = range == null ? 0 : (distance = range.containsOffset(caretOffset) ? 0 : Math.min(Math.abs(range.getStartOffset() - caretOffset), Math.abs(range.getEndOffset() - caretOffset)));
            if (bestBreakpoint != null && distance >= bestDistance && (distance != bestDistance || rangeLength >= bestRangeLength)) continue;
            bestBreakpoint = b;
            bestDistance = distance;
            bestRangeLength = rangeLength;
        }
        assert (bestBreakpoint != null);
        T t = bestBreakpoint;
        if (t == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(23);
        }
        return t;
    }

    @Deprecated(forRemoval=true)
    public static @NotNull Promise<@Nullable XLineBreakpoint> toggleAndReturnLineBreakpoint(@NotNull Project project, @NotNull List<? extends XLineBreakpointType> types, @NotNull XSourcePosition position, boolean temporary, @Nullable Editor editor, boolean canRemove) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(24);
        }
        if (types == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(25);
        }
        if (position == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(26);
        }
        return XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project, types, position, true, temporary, editor, canRemove);
    }

    @ApiStatus.Obsolete
    public static @NotNull Promise<@Nullable XLineBreakpoint> toggleAndReturnLineBreakpoint(@NotNull Project project, @NotNull List<? extends XLineBreakpointType> types, @NotNull XSourcePosition position, boolean selectVariantByPositionColumn, boolean temporary, @Nullable Editor editor, boolean canRemove) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(27);
        }
        if (types == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(28);
        }
        if (position == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(29);
        }
        List proxyTypes = ContainerUtil.map(types, t -> XBreakpointTypeProxyKt.asProxy(t, project));
        CompletableFuture<XLineBreakpointProxy> future = XDebuggerUtilImpl.toggleAndReturnLineBreakpointProxy(project, proxyTypes, position, selectVariantByPositionColumn, temporary, editor, canRemove, false, null);
        Promise promise = Promises.asPromise(future).then(b -> {
            XBreakpointBase xBreakpointBase;
            if (b instanceof XLineBreakpointProxy.Monolith) {
                XLineBreakpointProxy.Monolith monolith = (XLineBreakpointProxy.Monolith)b;
                xBreakpointBase = monolith.getBreakpoint();
            } else {
                xBreakpointBase = null;
            }
            return xBreakpointBase;
        });
        if (promise == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(30);
        }
        return promise;
    }

    public static @NotNull CompletableFuture<@Nullable XLineBreakpointProxy> toggleAndReturnLineBreakpointProxy(@NotNull Project project, @NotNull List<XLineBreakpointTypeProxy> types, @NotNull XSourcePosition position, boolean selectVariantByPositionColumn, boolean temporary, @Nullable Editor editor, boolean canRemove, boolean isLogging, @Nullable String logExpression) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(31);
        }
        if (types == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(32);
        }
        if (position == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(33);
        }
        XLineBreakpointInstallationInfo breakpointInfo = new XLineBreakpointInstallationInfo(types, position, temporary, isLogging, logExpression, canRemove);
        return XDebuggerUtilImpl.toggleAndReturnLineBreakpointProxy(project, editor, breakpointInfo, selectVariantByPositionColumn);
    }

    public static @NotNull CompletableFuture<@Nullable XLineBreakpointProxy> toggleAndReturnLineBreakpointProxy(@NotNull Project project, @Nullable Editor editor, @NotNull XLineBreakpointInstallationInfo breakpointInfo, boolean selectVariantByPositionColumn) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(34);
        }
        if (breakpointInfo == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(35);
        }
        if (XDebuggerUtilImpl.areInlineBreakpointsEnabled((VirtualFile)breakpointInfo.getPosition().getFile())) {
            return XDebuggerUtilImpl.processInlineBreakpoints(project, editor, breakpointInfo, selectVariantByPositionColumn);
        }
        return XDebuggerUtilImpl.selectBreakpointVariantWithPopup(project, breakpointInfo, editor);
    }

    private static @NotNull CompletableFuture<@Nullable XLineBreakpointProxy> selectBreakpointVariantWithPopup(@NotNull Project project, @NotNull XLineBreakpointInstallationInfo breakpointInfo, @Nullable Editor editor) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(36);
        }
        if (breakpointInfo == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(37);
        }
        VirtualFile file = breakpointInfo.getPosition().getFile();
        int line = breakpointInfo.getPosition().getLine();
        XBreakpointManagerProxy breakpointManager = XDebugManagerProxy.getInstance().getBreakpointManagerProxy(project);
        for (XLineBreakpointTypeProxy type : breakpointInfo.getTypes()) {
            XLineBreakpointProxy breakpoint2 = breakpointManager.findBreakpointAtLine(type, file, line);
            if (breakpoint2 == null) continue;
            XDebuggerUtilImpl.removeBreakpointIfPossible((Project)project, (XLineBreakpointInstallationInfo)breakpointInfo, (XBreakpointProxy[])new XLineBreakpointProxy[]{breakpoint2});
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                XDebuggerUtilImpl.$$$reportNull$$$0(38);
            }
            return completableFuture;
        }
        CompletableFuture<XLineBreakpointProxy> completableFuture = FrontendXLineBreakpointVariantKt.computeBreakpointProxy(project, editor, breakpointInfo, (Function1<? super VariantChoiceData, Unit>)((Function1)variantChoice -> {
            assert (!variantChoice.getVariants().isEmpty());
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                RelativePoint relativePoint;
                for (XLineBreakpointTypeProxy type : breakpointInfo.getTypes()) {
                    if (breakpointManager.findBreakpointAtLine(type, file, line) == null) continue;
                    variantChoice.breakpointRemoved();
                    return;
                }
                RelativePoint relativePoint2 = relativePoint = editor != null ? DebuggerUIUtil.getPositionForPopup(editor, line) : null;
                if (variantChoice.getVariants().size() > 1 && relativePoint != null) {
                    XDebuggerUtilImpl.showBreakpointSelectionPopup(project, breakpointInfo.getPosition(), editor, variantChoice, relativePoint);
                } else {
                    variantChoice.select(variantChoice.getVariants().get(0));
                }
            });
            return Unit.INSTANCE;
        }));
        if (completableFuture == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(39);
        }
        return completableFuture;
    }

    private static void showBreakpointSelectionPopup(@NotNull Project project, @NotNull XSourcePosition position, final @NotNull Editor editor, final VariantChoiceData choiceData, RelativePoint relativePoint) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(40);
        }
        if (position == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(41);
        }
        if (editor == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(42);
        }
        final int line = position.getLine();
        final int defaultIndex = XDebuggerUtilImpl.getIndexOfBestMatchingInlineVariant(position.getOffset(), choiceData.getVariants());
        class MySelectionListener
        implements ListSelectionListener {
            RangeHighlighter myHighlighter = null;

            MySelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    this.updateHighlighter(((JList)e.getSource()).getSelectedValue());
                }
            }

            public void initialSet(Object value) {
                if (this.myHighlighter == null) {
                    this.updateHighlighter(value);
                }
            }

            void updateHighlighter(Object value) {
                this.clearHighlighter();
                if (value instanceof FrontendXLineBreakpointVariant) {
                    FrontendXLineBreakpointVariant variant = (FrontendXLineBreakpointVariant)value;
                    TextRange range = variant.getHighlightRange();
                    TextRange lineRange = DocumentUtil.getLineTextRange((Document)editor.getDocument(), (int)line);
                    if (range == null) {
                        range = lineRange;
                    }
                    if (!range.isEmpty() && range.intersectsStrict(lineRange)) {
                        this.myHighlighter = editor.getMarkupModel().addRangeHighlighter(DebuggerColors.BREAKPOINT_ATTRIBUTES, range.getStartOffset(), range.getEndOffset(), 2980, HighlighterTargetArea.EXACT_RANGE);
                    }
                }
            }

            private void clearHighlighter() {
                if (this.myHighlighter != null) {
                    this.myHighlighter.dispose();
                }
            }
        }
        final MySelectionListener selectionListener = new MySelectionListener();
        BaseListPopupStep<FrontendXLineBreakpointVariant> step = new BaseListPopupStep<FrontendXLineBreakpointVariant>(XDebuggerBundle.message((String)"popup.title.set.breakpoint", (Object[])new Object[0]), choiceData.getVariants()){
            {
                super(arg0, arg1);
            }

            @NotNull
            public String getTextFor(FrontendXLineBreakpointVariant value) {
                String string = value.getText();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(FrontendXLineBreakpointVariant value) {
                return value.getIcon();
            }

            public void canceled() {
                selectionListener.clearHighlighter();
                choiceData.cancel();
            }

            public PopupStep<?> onChosen(FrontendXLineBreakpointVariant selectedValue, boolean finalChoice) {
                selectionListener.clearHighlighter();
                choiceData.select(selectedValue);
                return FINAL_CHOICE;
            }

            public int getDefaultOptionIndex() {
                return defaultIndex;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$2", "getTextFor"));
            }
        };
        ListPopupImpl popup2 = new ListPopupImpl(project, (ListPopupStep)step){
            {
                super(arg0, arg1);
            }

            protected void afterShow() {
                super.afterShow();
                selectionListener.initialSet(this.getList().getSelectedValue());
            }
        };
        DebuggerUIUtil.registerExtraHandleShortcuts(popup2, SHOW_BREAKPOINT_AD, "ToggleLineBreakpoint");
        popup2.addListSelectionListener((ListSelectionListener)selectionListener);
        popup2.show(relativePoint);
    }

    private static @NotNull CompletableFuture<@Nullable XLineBreakpointProxy> processInlineBreakpoints(@NotNull Project project, @Nullable Editor editor, @NotNull XLineBreakpointInstallationInfo breakpointInfo, boolean selectVariantByPositionColumn) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(43);
        }
        if (breakpointInfo == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(44);
        }
        CompletableFuture<XLineBreakpointProxy> completableFuture = FrontendXLineBreakpointVariantKt.computeBreakpointProxy(project, editor, breakpointInfo, (Function1<? super VariantChoiceData, Unit>)((Function1)variantChoice -> {
            FrontendXLineBreakpointVariant variant;
            List<FrontendXLineBreakpointVariant> variants = variantChoice.getVariants().stream().filter(v -> v.getUseAsInlineVariant()).toList();
            if (variants.isEmpty()) {
                LOG.error("Unexpected empty variants");
                variantChoice.cancel();
                return Unit.INSTANCE;
            }
            List<XLineBreakpointProxy> breakpoints = XDebuggerUtilImpl.findBreakpointsAtLine(project, breakpointInfo);
            if (selectVariantByPositionColumn) {
                Object breakpointOrVariant = XDebuggerUtilImpl.getBestMatchingBreakpoint(breakpointInfo.getPosition().getOffset(), Stream.concat(breakpoints.stream(), variants.stream()).iterator(), o -> {
                    TextRange textRange;
                    if (o instanceof XLineBreakpointProxy) {
                        XLineBreakpointProxy b = (XLineBreakpointProxy)o;
                        textRange = XDebuggerUtilImpl.rangeOrNull(b.getHighlightRange());
                    } else {
                        textRange = ((FrontendXLineBreakpointVariant)o).getHighlightRange();
                    }
                    return textRange;
                });
                if (breakpointOrVariant instanceof XLineBreakpointProxy) {
                    XLineBreakpointProxy existingBreakpoint = (XLineBreakpointProxy)breakpointOrVariant;
                    XDebuggerUtilImpl.removeBreakpointIfPossible((Project)project, (XLineBreakpointInstallationInfo)breakpointInfo, (XBreakpointProxy[])new XLineBreakpointProxy[]{existingBreakpoint});
                    variantChoice.breakpointRemoved();
                    return Unit.INSTANCE;
                }
                variant = (FrontendXLineBreakpointVariant)breakpointOrVariant;
            } else {
                if (!breakpoints.isEmpty()) {
                    XDebuggerUtilImpl.removeBreakpointIfPossible((Project)project, (XLineBreakpointInstallationInfo)breakpointInfo, (XBreakpointProxy[])((XLineBreakpointProxy[])breakpoints.toArray(XLineBreakpointProxy[]::new)));
                    variantChoice.breakpointRemoved();
                    return Unit.INSTANCE;
                }
                variant = variants.stream().max(Comparator.comparing(v -> v.getPriority())).get();
            }
            variantChoice.select(variant);
            return Unit.INSTANCE;
        }));
        if (completableFuture == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(45);
        }
        return completableFuture;
    }

    private static TextRange rangeOrNull(XLineBreakpointHighlighterRange range) {
        if (range instanceof XLineBreakpointHighlighterRange.Available) {
            XLineBreakpointHighlighterRange.Available available = (XLineBreakpointHighlighterRange.Available)range;
            return available.getRange();
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static @NotNull List<@NotNull XLineBreakpointProxy> findBreakpointsAtLine(@NotNull Project project, @NotNull XLineBreakpointInstallationInfo breakpointInfo) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(46);
        }
        if (breakpointInfo == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(47);
        }
        XBreakpointManagerProxy breakpointManager = XDebugManagerProxy.getInstance().getBreakpointManagerProxy(project);
        VirtualFile file = breakpointInfo.getPosition().getFile();
        int line = breakpointInfo.getPosition().getLine();
        List<XLineBreakpointProxy> list = breakpointInfo.getTypes().stream().flatMap(t -> breakpointManager.findBreakpointsAtLine((XLineBreakpointTypeProxy)t, file, line).stream()).toList();
        if (list == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(48);
        }
        return list;
    }

    public static <P extends XBreakpointProperties> XLineBreakpoint<P> addLineBreakpoint(XBreakpointManager breakpointManager, XLineBreakpointType.XLineBreakpointVariant variant, VirtualFile file, int line) {
        return XDebuggerUtilImpl.addLineBreakpoint(breakpointManager, variant, file, line, false);
    }

    public static <P extends XBreakpointProperties> XLineBreakpoint<P> addLineBreakpoint(XBreakpointManager breakpointManager, XLineBreakpointType.XLineBreakpointVariant variant, VirtualFile file, int line, Boolean temporary) {
        XLineBreakpoint<XBreakpointProperties> breakpoint2;
        XBreakpointProperties properties = variant.createProperties();
        XLineBreakpointType type = variant.getType();
        if (!type.variantAndBreakpointMatch(breakpoint2 = XDebuggerUtilImpl.addLineBreakpoint(breakpointManager, type, properties, file, line, temporary), variant)) {
            LOG.error("breakpoint doesn't match source variant, " + String.valueOf(type) + ", " + String.valueOf(variant.getClass()));
        }
        return breakpoint2;
    }

    private static <P extends XBreakpointProperties> XLineBreakpoint<P> addLineBreakpoint(XBreakpointManager breakpointManager, XLineBreakpointType<P> type, P properties, VirtualFile file, int line, Boolean temporary) {
        return breakpointManager.addLineBreakpoint(type, file.getUrl(), line, properties, temporary.booleanValue());
    }

    public static boolean removeBreakpointWithConfirmation(XBreakpointProxy breakpoint2) {
        return XDebuggerUtilImpl.removeBreakpointWithConfirmation(breakpoint2.getProject(), breakpoint2);
    }

    @ApiStatus.Internal
    public static <T extends XBreakpointProxy> void removeBreakpointIfPossible(Project project, XLineBreakpointInstallationInfo info, T ... breakpoints) {
        if (info.canRemoveBreakpoint()) {
            XDebuggerUtilImpl.removeBreakpointsWithConfirmation((Project)project, breakpoints);
        }
    }

    static <T extends XBreakpointProxy> void removeBreakpointsWithConfirmation(Project project, T ... breakpoints) {
        for (T b : breakpoints) {
            XDebuggerUtilImpl.removeBreakpointWithConfirmation(project, b);
        }
    }

    public static void removeBreakpointsWithConfirmation(List<XBreakpointProxy> breakpoints) {
        if (breakpoints.isEmpty()) {
            return;
        }
        Project project = breakpoints.get(0).getProject();
        LOG.assertTrue(ContainerUtil.and(breakpoints, b -> b.getProject().equals((Object)project)));
        XDebuggerUtilImpl.removeBreakpointsWithConfirmation((Project)project, (XBreakpointProxy[])((XBreakpointProxy[])breakpoints.toArray(XBreakpointProxy[]::new)));
    }

    public static void performDebuggerAction(@NotNull AnActionEvent e, @NotNull Runnable action) {
        if (e == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(49);
        }
        if (action == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(50);
        }
        action.run();
        XDebuggerUtilImpl.reshowInlayRunToCursor(e);
    }

    public static void reshowInlayRunToCursor(@NotNull AnActionEvent e) {
        if (e == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(51);
        }
        if (!(e.getInputEvent() instanceof MouseEvent)) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        XDebuggerUtilImpl.reshowInlayRunToCursor(project, editor);
    }

    @ApiStatus.Internal
    public static void reshowInlayRunToCursor(Project project, Editor editor) {
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
        if (xDebuggerManager instanceof XDebuggerManagerImpl) {
            XDebuggerManagerImpl debuggerManagerImpl = (XDebuggerManagerImpl)xDebuggerManager;
            debuggerManagerImpl.reshowInlayToolbar(editor);
        }
    }

    public static boolean removeBreakpointWithConfirmation(Project project, XBreakpointProxy breakpoint2) {
        if (!(XDebuggerUtilImpl.isEmptyExpression(breakpoint2.getConditionExpression()) && XDebuggerUtilImpl.isEmptyExpression(breakpoint2.getLogExpressionObject()) || ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode() || !XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isConfirmBreakpointRemoval())) {
            StringBuilder message = new StringBuilder("<html>").append(XDebuggerBundle.message((String)"message.confirm.breakpoint.removal.message", (Object[])new Object[0]));
            if (!XDebuggerUtilImpl.isEmptyExpression(breakpoint2.getConditionExpression())) {
                message.append("<br>").append(XDebuggerBundle.message((String)"message.confirm.breakpoint.removal.message.condition", (Object[])new Object[0])).append("<br><pre>").append(StringUtil.escapeXmlEntities((String)breakpoint2.getConditionExpression().getExpression())).append("</pre>");
            }
            if (!XDebuggerUtilImpl.isEmptyExpression(breakpoint2.getLogExpressionObject())) {
                message.append("<br>").append(XDebuggerBundle.message((String)"message.confirm.breakpoint.removal.message.log", (Object[])new Object[0])).append("<br><pre>").append(StringUtil.escapeXmlEntities((String)breakpoint2.getLogExpressionObject().getExpression())).append("</pre>");
            }
            if (Messages.showOkCancelDialog((String)message.toString(), (String)XDebuggerBundle.message((String)"message.confirm.breakpoint.removal.title", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon(), (DoNotAskOption)new DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    if (isSelected) {
                        XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().setConfirmBreakpointRemoval(false);
                    }
                }
            }) != 0) {
                return false;
            }
        }
        XBreakpointManagerProxy breakpointManager = XDebugManagerProxy.getInstance().getBreakpointManagerProxy(project);
        breakpointManager.rememberRemovedBreakpoint(breakpoint2);
        breakpointManager.removeBreakpoint(breakpoint2);
        return true;
    }

    public void removeBreakpoint(Project project, XBreakpoint<?> breakpoint2) {
        XDebuggerManager.getInstance((Project)project).getBreakpointManager().removeBreakpoint(breakpoint2);
    }

    public static void removeAllBreakpoints(@NotNull Project project) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(52);
        }
        ((XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)project).getBreakpointManager()).removeAllBreakpoints();
    }

    public <T extends XBreakpointType> T findBreakpointType(@NotNull Class<T> typeClass) {
        if (typeClass == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(53);
        }
        return (T)((XBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(typeClass));
    }

    public <T extends XDebuggerSettings<?>> T getDebuggerSettings(Class<T> aClass) {
        return XDebuggerSettingManagerImpl.getInstanceImpl().getSettings(aClass);
    }

    public XValueContainer getValueContainer(DataContext dataContext) {
        return XDebuggerTreeActionBase.getSelectedValue(dataContext);
    }

    @Nullable
    public XSourcePosition createPosition(@Nullable VirtualFile file, int line) {
        return file == null ? null : XSourcePositionImpl.create(file, line);
    }

    @Nullable
    public XSourcePosition createPosition(@Nullable VirtualFile file, int line, int column) {
        return file == null ? null : XSourcePositionImpl.create(file, line, column);
    }

    @Nullable
    public XSourcePosition createPositionByOffset(VirtualFile file, int offset) {
        return XSourcePositionImpl.createByOffset(file, offset);
    }

    @Nullable
    public XSourcePosition createPositionByElement(PsiElement element) {
        return XSourcePositionImpl.createByElement(element);
    }

    public <B extends XLineBreakpoint<?>> XBreakpointGroupingRule<B, ?> getGroupingByFileRule() {
        return new XBreakpointFileGroupingRule();
    }

    @Nullable
    public static XSourcePosition getCaretPosition(@NotNull Project project, DataContext context) {
        Editor editor;
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(54);
        }
        if ((editor = XDebuggerUtilImpl.getEditor(project, context)) == null) {
            return null;
        }
        Integer lineNumber = (Integer)LINE_NUMBER.getData(context);
        if (lineNumber != null) {
            return XSourcePositionImpl.create(editor.getVirtualFile(), lineNumber);
        }
        Integer offsetFromDataContext = (Integer)OFFSET.getData(context);
        if (offsetFromDataContext != null) {
            return XSourcePositionImpl.createByOffset(editor.getVirtualFile(), offsetFromDataContext);
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        return XSourcePositionImpl.createByOffset(file, offset);
    }

    @Nullable
    public static Editor getEditor(@NotNull Project project, DataContext context) {
        Editor editor;
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(55);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(context)) == null) {
            Editor editor2;
            @Nullable FileEditor fileEditor = (FileEditor)context.getData(PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR);
            if (fileEditor instanceof TextEditor) {
                TextEditor textEditor = (TextEditor)fileEditor;
                editor2 = textEditor.getEditor();
            } else {
                editor2 = null;
            }
            return editor2;
        }
        return editor;
    }

    public void iterateLine(@NotNull Project project, @NotNull Document document, int line, @NotNull Processor<? super PsiElement> processor) {
        int lineEnd;
        int lineStart;
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(56);
        }
        if (document == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(57);
        }
        if (processor == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(58);
        }
        try {
            lineStart = document.getLineStartOffset(line);
            lineEnd = document.getLineEndOffset(line);
        }
        catch (IndexOutOfBoundsException ignored) {
            return;
        }
        this.iterateOffsetRange(project, document, lineStart, lineEnd, processor);
    }

    public void iterateOffsetRange(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Processor<? super PsiElement> processor) {
        PsiFile file;
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(59);
        }
        if (document == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(60);
        }
        if (processor == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(61);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null) {
            return;
        }
        int offset = startOffset;
        while (offset < endOffset) {
            PsiElement element = file.findElementAt(offset);
            if (element != null && element.getTextLength() > 0) {
                if (!processor.process((Object)element)) {
                    return;
                }
                offset = element.getTextRange().getEndOffset();
                continue;
            }
            ++offset;
        }
    }

    public <B extends XLineBreakpoint<?>> List<XBreakpointGroupingRule<B, ?>> getGroupingByFileRuleAsList() {
        return Collections.singletonList(this.getGroupingByFileRule());
    }

    @Nullable
    public PsiElement findContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project, boolean checkXml) {
        PsiLanguageInjectionHost parent;
        PsiElement element;
        PsiFile file;
        if (virtualFile == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(62);
        }
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(63);
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        PsiFile psiFile = file = document == null ? null : PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (file == null) {
            return null;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > document.getTextLength()) {
            offset = document.getTextLength();
        }
        int startOffset = offset;
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
        PsiElement result2 = null;
        do {
            if ((element = file.findElementAt(offset)) instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            result2 = element;
            break;
        } while ((offset = element.getTextRange().getEndOffset() + 1) < lineEndOffset);
        if (result2 == null) {
            result2 = file.findElementAt(startOffset);
        }
        if (checkXml && result2 != null && StdFileTypes.XML.getLanguage().equals(result2.getLanguage()) && (parent = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)result2, PsiLanguageInjectionHost.class)) != null) {
            result2 = InjectedLanguageUtil.findElementInInjected((PsiLanguageInjectionHost)parent, (int)offset);
        }
        return result2;
    }

    public void disableValueLookup(@NotNull Editor editor) {
        if (editor == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(64);
        }
        ValueLookupManagerController.DISABLE_VALUE_LOOKUP.set((UserDataHolder)editor, (Object)Boolean.TRUE);
    }

    @Nullable
    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor) {
        if (descriptor == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(65);
        }
        return XDebuggerUtilImpl.createEditor(descriptor);
    }

    public static Editor createEditor(@NotNull OpenFileDescriptor descriptor) {
        if (descriptor == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(66);
        }
        if (descriptor.canNavigate()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)descriptor.getProject());
            boolean isEditorAreaFocused = fileEditorManager.getFocusedEditor() != null;
            return fileEditorManager.openTextEditor(descriptor, isEditorAreaFocused);
        }
        return null;
    }

    @NotNull
    public static Navigatable wrapKeepEditorAreaFocusNavigatable(final @NotNull Project project, final @NotNull Navigatable navigatable) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(67);
        }
        if (navigatable == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(68);
        }
        return new Navigatable(){

            public void navigate(boolean requestFocus) {
                boolean isEditorAreaFocused = FileEditorManager.getInstance((Project)project).getFocusedEditor() != null;
                navigatable.navigate(requestFocus && isEditorAreaFocused);
            }

            public boolean canNavigate() {
                return navigatable.canNavigate();
            }

            public boolean canNavigateToSource() {
                return navigatable.canNavigateToSource();
            }
        };
    }

    public static void rebuildAllSessionsViews(@Nullable Project project) {
        if (project == null) {
            return;
        }
        XDebugManagerProxy.getInstance().getSessions(project).stream().filter(XDebugSessionProxy::isSuspended).forEach(XDebugSessionProxy::rebuildViews);
    }

    public static void rebuildTreeAndViews(XDebuggerTree tree) {
        if (tree.isDetached()) {
            tree.rebuildAndRestore(XDebuggerTreeState.saveState(tree));
        }
        XDebuggerUtilImpl.rebuildAllSessionsViews(tree.getProject());
    }

    @NotNull
    public XExpression createExpression(@NotNull String text, Language language, String custom, @NotNull EvaluationMode mode) {
        if (text == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(69);
        }
        if (mode == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(70);
        }
        return new XExpressionImpl(text, language, custom, mode);
    }

    public static boolean isEmptyExpression(@Nullable XExpression expression) {
        return expression == null || StringUtil.isEmptyOrSpaces((String)expression.getExpression());
    }

    public void logStack(@NotNull XSuspendContext suspendContext, final @NotNull XDebugSession session) {
        XExecutionStack activeExecutionStack;
        if (suspendContext == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(71);
        }
        if (session == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(72);
        }
        if ((activeExecutionStack = suspendContext.getActiveExecutionStack()) != null) {
            activeExecutionStack.computeStackFrames(0, (XExecutionStack.XStackFrameContainer)new XStackFrameContainerEx(){
                final List<XStackFrame> myFrames = new ArrayList<XStackFrame>();

                public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
                    if (stackFrames == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    this.myFrames.addAll(stackFrames);
                    if (last) {
                        this.print(null);
                    }
                }

                @Override
                public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect, boolean last) {
                    if (stackFrames == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    this.addStackFrames(stackFrames, last);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        6.$$$reportNull$$$0(2);
                    }
                    this.print(errorMessage);
                }

                void print(@Nullable String errorMessage) {
                    ConsoleView view = session.getConsoleView();
                    Project project = session.getProject();
                    DebuggerUIUtil.invokeLater(() -> view.print("Stack: ", ConsoleViewContentType.SYSTEM_OUTPUT));
                    this.myFrames.forEach(f -> {
                        SimpleColoredText text = new SimpleColoredText();
                        ReadAction.run(() -> f.customizeTextPresentation((ColoredTextContainer)text));
                        XSourcePosition position = f.getSourcePosition();
                        Navigatable navigatable = position != null ? position.createNavigatable(project) : null;
                        DebuggerUIUtil.invokeLater(() -> {
                            view.print("\n\t", ConsoleViewContentType.SYSTEM_OUTPUT);
                            view.printHyperlink(text.toString(), p -> {
                                if (navigatable != null) {
                                    navigatable.navigate(true);
                                }
                            });
                        });
                    });
                    DebuggerUIUtil.invokeLater(() -> {
                        if (errorMessage != null) {
                            view.print("\n\t" + errorMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
                        }
                        view.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "stackFrames";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerUtilImpl$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "addStackFrames";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public static Icon getVerifiedIcon(@NotNull XBreakpoint breakpoint2) {
        if (breakpoint2 == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(73);
        }
        return breakpoint2.getSuspendPolicy() == SuspendPolicy.NONE ? AllIcons.Debugger.Db_verified_no_suspend_breakpoint : AllIcons.Debugger.Db_verified_breakpoint;
    }

    public static Navigatable createNavigatable(Project project, XSourcePosition position) {
        return XDebuggerUtilImplShared.createNavigatable((Project)project, (XSourcePosition)position);
    }

    @NotNull
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(74);
        }
        if (position == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(75);
        }
        OpenFileDescriptor openFileDescriptor = XDebuggerUtilImplShared.createOpenFileDescriptor((Project)project, (XSourcePosition)position);
        if (openFileDescriptor == null) {
            XDebuggerUtilImpl.$$$reportNull$$$0(76);
        }
        return openFileDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 23, 30, 38, 39, 45, 48, 76 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 23: 
            case 30: 
            case 38: 
            case 39: 
            case 45: 
            case 48: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerUtilImpl";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 26: 
            case 29: 
            case 33: 
            case 41: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 35: 
            case 37: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointInfo";
                break;
            }
            case 42: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClass";
                break;
            }
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerUtilImpl";
                break;
            }
            case 6: 
            case 7: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleAndReturnLineBreakpoint";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestMatchingBreakpoint";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "selectBreakpointVariantWithPopup";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "processInlineBreakpoints";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findBreakpointsAtLine";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenFileDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toggleLineBreakpoint";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpointTypeByPosition";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "toggleAndReturnLineBreakpoint";
                break;
            }
            case 6: 
            case 7: 
            case 23: 
            case 30: 
            case 38: 
            case 39: 
            case 45: 
            case 48: 
            case 76: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canPutBreakpointAt";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakpointVariantsSync";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakpointVariants";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpointVariant";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "toggleAndReturnLineBreakpointProxy";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "selectBreakpointVariantWithPopup";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "showBreakpointSelectionPopup";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processInlineBreakpoints";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findBreakpointsAtLine";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "performDebuggerAction";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "reshowInlayRunToCursor";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removeAllBreakpoints";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findBreakpointType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCaretPosition";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "iterateLine";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "iterateOffsetRange";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findContextElement";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "disableValueLookup";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "openTextEditor";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "wrapKeepEditorAreaFocusNavigatable";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "logStack";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getVerifiedIcon";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createOpenFileDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 23, 30, 38, 39, 45, 48, 76 -> new IllegalStateException(string);
        };
    }
}

