/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.popup.util.DetailController;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.DetailViewImpl;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointTypeProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.ui.AddXBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointCustomGroup;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsCheckboxTree;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import com.intellij.xdebugger.impl.rpc.XBreakpointId;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BreakpointsDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @Nullable
    private final XBreakpointId myInitialBreakpointId;
    private final XBreakpointManagerProxy myBreakpointManager;
    private BreakpointItemsTreeController myTreeController;
    private final MasterController myMasterController;
    private final DetailController myDetailController;
    private final Collection<BreakpointItem> myBreakpointItems;
    private final SingleAlarm myRebuildAlarm;
    private final List<XBreakpointGroupingRule> myRulesAvailable;
    private final Set<XBreakpointGroupingRule> myRulesEnabled;
    private final Disposable myListenerDisposable;
    private final List<ToggleAction> myToggleRuleActions;

    private void updateBreakpoints() {
        this.collectItems();
        this.myTreeController.rebuildTree(this.myBreakpointItems);
        this.myDetailController.doUpdateDetailView(true);
    }

    private XBreakpointManagerProxy getBreakpointManager() {
        return this.myBreakpointManager;
    }

    protected BreakpointsDialog(@NotNull Project project, @Nullable XBreakpointId initialBreakpointId, XBreakpointManagerProxy breakpointManager) {
        if (project == null) {
            BreakpointsDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myMasterController = new MasterController(){

            public ItemWrapper[] getSelectedItems() {
                List<BreakpointItem> res = BreakpointsDialog.this.myTreeController.getSelectedBreakpoints(false);
                return res.toArray(new ItemWrapper[0]);
            }

            @Nullable
            public JLabel getPathLabel() {
                return null;
            }
        };
        this.myDetailController = new DetailController(this.myMasterController);
        this.myBreakpointItems = new ArrayList<BreakpointItem>();
        this.myRebuildAlarm = new SingleAlarm(() -> this.updateBreakpoints(), 100, this.myDisposable);
        this.myRulesAvailable = new ArrayList<XBreakpointGroupingRule>();
        this.myRulesEnabled = new TreeSet<XBreakpointGroupingRule>(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
        this.myListenerDisposable = Disposer.newDisposable();
        this.myToggleRuleActions = new ArrayList<ToggleAction>();
        this.myProject = project;
        this.myInitialBreakpointId = initialBreakpointId;
        this.myBreakpointManager = breakpointManager;
        this.collectGroupingRules();
        this.collectItems();
        this.setTitle(XDebuggerBundle.message((String)"xbreakpoints.dialog.title", (Object[])new Object[0]));
        this.setModal(false);
        this.init();
        this.setOKButtonText(XDebuggerBundle.message((String)"done.action.text", (Object[])new Object[0]));
    }

    private String getSplitterProportionKey() {
        return this.getDimensionServiceKey() + ".splitter";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JBSplitter splitPane = new JBSplitter(0.3f);
        splitPane.setSplitterProportionKey(this.getSplitterProportionKey());
        splitPane.setFirstComponent(this.createMasterView());
        splitPane.setSecondComponent(this.createDetailView());
        mainPanel.add((Component)splitPane, "Center");
        return mainPanel;
    }

    private JComponent createDetailView() {
        DetailViewImpl detailView = new DetailViewImpl(this.myProject);
        detailView.setEmptyLabel(XDebuggerBundle.message((String)"xbreakpoint.label.empty", (Object[])new Object[0]));
        detailView.addEditorChangedListener(newEditor -> {
            if (newEditor != null) {
                this.registerEditSourceAction(newEditor.getComponent());
            }
        });
        this.myDetailController.setDetailView((DetailView)detailView);
        return detailView;
    }

    private void registerEditSourceAction(JComponent component) {
        new AnAction(XDebuggerBundle.messagePointer((String)"action.Anonymous.text.breakpointdialog.showsource", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                BreakpointsDialog.this.navigate(true);
                BreakpointsDialog.this.close(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$2", "actionPerformed"));
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), component, this.myDisposable);
    }

    void collectItems() {
        this.disposeItems();
        this.myBreakpointItems.clear();
        this.myBreakpointItems.addAll(this.getBreakpointManager().getAllBreakpointItems());
    }

    void initSelection(Collection<BreakpointItem> breakpoints) {
        XBreakpointsDialogState settings = this.getBreakpointManager().getBreakpointsDialogSettings();
        if (settings != null && settings.getTreeState() != null) {
            settings.getTreeState().applyTo(this.myTreeController.getTreeView());
            if (this.myTreeController.getTreeView().getSelectionCount() == 0) {
                this.myTreeController.selectFirstBreakpointItem();
            }
        } else {
            TreeUtil.expand((JTree)this.myTreeController.getTreeView(), path -> {
                Object lastPathComponent = path.getLastPathComponent();
                if (!(lastPathComponent instanceof BreakpointsGroupNode)) {
                    return TreeVisitor.Action.CONTINUE;
                }
                return ((BreakpointsGroupNode)((Object)((Object)lastPathComponent))).getGroup().expandedByDefault() ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.SKIP_CHILDREN;
            }, treePath -> {});
            this.myTreeController.selectFirstBreakpointItem();
        }
        this.selectBreakpoint(this.myInitialBreakpointId, false);
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getHelpAction()};
        if (actionArray == null) {
            BreakpointsDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    private JComponent createMasterView() {
        this.myTreeController = new BreakpointItemsTreeController(this.myRulesEnabled){

            @Override
            public void nodeStateWillChangeImpl(CheckedTreeNode node) {
                if (node instanceof BreakpointItemNode) {
                    ((BreakpointItemNode)node).getBreakpointItem().saveState();
                }
                super.nodeStateWillChangeImpl(node);
            }

            @Override
            public void nodeStateDidChangeImpl(CheckedTreeNode node) {
                super.nodeStateDidChangeImpl(node);
                if (node instanceof BreakpointItemNode) {
                    BreakpointsDialog.this.myDetailController.doUpdateDetailView(true);
                }
            }

            @Override
            protected void selectionChangedImpl() {
                super.selectionChangedImpl();
                BreakpointsDialog.this.saveCurrentItem();
                BreakpointsDialog.this.myDetailController.updateDetailView();
            }
        };
        final BreakpointsCheckboxTree tree = new BreakpointsCheckboxTree(this.myProject, this.myTreeController){

            protected void onDoubleClick(CheckedTreeNode node) {
                if (node instanceof BreakpointsGroupNode) {
                    TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
                    if (this.isExpanded(path)) {
                        this.collapsePath(path);
                    } else {
                        this.expandPath(path);
                    }
                } else {
                    BreakpointsDialog.this.navigate(false);
                }
            }
        };
        tree.setHorizontalAutoScrollingEnabled(false);
        PopupHandler.installPopupMenu((JComponent)((Object)tree), (ActionGroup)new ActionGroup(){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                ActionGroup group = new ActionGroup(XDebuggerBundle.message((String)"move.to.group", (Object[])new Object[0]), true){

                    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                        ArrayList<MoveToGroupAction> res = new ArrayList<MoveToGroupAction>();
                        res.add(new MoveToGroupAction(null));
                        BreakpointsDialog.this.myBreakpointItems.stream().map(BreakpointItem::getBreakpoint).filter(Objects::nonNull).map(XBreakpointProxy::getGroup).filter(Objects::nonNull).distinct().sorted().forEach(g -> res.add(new MoveToGroupAction((String)g)));
                        res.add((MoveToGroupAction)new Separator());
                        res.add(new MoveToGroupAction());
                        AnAction[] anActionArray = res.toArray(AnAction.EMPTY_ARRAY);
                        if (anActionArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return anActionArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$5$1", "getChildren"));
                    }
                };
                ArrayList<Object> res = new ArrayList<Object>();
                res.add(group);
                Object component = tree.getLastSelectedPathComponent();
                if (tree.getSelectionCount() == 1 && component instanceof BreakpointsGroupNode && ((BreakpointsGroupNode)((Object)component)).getGroup() instanceof XBreakpointCustomGroup) {
                    res.add((Object)new SetAsDefaultGroupAction((XBreakpointCustomGroup)((Object)((BreakpointsGroupNode)((Object)component)).getGroup())));
                }
                if (tree.getSelectionCount() == 1 && component instanceof BreakpointItemNode) {
                    res.add((Object)new EditDescriptionAction(((BreakpointItemNode)((Object)component)).getBreakpointItem().getBreakpoint()));
                }
                AnAction[] anActionArray = res.toArray(AnAction.EMPTY_ARRAY);
                if (anActionArray == null) {
                    5.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$5", "getChildren"));
            }
        }, (String)"BreakpointTreePopup");
        new AnAction(XDebuggerBundle.messagePointer((String)"action.Anonymous.text.breakpointdialog.gotosource", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                BreakpointsDialog.this.navigate(true);
                BreakpointsDialog.this.close(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$6", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)tree), this.myDisposable);
        this.registerEditSourceAction((JComponent)((Object)tree));
        List<AddXBreakpointAction> breakpointTypeActions = this.getBreakpointManager().getAllBreakpointTypes().stream().filter(XBreakpointTypeProxy::isAddBreakpointButtonVisible).map(type -> new AddXBreakpointAction(this.myProject, (XBreakpointTypeProxy)type, (Function0<Unit>)((Function0)() -> {
            this.saveCurrentItem();
            return Unit.INSTANCE;
        }), (Function1<? super XBreakpointId, Unit>)((Function1)breakpointId -> {
            this.selectBreakpoint((XBreakpointId)breakpointId, true);
            return Unit.INSTANCE;
        }))).toList();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)tree)).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty()).setAddAction(BreakpointsDialog.createAddActionRunnable(breakpointTypeActions)).setRemoveAction(button -> this.myTreeController.removeSelectedBreakpoints(this.myProject)).setRemoveActionUpdater(e -> {
            for (BreakpointItem item : this.myTreeController.getSelectedBreakpoints(true)) {
                if (!item.allowedToRemove()) continue;
                return true;
            }
            return false;
        });
        this.myToggleRuleActions.forEach(arg_0 -> ((ToolbarDecorator)decorator).addExtraAction(arg_0));
        JPanel decoratorPanel = decorator.createPanel();
        this.myTreeController.setTreeView((JTree)((Object)tree));
        this.myTreeController.buildTree(this.myBreakpointItems);
        this.initSelection(this.myBreakpointItems);
        this.myBreakpointManager.subscribeOnBreakpointsChanges(this.myListenerDisposable, (Function0<Unit>)((Function0)() -> {
            this.myRebuildAlarm.cancelAndRequest();
            return Unit.INSTANCE;
        }));
        return decoratorPanel;
    }

    @Nullable
    private static AnActionButtonRunnable createAddActionRunnable(List<AddXBreakpointAction> breakpointTypeActions) {
        DefaultActionGroup breakpointTypes = new DefaultActionGroup(breakpointTypeActions);
        AnActionButtonRunnable addAction = breakpointTypeActions.isEmpty() ? null : button -> JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)breakpointTypes, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.NUMBERING, false).show(button.getPreferredPopupPoint());
        return addAction;
    }

    private void navigate(boolean requestFocus) {
        this.myTreeController.getSelectedBreakpoints(false).stream().findFirst().ifPresent(b -> b.navigate(requestFocus));
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTreeController.getTreeView();
    }

    private void collectGroupingRules() {
        this.myRulesAvailable.addAll(XBreakpointGroupingRule.EP.getExtensionList());
        this.myRulesAvailable.sort(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
        this.myRulesEnabled.clear();
        XBreakpointsDialogState settings = this.getBreakpointManager().getBreakpointsDialogSettings();
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (!rule.isAlwaysEnabled() && (settings == null || !settings.getSelectedGroupingRules().contains(rule.getId()))) continue;
            this.myRulesEnabled.add(rule);
        }
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (rule.isAlwaysEnabled()) continue;
            this.myToggleRuleActions.add((ToggleAction)new ToggleBreakpointGroupingRuleEnabledAction(rule));
        }
    }

    private void saveBreakpointsDialogState() {
        XBreakpointsDialogState dialogState = new XBreakpointsDialogState();
        this.saveTreeState(dialogState);
        List rulesEnabled = ContainerUtil.filter(this.myRulesEnabled, rule -> !rule.isAlwaysEnabled());
        dialogState.setSelectedGroupingRules(new HashSet<String>(ContainerUtil.map((Collection)rulesEnabled, XBreakpointGroupingRule::getId)));
        this.getBreakpointManager().setBreakpointsDialogSettings(dialogState);
    }

    private void saveTreeState(XBreakpointsDialogState state) {
        JTree tree = this.myTreeController.getTreeView();
        state.setTreeState(TreeState.createOn((JTree)tree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)tree.getModel().getRoot())));
    }

    protected void dispose() {
        this.saveCurrentItem();
        Disposer.dispose((Disposable)this.myListenerDisposable);
        this.saveBreakpointsDialogState();
        this.disposeItems();
        super.dispose();
    }

    private void disposeItems() {
        this.myBreakpointItems.forEach(BreakpointItem::dispose);
    }

    @Nullable
    protected String getHelpId() {
        return "reference.dialogs.breakpoints";
    }

    private void saveCurrentItem() {
        ItemWrapper item = this.myDetailController.getSelectedItem();
        if (item instanceof BreakpointItem) {
            ((BreakpointItem)item).saveState();
        }
    }

    public void toFront() {
        Window window = this.getWindow();
        if (window != null) {
            window.setBounds(window.getBounds());
        }
        super.toFront();
    }

    public boolean selectBreakpoint(@Nullable XBreakpointId breakpointId, boolean update) {
        if (update) {
            this.updateBreakpoints();
        }
        if (breakpointId != null) {
            for (BreakpointItem item : this.myBreakpointItems) {
                if (!Objects.equals(item.getId(), breakpointId)) continue;
                this.myTreeController.selectBreakpointItem(item, null);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class ToggleBreakpointGroupingRuleEnabledAction
    extends DumbAwareToggleAction {
        private final XBreakpointGroupingRule<?, ?> myRule;

        ToggleBreakpointGroupingRuleEnabledAction(XBreakpointGroupingRule<?, ?> rule) {
            super(rule.getPresentableName(), null, rule.getIcon());
            this.myRule = rule;
            this.getTemplatePresentation().setText(rule.getPresentableName());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleBreakpointGroupingRuleEnabledAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(AnActionEvent e) {
            return BreakpointsDialog.this.myRulesEnabled.contains(this.myRule);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                BreakpointsDialog.this.myRulesEnabled.add(this.myRule);
            } else {
                BreakpointsDialog.this.myRulesEnabled.remove(this.myRule);
            }
            BreakpointsDialog.this.myTreeController.setGroupingRules(BreakpointsDialog.this.myRulesEnabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$ToggleBreakpointGroupingRuleEnabledAction", "getActionUpdateThread"));
        }
    }

    private final class EditDescriptionAction
    extends AnAction {
        private final XBreakpointProxy myBreakpoint;

        private EditDescriptionAction(XBreakpointProxy breakpoint2) {
            super(XDebuggerBundle.message((String)"breakpoints.dialog.edit.description", (Object[])new Object[0]));
            this.myBreakpoint = breakpoint2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String description;
            if (e == null) {
                EditDescriptionAction.$$$reportNull$$$0(0);
            }
            if ((description = Messages.showInputDialog((String)"", (String)XDebuggerBundle.message((String)"breakpoints.dialog.edit.description", (Object[])new Object[0]), null, (String)this.myBreakpoint.getUserDescription(), null)) == null) {
                return;
            }
            this.myBreakpoint.setUserDescription(description);
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$EditDescriptionAction", "actionPerformed"));
        }
    }

    private final class SetAsDefaultGroupAction
    extends AnAction {
        @Nullable
        private final String myName;

        private SetAsDefaultGroupAction(XBreakpointCustomGroup group) {
            super(group.isDefault() ? XDebuggerBundle.message((String)"breakpoints.dialog.unset.as.default", (Object[])new Object[0]) : XDebuggerBundle.message((String)"breakpoints.dialog.set.as.default", (Object[])new Object[0]));
            this.myName = group.isDefault() ? null : group.getName();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetAsDefaultGroupAction.$$$reportNull$$$0(0);
            }
            BreakpointsDialog.this.getBreakpointManager().setDefaultGroup(this.myName);
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$SetAsDefaultGroupAction", "actionPerformed"));
        }
    }

    private final class MoveToGroupAction
    extends AnAction {
        private final String myGroup;
        private final boolean myNewGroup;

        private MoveToGroupAction(String group) {
            super(group == null ? XDebuggerBundle.message((String)"breakpoints.dialog.no.group", (Object[])new Object[0]) : group);
            this.myGroup = group;
            this.myNewGroup = false;
        }

        private MoveToGroupAction() {
            super(XDebuggerBundle.message((String)"breakpoints.dialog.create.new.group", (Object[])new Object[0]));
            this.myNewGroup = true;
            this.myGroup = null;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveToGroupAction.$$$reportNull$$$0(0);
            }
            String groupName = this.myGroup;
            if (this.myNewGroup && (groupName = Messages.showInputDialog((String)XDebuggerBundle.message((String)"breakpoints.dialog.new.group.name", (Object[])new Object[0]), (String)XDebuggerBundle.message((String)"breakpoints.dialog.new.group", (Object[])new Object[0]), (Icon)AllIcons.Nodes.Folder)) == null) {
                return;
            }
            for (BreakpointItem item : BreakpointsDialog.this.myTreeController.getSelectedBreakpoints(true)) {
                XBreakpointProxy breakpoint2 = item.getBreakpoint();
                if (breakpoint2 == null) continue;
                breakpoint2.setGroup(groupName);
            }
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog$MoveToGroupAction", "actionPerformed"));
        }
    }
}

