/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarListener;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.AnActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.impl.ui.InplaceEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public abstract class XDebuggerPopupPanel {
    @NotNull
    protected final BorderLayoutPanel myContent = JBUI.Panels.simplePanel();
    @NotNull
    protected final BorderLayoutPanel myMainPanel = JBUI.Panels.simplePanel();
    protected ActionToolbarImpl myToolbar = null;

    protected boolean shouldBeVisible(AnAction action) {
        return true;
    }

    protected final void setAutoResizeUntilToolbarNotFull(final @NotNull Runnable resizeRunnable, Disposable disposable) {
        if (resizeRunnable == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(0);
        }
        if (this.myToolbar == null) {
            return;
        }
        final ContainerListener containerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                resizeRunnable.run();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                resizeRunnable.run();
            }
        };
        this.myToolbar.addContainerListener(containerListener);
        this.myToolbar.addListener(new ActionToolbarListener(){
            private boolean myActionsUpdatedOnce = false;

            public void actionsUpdated() {
                if (this.myActionsUpdatedOnce) {
                    XDebuggerPopupPanel.this.myToolbar.removeContainerListener(containerListener);
                }
                this.myActionsUpdatedOnce = true;
            }
        }, disposable);
    }

    protected static void updatePopupBounds(@NotNull Window popupWindow, int newWidth, int newHeight) {
        if (popupWindow == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(1);
        }
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Component)popupWindow);
        Point location = popupWindow.getLocation();
        int delta = location.x + newWidth - (screenRectangle.x + screenRectangle.width);
        location.x -= Math.max(delta, 0);
        location.x = Math.max(location.x, screenRectangle.x);
        Rectangle targetBounds = new Rectangle(location.x, location.y, newWidth, newHeight);
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        if (targetBounds.height != popupWindow.getHeight() || targetBounds.width != popupWindow.getWidth()) {
            popupWindow.setBounds(targetBounds);
            popupWindow.validate();
            popupWindow.repaint();
        }
    }

    protected final void setContent(@NotNull JComponent content, @NotNull DefaultActionGroup toolbarActions, @NotNull String actionsPlace, @Nullable Component toolbarActionsDataProvider) {
        if (content == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(2);
        }
        if (toolbarActions == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(3);
        }
        if (actionsPlace == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(4);
        }
        this.myToolbar = this.createToolbar(toolbarActions, actionsPlace, toolbarActionsDataProvider);
        this.fillContentPanel(content, this.myToolbar);
    }

    @NotNull
    private ActionToolbarImpl createToolbar(@NotNull DefaultActionGroup toolbarActions, @NotNull String actionsPlace, @Nullable Component toolbarActionsDataProvider) {
        if (toolbarActions == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(5);
        }
        if (actionsPlace == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(6);
        }
        toolbarActions.add((AnAction)new Separator());
        DefaultActionGroup wrappedActions = this.wrapActions(toolbarActions, actionsPlace, toolbarActionsDataProvider);
        ActionToolbarImpl toolbarImpl = new ActionToolbarImpl(actionsPlace, (ActionGroup)wrappedActions, true);
        toolbarImpl.setTargetComponent(null);
        for (AnAction action : wrappedActions.getChildren(ActionManager.getInstance())) {
            action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)this.myMainPanel);
        }
        toolbarImpl.setBorder(BorderFactory.createEmptyBorder());
        ActionToolbarImpl actionToolbarImpl = toolbarImpl;
        if (actionToolbarImpl == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(7);
        }
        return actionToolbarImpl;
    }

    private void fillContentPanel(@NotNull JComponent content, @NotNull ActionToolbarImpl toolbar) {
        if (content == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(8);
        }
        if (toolbar == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(9);
        }
        this.myMainPanel.addToCenter((Component)content);
        toolbar.setBackground(UIUtil.getToolTipActionBackground());
        new WindowMoveListener((Component)this.myContent).installTo((Component)toolbar);
        this.myContent.addToCenter((Component)this.myMainPanel).addToBottom((Component)toolbar);
    }

    @NotNull
    private DefaultActionGroup wrapActions(@NotNull DefaultActionGroup toolbarActions, @NotNull String actionsPlace, @Nullable Component toolbarActionsDataProvider) {
        if (toolbarActions == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(10);
        }
        if (actionsPlace == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(11);
        }
        DefaultActionGroup wrappedActions = new DefaultActionGroup();
        for (AnAction action : toolbarActions.getChildren(ActionManager.getInstance())) {
            ActionWrapper actionLink = new ActionWrapper(action, actionsPlace);
            actionLink.setDataProvider(toolbarActionsDataProvider);
            wrappedActions.add((AnAction)actionLink);
        }
        DefaultActionGroup defaultActionGroup = wrappedActions;
        if (defaultActionGroup == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(12);
        }
        return defaultActionGroup;
    }

    @NotNull
    private static JPanel createCustomToolbarComponent(@NotNull AnAction action, @NotNull AnActionLink actionLink) {
        if (action == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(13);
        }
        if (actionLink == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(14);
        }
        JPanel actionPanel = new JPanel(new GridBagLayout());
        GridBag gridBag = new GridBag().fillCellHorizontally().anchor(17);
        int topInset = 5;
        int bottomInset = 4;
        actionPanel.add((Component)actionLink, gridBag.next().insets(topInset, 10, bottomInset, 4));
        Shortcut[] shortcuts = action.getShortcutSet().getShortcuts();
        String shortcutsText = KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
        if (!shortcutsText.isEmpty()) {
            JComponent keymapHint = XDebuggerPopupPanel.createKeymapHint(shortcutsText);
            actionPanel.add((Component)keymapHint, gridBag.next().insets(topInset, 4, bottomInset, 12));
        }
        actionPanel.setBackground(UIUtil.getToolTipActionBackground());
        JPanel jPanel = actionPanel;
        if (jPanel == null) {
            XDebuggerPopupPanel.$$$reportNull$$$0(15);
        }
        return jPanel;
    }

    private static JComponent createKeymapHint(@NlsContexts.Label String shortcutRunAction) {
        JBLabel shortcutHint = new JBLabel(shortcutRunAction){

            public Color getForeground() {
                return XDebuggerPopupPanel.getKeymapColor();
            }
        };
        shortcutHint.setBorder((Border)JBUI.Borders.empty());
        shortcutHint.setFont(UIUtil.getToolTipFont());
        return shortcutHint;
    }

    private static Color getKeymapColor() {
        return JBColor.namedColor((String)"ToolTip.Actions.infoForeground", (Color)new JBColor(10069165, 0x919191));
    }

    private static JPanel getSecretComponentForToolbar() {
        JPanel secretPanel = new JPanel();
        secretPanel.setPreferredSize(new Dimension(0, 27));
        return secretPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resizeRunnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupWindow";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarActions";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionsPlace";
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerPopupPanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerPopupPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomToolbarComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAutoResizeUntilToolbarNotFull";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updatePopupBounds";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillContentPanel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "wrapActions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCustomToolbarComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12, 15 -> new IllegalStateException(string);
        };
    }

    private class ActionWrapper
    extends AnAction
    implements CustomComponentAction {
        private final AnAction myDelegate;
        @NotNull
        private final String myActionPlace;
        @Nullable
        private Component myProvider;

        ActionWrapper(@NotNull AnAction delegate, String actionPlace) {
            if (actionPlace == null) {
                ActionWrapper.$$$reportNull$$$0(0);
            }
            super(delegate.getTemplateText());
            this.copyFrom(delegate);
            this.myDelegate = delegate;
            this.myActionPlace = actionPlace;
        }

        public void setDataProvider(@Nullable Component provider) {
            this.myProvider = provider;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ActionWrapper.$$$reportNull$$$0(1);
            }
            AnActionEvent delegateEvent = e;
            if (this.myProvider != null) {
                delegateEvent = AnActionEvent.createFromAnAction((AnAction)this.myDelegate, (InputEvent)e.getInputEvent(), (String)this.myActionPlace, (DataContext)DataManager.getInstance().getDataContext(this.myProvider));
            }
            this.myDelegate.actionPerformed(delegateEvent);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ActionWrapper.$$$reportNull$$$0(2);
            }
            this.myDelegate.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(presentation.isEnabled() && XDebuggerPopupPanel.this.shouldBeVisible(this.myDelegate));
            presentation.setVisible(presentation.isVisible() && XDebuggerPopupPanel.this.shouldBeVisible(this.myDelegate));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = this.myDelegate.getActionUpdateThread();
            if (actionUpdateThread == null) {
                ActionWrapper.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public boolean isDumbAware() {
            return this.myDelegate.isDumbAware();
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                ActionWrapper.$$$reportNull$$$0(4);
            }
            if (place == null) {
                ActionWrapper.$$$reportNull$$$0(5);
            }
            if (this.myDelegate instanceof Separator) {
                JPanel jPanel = XDebuggerPopupPanel.getSecretComponentForToolbar();
                if (jPanel == null) {
                    ActionWrapper.$$$reportNull$$$0(6);
                }
                return jPanel;
            }
            this.myDelegate.applyTextOverride(this.myActionPlace, presentation);
            final ActionLinkButton button = new ActionLinkButton(this, presentation, this.myProvider);
            ClientProperty.put((JComponent)((Object)button), InplaceEditor.IGNORE_MOUSE_EVENT, (Object)true);
            final JPanel actionPanel = XDebuggerPopupPanel.createCustomToolbarComponent(this, button);
            presentation.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("text".equals(evt.getPropertyName())) {
                        String value = (String)evt.getNewValue();
                        button.setText(StringUtil.capitalize((String)value.toLowerCase(Locale.ROOT)));
                        button.repaint();
                    }
                    if ("enabled".equals(evt.getPropertyName())) {
                        actionPanel.setVisible((Boolean)evt.getNewValue());
                        actionPanel.repaint();
                    }
                }
            });
            actionPanel.setVisible(presentation.isEnabled());
            JPanel jPanel = actionPanel;
            if (jPanel == null) {
                ActionWrapper.$$$reportNull$$$0(7);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionPlace";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerPopupPanel$ActionWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerPopupPanel$ActionWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class ActionLinkButton
    extends AnActionLink {
        final Component contextComponent;

        ActionLinkButton(@NotNull AnAction action, @NotNull Presentation presentation, @Nullable Component contextComponent) {
            if (action == null) {
                ActionLinkButton.$$$reportNull$$$0(0);
            }
            if (presentation == null) {
                ActionLinkButton.$$$reportNull$$$0(1);
            }
            super(StringUtil.capitalize((String)presentation.getText().toLowerCase(Locale.ROOT)), action);
            this.contextComponent = contextComponent;
            this.setFont(UIUtil.getToolTipFont());
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ActionLinkButton.$$$reportNull$$$0(2);
            }
            super.uiDataSnapshot(sink);
            DataSink.uiDataSnapshot((DataSink)sink, (Object)this.contextComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerPopupPanel$ActionLinkButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

