/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.hotswap;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.hotswap.HotSwapProvider;
import com.intellij.xdebugger.hotswap.HotSwapSession;
import com.intellij.xdebugger.hotswap.HotSwapSessionManager;
import com.intellij.xdebugger.impl.hotswap.CurrentSessionState;
import com.intellij.xdebugger.impl.hotswap.HotSwapSessionImpl;
import com.intellij.xdebugger.impl.hotswap.HotSwapSessionManagerImplKt;
import com.intellij.xdebugger.impl.rpc.HotSwapVisibleStatus;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0019\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\nH\u0000\u00a2\u0006\u0002\b\u001eJ\u0014\u0010\u001f\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0006\u0010 \u001a\u00020\u001cJ%\u0010$\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00152\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0000\u00a2\u0006\u0002\b'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006)"}, d2={"Lcom/intellij/xdebugger/impl/hotswap/HotSwapSessionManagerImpl;", "Lcom/intellij/xdebugger/hotswap/HotSwapSessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "sessions", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/xdebugger/impl/hotswap/HotSwapSessionImpl;", "selectedSession", "Ljava/lang/ref/WeakReference;", "_currentStatusFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/xdebugger/impl/hotswap/CurrentSessionState;", "currentStatusFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getCurrentStatusFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "createSession", "Lcom/intellij/xdebugger/hotswap/HotSwapSession;", "T", "provider", "Lcom/intellij/xdebugger/hotswap/HotSwapProvider;", "disposable", "Lcom/intellij/openapi/Disposable;", "onSessionDispose", "", "session", "onSessionDispose$intellij_platform_debugger_impl", "onSessionSelected", "hide", "currentSession", "getCurrentSession$intellij_platform_debugger_impl", "()Lcom/intellij/xdebugger/impl/hotswap/HotSwapSessionImpl;", "fireStatusChanged", "forceStatus", "Lcom/intellij/xdebugger/impl/rpc/HotSwapVisibleStatus;", "fireStatusChanged$intellij_platform_debugger_impl", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class HotSwapSessionManagerImpl
implements HotSwapSessionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CopyOnWriteArrayList<HotSwapSessionImpl<?>> sessions;
    @Nullable
    private volatile WeakReference<HotSwapSessionImpl<?>> selectedSession;
    @NotNull
    private final MutableStateFlow<CurrentSessionState> _currentStatusFlow;
    @NotNull
    private final StateFlow<CurrentSessionState> currentStatusFlow;

    private HotSwapSessionManagerImpl(Project project, CoroutineScope coroutineScope) {
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.sessions = new CopyOnWriteArrayList();
        this._currentStatusFlow = StateFlowKt.MutableStateFlow(null);
        this.currentStatusFlow = (StateFlow)this._currentStatusFlow;
    }

    @NotNull
    public final StateFlow<CurrentSessionState> getCurrentStatusFlow() {
        return this.currentStatusFlow;
    }

    @NotNull
    public <T> HotSwapSession<T> createSession(@NotNull HotSwapProvider<T> provider, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        HotSwapSessionImpl<T> hotSwapSession = new HotSwapSessionImpl<T>(this.project, provider, this.coroutineScope);
        Disposer.register((Disposable)disposable, (Disposable)hotSwapSession);
        this.sessions.add(hotSwapSession);
        hotSwapSession.init$intellij_platform_debugger_impl();
        HotSwapSessionManagerImpl.fireStatusChanged$intellij_platform_debugger_impl$default(this, hotSwapSession, null, 2, null);
        return hotSwapSession;
    }

    public final void onSessionDispose$intellij_platform_debugger_impl(@NotNull HotSwapSessionImpl<?> session) {
        HotSwapSessionImpl<?> newCurrent;
        Intrinsics.checkNotNullParameter(session, (String)"session");
        CurrentSessionState currentStatus = (CurrentSessionState)this._currentStatusFlow.getValue();
        if (session == this.getCurrentSession$intellij_platform_debugger_impl()) {
            this.selectedSession = null;
        }
        this.sessions.remove(session);
        CurrentSessionState currentSessionState = currentStatus;
        if ((currentSessionState != null ? currentSessionState.getSession() : null) == session) {
            this._currentStatusFlow.compareAndSet((Object)currentStatus, null);
        }
        if ((newCurrent = this.getCurrentSession$intellij_platform_debugger_impl()) != null) {
            HotSwapSessionManagerImpl.fireStatusChanged$intellij_platform_debugger_impl$default(this, newCurrent, null, 2, null);
        }
    }

    public void onSessionSelected(@NotNull HotSwapSession<?> session) {
        HotSwapSessionImpl selected;
        Intrinsics.checkNotNullParameter(session, (String)"session");
        if (!(session instanceof HotSwapSessionImpl)) {
            return;
        }
        if (!this.sessions.contains(session)) {
            return;
        }
        WeakReference<HotSwapSessionImpl<?>> weakReference = this.selectedSession;
        HotSwapSessionImpl hotSwapSessionImpl = selected = weakReference != null ? (HotSwapSessionImpl)weakReference.get() : null;
        if (selected != session) {
            this.selectedSession = new WeakReference(session);
        }
        HotSwapSessionManagerImpl.fireStatusChanged$intellij_platform_debugger_impl$default(this, session, null, 2, null);
    }

    public final void hide() {
        CurrentSessionState currentSessionState = (CurrentSessionState)this._currentStatusFlow.getValue();
        if (currentSessionState == null) {
            return;
        }
        CurrentSessionState currentState = currentSessionState;
        this._currentStatusFlow.compareAndSet((Object)currentState, (Object)CurrentSessionState.copy$default(currentState, null, HotSwapVisibleStatus.HIDDEN, 1, null));
    }

    @Nullable
    public final HotSwapSessionImpl<?> getCurrentSession$intellij_platform_debugger_impl() {
        HotSwapSessionImpl selected;
        WeakReference<HotSwapSessionImpl<?>> weakReference = this.selectedSession;
        HotSwapSessionImpl hotSwapSessionImpl = selected = weakReference != null ? (HotSwapSessionImpl)weakReference.get() : null;
        if (selected != null) {
            return selected;
        }
        return (HotSwapSessionImpl)HotSwapSessionManagerImplKt.access$safeLastOrNull(this.sessions);
    }

    public final void fireStatusChanged$intellij_platform_debugger_impl(@NotNull HotSwapSession<?> session, @Nullable HotSwapVisibleStatus forceStatus) {
        Intrinsics.checkNotNullParameter(session, (String)"session");
        if (session != this.getCurrentSession$intellij_platform_debugger_impl()) {
            return;
        }
        HotSwapVisibleStatus hotSwapVisibleStatus = forceStatus;
        if (hotSwapVisibleStatus == null) {
            hotSwapVisibleStatus = ((HotSwapSessionImpl)session).getCurrentStatus$intellij_platform_debugger_impl();
        }
        HotSwapVisibleStatus status = hotSwapVisibleStatus;
        this._currentStatusFlow.setValue((Object)new CurrentSessionState((HotSwapSessionImpl)session, status));
    }

    public static /* synthetic */ void fireStatusChanged$intellij_platform_debugger_impl$default(HotSwapSessionManagerImpl hotSwapSessionManagerImpl, HotSwapSession hotSwapSession, HotSwapVisibleStatus hotSwapVisibleStatus, int n, Object object) {
        if ((n & 2) != 0) {
            hotSwapVisibleStatus = null;
        }
        hotSwapSessionManagerImpl.fireStatusChanged$intellij_platform_debugger_impl(hotSwapSession, hotSwapVisibleStatus);
    }

    @JvmStatic
    @NotNull
    public static final HotSwapSessionManagerImpl getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/xdebugger/impl/hotswap/HotSwapSessionManagerImpl$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/xdebugger/impl/hotswap/HotSwapSessionManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceOrNull", "getInstanceOrNull$intellij_platform_debugger_impl", "intellij.platform.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nHotSwapSessionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotSwapSessionManagerImpl.kt\ncom/intellij/xdebugger/impl/hotswap/HotSwapSessionManagerImpl$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,217:1\n58#2:218\n*S KotlinDebug\n*F\n+ 1 HotSwapSessionManagerImpl.kt\ncom/intellij/xdebugger/impl/hotswap/HotSwapSessionManagerImpl$Companion\n*L\n95#1:218\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HotSwapSessionManagerImpl getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            HotSwapSessionManager hotSwapSessionManager = HotSwapSessionManager.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)hotSwapSessionManager, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.hotswap.HotSwapSessionManagerImpl");
            return (HotSwapSessionManagerImpl)hotSwapSessionManager;
        }

        @Nullable
        public final HotSwapSessionManagerImpl getInstanceOrNull$intellij_platform_debugger_impl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            Object object = $this$serviceIfCreated$iv.getServiceIfCreated(HotSwapSessionManager.class);
            return object instanceof HotSwapSessionManagerImpl ? (HotSwapSessionManagerImpl)object : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

