/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.attach.dialog.items.cells;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.AttachToProcessElementsFilters;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.cells.AttachTableCell;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.columns.AttachDialogColumnsLayout;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.nodes.AttachDialogProcessNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/cells/AttachFiltersAwareCell;", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/cells/AttachTableCell;", "columnKey", "", "node", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/nodes/AttachDialogProcessNode;", "filters", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/AttachToProcessElementsFilters;", "columnsLayout", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/columns/AttachDialogColumnsLayout;", "<init>", "(Ljava/lang/String;Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/nodes/AttachDialogProcessNode;Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/AttachToProcessElementsFilters;Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/columns/AttachDialogColumnsLayout;)V", "getNode", "()Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/nodes/AttachDialogProcessNode;", "getFilters", "()Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/AttachToProcessElementsFilters;", "getTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "intellij.platform.debugger.impl"})
public abstract class AttachFiltersAwareCell
extends AttachTableCell {
    @NotNull
    private final AttachDialogProcessNode node;
    @NotNull
    private final AttachToProcessElementsFilters filters;

    public AttachFiltersAwareCell(@NotNull String columnKey, @NotNull AttachDialogProcessNode node, @NotNull AttachToProcessElementsFilters filters, @NotNull AttachDialogColumnsLayout columnsLayout) {
        Intrinsics.checkNotNullParameter((Object)columnKey, (String)"columnKey");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)columnsLayout, (String)"columnsLayout");
        super(columnKey, columnsLayout);
        this.node = node;
        this.filters = filters;
    }

    @NotNull
    public final AttachDialogProcessNode getNode() {
        return this.node;
    }

    @NotNull
    public final AttachToProcessElementsFilters getFilters() {
        return this.filters;
    }

    @Override
    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes;
        if (CollectionsKt.any((Iterable)this.node.getItem().getGroups()) && this.filters.matches(this.node)) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
            Intrinsics.checkNotNull((Object)simpleTextAttributes2);
            simpleTextAttributes = simpleTextAttributes2;
        } else {
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNull((Object)simpleTextAttributes3);
            simpleTextAttributes = simpleTextAttributes3;
        }
        return simpleTextAttributes;
    }
}

