/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J4\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/xdebugger/impl/ui/CustomComponentEvaluator;", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "name", "", "<init>", "(Ljava/lang/String;)V", "createComponent", "Ljavax/swing/JComponent;", "fullValue", "show", "", "event", "Ljava/awt/event/MouseEvent;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "showValuePopup", "component", "cancelCallback", "Ljava/lang/Runnable;", "EvaluationCallback", "intellij.platform.debugger.impl"})
@ApiStatus.Experimental
public abstract class CustomComponentEvaluator
extends XFullValueEvaluator {
    public CustomComponentEvaluator(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
    }

    @Nullable
    public JComponent createComponent(@Nullable String fullValue) {
        return null;
    }

    public void show(@NotNull MouseEvent event, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JPanel panel2 = new JPanel(new CardLayout());
        EvaluationCallback callback = new EvaluationCallback(panel2, this, project);
        this.showValuePopup(event, project, editor, panel2, callback::setObsolete);
        this.startEvaluation(callback);
    }

    protected void showValuePopup(@NotNull MouseEvent event, @NotNull Project project, @Nullable Editor editor, @NotNull JComponent component, @Nullable Runnable cancelCallback) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        VisualizedTextPopupUtil.INSTANCE.showValuePopup(event, project, editor, component, cancelCallback);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0006\u0010\u0014\u001a\u00020\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/xdebugger/impl/ui/CustomComponentEvaluator$EvaluationCallback;", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator$XFullValueEvaluationCallback;", "myPanel", "Ljavax/swing/JComponent;", "myEvaluator", "Lcom/intellij/xdebugger/impl/ui/CustomComponentEvaluator;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/xdebugger/impl/ui/CustomComponentEvaluator;Lcom/intellij/openapi/project/Project;)V", "myObsolete", "Ljava/util/concurrent/atomic/AtomicBoolean;", "evaluated", "", "fullValue", "", "font", "Ljava/awt/Font;", "errorOccurred", "errorMessage", "setObsolete", "isObsolete", "", "intellij.platform.debugger.impl"})
    protected static final class EvaluationCallback
    implements XFullValueEvaluator.XFullValueEvaluationCallback {
        @NotNull
        private final JComponent myPanel;
        @NotNull
        private final CustomComponentEvaluator myEvaluator;
        @NotNull
        private final Project myProject;
        @NotNull
        private final AtomicBoolean myObsolete;

        public EvaluationCallback(@NotNull JComponent myPanel, @NotNull CustomComponentEvaluator myEvaluator, @NotNull Project myProject) {
            Intrinsics.checkNotNullParameter((Object)myPanel, (String)"myPanel");
            Intrinsics.checkNotNullParameter((Object)((Object)myEvaluator), (String)"myEvaluator");
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            this.myPanel = myPanel;
            this.myEvaluator = myEvaluator;
            this.myProject = myProject;
            this.myObsolete = new AtomicBoolean(false);
        }

        public void evaluated(@NotNull String fullValue, @Nullable Font font) {
            Intrinsics.checkNotNullParameter((Object)fullValue, (String)"fullValue");
            AppUIUtil.invokeOnEdt(() -> EvaluationCallback.evaluated$lambda$0(this, fullValue, font));
        }

        public void errorOccurred(@NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            AppUIUtil.invokeOnEdt(() -> EvaluationCallback.errorOccurred$lambda$0(this, errorMessage));
        }

        public final void setObsolete() {
            this.myObsolete.set(true);
        }

        public boolean isObsolete() {
            return this.myObsolete.get();
        }

        private static final void evaluated$lambda$0(EvaluationCallback this$0, String $fullValue, Font $font) {
            try {
                this$0.myPanel.removeAll();
                JComponent component = this$0.myEvaluator.createComponent($fullValue);
                if (component == null) {
                    TextViewer textViewer = DebuggerUIUtil.createTextViewer($fullValue, this$0.myProject);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)textViewer), (String)"createTextViewer(...)");
                    EditorTextField textArea = textViewer;
                    if ($font != null) {
                        textArea.setFont($font);
                    }
                    component = (JComponent)textArea;
                }
                this$0.myPanel.add(component);
                this$0.myPanel.revalidate();
                this$0.myPanel.repaint();
            }
            catch (Exception e) {
                this$0.errorOccurred(e.toString());
            }
        }

        private static final void errorOccurred$lambda$0(EvaluationCallback this$0, String $errorMessage) {
            this$0.myPanel.removeAll();
            TextViewer textViewer = DebuggerUIUtil.createTextViewer($errorMessage, this$0.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)textViewer), (String)"createTextViewer(...)");
            EditorTextField textArea = textViewer;
            textArea.setForeground(XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES.getFgColor());
            this$0.myPanel.add((Component)textArea);
        }
    }
}

