/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XAlwaysEvaluatedWatch;
import com.intellij.xdebugger.impl.XWatch;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XRendererDecoratorPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XCustomizableTextRenderer;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackWithOrigin;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class WatchNodeImpl
extends XValueNodeImpl
implements WatchNode {
    private final XWatch myWatch;
    @ApiStatus.Internal
    public static final XValuePresentation PAUSED_PRESENTATION = new XValuePresentation(){

        @NotNull
        public String getSeparator() {
            return " ";
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                1.$$$reportNull$$$0(0);
            }
            renderer.renderComment(XDebuggerBundle.message((String)"xdebugger.watch.is.paused.message", (Object[])new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$1", "renderValue"));
        }
    };

    public WatchNodeImpl(@NotNull XDebuggerTree tree, @NotNull XDebuggerTreeNode parent, @NotNull XWatch watch, @Nullable XStackFrame stackFrame, @Nullable String name, @Nullable XValue value) {
        if (tree == null) {
            WatchNodeImpl.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            WatchNodeImpl.$$$reportNull$$$0(1);
        }
        if (watch == null) {
            WatchNodeImpl.$$$reportNull$$$0(2);
        }
        super(tree, parent, name == null ? WatchNodeImpl.renderName(watch.getExpression()) : name, (XValue)(value == null ? new XWatchValue(watch, tree, stackFrame) : value));
        this.myWatch = watch;
    }

    public WatchNodeImpl(@NotNull XDebuggerTree tree, @NotNull WatchesRootNode parent, @NotNull XExpression expression, @Nullable XStackFrame stackFrame) {
        if (tree == null) {
            WatchNodeImpl.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            WatchNodeImpl.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            WatchNodeImpl.$$$reportNull$$$0(5);
        }
        this(tree, parent, (XWatch)new XAlwaysEvaluatedWatch(expression), stackFrame, null, null);
    }

    protected WatchNodeImpl(XDebuggerTree tree, XDebuggerTreeNode parent, XExpression expression, XNamedValue value) {
        this(tree, parent, (XWatch)new XAlwaysEvaluatedWatch(expression), null, null, (XValue)value);
    }

    public XWatch getXWatch() {
        return this.myWatch;
    }

    protected static String renderName(XExpression expression) {
        StringBuilder output = new StringBuilder();
        XValuePresentationUtil.renderName(expression.getExpression(), Integer.MAX_VALUE, s -> output.append((String)s));
        return output.toString();
    }

    @Override
    @ApiStatus.Internal
    protected boolean isChanged() {
        return super.isChanged() && !this.myWatch.isPaused();
    }

    @Override
    @NotNull
    public XExpression getExpression() {
        XExpression xExpression = this.myWatch.getExpression();
        if (xExpression == null) {
            WatchNodeImpl.$$$reportNull$$$0(6);
        }
        return xExpression;
    }

    @Override
    @NotNull
    public XValue getValueContainer() {
        XValue value;
        XValue container2 = (XValue)super.getValueContainer();
        if (container2 instanceof XWatchValue && (value = ((XWatchValue)container2).myValue) != null) {
            XValue xValue = value;
            if (xValue == null) {
                WatchNodeImpl.$$$reportNull$$$0(7);
            }
            return xValue;
        }
        XValue xValue = container2;
        if (xValue == null) {
            WatchNodeImpl.$$$reportNull$$$0(8);
        }
        return xValue;
    }

    @ApiStatus.Internal
    @NotNull
    public XEvaluationOrigin getEvaluationOrigin() {
        XEvaluationOrigin xEvaluationOrigin = XEvaluationOrigin.WATCH;
        if (xEvaluationOrigin == null) {
            WatchNodeImpl.$$$reportNull$$$0(9);
        }
        return xEvaluationOrigin;
    }

    protected void evaluated() {
    }

    public void computePresentationIfNeeded() {
        if (this.getValuePresentation() == null) {
            this.getValueContainer().computePresentation((XValueNode)this, XValuePlace.TREE);
        }
    }

    @Override
    protected boolean shouldUpdateInlineDebuggerData() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watch";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueContainer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationOrigin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class XWatchValue
    extends XNamedValue {
        private final XWatch myWatch;
        private final XDebuggerTree myTree;
        private final XStackFrame myStackFrame;
        private volatile XValue myValue;
        private final AtomicBoolean myEvaluateRequested = new AtomicBoolean(false);
        private static final XValuePresentation EMPTY_PRESENTATION = new XValuePresentation(){

            @NotNull
            public String getSeparator() {
                return "";
            }

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                if (renderer == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$1", "renderValue"));
            }
        };

        XWatchValue(XWatch watch, XDebuggerTree tree, XStackFrame stackFrame) {
            super(watch.getExpression().getExpression());
            this.myWatch = watch;
            this.myTree = tree;
            this.myStackFrame = stackFrame;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                XWatchValue.$$$reportNull$$$0(0);
            }
            if (this.myValue != null) {
                this.myValue.computeChildren(node);
            }
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                XWatchValue.$$$reportNull$$$0(1);
            }
            if (place == null) {
                XWatchValue.$$$reportNull$$$0(2);
            }
            this.clearPausedLink(node);
            if (this.myWatch.isPaused() && !this.myEvaluateRequested.getAndSet(false)) {
                this.showPausedPresentation(node, place);
                return;
            }
            if (this.myStackFrame != null) {
                if (this.myTree.isShowing() || ApplicationManager.getApplication().isUnitTestMode()) {
                    XDebuggerEvaluator evaluator = this.myStackFrame.getEvaluator();
                    if (evaluator != null) {
                        evaluator.evaluate(this.myWatch.getExpression(), (XDebuggerEvaluator.XEvaluationCallback)new MyEvaluationCallback(node, place), this.myStackFrame.getSourcePosition());
                        return;
                    }
                } else {
                    return;
                }
            }
            node.setPresentation(AllIcons.Debugger.Db_watch, EMPTY_PRESENTATION, false);
        }

        private void clearPausedLink(@NotNull XValueNode node) {
            XValueNodeImpl xValueNode;
            if (node == null) {
                XWatchValue.$$$reportNull$$$0(3);
            }
            if (node instanceof XValueNodeImpl && (xValueNode = (XValueNodeImpl)node).getFullValueEvaluator() instanceof EvaluateLink) {
                xValueNode.clearFullValueEvaluator();
            }
        }

        private void showPausedPresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                XWatchValue.$$$reportNull$$$0(4);
            }
            if (place == null) {
                XWatchValue.$$$reportNull$$$0(5);
            }
            node.setPresentation(AllIcons.Actions.Pause, PAUSED_PRESENTATION, false);
            node.setFullValueEvaluator((XFullValueEvaluator)new EvaluateLink(node, place));
        }

        @Nullable
        public String getEvaluationExpression() {
            return this.myValue != null ? this.myValue.getEvaluationExpression() : null;
        }

        @NotNull
        public Promise<XExpression> calculateEvaluationExpression() {
            Promise promise = Promises.resolvedPromise((Object)this.myWatch.getExpression());
            if (promise == null) {
                XWatchValue.$$$reportNull$$$0(6);
            }
            return promise;
        }

        @Nullable
        public XInstanceEvaluator getInstanceEvaluator() {
            return this.myValue != null ? this.myValue.getInstanceEvaluator() : null;
        }

        @Nullable
        public XValueModifier getModifier() {
            return this.myValue != null ? this.myValue.getModifier() : null;
        }

        public void computeSourcePosition(@NotNull XNavigatable navigatable) {
            if (navigatable == null) {
                XWatchValue.$$$reportNull$$$0(7);
            }
            if (this.myValue != null) {
                this.myValue.computeSourcePosition(navigatable);
            }
        }

        @NotNull
        public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback2) {
            if (callback2 == null) {
                XWatchValue.$$$reportNull$$$0(8);
            }
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                XWatchValue.$$$reportNull$$$0(9);
            }
            return threeState;
        }

        public boolean canNavigateToSource() {
            return this.myValue != null && this.myValue.canNavigateToSource();
        }

        public boolean canNavigateToTypeSource() {
            return this.myValue != null && this.myValue.canNavigateToTypeSource();
        }

        public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
            if (navigatable == null) {
                XWatchValue.$$$reportNull$$$0(10);
            }
            if (this.myValue != null) {
                this.myValue.computeTypeSourcePosition(navigatable);
            }
        }

        @Nullable
        public XReferrersProvider getReferrersProvider() {
            return this.myValue != null ? this.myValue.getReferrersProvider() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigatable";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateEvaluationExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeInlineDebuggerData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeChildren";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "computePresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "clearPausedLink";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showPausedPresentation";
                    break;
                }
                case 6: 
                case 9: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "computeSourcePosition";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "computeInlineDebuggerData";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "computeTypeSourcePosition";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 9 -> new IllegalStateException(string);
            };
        }

        private class MyEvaluationCallback
        extends XEvaluationCallbackBase
        implements XEvaluationCallbackWithOrigin,
        Obsolescent {
            @NotNull
            private final XValueNode myNode;
            @NotNull
            private final XValuePlace myPlace;

            MyEvaluationCallback(@NotNull XValueNode node, XValuePlace place) {
                if (node == null) {
                    MyEvaluationCallback.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    MyEvaluationCallback.$$$reportNull$$$0(1);
                }
                this.myNode = node;
                this.myPlace = place;
            }

            @Override
            public XEvaluationOrigin getOrigin() {
                XValueNode xValueNode = this.myNode;
                if (xValueNode instanceof WatchNodeImpl) {
                    WatchNodeImpl watchNode = (WatchNodeImpl)xValueNode;
                    return watchNode.getEvaluationOrigin();
                }
                return XEvaluationOrigin.UNSPECIFIED_WATCH;
            }

            public boolean isObsolete() {
                return this.myNode.isObsolete();
            }

            public void evaluated(@NotNull XValue result2) {
                if (result2 == null) {
                    MyEvaluationCallback.$$$reportNull$$$0(2);
                }
                XWatchValue.this.myValue = result2;
                XValueNode xValueNode = this.myNode;
                if (xValueNode instanceof WatchNodeImpl) {
                    WatchNodeImpl watchNode = (WatchNodeImpl)xValueNode;
                    watchNode.evaluated();
                }
                result2.computePresentation(this.myNode, this.myPlace);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    MyEvaluationCallback.$$$reportNull$$$0(3);
                }
                this.myNode.setPresentation(XDebuggerUIConstants.ERROR_MESSAGE_ICON, (XValuePresentation)new XErrorValuePresentation(errorMessage), false);
            }

            public void invalidExpression(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    MyEvaluationCallback.$$$reportNull$$$0(4);
                }
                if (this.myNode instanceof WatchesRootNode.ResultNode) {
                    this.errorOccurred(errorMessage);
                    return;
                }
                this.myNode.setPresentation(AllIcons.Debugger.Db_watch, (XValuePresentation)new GrayedPresentation(errorMessage), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$MyEvaluationCallback";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "invalidExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class EvaluateLink
        extends XFullValueEvaluator {
            @NotNull
            private final XValueNode myNode;
            @NotNull
            private final XValuePlace myPlace;

            private EvaluateLink(@NotNull XValueNode node, XValuePlace place) {
                if (node == null) {
                    EvaluateLink.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    EvaluateLink.$$$reportNull$$$0(1);
                }
                super(XDebuggerBundle.message((String)"xdebugger.evaluate.paused.watch", (Object[])new Object[0]));
                this.myNode = node;
                this.myPlace = place;
                this.setShowValuePopup(false);
            }

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback2) {
                if (callback2 == null) {
                    EvaluateLink.$$$reportNull$$$0(2);
                }
                callback2.evaluated("");
                XWatchValue.this.myEvaluateRequested.set(true);
                XWatchValue.this.computePresentation(this.myNode, this.myPlace);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callback";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$EvaluateLink";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startEvaluation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class GrayedPresentation
        extends XValuePresentation
        implements XRendererDecoratorPresentation {
            @NotNull
            private final String myErrorMessage;

            private GrayedPresentation(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    GrayedPresentation.$$$reportNull$$$0(0);
                }
                this.myErrorMessage = errorMessage;
            }

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                if (renderer == null) {
                    GrayedPresentation.$$$reportNull$$$0(1);
                }
                renderer.renderComment(this.myErrorMessage);
            }

            @Override
            @NotNull
            public XCustomizableTextRenderer decorate(final @NotNull XCustomizableTextRenderer renderer) {
                if (renderer == null) {
                    GrayedPresentation.$$$reportNull$$$0(2);
                }
                return new XCustomizableTextRenderer(){

                    public void renderComment(@NotNull String comment) {
                        if (comment == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        renderer.renderComment(comment);
                    }

                    public void renderValue(@NotNull String value) {
                        if (value == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.renderComment(value);
                    }

                    public void renderStringValue(@NotNull String value, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
                        if (value == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        this.renderComment(value);
                    }

                    public void renderSpecialSymbol(@NotNull String symbol) {
                        if (symbol == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        this.renderComment(symbol);
                    }

                    public void renderError(@NotNull String error) {
                        if (error == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        this.renderComment(error);
                    }

                    @Override
                    public void renderRaw(@NotNull String text, @NotNull SimpleTextAttributes attributes) {
                        if (text == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        if (attributes == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        this.renderComment(text);
                    }

                    public void renderKeywordValue(@NotNull String value) {
                        if (value == null) {
                            1.$$$reportNull$$$0(7);
                        }
                        this.renderComment(value);
                    }

                    public void renderNumericValue(@NotNull String value) {
                        if (value == null) {
                            1.$$$reportNull$$$0(8);
                        }
                        this.renderComment(value);
                    }

                    public void renderStringValue(@NotNull String value) {
                        if (value == null) {
                            1.$$$reportNull$$$0(9);
                        }
                        this.renderComment(value);
                    }

                    public void renderValue(@NotNull String value, @NotNull TextAttributesKey key) {
                        if (value == null) {
                            1.$$$reportNull$$$0(10);
                        }
                        if (key == null) {
                            1.$$$reportNull$$$0(11);
                        }
                        this.renderComment(value);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "comment";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "value";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "symbol";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                            case 6: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attributes";
                                break;
                            }
                            case 11: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "key";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$GrayedPresentation$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renderComment";
                                break;
                            }
                            case 1: 
                            case 10: 
                            case 11: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renderValue";
                                break;
                            }
                            case 2: 
                            case 9: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renderStringValue";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renderSpecialSymbol";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renderError";
                                break;
                            }
                            case 5: 
                            case 6: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renderRaw";
                                break;
                            }
                            case 7: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renderKeywordValue";
                                break;
                            }
                            case 8: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renderNumericValue";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renderer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchNodeImpl$XWatchValue$GrayedPresentation";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "renderValue";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "decorate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

