/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.SplitDebuggerAction;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.actions.ShowLibraryFramesActionCoroutineScope;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/xdebugger/impl/actions/ShowLibraryFramesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/platform/debugger/impl/shared/SplitDebuggerAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "setSelected", "enabled", "Companion", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nShowLibraryFramesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowLibraryFramesAction.kt\ncom/intellij/xdebugger/impl/actions/ShowLibraryFramesAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,110:1\n30#2,2:111\n*S KotlinDebug\n*F\n+ 1 ShowLibraryFramesAction.kt\ncom/intellij/xdebugger/impl/actions/ShowLibraryFramesAction\n*L\n62#1:111,2\n*E\n"})
public final class ShowLibraryFramesAction
extends ToggleAction
implements SplitDebuggerAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String IS_LIBRARY_FRAME_FILTER_SUPPORTED = "isLibraryFrameFilterSupported";

    public ShowLibraryFramesAction() {
        Presentation presentation;
        Presentation $this$_init__u24lambda_u240 = presentation = this.getTemplatePresentation();
        boolean bl = false;
        $this$_init__u24lambda_u240.setText(XDebuggerBundle.message((String)"hide.library.frames.tooltip", (Object[])new Object[0]));
        $this$_init__u24lambda_u240.setDescription("");
        $this$_init__u24lambda_u240.setIcon(AllIcons.General.Filter);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation $this$update_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$update_u24lambda_u240);
        if (!ShowLibraryFramesAction.Companion.isLibraryFrameFilterSupported(e, $this$update_u24lambda_u240)) {
            $this$update_u24lambda_u240.setVisible(false);
            return;
        }
        $this$update_u24lambda_u240.setVisible(true);
        if (e.isFromActionToolbar()) {
            boolean shouldShow = !this.isSelected(e);
            $this$update_u24lambda_u240.setText(XDebuggerBundle.message((String)(shouldShow ? "hide.library.frames.tooltip" : "show.all.frames.tooltip"), (Object[])new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return !XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().isShowLibraryStackFrames();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().setShowLibraryStackFrames(!enabled);
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            CoroutineScope coroutineScope = e.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
            StoreUtilKt.saveSettingsForRemoteDevelopment((CoroutineScope)coroutineScope, (ComponentManager)((ComponentManager)project2));
            Object object = e.getProject();
            if (object == null) break block3;
            ComponentManager $this$service$iv = (ComponentManager)object;
            boolean $i$f$service = false;
            Class<ShowLibraryFramesActionCoroutineScope> serviceClass$iv = ShowLibraryFramesActionCoroutineScope.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            object = (ShowLibraryFramesActionCoroutineScope)object2;
            if (object != null) {
                ((ShowLibraryFramesActionCoroutineScope)object).toggle(!enabled);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/xdebugger/impl/actions/ShowLibraryFramesAction$Companion;", "", "<init>", "()V", "IS_LIBRARY_FRAME_FILTER_SUPPORTED", "", "isLibraryFrameFilterSupported", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isLibraryFrameFilterSupported(AnActionEvent e, Presentation presentation) {
            Object isSupported = presentation.getClientProperty(ShowLibraryFramesAction.IS_LIBRARY_FRAME_FILTER_SUPPORTED);
            XDebugSessionProxy sessionProxy = DebuggerUIUtil.getSessionProxy(e);
            if (isSupported == null) {
                if (sessionProxy == null) {
                    presentation.setVisible(false);
                    return false;
                }
                isSupported = sessionProxy.isLibraryFrameFilterSupported();
                presentation.putClientProperty(ShowLibraryFramesAction.IS_LIBRARY_FRAME_FILTER_SUPPORTED, isSupported);
            }
            return Intrinsics.areEqual((Object)isSupported, (Object)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

