/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.BookmarksListProvider;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeNodeCache;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.actions.EditBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003'()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0016J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\f0\u0007\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b#H\u0016J\u0014\u0010$\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030%H\u0016J\u001c\u0010&\u001a\u00020\u001e2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0002X\u0083D\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider;", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "rootNameKey", "", "getRootNameKey$annotations", "()V", "root", "Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$RootNode;", "getRoot", "()Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$RootNode;", "root$delegate", "Lkotlin/Lazy;", "getWeight", "", "getProject", "createNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "node", "getEditActionText", "canEdit", "", "selection", "", "performEdit", "", "parent", "Ljavax/swing/JComponent;", "getDeleteActionText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "canDelete", "", "performDelete", "RootNode", "GroupNode", "ItemNode", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nBreakpointListProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreakpointListProvider.kt\ncom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n1#2:198\n1740#3,3:199\n1869#3,2:202\n*S KotlinDebug\n*F\n+ 1 BreakpointListProvider.kt\ncom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider\n*L\n63#1:199,3\n64#1:202,2\n*E\n"})
public final class BreakpointListProvider
implements BookmarksListProvider {
    @NotNull
    private final Project project;
    @PropertyKey(resourceBundle="messages.XDebuggerBundle")
    @NotNull
    private final String rootNameKey;
    @NotNull
    private final Lazy root$delegate;

    public BreakpointListProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.rootNameKey = "xbreakpoints.dialog.title";
        this.root$delegate = LazyKt.lazy(() -> BreakpointListProvider.root_delegate$lambda$0(this));
    }

    private static /* synthetic */ void getRootNameKey$annotations() {
    }

    private final RootNode getRoot() {
        Lazy lazy = this.root$delegate;
        return (RootNode)lazy.getValue();
    }

    public int getWeight() {
        return 200;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public AbstractTreeNode<?> createNode() {
        return this.getRoot().hasVisibleBreakpoints() ? (AbstractTreeNode)this.getRoot() : null;
    }

    @Nullable
    public OpenFileDescriptor getDescriptor(@NotNull AbstractTreeNode<?> node) {
        OpenFileDescriptor openFileDescriptor;
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Object object = node.getEqualityObject();
        BreakpointItem breakpointItem = object instanceof BreakpointItem ? (BreakpointItem)object : null;
        if (breakpointItem == null) {
            return null;
        }
        BreakpointItem item = breakpointItem;
        XBreakpointProxy xBreakpointProxy = item.getBreakpoint();
        if (xBreakpointProxy == null) {
            return null;
        }
        XBreakpointProxy breakpoint2 = xBreakpointProxy;
        XSourcePosition xSourcePosition = breakpoint2.getSourcePosition();
        if (xSourcePosition != null) {
            XSourcePosition it = xSourcePosition;
            boolean bl = false;
            openFileDescriptor = new OpenFileDescriptor(this.project, it.getFile(), it.getLine(), 0);
        } else {
            openFileDescriptor = null;
        }
        return openFileDescriptor;
    }

    @NotNull
    public String getEditActionText() {
        String string = ActionsBundle.actionText((String)"EditBreakpoint");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"actionText(...)");
        return string;
    }

    public boolean canEdit(@NotNull Object selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return selection instanceof ItemNode;
    }

    /*
     * WARNING - void declaration
     */
    public void performEdit(@NotNull Object selection, @NotNull JComponent parent) {
        int n;
        int n2;
        Rectangle $this$performEdit_u24lambda_u241_u240;
        Rectangle rectangle;
        Rectangle rectangle2;
        Rectangle rectangle3;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ItemNode itemNode = selection instanceof ItemNode ? (ItemNode)((Object)selection) : null;
        if (itemNode == null) {
            return;
        }
        ItemNode node = itemNode;
        BreakpointItem breakpointItem = (BreakpointItem)node.getValue();
        if (breakpointItem == null) {
            return;
        }
        BreakpointItem breakpoint2 = breakpointItem;
        JTree jTree = parent instanceof JTree ? (JTree)parent : null;
        if (jTree != null) {
            JTree $this$performEdit_u24lambda_u240 = jTree;
            boolean bl = false;
            rectangle3 = $this$performEdit_u24lambda_u240.getPathBounds($this$performEdit_u24lambda_u240.getLeadSelectionPath());
        } else {
            rectangle3 = null;
        }
        Rectangle bounds = rectangle3;
        Rectangle $this$performEdit_u24lambda_u241 = rectangle2 = parent.getVisibleRect();
        boolean bl = false;
        Rectangle rectangle4 = $this$performEdit_u24lambda_u241;
        Rectangle rectangle5 = bounds;
        if (rectangle5 != null) {
            Rectangle rectangle6 = rectangle5;
            rectangle = rectangle4;
            boolean bl2 = false;
            rectangle4 = rectangle;
            n2 = RangesKt.coerceIn((int)((Number)($this$performEdit_u24lambda_u241_u240.x + $this$performEdit_u24lambda_u241_u240.width)).intValue(), (int)$this$performEdit_u24lambda_u241.x, (int)($this$performEdit_u24lambda_u241.x + $this$performEdit_u24lambda_u241.width));
        } else {
            n2 = $this$performEdit_u24lambda_u241.x + $this$performEdit_u24lambda_u241.width / 2;
        }
        rectangle4.x = n2;
        Rectangle rectangle7 = $this$performEdit_u24lambda_u241;
        Rectangle rectangle8 = bounds;
        if (rectangle8 != null) {
            void $this$performEdit_u24lambda_u241_u241;
            $this$performEdit_u24lambda_u241_u240 = rectangle8;
            rectangle = rectangle7;
            boolean bl3 = false;
            rectangle7 = rectangle;
            n = RangesKt.coerceIn((int)((Number)($this$performEdit_u24lambda_u241_u241.y + $this$performEdit_u24lambda_u241_u241.height / 2)).intValue(), (int)$this$performEdit_u24lambda_u241.y, (int)($this$performEdit_u24lambda_u241.y + $this$performEdit_u24lambda_u241.height));
        } else {
            n = $this$performEdit_u24lambda_u241.y + $this$performEdit_u24lambda_u241.height / 2;
        }
        rectangle7.y = n;
        Rectangle visible = rectangle2;
        EditBreakpointAction.HANDLER.editBreakpoint(this.project, parent, visible.getLocation(), breakpoint2);
    }

    @NotNull
    public String getDeleteActionText() {
        String string = XDebuggerBundle.message((String)"xdebugger.remove.line.breakpoint.action.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDelete(@NotNull List<?> selection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Iterable $this$all$iv = selection;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return true;
            Object it = element$iv = iterator.next();
            boolean bl2 = false;
            if (!(it instanceof ItemNode)) return false;
            BreakpointItem breakpointItem = (BreakpointItem)((ItemNode)((Object)it)).getValue();
            if (breakpointItem == null) return false;
            if (!breakpointItem.canNavigate()) return false;
            boolean bl3 = true;
            if (!bl3) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public void performDelete(@NotNull List<?> selection, @NotNull JComponent parent) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Iterable $this$forEach$iv = selection;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            ItemNode node = it instanceof ItemNode ? (ItemNode)((Object)it) : null;
            ItemNode itemNode = node;
            if (itemNode == null || (itemNode = (BreakpointItem)itemNode.getValue()) == null) continue;
            itemNode.removed(this.project);
        }
    }

    private static final RootNode root_delegate$lambda$0(BreakpointListProvider this$0) {
        return new RootNode(this$0.project, this$0.rootNameKey);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0012\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$GroupNode;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointGroup;", "project", "Lcom/intellij/openapi/project/Project;", "value", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointGroup;)V", "cache", "Lcom/intellij/ide/util/treeView/AbstractTreeNodeCache;", "", "getKeys", "", "getChildren", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.debugger.impl"})
    private static final class GroupNode
    extends AbstractTreeNode<XBreakpointGroup> {
        @NotNull
        private final AbstractTreeNodeCache<Object, AbstractTreeNode<?>> cache;

        public GroupNode(@NotNull Project project, @NotNull XBreakpointGroup value) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(project, (Object)value);
            this.cache = new AbstractTreeNodeCache((AbstractTreeNode)this, arg_0 -> GroupNode.cache$lambda$0(project, arg_0));
        }

        private final List<Object> getKeys() {
            for (AbstractTreeNode node = this.getParent(); node != null; node = node.getParent()) {
                if (!(node instanceof RootNode)) continue;
                RootNode rootNode = (RootNode)node;
                Object object = this.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                return rootNode.getKeys(object);
            }
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<AbstractTreeNode<?>> getChildren() {
            return this.cache.getNodes((Collection)this.getKeys());
        }

        protected void update(@NotNull PresentationData presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            presentation.setIcon(((XBreakpointGroup)this.getValue()).getIcon(true));
            presentation.setPresentableText(((XBreakpointGroup)this.getValue()).getName());
        }

        private static final AbstractTreeNode cache$lambda$0(Project $project, Object it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof BreakpointItem ? (AbstractTreeNode)new ItemNode($project, (BreakpointItem)it) : (it instanceof XBreakpointGroup ? (AbstractTreeNode)new GroupNode($project, (XBreakpointGroup)it) : null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\u0012\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$ItemNode;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointItem;", "project", "Lcom/intellij/openapi/project/Project;", "item", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointItem;)V", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "isAlwaysLeaf", "getChildren", "", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.debugger.impl"})
    private static final class ItemNode
    extends AbstractTreeNode<BreakpointItem> {
        public ItemNode(@NotNull Project project, @NotNull BreakpointItem item) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            super(project, (Object)item);
        }

        public boolean canNavigate() {
            return ((BreakpointItem)this.getValue()).canNavigate();
        }

        public boolean canNavigateToSource() {
            return ((BreakpointItem)this.getValue()).canNavigateToSource();
        }

        public void navigate(boolean requestFocus) {
            ((BreakpointItem)this.getValue()).navigate(requestFocus);
        }

        public boolean isAlwaysLeaf() {
            return true;
        }

        @NotNull
        public Collection<AbstractTreeNode<?>> getChildren() {
            return CollectionsKt.emptyList();
        }

        protected void update(@NotNull PresentationData presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            presentation.setIcon(((BreakpointItem)this.getValue()).getIcon());
            presentation.setPresentableText(((BreakpointItem)this.getValue()).getDisplayText());
            if (!((BreakpointItem)this.getValue()).isEnabled()) {
                presentation.setForcedTextForeground(NamedColorUtil.getInactiveTextColor());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00032\b\u0012\u0004\u0012\u00020\u00050\u0004B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002J\u001c\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$RootNode;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "", "project", "Lcom/intellij/openapi/project/Project;", "key", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "map", "", "valid", "Ljava/util/concurrent/atomic/AtomicBoolean;", "icon16x12", "Lcom/intellij/ui/SizedIcon;", "cache", "Lcom/intellij/ide/util/treeView/AbstractTreeNodeCache;", "hasVisibleBreakpoints", "", "getKeys", "", "value", "compare", "", "o1", "o2", "getChildren", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "breakpointsUpdater", "Lcom/intellij/util/SingleAlarm;", "intellij.platform.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nBreakpointListProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreakpointListProvider.kt\ncom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$RootNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n1#2:198\n1#2:209\n136#3,9:199\n216#3:208\n217#3:210\n145#3:211\n188#3,3:212\n774#4:215\n865#4,2:216\n*S KotlinDebug\n*F\n+ 1 BreakpointListProvider.kt\ncom/intellij/xdebugger/impl/breakpoints/BreakpointListProvider$RootNode\n*L\n86#1:209\n86#1:199,9\n86#1:208\n86#1:210\n86#1:211\n140#1:212,3\n119#1:215\n119#1:216,2\n*E\n"})
    private static final class RootNode
    extends AbstractTreeNode<String>
    implements Comparator<Object> {
        @NotNull
        private final Map<Object, Object> map;
        @NotNull
        private final AtomicBoolean valid;
        @NotNull
        private final SizedIcon icon16x12;
        @NotNull
        private final AbstractTreeNodeCache<Object, AbstractTreeNode<?>> cache;
        @NotNull
        private final SingleAlarm breakpointsUpdater;

        public RootNode(@NotNull Project project, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(project, (Object)key);
            this.map = new LinkedHashMap();
            this.valid = new AtomicBoolean();
            this.icon16x12 = (SizedIcon)JBUIScale.scaleIcon((JBScalableIcon)((JBScalableIcon)new SizedIcon(AllIcons.Debugger.Db_set_breakpoint, 16, 12)));
            this.cache = new AbstractTreeNodeCache((AbstractTreeNode)this, arg_0 -> RootNode.cache$lambda$0(project, arg_0));
            XBreakpointUtil.subscribeOnBreakpointsChanges(project, (Disposable)project, arg_0 -> RootNode._init_$lambda$0(this, arg_0));
            this.breakpointsUpdater = SingleAlarm.Companion.pooledThreadSingleAlarm(50, (Disposable)project, () -> RootNode.breakpointsUpdater$lambda$0(project, this));
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.breakpointsUpdater, (boolean)false, (int)1, null);
        }

        public final boolean hasVisibleBreakpoints() {
            return this.valid.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<Object> getKeys(@NotNull Object value) {
            List list;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Map<Object, Object> map2 = this.map;
            synchronized (map2) {
                void $this$mapNotNullTo$iv$iv;
                boolean bl = false;
                Map<Object, Object> $this$mapNotNull$iv = this.map;
                boolean $i$f$mapNotNull = false;
                Map<Object, Object> map3 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object it$iv$iv;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry it = element$iv$iv;
                    boolean bl3 = false;
                    if ((Intrinsics.areEqual(it.getValue(), (Object)value) ? (Object)it.getKey() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            return CollectionsKt.sortedWith((Iterable)list, (Comparator)this);
        }

        @Override
        public int compare(@Nullable Object o1, @Nullable Object o2) {
            int n;
            if (o1 instanceof BreakpointItem && o2 instanceof BreakpointItem) {
                boolean default1 = ((BreakpointItem)o1).isDefaultBreakpoint();
                boolean default2 = ((BreakpointItem)o2).isDefaultBreakpoint();
                n = default1 && !default2 ? -1 : (!default1 && default2 ? 1 : ((BreakpointItem)o1).compareTo(o2));
            } else {
                n = o1 instanceof XBreakpointGroup && o2 instanceof XBreakpointGroup ? ((XBreakpointGroup)o1).compareTo((XBreakpointGroup)o2) : (o1 instanceof XBreakpointGroup ? -1 : 1);
            }
            return n;
        }

        @NotNull
        public List<AbstractTreeNode<?>> getChildren() {
            Object object = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return this.cache.getNodes((Collection)this.getKeys(object));
        }

        protected void update(@NotNull PresentationData presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            presentation.setIcon((Icon)this.icon16x12);
            presentation.setPresentableText(XDebuggerBundle.message((String)((String)this.getValue()), (Object[])new Object[0]));
        }

        private static final AbstractTreeNode cache$lambda$0(Project $project, Object it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof BreakpointItem ? (AbstractTreeNode)new ItemNode($project, (BreakpointItem)it) : (it instanceof XBreakpointGroup ? (AbstractTreeNode)new GroupNode($project, (XBreakpointGroup)it) : null);
        }

        private static final Unit _init_$lambda$0(RootNode this$0, XBreakpoint it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this$0.breakpointsUpdater, (boolean)false, (int)1, null);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit breakpointsUpdater$lambda$0(Project $project, RootNode this$0) {
            boolean bl;
            block10: {
                if ($project.isDisposed()) {
                    return Unit.INSTANCE;
                }
                Map breakpoints = new LinkedHashMap();
                ReadAction.run(() -> RootNode.breakpointsUpdater$lambda$0$0($project, breakpoints, this$0));
                Map<Object, Object> map2 = this$0.map;
                synchronized (map2) {
                    boolean $i$a$-synchronized-BreakpointListProvider$RootNode$breakpointsUpdater$1$32 = false;
                    this$0.map.clear();
                    this$0.map.putAll(breakpoints);
                    Unit $i$a$-synchronized-BreakpointListProvider$RootNode$breakpointsUpdater$1$32 = Unit.INSTANCE;
                }
                Map $this$any$iv = breakpoints;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getValue(), (Object)this$0.getValue())) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            boolean newValid = bl;
            boolean oldValid = this$0.valid.getAndSet(newValid);
            if (oldValid != newValid) {
                MessageBus messageBus = $project.getMessageBus();
                Topic topic = BookmarksListener.TOPIC;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                ((BookmarksListener)messageBus.syncPublisher(topic)).structureChanged(null);
            } else if (newValid) {
                MessageBus messageBus = $project.getMessageBus();
                Topic topic = BookmarksListener.TOPIC;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                ((BookmarksListener)messageBus.syncPublisher(topic)).structureChanged((Object)this$0);
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final void breakpointsUpdater$lambda$0$0(Project $project, Map $breakpoints, RootNode this$0) {
            items = XBreakpointUtil.getAllBreakpointItems($project);
            var5_4 = XDebuggerManager.getInstance((Project)$project).getBreakpointManager();
            manager = var5_4 instanceof XBreakpointManagerImpl != false ? (XBreakpointManagerImpl)var5_4 : null;
            v0 = manager;
            selectedRules = v0 != null && (v0 = v0.getBreakpointsDialogSettings()) != null ? v0.getSelectedGroupingRules() : null;
            var7_6 = new ArrayList<E>();
            $this$breakpointsUpdater_u24lambda_u240_u240_u240 = var7_6;
            $i$a$-apply-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$enabledRules$1 = false;
            $this$breakpointsUpdater_u24lambda_u240_u240_u240.addAll(XBreakpointGroupingRule.EP.getExtensionList());
            var7_6 = (Iterable)var7_6;
            $i$f$filter = false;
            $i$a$-apply-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$enabledRules$1 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (XBreakpointGroupingRule)element$iv$iv;
                $i$a$-filter-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$enabledRules$2 = false;
                if (it.isAlwaysEnabled()) ** GOTO lbl-1000
                v1 = selectedRules != null ? selectedRules.contains(it.getId()) : false;
                if (v1) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v3 = (List)destination$iv$iv;
            v4 = XBreakpointGroupingRule.PRIORITY_COMPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"PRIORITY_COMPARATOR");
            enabledRules = CollectionsKt.toSortedSet((Iterable)v3, (Comparator)v4);
            for (BreakpointItem item : items) {
                if (!item.canNavigate() && !Registry.Companion.is("ide.bookmark.show.all.breakpoints", false)) continue;
                any = null;
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type kotlin.Any");
                any = item;
                for (XBreakpointGroupingRule rule : enabledRules) {
                    if (item.getBreakpoint() == null) continue;
                    if (rule.getGroup((Object)breakpoint) == null) continue;
                    $i$a$-let-BreakpointListProvider$RootNode$breakpointsUpdater$1$1$1 = false;
                    $breakpoints.put(any, it);
                    any = it;
                }
                $breakpoints.put(any, this$0.getValue());
            }
        }
    }
}

