/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.debugger.impl.shared.proxy.XLightLineBreakpointProxy;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointVisualRepresentation;
import com.intellij.xdebugger.impl.proxy.MonolithBreakpointManagerKt;
import com.intellij.xdebugger.impl.proxy.MonolithBreakpointProxyKt;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class XLineBreakpointImpl<P extends XBreakpointProperties>
extends XBreakpointBase<XLineBreakpoint<P>, P, LineBreakpointState>
implements XLineBreakpoint<P> {
    private final XBreakpointVisualRepresentation myVisualRepresentation;
    private final XLineBreakpointType<P> myType;
    private volatile XSourcePosition mySourcePosition;

    public XLineBreakpointImpl(XLineBreakpointType<P> type, XBreakpointManagerImpl breakpointManager, @Nullable P properties, LineBreakpointState state) {
        super(type, breakpointManager, properties, state);
        this.myType = type;
        this.myVisualRepresentation = new XBreakpointVisualRepresentation(this.getCoroutineScope(), (XLightLineBreakpointProxy)MonolithBreakpointProxyKt.asProxy(this), !SplitDebuggerMode.isSplitDebugger(), MonolithBreakpointManagerKt.asProxy(breakpointManager));
    }

    @Deprecated
    public void updateUI() {
        this.myVisualRepresentation.updateUI();
    }

    @Nullable
    public VirtualFile getFile() {
        return VirtualFileManager.getInstance().findFileByUrl(this.getFileUrl());
    }

    @NotNull
    public XLineBreakpointType<P> getType() {
        XLineBreakpointType<P> xLineBreakpointType = this.myType;
        if (xLineBreakpointType == null) {
            XLineBreakpointImpl.$$$reportNull$$$0(0);
        }
        return xLineBreakpointType;
    }

    public int getLine() {
        return ((LineBreakpointState)this.myState).getLine();
    }

    public String getFileUrl() {
        return ((LineBreakpointState)this.myState).getFileUrl();
    }

    public String getPresentableFilePath() {
        String url = this.getFileUrl();
        if ("file".equals(VirtualFileManager.extractProtocol((String)url))) {
            String path = VfsUtilCore.urlToPath((String)url);
            VirtualFile project = ProjectUtil.guessProjectDir((Project)this.getProject());
            String relativePath = project != null ? FileUtil.getRelativePath((String)project.getPath(), (String)path, (char)'/') : null;
            String presentablePath = relativePath != null ? relativePath : path;
            return FileUtil.toSystemDependentName((String)presentablePath);
        }
        return url;
    }

    public String getShortFilePath() {
        return new File(VfsUtilCore.urlToPath((String)this.getFileUrl())).getName();
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        return this.myVisualRepresentation.getHighlighter();
    }

    @Override
    public XSourcePosition getSourcePosition() {
        if (this.mySourcePosition != null) {
            return this.mySourcePosition;
        }
        this.mySourcePosition = super.getSourcePosition();
        if (this.mySourcePosition == null) {
            this.mySourcePosition = XDebuggerUtil.getInstance().createPosition(this.getFile(), this.getLine());
        }
        return this.mySourcePosition;
    }

    @Override
    @Deprecated
    public boolean isValid() {
        return super.isValid();
    }

    public void updatePosition() {
        RangeMarker highlighter = this.myVisualRepresentation.getRangeMarker();
        if (highlighter != null && highlighter.isValid()) {
            this.resetSourcePosition();
            this.setLine(-1L, highlighter.getDocument().getLineNumber(highlighter.getStartOffset()), false);
        }
    }

    void resetSourcePosition() {
        this.resetSourcePosition(-1L);
    }

    public void resetSourcePosition(long requestId) {
        this.mySourcePosition = null;
        if (this.getBreakpointManager().getRequestCounter().setRequestCompleted(requestId)) {
            this.fireBreakpointChanged();
        }
    }

    public void setFileUrl(String newUrl) {
        this.setFileUrl(-1L, newUrl);
    }

    public void setFileUrl(long requestId, String newUrl) {
        this.updateStateIfNeededAndNotify(requestId, newUrl, this::getFileUrl, url -> {
            VirtualFile oldFile = this.getFile();
            ((LineBreakpointState)this.myState).setFileUrl((String)url);
            this.resetSourcePosition();
            this.myVisualRepresentation.removeHighlighter();
            this.myVisualRepresentation.redrawInlineInlays(oldFile, this.getLine());
            this.myVisualRepresentation.redrawInlineInlays(this.getFile(), this.getLine());
        });
    }

    @ApiStatus.Internal
    public void setLine(int line) {
        this.setLine(-1L, line, true);
    }

    public void setLine(long requestId, int line) {
        this.setLine(requestId, line, true);
    }

    private void setLine(long requestId, int line, boolean visualLineMightBeChanged) {
        if (this.getLine() != line && visualLineMightBeChanged && !this.myType.lineShouldBeChanged((XLineBreakpoint)this, line, this.getProject())) {
            return;
        }
        this.updateStateIfNeededAndNotify(requestId, line, this::getLine, l -> {
            int oldLine = this.getLine();
            ((LineBreakpointState)this.myState).setLine(line);
            this.resetSourcePosition();
            if (visualLineMightBeChanged) {
                this.myVisualRepresentation.removeHighlighter();
            }
            this.myVisualRepresentation.redrawInlineInlays(this.getFile(), oldLine);
            this.myVisualRepresentation.redrawInlineInlays(this.getFile(), line);
        });
    }

    public void doUpdateUI(Runnable callOnUpdate) {
        this.myVisualRepresentation.doUpdateUI(callOnUpdate);
    }

    @NotNull
    public GutterDraggableObject createBreakpointDraggableObject() {
        GutterDraggableObject gutterDraggableObject = this.myVisualRepresentation.createBreakpointDraggableObject();
        if (gutterDraggableObject == null) {
            XLineBreakpointImpl.$$$reportNull$$$0(1);
        }
        return gutterDraggableObject;
    }

    public boolean isTemporary() {
        return ((LineBreakpointState)this.myState).isTemporary();
    }

    public void setTemporary(boolean temporary) {
        this.setTemporary(-1L, temporary);
    }

    public void setTemporary(long requestId, boolean temporary) {
        this.updateStateIfNeededAndNotify(requestId, temporary, this::isTemporary, ((LineBreakpointState)this.myState)::setTemporary);
    }

    @Override
    public String toString() {
        return "XLineBreakpointImpl(id = " + String.valueOf(this.getBreakpointId()) + ", " + this.myType.getId() + " at " + this.getShortFilePath() + ":" + this.getLine() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointDraggableObject";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

