/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointTypeProxy;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointActionsPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XMasterBreakpointPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XSuspendPolicyPanel;
import com.intellij.xdebugger.impl.proxy.MonolithBreakpointManagerKt;
import com.intellij.xdebugger.impl.proxy.MonolithBreakpointProxyKt;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import com.intellij.xdebugger.impl.util.XDebugMonolithUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XLightBreakpointPropertiesPanel
implements XSuspendPolicyPanel.Delegate {
    public static final String CONDITION_HISTORY_ID = "breakpointCondition";
    private boolean myShowMoreActionOptionsIsAvailable;
    private JPanel myConditionPanel;
    private JPanel myMainPanel;
    private Delegate myDelegate;
    @Nullable
    private Balloon myBalloon;
    private XSuspendPolicyPanel mySuspendPolicyPanel;
    private XBreakpointActionsPanel myActionsPanel;
    private XMasterBreakpointPanel myMasterBreakpointPanel;
    private JPanel myCustomPropertiesPanelWrapper;
    private JPanel myCustomConditionsPanelWrapper;
    private JCheckBox myEnabledCheckbox;
    private JPanel myCustomRightPropertiesPanelWrapper;
    private JBCheckBox myConditionEnabledCheckbox;
    private JPanel myCustomTopPropertiesPanelWrapper;
    private JBLabel myBreakpointNameLabel;
    private JPanel myConditionCheckboxPanel;
    private JPanel myLanguageChooserPanel;
    private JPanel myConditionExpressionPanel;
    private ActionLink myRestoreLink;
    private final List<XBreakpointCustomPropertiesPanel> myCustomPanels;
    private final List<XBreakpointPropertiesSubPanel> mySubPanels;
    @Nullable
    private XDebuggerExpressionComboBox myConditionComboBox;
    private final XBreakpointProxy myBreakpoint;
    private final boolean myShowAllOptions;
    private final boolean myIsEditorBalloon;
    @NotNull
    private final XBreakpointManagerProxy myBreakpointManager;

    public boolean showMoreOptions() {
        return this.myShowMoreActionOptionsIsAvailable;
    }

    @Override
    public void showActionOptionsIfNeeded() {
        if (this.myShowMoreActionOptionsIsAvailable && this.myDelegate != null) {
            this.myDelegate.showActionOptions();
        }
    }

    private void createUIComponents() {
        this.myRestoreLink = new ActionLink(XDebuggerBundle.message((String)"xbreakpoints.restore.label", (Object[])new Object[0]), e -> {
            this.myBreakpointManager.restoreRemovedBreakpoint(this.myBreakpoint);
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
        });
    }

    public Delegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    @ApiStatus.Internal
    public void setBalloon(@NotNull Balloon balloon) {
        if (balloon == null) {
            XLightBreakpointPropertiesPanel.$$$reportNull$$$0(0);
        }
        this.myBalloon = balloon;
    }

    public void setDetailView(DetailView detailView) {
        this.myMasterBreakpointPanel.setDetailView(detailView);
    }

    public XLightBreakpointPropertiesPanel(Project project, XBreakpointManagerProxy breakpointManager, XBreakpointProxy breakpoint2, boolean showAllOptions, boolean isEditorBalloon) {
        this(project, breakpointManager, breakpoint2, showAllOptions, showAllOptions, isEditorBalloon);
    }

    @Deprecated
    public XLightBreakpointPropertiesPanel(Project project, XBreakpointManager breakpointManager, XBreakpointBase breakpoint2, boolean showActionOptions, boolean showAllOptions, boolean isEditorBalloon) {
        this(project, MonolithBreakpointManagerKt.asProxy((XBreakpointManagerImpl)breakpointManager), MonolithBreakpointProxyKt.asProxy(breakpoint2), showActionOptions, showAllOptions, isEditorBalloon);
    }

    public XLightBreakpointPropertiesPanel(Project project, XBreakpointManagerProxy breakpointManager, final XBreakpointProxy breakpoint2, boolean showActionOptions, boolean showAllOptions, boolean isEditorBalloon) {
        XBreakpointBase<?, ?, ?> monolithBreakpoint;
        this.$$$setupUI$$$();
        this.mySubPanels = new ArrayList<XBreakpointPropertiesSubPanel>();
        this.myBreakpointManager = breakpointManager;
        this.myBreakpoint = breakpoint2;
        this.myShowAllOptions = showAllOptions;
        this.myIsEditorBalloon = isEditorBalloon;
        final XBreakpointTypeProxy breakpointType = breakpoint2.getType();
        if (breakpointType.getVisibleStandardPanels().contains(XBreakpointType.StandardPanels.SUSPEND_POLICY)) {
            this.mySuspendPolicyPanel.init(project, breakpoint2);
            this.mySuspendPolicyPanel.setDelegate(this);
            this.mySubPanels.add(this.mySuspendPolicyPanel);
        } else {
            this.mySuspendPolicyPanel.hide();
        }
        if (breakpointType.getVisibleStandardPanels().contains(XBreakpointType.StandardPanels.DEPENDENCY)) {
            this.myMasterBreakpointPanel.init(project, breakpoint2);
            this.mySubPanels.add(this.myMasterBreakpointPanel);
        } else {
            this.myMasterBreakpointPanel.hide();
        }
        XDebuggerEditorsProvider debuggerEditorsProvider = breakpoint2.getEditorsProvider();
        if (breakpointType.getVisibleStandardPanels().contains(XBreakpointType.StandardPanels.ACTIONS)) {
            this.myActionsPanel.init(project, breakpoint2, debuggerEditorsProvider, this.myShowAllOptions);
            this.mySubPanels.add(this.myActionsPanel);
        } else {
            this.myActionsPanel.hide();
        }
        this.myCustomPanels = new ArrayList<XBreakpointCustomPropertiesPanel>();
        if (debuggerEditorsProvider != null) {
            this.myConditionEnabledCheckbox = new JBCheckBox(XDebuggerBundle.message((String)"xbreakpoints.condition.checkbox", (Object[])new Object[0]));
            this.myConditionComboBox = new XDebuggerExpressionComboBox(project, debuggerEditorsProvider, CONDITION_HISTORY_ID, null, true, false);
            this.myLanguageChooserPanel.add((Component)this.myConditionComboBox.getLanguageChooser(), "Center");
            this.myConditionExpressionPanel.add((Component)this.myConditionComboBox.getComponent(), "Center");
            this.myConditionEnabledCheckbox.addActionListener(e -> this.onCheckboxChanged());
            DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myConditionEnabledCheckbox, this.myConditionComboBox.getEditorComponent());
        } else {
            this.myConditionPanel.setVisible(false);
        }
        this.myShowMoreActionOptionsIsAvailable = false;
        for (XBreakpointPropertiesSubPanel panel2 : this.mySubPanels) {
            if (panel2 instanceof XBreakpointActionsPanel) {
                if (!panel2.lightVariant(showActionOptions || this.myShowAllOptions)) continue;
                this.myShowMoreActionOptionsIsAvailable = true;
                continue;
            }
            panel2.lightVariant(this.myShowAllOptions);
        }
        XBreakpointCustomPropertiesPanel customPropertiesPanel = breakpointType.createCustomPropertiesPanel(project);
        if (customPropertiesPanel != null) {
            this.myCustomPropertiesPanelWrapper.add((Component)customPropertiesPanel.getComponent(), "Center");
            this.myCustomPanels.add(customPropertiesPanel);
        } else {
            this.myCustomPropertiesPanelWrapper.getParent().remove(this.myCustomPropertiesPanelWrapper);
        }
        XBreakpointCustomPropertiesPanel customConditionPanel = breakpointType.createCustomConditionsPanel();
        if (customConditionPanel != null) {
            this.myCustomConditionsPanelWrapper.add((Component)customConditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(customConditionPanel);
        } else {
            this.myCustomConditionsPanelWrapper.getParent().remove(this.myCustomConditionsPanelWrapper);
        }
        XBreakpointCustomPropertiesPanel customRightConditionPanel = breakpointType.createCustomRightPropertiesPanel(project);
        boolean isVisibleOnPopup = false;
        if (customRightConditionPanel != null && (monolithBreakpoint = XDebugMonolithUtils.findBreakpointById(this.myBreakpoint.getId())) != null) {
            isVisibleOnPopup = customRightConditionPanel.isVisibleOnPopup(monolithBreakpoint);
        }
        if (customRightConditionPanel != null && (this.myShowAllOptions || isVisibleOnPopup)) {
            this.myCustomRightPropertiesPanelWrapper.add((Component)customRightConditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(customRightConditionPanel);
        } else {
            this.myCustomRightPropertiesPanelWrapper.getParent().remove(this.myCustomRightPropertiesPanelWrapper);
        }
        XBreakpointCustomPropertiesPanel customTopPropertiesPanel = breakpointType.createCustomTopPropertiesPanel(project);
        if (customTopPropertiesPanel != null) {
            this.myCustomTopPropertiesPanelWrapper.add((Component)customTopPropertiesPanel.getComponent(), "Center");
            this.myCustomPanels.add(customTopPropertiesPanel);
        } else {
            this.myCustomTopPropertiesPanelWrapper.getParent().remove(this.myCustomTopPropertiesPanelWrapper);
        }
        this.myMainPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                boolean isSuspending;
                JComponent compToFocus = null;
                boolean actionsAvailable = breakpointType.getVisibleStandardPanels().contains(XBreakpointType.StandardPanels.ACTIONS);
                boolean conditionEditable = XLightBreakpointPropertiesPanel.this.myConditionComboBox != null && XLightBreakpointPropertiesPanel.this.myConditionComboBox.getComboBox().isEnabled();
                boolean bl = isSuspending = breakpoint2.getSuspendPolicy() != SuspendPolicy.NONE;
                if (!(!actionsAvailable || isSuspending && conditionEditable)) {
                    compToFocus = XLightBreakpointPropertiesPanel.this.myActionsPanel.getDefaultFocusComponent();
                } else if (conditionEditable) {
                    compToFocus = XLightBreakpointPropertiesPanel.this.myConditionComboBox.getEditorComponent();
                }
                if (compToFocus != null) {
                    IdeFocusManager.findInstance().requestFocus((Component)compToFocus, false);
                }
            }
        });
        this.myEnabledCheckbox.addActionListener(e -> this.myBreakpoint.setEnabled(this.myEnabledCheckbox.isSelected()));
        this.myRestoreLink.setVisible(false);
        ReadAction.nonBlocking(() -> {
            XSourcePosition sourcePosition = this.myBreakpoint.getSourcePosition();
            XBreakpointProxy lastRemovedBreakpoint = breakpointManager.getLastRemovedBreakpoint();
            boolean restore = lastRemovedBreakpoint != null && breakpointType.equals((Object)lastRemovedBreakpoint.getType()) && XSourcePosition.isOnTheSameLine((XSourcePosition)sourcePosition, (XSourcePosition)lastRemovedBreakpoint.getSourcePosition()) && !lastRemovedBreakpoint.haveSameState(breakpoint2, true);
            return Pair.create((Object)sourcePosition, (Object)restore);
        }).finishOnUiThread(ModalityState.defaultModalityState(), pair -> {
            XSourcePosition sourcePosition = (XSourcePosition)pair.getFirst();
            if (this.myConditionComboBox != null) {
                this.myConditionComboBox.setSourcePosition(sourcePosition);
            }
            this.myActionsPanel.setSourcePosition(sourcePosition);
            this.myRestoreLink.setVisible(((Boolean)pair.getSecond()).booleanValue());
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void onCheckboxChanged() {
        if (this.myConditionComboBox != null) {
            this.myConditionComboBox.setEnabled(this.myConditionEnabledCheckbox.isSelected());
        }
    }

    public void saveProperties() {
        XBreakpointBase<?, ?, ?> monolithBreakpoint;
        this.mySubPanels.forEach(XBreakpointPropertiesSubPanel::saveProperties);
        if (this.myConditionComboBox != null) {
            XExpression expression = this.myConditionComboBox.getExpression();
            XExpression condition = !XDebuggerUtilImpl.isEmptyExpression(expression) ? expression : null;
            this.myBreakpoint.setConditionEnabled(condition == null || this.myConditionEnabledCheckbox.isSelected());
            this.myBreakpoint.setConditionExpression(condition);
            this.myConditionComboBox.saveTextInHistory();
        }
        if ((monolithBreakpoint = XDebugMonolithUtils.findBreakpointById(this.myBreakpoint.getId())) != null) {
            for (XBreakpointCustomPropertiesPanel customPanel : this.myCustomPanels) {
                customPanel.saveTo(monolithBreakpoint);
            }
        }
        this.myBreakpoint.setEnabled(this.myEnabledCheckbox.isSelected());
    }

    public void loadProperties() {
        XBreakpointBase<?, ?, ?> monolithBreakpoint;
        this.mySubPanels.forEach(XBreakpointPropertiesSubPanel::loadProperties);
        if (this.myConditionComboBox != null) {
            XExpression condition = this.myBreakpoint.getConditionExpressionInt();
            this.myConditionComboBox.setExpression(condition);
            boolean hideCheckbox = !this.myShowAllOptions && condition == null;
            this.myConditionEnabledCheckbox.setSelected(hideCheckbox || this.myBreakpoint.isConditionEnabled() && condition != null);
            this.myConditionCheckboxPanel.removeAll();
            if (hideCheckbox) {
                JBLabel label = new JBLabel(XDebuggerBundle.message((String)"xbreakpoints.condition.checkbox", (Object[])new Object[0]));
                label.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)0));
                label.setLabelFor((Component)this.myConditionComboBox.getComboBox());
                this.myConditionCheckboxPanel.add((Component)label);
                this.myConditionExpressionPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)3));
            } else {
                this.myConditionCheckboxPanel.add((Component)this.myConditionEnabledCheckbox);
                this.myConditionExpressionPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myConditionEnabledCheckbox)));
            }
            this.onCheckboxChanged();
        }
        if ((monolithBreakpoint = XDebugMonolithUtils.findBreakpointById(this.myBreakpoint.getId())) != null) {
            for (XBreakpointCustomPropertiesPanel customPanel : this.myCustomPanels) {
                customPanel.loadFrom(monolithBreakpoint);
            }
        }
        this.myEnabledCheckbox.setSelected(this.myBreakpoint.isEnabled());
        this.myBreakpointNameLabel.setText(this.getBreakpointNameLabel());
    }

    @Nls
    private String getBreakpointNameLabel() {
        String description = this.myBreakpoint.getGeneralDescription();
        if (this.myIsEditorBalloon) {
            return description;
        }
        String itemTitleText = this.myBreakpoint.getShortText();
        if (description.contains(itemTitleText)) {
            return description;
        }
        if (itemTitleText.contains(description)) {
            return itemTitleText;
        }
        if (this.isDefaultDescriptionOfXLineBreakpoint(description)) {
            return description;
        }
        return XDebuggerBundle.message((String)"xbreakpoints.dialog.double.breakpoint.title", (Object[])new Object[]{itemTitleText, description});
    }

    private boolean isDefaultDescriptionOfXLineBreakpoint(String description) {
        XBreakpointProxy xBreakpointProxy = this.myBreakpoint;
        if (xBreakpointProxy instanceof XLineBreakpoint) {
            XLineBreakpoint lineBreakpoint = (XLineBreakpoint)xBreakpointProxy;
            XLineBreakpointType type = lineBreakpoint.getType();
            return description.equals(type.getDisplayTextDefaultWithPathAndLine(lineBreakpoint));
        }
        return false;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void dispose() {
        this.myActionsPanel.dispose();
        this.myCustomPanels.forEach(Disposer::dispose);
        this.myCustomPanels.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/xdebugger/impl/breakpoints/ui/XLightBreakpointPropertiesPanel", "setBalloon"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        XMasterBreakpointPanel xMasterBreakpointPanel;
        XBreakpointActionsPanel xBreakpointActionsPanel;
        XSuspendPolicyPanel xSuspendPolicyPanel;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        JPanel jPanel9;
        this.createUIComponents();
        this.myMainPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConditionPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel9.add((Component)jPanel8, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myConditionCheckboxPanel = jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myLanguageChooserPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel6, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 3, null, null, null));
        this.myConditionExpressionPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel5, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySuspendPolicyPanel = xSuspendPolicyPanel = new XSuspendPolicyPanel();
        JComponent jComponent = xSuspendPolicyPanel.$$$getRootComponent$$$();
        jPanel9.add((Component)jComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myActionsPanel = xBreakpointActionsPanel = new XBreakpointActionsPanel();
        JComponent jComponent2 = xBreakpointActionsPanel.$$$getRootComponent$$$();
        jPanel9.add((Component)jComponent2, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myMasterBreakpointPanel = xMasterBreakpointPanel = new XMasterBreakpointPanel();
        JComponent jComponent3 = xMasterBreakpointPanel.$$$getRootComponent$$$();
        jPanel9.add((Component)jComponent3, new GridConstraints(7, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCustomPropertiesPanelWrapper = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel4, new GridConstraints(9, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(10, 0, 1, 2, 0, 1, 6, 1, null, new Dimension(400, -1), null));
        this.myCustomConditionsPanelWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel3, new GridConstraints(5, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myCustomRightPropertiesPanelWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel2).setEnabled(true);
        ((Component)jPanel2).setVisible(true);
        jPanel9.add((Component)jPanel2, new GridConstraints(6, 1, 3, 1, 0, 3, 3, 3, null, null, null, 2));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), null, 0, 0, null, null));
        Spacer spacer3 = new Spacer();
        jPanel9.add((Component)spacer3, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCustomTopPropertiesPanelWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myEnabledCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XLightBreakpointPropertiesPanel.class).getString("xbreakpoints.enabled.label"));
        jPanel10.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myBreakpointNameLabel = jBLabel = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel.getFont());
        if (font != null) {
            jBLabel.setFont(font);
        }
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XLightBreakpointPropertiesPanel.class).getString("xbreakpoints.breakpoint.name"));
        jPanel11.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ActionLink actionLink = this.myRestoreLink;
        this.$$$loadButtonText$$$((AbstractButton)actionLink, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XLightBreakpointPropertiesPanel.class).getString("xbreakpoints.restore.label"));
        jPanel11.add((Component)actionLink, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Delegate {
        public void showActionOptions();
    }
}

