/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.dashboard;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/xdebugger/impl/dashboard/XDebuggerRunDashboardUpdater;", "Lcom/intellij/execution/ExecutionListener;", "<init>", "()V", "processStarted", "", "executorId", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nXDebuggerRunDashboardUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XDebuggerRunDashboardUpdater.kt\ncom/intellij/xdebugger/impl/dashboard/XDebuggerRunDashboardUpdater\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class XDebuggerRunDashboardUpdater
implements ExecutionListener {
    public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
        Object object;
        Project project;
        RunProfile profile;
        block7: {
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            if (!Intrinsics.areEqual((Object)"Debug", (Object)executorId)) {
                return;
            }
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
            if (runnerAndConfigurationSettings == null) {
                return;
            }
            RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            RunProfile runProfile = ExecutionManagerImpl.Companion.getDelegatedRunProfile((RunProfile)configuration);
            if (runProfile == null) {
                runProfile = (RunProfile)configuration;
            }
            if (!((profile = runProfile) instanceof RunConfiguration)) {
                return;
            }
            project = ((RunConfiguration)profile).getProject();
            if (!RunDashboardManager.getInstance((Project)project).isShowInDashboard((RunConfiguration)profile)) {
                return;
            }
            XDebugSession[] xDebugSessionArray = XDebuggerManager.getInstance((Project)project).getDebugSessions();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
            for (Object object2 : (Object[])xDebugSessionArray) {
                XDebugSession it = (XDebugSession)object2;
                boolean bl = false;
                if (!(it.getDebugProcess().getProcessHandler() == handler)) continue;
                object = object2;
                break block7;
            }
            object = null;
        }
        XDebugSession xDebugSession = (XDebugSession)object;
        if (xDebugSession == null) {
            return;
        }
        XDebugSession session = xDebugSession;
        session.addSessionListener(new XDebugSessionListener(session, project, profile){
            final /* synthetic */ XDebugSession $session;
            final /* synthetic */ Project $project;
            final /* synthetic */ RunProfile $profile;
            {
                this.$session = $session;
                this.$project = $project;
                this.$profile = $profile;
            }

            public void sessionPaused() {
                this.updateDashboard();
            }

            public void sessionResumed() {
                this.updateDashboard();
            }

            public void sessionStopped() {
                this.$session.removeSessionListener((XDebugSessionListener)this);
            }

            private final void updateDashboard() {
                MessageBus messageBus = this.$project.getMessageBus();
                Topic topic = RunDashboardListener.DASHBOARD_TOPIC;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DASHBOARD_TOPIC");
                ((RunDashboardListener)messageBus.syncPublisher(topic)).configurationChanged((RunConfiguration)this.$profile, false);
            }
        });
    }
}

