/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.XValueTextModificationPreparator;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.XDebuggerPopupPanel;
import com.intellij.xdebugger.impl.evaluate.quick.common.XDebuggerTreePopup;
import com.intellij.xdebugger.impl.frame.XValueTextModificationPreparatorProviders;
import com.intellij.xdebugger.impl.messages.XDebuggerImplBundle;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class XDebuggerTextPopup<D>
extends XDebuggerPopupPanel {
    public static final String ACTION_PLACE = "XDebuggerTextPopup";
    private static final int MAX_POPUP_WIDTH = 650;
    private static final int MAX_POPUP_HEIGHT = 400;
    private static final int MIN_POPUP_WIDTH = 170;
    private static final int MIN_POPUP_HEIGHT = 100;
    private static final int TOOLBAR_MARGIN = 30;
    @Nullable
    protected final XFullValueEvaluator myEvaluator;
    @NotNull
    protected final DebuggerTreeCreator<D> myTreeCreator;
    @NotNull
    protected final D myInitialItem;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Editor myEditor;
    @NotNull
    protected final Point myPoint;
    @Nullable
    protected final Runnable myHideRunnable;
    private VisualizedTextPanel myTextPanel;
    @Nullable
    private JBPopup myPopup;
    protected boolean myTreePopupIsShown;
    @Nullable
    protected Tree myTree;
    private boolean mySetValueModeEnabled;

    @ApiStatus.Experimental
    public XDebuggerTextPopup(@Nullable XFullValueEvaluator evaluator, final @NotNull XValue value, @NotNull DebuggerTreeCreator<D> creator, @NotNull D initialItem, @NotNull Editor editor, @NotNull Point point, @NotNull Project project, @Nullable Runnable hideRunnable) {
        XValueTextProvider textValue;
        if (value == null) {
            XDebuggerTextPopup.$$$reportNull$$$0(0);
        }
        if (creator == null) {
            XDebuggerTextPopup.$$$reportNull$$$0(1);
        }
        if (initialItem == null) {
            XDebuggerTextPopup.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            XDebuggerTextPopup.$$$reportNull$$$0(3);
        }
        if (point == null) {
            XDebuggerTextPopup.$$$reportNull$$$0(4);
        }
        if (project == null) {
            XDebuggerTextPopup.$$$reportNull$$$0(5);
        }
        this.myTreePopupIsShown = false;
        this.mySetValueModeEnabled = false;
        this.myTreeCreator = creator;
        this.myInitialItem = initialItem;
        this.myEditor = editor;
        this.myPoint = point;
        this.myProject = project;
        this.myHideRunnable = hideRunnable;
        if (evaluator == null && value instanceof XValueTextProvider && (textValue = (XValueTextProvider)value).shouldShowTextValue()) {
            evaluator = new XFullValueEvaluator(this){

                public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                    if (callback == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    value.computePresentation((XValueNode)new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){

                        @Override
                        public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                            if (valuePresenter == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            callback.evaluated(StringUtil.notNullize((String)textValue.getValueText()));
                        }

                        @Override
                        public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                            if (fullValueEvaluator == null) {
                                1.$$$reportNull$$$0(1);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "valuePresenter";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "fullValueEvaluator";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "applyPresentation";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "setFullValueEvaluator";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, XValuePlace.TOOLTIP);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup$1", "startEvaluation"));
                }
            };
        }
        this.myEvaluator = evaluator;
    }

    private JBPopup createPopup(XFullValueEvaluator evaluator, final Runnable afterEvaluation, Runnable hideTextPopupRunnable) {
        final AtomicBoolean evaluationObsolete = new AtomicBoolean(false);
        XFullValueEvaluator.XFullValueEvaluationCallback callback = new XFullValueEvaluator.XFullValueEvaluationCallback(){
            private final AtomicReference<Integer> lastFullValueHashCode = new AtomicReference();

            private boolean preventDoubleExecution(@NotNull String fullValue) {
                Integer hashCode;
                if (fullValue == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((hashCode = Integer.valueOf(fullValue.hashCode())).equals(this.lastFullValueHashCode.get())) {
                    return true;
                }
                this.lastFullValueHashCode.set(hashCode);
                return false;
            }

            public void evaluated(@NotNull String fullValue, @Nullable Font font) {
                if (fullValue == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (this.preventDoubleExecution(fullValue)) {
                    return;
                }
                AppUIUtil.invokeOnEdt(() -> {
                    XDebuggerTextPopup.this.myTextPanel.showVisualizedText(fullValue);
                    if (afterEvaluation != null) {
                        afterEvaluation.run();
                    }
                });
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    2.$$$reportNull$$$0(2);
                }
                AppUIUtil.invokeOnEdt(() -> XDebuggerTextPopup.this.myTextPanel.showError(errorMessage));
            }

            public boolean isObsolete() {
                return evaluationObsolete.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fullValue";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "preventDoubleExecution";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Runnable cancelCallback = () -> {
            evaluationObsolete.set(true);
            if (hideTextPopupRunnable != null) {
                hideTextPopupRunnable.run();
            }
        };
        evaluator.startEvaluation(callback);
        ComponentPopupBuilder builder = DebuggerUIUtil.createCancelablePopupBuilder(this.myProject, (JComponent)this.myContent, this.myTextPanel, cancelCallback, null);
        return builder.setCancelKeyEnabled(false).setRequestFocus(true).setKeyEventHandler(event -> {
            if (this.mySetValueModeEnabled) {
                return false;
            }
            if (AbstractPopup.isCloseRequest((KeyEvent)event) && this.myPopup != null) {
                this.myPopup.cancel();
                return true;
            }
            return false;
        }).createPopup();
    }

    public JBPopup show(@NotNull String initialText) {
        if (initialText == null) {
            XDebuggerTextPopup.$$$reportNull$$$0(6);
        }
        this.myTextPanel = new VisualizedTextPanel(this.myProject);
        this.myMainPanel.setBorder((Border)JBUI.Borders.empty());
        this.myMainPanel.setBackground(this.myTextPanel.getBackground());
        this.setContent(this.myTextPanel, this.getToolbarActions(), ACTION_PLACE, null);
        this.myMainPanel.setPreferredSize((Dimension)JBUI.size((int)0, (int)0));
        XFullValueEvaluator evaluator = this.myEvaluator != null ? this.myEvaluator : new ImmediateFullValueEvaluator(initialText);
        Runnable hideTextPopupRunnable = this.myHideRunnable == null ? null : () -> {
            if (!this.myTreePopupIsShown) {
                this.myHideRunnable.run();
            }
        };
        this.myPopup = this.createPopup(evaluator, this::resizePopup, hideTextPopupRunnable);
        Disposer.register((Disposable)this.myPopup, (Disposable)this.myTextPanel);
        this.myTree = this.myTreeCreator.createTree(this.myInitialItem);
        XDebuggerTextPopup.registerTreeDisposable((Disposable)this.myPopup, this.myTree);
        this.setAutoResizeUntilToolbarNotFull(this::resizePopup, (Disposable)this.myPopup);
        this.myPopup.show(new RelativePoint((Component)this.myEditor.getContentComponent(), this.myPoint));
        return this.myPopup;
    }

    private void resizePopup() {
        if (this.myPopup == null || !this.myPopup.isVisible() || this.myPopup.isDisposed()) {
            return;
        }
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        if (popupWindow == null) {
            return;
        }
        int textWidth = this.myTextPanel.getPreferredSize().width;
        int toolbarWidth = this.myToolbar.getPreferredSize().width;
        int newWidth = Math.max(toolbarWidth, textWidth) + 30;
        int textHeight = this.myTextPanel.getPreferredSize().height;
        int toolbarHeight = this.myToolbar.getPreferredSize().height;
        int newHeight = textHeight + toolbarHeight;
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Component)this.myToolbar);
        newWidth = Math.min(newWidth, XDebuggerTextPopup.getMaxPopupWidth(screenRectangle));
        newWidth = Math.max(newWidth, XDebuggerTextPopup.getMinPopupWidth(screenRectangle));
        newHeight = Math.min(newHeight, XDebuggerTextPopup.getMaxPopupHeight(screenRectangle));
        newHeight = Math.max(newHeight, XDebuggerTextPopup.getMinPopupHeight(screenRectangle));
        XDebuggerTextPopup.updatePopupBounds(popupWindow, newWidth, newHeight);
    }

    protected void hideTextPopup() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
        }
    }

    @NotNull
    protected DefaultActionGroup getToolbarActions() {
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        toolbarActions.add((AnAction)new ShowAsObject());
        toolbarActions.add((AnAction)new EnableSetValueMode());
        toolbarActions.add((AnAction)new SetTextValueAction());
        toolbarActions.add((AnAction)new CancelSetValue());
        DefaultActionGroup defaultActionGroup = toolbarActions;
        if (defaultActionGroup == null) {
            XDebuggerTextPopup.$$$reportNull$$$0(7);
        }
        return defaultActionGroup;
    }

    @Nullable
    private XValueNodeImpl getValueNode() {
        if (this.myTree instanceof XDebuggerTree) {
            XDebuggerTreeNode node = ((XDebuggerTree)this.myTree).getRoot();
            return node instanceof XValueNodeImpl ? (XValueNodeImpl)node : null;
        }
        return null;
    }

    protected void showTreePopup(Runnable hideTreeRunnable) {
        new XDebuggerTreePopup<D>(this.myTreeCreator, this.myEditor, this.myPoint, this.myProject, hideTreeRunnable).show(this.myInitialItem);
    }

    private void tryEnableSetValueMode() {
        if (this.myTextPanel.tryEditText()) {
            this.mySetValueModeEnabled = true;
            this.myToolbar.updateActionsImmediately();
        }
    }

    private String disableSetValueMode(boolean saveChanges) {
        String newText = this.myTextPanel.finishEdit(saveChanges);
        this.mySetValueModeEnabled = false;
        this.myToolbar.updateActionsImmediately();
        return newText;
    }

    @Override
    protected boolean shouldBeVisible(AnAction action) {
        boolean isSetValueModeAction = action instanceof SetTextValueAction || action instanceof CancelSetValue;
        return isSetValueModeAction && this.mySetValueModeEnabled || !isSetValueModeAction && !this.mySetValueModeEnabled;
    }

    private static int getMaxPopupWidth(Rectangle screenRectangle) {
        return Math.min(screenRectangle.width / 2, 650);
    }

    private static int getMaxPopupHeight(Rectangle screenRectangle) {
        return Math.min(screenRectangle.height / 2, 400);
    }

    private static int getMinPopupWidth(Rectangle screenRectangle) {
        return Math.max(screenRectangle.width / 5, 170);
    }

    private static int getMinPopupHeight(Rectangle screenRectangle) {
        return Math.max(screenRectangle.height / 7, 100);
    }

    private static boolean canSetTextValue(@Nullable XValueNodeImpl node) {
        return XDebuggerTextPopup.getTextValuePreparator(node) != null;
    }

    @Nullable
    private static XValueTextModificationPreparator getTextValuePreparator(@Nullable XValueNodeImpl node) {
        XValueTextProvider textProvider;
        if (node == null) {
            return null;
        }
        XValue value = (XValue)node.getValueContainer();
        return value instanceof XValueTextProvider && (textProvider = (XValueTextProvider)value).shouldShowTextValue() && value.getModifier() != null ? XValueTextModificationPreparatorProviders.getPreparator(value) : null;
    }

    protected static void registerTreeDisposable(Disposable disposable, Tree tree) {
        if (tree instanceof Disposable) {
            Disposer.register((Disposable)disposable, (Disposable)((Disposable)tree));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private class ShowAsObject
    extends AnAction {
        private ShowAsObject() {
            super(XDebuggerImplBundle.message("action.Debugger.XDebuggerTextPopup.ShowAsObject.text", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAsObject.$$$reportNull$$$0(0);
            }
            Runnable hideTreeRunnable = XDebuggerTextPopup.this.myHideRunnable == null ? null : () -> {
                XDebuggerTextPopup.this.myTreePopupIsShown = false;
                XDebuggerTextPopup.this.myHideRunnable.run();
            };
            XDebuggerTextPopup.this.showTreePopup(hideTreeRunnable);
            XDebuggerTextPopup.this.myTreePopupIsShown = true;
            XDebuggerTextPopup.this.hideTextPopup();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup$ShowAsObject", "actionPerformed"));
        }
    }

    private class EnableSetValueMode
    extends AnAction {
        private EnableSetValueMode() {
            super(XDebuggerBundle.message((String)"xdebugger.enable.set.action.title", (Object[])new Object[0]));
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EnableSetValueMode.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(XDebuggerTextPopup.canSetTextValue(XDebuggerTextPopup.this.getValueNode()));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                EnableSetValueMode.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EnableSetValueMode.$$$reportNull$$$0(2);
            }
            XDebuggerTextPopup.this.tryEnableSetValueMode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup$EnableSetValueMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup$EnableSetValueMode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class SetTextValueAction
    extends AnAction {
        private SetTextValueAction() {
            super(XDebuggerBundle.message((String)"xdebugger.set.text.value.action.title", (Object[])new Object[0]));
            this.setShortcutSet(CommonShortcuts.getCtrlEnter());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SetTextValueAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(XDebuggerTextPopup.canSetTextValue(XDebuggerTextPopup.this.getValueNode()));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SetTextValueAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            XValueNodeImpl node;
            XValueTextModificationPreparator preparator;
            if (e == null) {
                SetTextValueAction.$$$reportNull$$$0(2);
            }
            if ((preparator = XDebuggerTextPopup.getTextValuePreparator(node = XDebuggerTextPopup.this.getValueNode())) != null) {
                String newValue = XDebuggerTextPopup.this.disableSetValueMode(true);
                this.setTextValue(node, preparator, newValue);
            } else {
                this.onErrorSettingValue("Unexpectedly cannot set text value for this edited value");
            }
        }

        private void setTextValue(@NotNull XValueNodeImpl node, @NotNull XValueTextModificationPreparator preparator, @NotNull String text) {
            if (node == null) {
                SetTextValueAction.$$$reportNull$$$0(3);
            }
            if (preparator == null) {
                SetTextValueAction.$$$reportNull$$$0(4);
            }
            if (text == null) {
                SetTextValueAction.$$$reportNull$$$0(5);
            }
            XExpressionImpl expression = XExpressionImpl.fromText(preparator.convertToStringLiteral(text));
            DebuggerUIUtil.setTreeNodeValue(node, expression, (Consumer<? super String>)((Consumer)this::onErrorSettingValue));
        }

        private void onErrorSettingValue(String errorMessage) {
            XDebuggerTextPopup.this.hideTextPopup();
            @NlsContexts.DialogMessage String message = errorMessage;
            Messages.showErrorDialog((Component)XDebuggerTextPopup.this.myEditor.getComponent(), (String)message, (String)XDebuggerBundle.message((String)"xdebugger.set.text.value.error.title", (Object[])new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup$SetTextValueAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preparator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup$SetTextValueAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setTextValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class CancelSetValue
    extends AnAction {
        private CancelSetValue() {
            super(XDebuggerBundle.message((String)"xdebugger.cancel.set.action.title", (Object[])new Object[0]));
            this.setShortcutSet(CommonShortcuts.ESCAPE);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CancelSetValue.$$$reportNull$$$0(0);
            }
            XDebuggerTextPopup.this.disableSetValueMode(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTextPopup$CancelSetValue", "actionPerformed"));
        }
    }
}

