/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.platform.debugger.impl.rpc.FrameNotificationRequest;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionId;
import com.intellij.platform.debugger.impl.shared.proxy.IXDebuggerSessionTab;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.platform.rpc.topics.ProjectRemoteTopic;
import com.intellij.platform.rpc.topics.ProjectRemoteTopicKt;
import com.intellij.ui.awt.AnchoredPoint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.frame.FrameNotificationRemoteTopicKt;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.intellij.xdebugger.impl.proxy.MonolithSessionProxyKt;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicArrowButton;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\"\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/xdebugger/impl/frame/FrameNotificationUtils;", "", "<init>", "()V", "FRAME_NOTIFICATION_REMOTE_TOPIC", "Lcom/intellij/platform/rpc/topics/ProjectRemoteTopic;", "Lcom/intellij/platform/debugger/impl/rpc/FrameNotificationRequest;", "getFRAME_NOTIFICATION_REMOTE_TOPIC", "()Lcom/intellij/platform/rpc/topics/ProjectRemoteTopic;", "showNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "content", "", "showNotificationImpl", "Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class FrameNotificationUtils {
    @NotNull
    public static final FrameNotificationUtils INSTANCE = new FrameNotificationUtils();
    @NotNull
    private static final ProjectRemoteTopic<FrameNotificationRequest> FRAME_NOTIFICATION_REMOTE_TOPIC = ProjectRemoteTopicKt.ProjectRemoteTopic((String)"xdebugger.show.frame.notification", (KSerializer)FrameNotificationRequest.Companion.serializer());

    private FrameNotificationUtils() {
    }

    @NotNull
    public final ProjectRemoteTopic<FrameNotificationRequest> getFRAME_NOTIFICATION_REMOTE_TOPIC() {
        return FRAME_NOTIFICATION_REMOTE_TOPIC;
    }

    @JvmStatic
    public static final void showNotification(@NotNull Project project, @Nullable XDebugSession session, @NlsSafe @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (SplitDebuggerMode.isSplitDebugger()) {
            XDebugSessionImpl xDebugSessionImpl = session instanceof XDebugSessionImpl ? (XDebugSessionImpl)session : null;
            XDebugSessionId sessionId = xDebugSessionImpl != null ? xDebugSessionImpl.getId() : null;
            ProjectRemoteTopicKt.sendToClient$default(FRAME_NOTIFICATION_REMOTE_TOPIC, (Project)project, (Object)new FrameNotificationRequest(sessionId, content), null, (int)4, null);
        } else {
            XDebugSession xDebugSession = session;
            INSTANCE.showNotificationImpl(project, (XDebugSessionProxy)(xDebugSession != null ? MonolithSessionProxyKt.asProxy(xDebugSession) : null), content);
        }
    }

    public final void showNotificationImpl(@NotNull Project project, @Nullable XDebugSessionProxy session, @NlsSafe @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        EDT.assertIsEdt();
        MessageType messageType = MessageType.INFO;
        if (session != null) {
            XFramesView view;
            XDebugSessionTab tab;
            IXDebuggerSessionTab iXDebuggerSessionTab = session.getSessionTab();
            XDebugSessionTab xDebugSessionTab = tab = iXDebuggerSessionTab instanceof XDebugSessionTab ? (XDebugSessionTab)iXDebuggerSessionTab : null;
            if (tab != null && (view = tab.getFramesView()) != null) {
                ComboBox<XExecutionStack> comboBox = view.getThreadComboBox();
                Intrinsics.checkNotNullExpressionValue(comboBox, (String)"getThreadComboBox(...)");
                ComboBox<XExecutionStack> comboBox2 = comboBox;
                ComboBox<XExecutionStack> arrowButton = (ComboBox<XExecutionStack>)UIUtil.findComponentOfType((JComponent)((JComponent)comboBox2), BasicArrowButton.class);
                ComboBox<XExecutionStack> comboBox3 = arrowButton;
                if (comboBox3 == null) {
                    comboBox3 = comboBox2;
                }
                ComboBox<XExecutionStack> target2 = comboBox3;
                BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(content, messageType, null).setHideOnClickOutside(true).setDisposable(FrameNotificationRemoteTopicKt.access$createEdtDisposable(CoroutineScopeKt.asDisposable((CoroutineScope)session.getCoroutineScope()))).setHideOnFrameResize(false);
                Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"setHideOnFrameResize(...)");
                BalloonBuilder balloonBuilder2 = balloonBuilder;
                Balloon balloon = balloonBuilder2.createBalloon();
                Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
                Balloon balloon2 = balloon;
                balloon2.show((RelativePoint)new AnchoredPoint(AnchoredPoint.Anchor.TOP, (Component)target2, null, 4, null), Balloon.Position.above);
                return;
            }
        }
        NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
        Intrinsics.checkNotNull((Object)messageType);
        notificationGroup.createNotification(content, messageType).notify(project);
    }
}

