/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.actions.CreateAction;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.BackendExecutionEnvironmentProxy;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProxy;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.customization.CustomActionsListener;
import com.intellij.ide.ui.customization.DefaultActionGroupWithDelegate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebugSessionSelectionService;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebugViewSessionListener;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.intellij.xdebugger.impl.frame.XThreadsView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XVariablesViewBase;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.messages.XDebuggerImplBundle;
import com.intellij.xdebugger.impl.proxy.MonolithSessionProxy;
import com.intellij.xdebugger.impl.proxy.MonolithSessionProxyKt;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab3;
import com.intellij.xdebugger.impl.ui.XDebugSessionTabCustomizerKt;
import com.intellij.xdebugger.impl.ui.XDebugSessionTabNewUI;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XDebugSessionTab
extends DebuggerSessionTabBase {
    private static final Logger LOG = Logger.getInstance(XDebugSessionTab.class);
    public static final DataKey<XDebugSessionTab> TAB_KEY = DataKey.create((String)"XDebugSessionTab");
    protected XWatchesViewImpl myWatchesView;
    private boolean myWatchesInVariables;
    private final Map<String, XDebugView> myViews;
    @Nullable
    protected XDebugSessionProxy mySession;
    private XDebugSessionData mySessionData;
    private Consumer<DataSink> myAdditionalKeysProvider;

    @Deprecated
    @NotNull
    public static XDebugSessionTab create(@NotNull XDebugSessionImpl session, @Nullable Icon icon, @Nullable ExecutionEnvironment environment, @Nullable RunContentDescriptor contentToReuse) {
        if (session == null) {
            XDebugSessionTab.$$$reportNull$$$0(0);
        }
        XDebugSessionProxy proxy = MonolithSessionProxyKt.asProxy(session);
        boolean forceNewDebuggerUi = XDebugSessionTabCustomizerKt.forceShowNewDebuggerUi(session.getDebugProcess());
        boolean withFramesCustomization = XDebugSessionTabCustomizerKt.allowFramesViewCustomization(session.getDebugProcess());
        @Nullable String defaultFramesViewKey = XDebugSessionTabCustomizerKt.getDefaultFramesViewKey(session.getDebugProcess());
        return XDebugSessionTab.create(proxy, icon, (ExecutionEnvironmentProxy)(environment == null ? null : new BackendExecutionEnvironmentProxy(environment)), contentToReuse, forceNewDebuggerUi, withFramesCustomization, defaultFramesViewKey);
    }

    @ApiStatus.Internal
    @NotNull
    public static XDebugSessionTab create(@NotNull XDebugSessionProxy proxy, @Nullable Icon icon, @Nullable ExecutionEnvironmentProxy environmentProxy, @Nullable RunContentDescriptor contentToReuse, boolean forceNewDebuggerUi, boolean withFramesCustomization, @Nullable String defaultFramesViewKey) {
        XDebugSessionTab oldTab;
        JComponent component;
        if (proxy == null) {
            XDebugSessionTab.$$$reportNull$$$0(1);
        }
        if (contentToReuse != null && SystemProperties.getBooleanProperty((String)"xdebugger.reuse.session.tab", (boolean)false) && (component = contentToReuse.getComponent()) != null && (oldTab = (XDebugSessionTab)((Object)TAB_KEY.getData(DataManager.getInstance().getDataContext((Component)component)))) != null) {
            oldTab.setSession(proxy, environmentProxy, icon);
            oldTab.attachToSession(proxy);
            XDebugSessionTab xDebugSessionTab = oldTab;
            if (xDebugSessionTab == null) {
                XDebugSessionTab.$$$reportNull$$$0(2);
            }
            return xDebugSessionTab;
        }
        XDebugSessionTab tab = UIExperiment.isNewDebuggerUIEnabled() || forceNewDebuggerUi ? (withFramesCustomization ? new XDebugSessionTab3(proxy, icon, environmentProxy, defaultFramesViewKey) : new XDebugSessionTabNewUI(proxy, icon, environmentProxy)) : new XDebugSessionTab(proxy, icon, environmentProxy, true);
        tab.init(proxy);
        tab.myRunContentDescriptor.setActivateToolWindowWhenAdded(contentToReuse == null || contentToReuse.isActivateToolWindowWhenAdded());
        XDebugSessionTab xDebugSessionTab = tab;
        if (xDebugSessionTab == null) {
            XDebugSessionTab.$$$reportNull$$$0(3);
        }
        return xDebugSessionTab;
    }

    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = this.myUi;
        if (runnerLayoutUi == null) {
            XDebugSessionTab.$$$reportNull$$$0(4);
        }
        return runnerLayoutUi;
    }

    protected XDebugSessionTab(@NotNull XDebugSessionProxy session, @Nullable Icon icon, @Nullable ExecutionEnvironmentProxy environmentProxy, boolean shouldInitTabDefaults) {
        if (session == null) {
            XDebugSessionTab.$$$reportNull$$$0(5);
        }
        super(session.getProject(), "Debug", session.getSessionName(), GlobalSearchScope.allScope((Project)session.getProject()), shouldInitTabDefaults);
        this.myWatchesInVariables = Registry.is((String)"debugger.watches.in.variables");
        this.myViews = new LinkedHashMap<String, XDebugView>();
        this.setSession(session, environmentProxy, icon);
        this.myUi.getContentManager().addUiDataProvider(sink -> {
            sink.set(XWatchesView.DATA_KEY, (Object)this.myWatchesView);
            sink.set(TAB_KEY, (Object)this);
            sink.set(XDebugSessionData.DATA_KEY, (Object)this.mySessionData);
            if (this.myAdditionalKeysProvider != null) {
                this.myAdditionalKeysProvider.accept(sink);
            }
            if (this.mySession != null) {
                sink.set(XDebugSessionProxy.DEBUG_SESSION_PROXY_KEY, (Object)this.mySession);
                this.mySession.putKey(sink);
                sink.set(LangDataKeys.CONSOLE_VIEW, (Object)this.mySession.getConsoleView());
            }
        });
    }

    @ApiStatus.Internal
    public void setAdditionalKeysProvider(Consumer<DataSink> additionalKeysProvider) {
        LOG.assertTrue(this.myAdditionalKeysProvider == null, (Object)"Additional keys provider is already set");
        this.myAdditionalKeysProvider = additionalKeysProvider;
    }

    protected void init(XDebugSessionProxy session) {
        this.initDebuggerTab(session);
        this.initFocusingVariablesFromFramesView();
        this.attachToSession(session);
        DefaultActionGroup focus = new DefaultActionGroup();
        focus.add(ActionManager.getInstance().getAction("Debugger.FocusOnBreakpoint"));
        focus.add(ActionManager.getInstance().getAction("Debugger.FocusOnFinish"));
        this.myUi.getOptions().setAdditionalFocusActions((ActionGroup)focus).setMinimizeActionEnabled(true).setMoveToGridActionEnabled(true);
        this.initListeners(this.myUi);
        this.rebuildViews();
    }

    @Nullable
    protected <T> T getView(String viewId, Class<T> viewClass) {
        return (T)ObjectUtils.tryCast((Object)this.myViews.get(viewId), viewClass);
    }

    @ApiStatus.Internal
    @Nullable
    public XFramesView getFramesView() {
        return this.getView(this.getFramesContentId(), XFramesView.class);
    }

    @ApiStatus.Internal
    @Nullable
    public XVariablesViewBase getVariablesView() {
        return this.getView("VariablesContent", XVariablesViewBase.class);
    }

    @ApiStatus.Internal
    public void showTab() {
        RunContentDescriptor descriptor = this.getRunContentDescriptor();
        if (descriptor == null) {
            return;
        }
        RunContentManager.getInstance((Project)this.myProject).showRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
    }

    protected void initFocusingVariablesFromFramesView() {
        XFramesView framesView = this.getView("FrameContent", XFramesView.class);
        XVariablesViewBase variablesView = this.getVariablesView();
        if (framesView == null || variablesView == null) {
            return;
        }
        framesView.onFrameSelectionKeyPressed(frame -> {
            Content content = this.findOrRestoreContentIfNeeded("VariablesContent");
            if (content == null) {
                return;
            }
            this.getUi().selectAndFocus(content, true, true).doWhenDone(() -> variablesView.onReady().whenComplete((node, throwable) -> {
                if (node != null && node.getTree().isSelectionEmpty()) {
                    node.getTree().setSelectionRow(0);
                }
            }));
        });
    }

    protected void initDebuggerTab(XDebugSessionProxy session) {
        this.createDefaultTabs(session);
        CustomActionsListener.subscribe((Disposable)this, () -> this.initToolbars(session));
    }

    protected final void createDefaultTabs(XDebugSessionProxy session) {
        this.myUi.addContent(this.createFramesContent(session), 0, PlaceInGrid.left, false);
        if (Registry.is((String)"debugger.new.threads.view") || SplitDebuggerMode.isSplitDebugger()) {
            Content threadsContent = this.createThreadsContent(session);
            this.myUi.addContent(threadsContent, 0, PlaceInGrid.right, true);
        }
        this.addVariablesAndWatches(session);
    }

    protected void initListeners(RunnerLayoutUi ui) {
        ui.addListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Content content = event.getContent();
                if (XDebugSessionTab.this.mySession != null && content.isSelected() && XDebugSessionTab.this.getWatchesContentId().equals(ViewImpl.ID.get((UserDataHolder)content))) {
                    XDebugSessionTab.this.computeWatches();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/XDebugSessionTab$1", "selectionChanged"));
            }
        }, (Disposable)this.myRunContentDescriptor);
    }

    protected void addVariablesAndWatches(@NotNull XDebugSessionProxy session) {
        if (session == null) {
            XDebugSessionTab.$$$reportNull$$$0(6);
        }
        Content variablesContent = this.createVariablesContent(session);
        this.myUi.addContent(variablesContent, 0, PlaceInGrid.center, false);
        if (!this.myWatchesInVariables) {
            Content watchesContent = this.createWatchesContent(session, null);
            this.myUi.addContent(watchesContent, 0, PlaceInGrid.right, false);
        }
    }

    private void setSession(@NotNull XDebugSessionProxy session, @Nullable ExecutionEnvironmentProxy environmentProxy, @Nullable Icon icon) {
        if (session == null) {
            XDebugSessionTab.$$$reportNull$$$0(7);
        }
        this.myEnvironment = environmentProxy == null ? null : environmentProxy.getExecutionEnvironment();
        this.myEnvironmentProxy = environmentProxy;
        this.mySession = session;
        this.mySessionData = session.getSessionData();
        this.myConsole = session.getConsoleView();
        List restartActionsList = session.getRestartActions();
        AnAction[] restartActions = restartActionsList.isEmpty() ? AnAction.EMPTY_ARRAY : restartActionsList.toArray(AnAction.EMPTY_ARRAY);
        this.myRunContentDescriptor = new RunContentDescriptor(this.myConsole, session.getProcessHandler(), this.myUi.getComponent(), session.getSessionName(), icon, this::computeWatches, restartActions);
        if (!(session instanceof MonolithSessionProxy)) {
            this.myRunContentDescriptor.setId((RunContentDescriptorId)session.getRunContentDescriptorId());
        }
        if (this.myEnvironmentProxy != null) {
            String toolWindowId = this.myEnvironmentProxy.getContentDescriptorToolWindowId();
            if (toolWindowId != null) {
                this.myRunContentDescriptor.setContentToolWindowId(toolWindowId);
            }
            this.myRunContentDescriptor.setRunConfigurationName(this.myEnvironmentProxy.getRunProfileName());
            this.myRunContentDescriptor.setRunConfigurationTypeId(this.myEnvironmentProxy.getRunConfigurationTypeId());
        }
        this.myRunContentDescriptor.setRunnerLayoutUi(this.myUi);
        Disposer.register((Disposable)this.myRunContentDescriptor, (Disposable)this);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myRunContentDescriptor);
        XDebugSessionSelectionService.startCurrentSessionListening(this.myProject);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                this.updateActions();
            }

            public void sessionResumed() {
                this.updateActions();
            }

            public void sessionStopped() {
                this.updateActions();
                AppUIUtil.invokeOnEdt(() -> {
                    XDebugSessionTab.this.myUi.attractBy("finish");
                    if (!XDebugSessionTab.this.myProject.isDisposed()) {
                        XDebugSessionTab.this.myWatchesView.updateSessionData();
                    }
                    XDebugSessionTab.this.detachFromSession();
                });
                if (!XDebugSessionTab.this.myProject.isDisposed() && !ApplicationManager.getApplication().isUnitTestMode() && XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isHideDebuggerOnProcessTermination()) {
                    RunContentManager.getInstance((Project)XDebugSessionTab.this.myProject).hideRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), XDebugSessionTab.this.getRunContentDescriptor());
                }
            }

            public void stackFrameChanged() {
                this.updateActions();
            }

            public void beforeSessionResume() {
                UIUtil.invokeLaterIfNeeded(() -> XDebugSessionTab.this.getUi().clearAttractionBy("breakpoint"));
            }

            private void updateActions() {
                UIUtil.invokeLaterIfNeeded(() -> XDebugSessionTab.this.getUi().updateActionsNow());
            }
        }, (Disposable)this);
    }

    @NotNull
    private Content createVariablesContent(@NotNull XDebugSessionProxy proxy) {
        XVariablesView variablesView;
        if (proxy == null) {
            XDebugSessionTab.$$$reportNull$$$0(8);
        }
        if (this.myWatchesInVariables) {
            this.myWatchesView = new XWatchesViewImpl(proxy, this.myWatchesInVariables, false, false);
            variablesView = this.myWatchesView;
        } else {
            variablesView = new XVariablesView(proxy);
        }
        this.registerView("VariablesContent", variablesView);
        Content result2 = this.myUi.createContent("VariablesContent", variablesView.getPanel(), XDebuggerBundle.message((String)"debugger.session.tab.variables.title", (Object[])new Object[0]), null, variablesView.getDefaultFocusedComponent());
        result2.setCloseable(false);
        ActionGroup group = XDebugSessionTab.getCustomizedActionGroup("XDebugger.Variables.Tree.Toolbar");
        result2.setActions(group, "DebuggerToolbar", (JComponent)((Object)variablesView.getTree()));
        Content content = result2;
        if (content == null) {
            XDebugSessionTab.$$$reportNull$$$0(9);
        }
        return content;
    }

    @ApiStatus.Internal
    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    @NotNull
    protected Content createWatchesContent(@NotNull XDebugSessionProxy proxy, @Nullable XWatchesViewImpl watchesView) {
        if (proxy == null) {
            XDebugSessionTab.$$$reportNull$$$0(10);
        }
        this.myWatchesView = watchesView != null ? watchesView : new XWatchesViewImpl(proxy, this.myWatchesInVariables);
        this.registerView("WatchesContent", this.myWatchesView);
        Content watchesContent = this.myUi.createContent("WatchesContent", this.myWatchesView.getPanel(), XDebuggerBundle.message((String)"debugger.session.tab.watches.title", (Object[])new Object[0]), null, this.myWatchesView.getDefaultFocusedComponent());
        watchesContent.setCloseable(false);
        Content content = watchesContent;
        if (content == null) {
            XDebugSessionTab.$$$reportNull$$$0(11);
        }
        return content;
    }

    @NotNull
    private Content createFramesContent(XDebugSessionProxy proxy) {
        XFramesView framesView = new XFramesView(proxy);
        this.registerView("FrameContent", framesView);
        Content framesContent = this.myUi.createContent("FrameContent", (JComponent)framesView.getMainPanel(), XDebuggerBundle.message((String)"debugger.session.tab.frames.title", (Object[])new Object[0]), null, (JComponent)((Object)framesView.getFramesList()));
        framesContent.setCloseable(false);
        Content content = framesContent;
        if (content == null) {
            XDebugSessionTab.$$$reportNull$$$0(12);
        }
        return content;
    }

    @NotNull
    private Content createThreadsContent(XDebugSessionProxy proxy) {
        XThreadsView threadsView = new XThreadsView(this.myProject, proxy);
        this.registerView("ThreadsContent", threadsView);
        Content threadsContent = this.myUi.createContent("ThreadsContent", (JComponent)threadsView.getPanel(), XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), null, (JComponent)((Object)threadsView.getDefaultFocusedComponent()));
        threadsContent.setCloseable(false);
        Content content = threadsContent;
        if (content == null) {
            XDebugSessionTab.$$$reportNull$$$0(13);
        }
        return content;
    }

    public void rebuildViews() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> {
            if (this.mySession != null) {
                this.mySession.rebuildViews();
            }
        });
    }

    public XWatchesView getWatchesView() {
        return this.myWatchesView;
    }

    private void attachToSession(@NotNull XDebugSessionProxy session) {
        if (session == null) {
            XDebugSessionTab.$$$reportNull$$$0(14);
        }
        for (XDebugView view : this.myViews.values()) {
            XDebugSessionTab.attachViewToSession(session, view);
        }
        XDebugTabLayouter layouter = session.createTabLayouter();
        if (this.myConsole != null) {
            Content consoleContent = layouter.registerConsoleContent(this.myUi, this.myConsole);
            this.attachNotificationTo(consoleContent);
            layouter.registerAdditionalContent(this.myUi);
            DefaultActionGroup consoleActions = new DefaultActionGroup();
            for (AnAction action : session.getConsoleActions()) {
                consoleActions.add(action);
            }
            consoleContent.setActions((ActionGroup)consoleActions, "RunnerToolbar", this.myConsole.getComponent());
            consoleContent.setHelpId(DefaultDebugExecutor.getDebugExecutorInstance().getHelpId());
        } else {
            layouter.registerAdditionalContent(this.myUi);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.initToolbars(session);
        if (this.myEnvironment != null && this.myConsole != null) {
            this.initLogConsoles(this.myEnvironment.getRunProfile(), this.myRunContentDescriptor, this.myConsole);
        }
    }

    protected void initToolbars(@NotNull XDebugSessionProxy session) {
        if (session == null) {
            XDebugSessionTab.$$$reportNull$$$0(15);
        }
        ActionGroup leftGroup = XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.LeftToolbar");
        DefaultActionGroupWithDelegate leftToolbar = new DefaultActionGroupWithDelegate(leftGroup);
        if (this.myEnvironment != null) {
            leftToolbar.add(ActionManager.getInstance().getAction("Rerun"));
            leftToolbar.addAll((Collection)session.getRestartActions());
            leftToolbar.add((AnAction)new CreateAction(AllIcons.General.Settings));
            leftToolbar.addSeparator();
            leftToolbar.addAll((Collection)session.getExtraActions());
        }
        RunContentBuilder.addAvoidingDuplicates((DefaultActionGroup)leftToolbar, (ActionGroup)leftGroup);
        for (AnAction action : session.getExtraStopActions()) {
            leftToolbar.add(action, new Constraints(Anchor.AFTER, "Stop"));
        }
        leftToolbar.addSeparator();
        leftToolbar.add(this.myUi.getOptions().getLayoutActions());
        AnAction[] commonSettings = this.myUi.getOptions().getSettingsActionsList();
        DefaultActionGroup settings = DefaultActionGroup.createPopupGroup(XDebuggerImplBundle.lazyMessage("group.XDebugger.settings.text", new Object[0]));
        settings.getTemplatePresentation().setIcon(this.myUi.getOptions().getSettingsActions().getTemplatePresentation().getIcon());
        settings.addAll(commonSettings);
        leftToolbar.add((AnAction)settings);
        leftToolbar.addSeparator();
        leftToolbar.add(PinToolwindowTabAction.getPinAction());
        ActionGroup topGroup = XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.TopToolbar");
        DefaultActionGroupWithDelegate topLeftToolbar = new DefaultActionGroupWithDelegate(topGroup);
        RunContentBuilder.addAvoidingDuplicates((DefaultActionGroup)topLeftToolbar, (ActionGroup)topGroup);
        this.registerAdditionalActions((DefaultActionGroup)leftToolbar, (DefaultActionGroup)topLeftToolbar, settings);
        this.myUi.getOptions().setLeftToolbar((ActionGroup)leftToolbar, "DebuggerToolbar");
        this.myUi.getOptions().setTopLeftToolbar((ActionGroup)topLeftToolbar, "DebuggerToolbar");
    }

    protected void registerAdditionalActions(DefaultActionGroup leftToolbar, DefaultActionGroup topLeftToolbar, DefaultActionGroup settings) {
        if (this.mySession != null) {
            this.mySession.registerAdditionalActions(leftToolbar, topLeftToolbar, settings);
        }
    }

    protected static void attachViewToSession(@NotNull XDebugSessionProxy session, @Nullable XDebugView view) {
        if (session == null) {
            XDebugSessionTab.$$$reportNull$$$0(16);
        }
        if (view != null) {
            XDebugViewSessionListener.attach(view, session);
        }
    }

    private void detachFromSession() {
        assert (this.mySession != null);
        this.mySession = null;
    }

    @Nullable
    public RunContentDescriptor getRunContentDescriptor() {
        return this.myRunContentDescriptor;
    }

    public boolean isWatchesInVariables() {
        return this.myWatchesInVariables;
    }

    public void setWatchesInVariables(boolean watchesInVariables) {
        if (this.myWatchesInVariables != watchesInVariables) {
            this.myWatchesInVariables = watchesInVariables;
            Registry.get((String)"debugger.watches.in.variables").setValue(watchesInVariables);
            if (this.mySession != null) {
                this.setWatchesInVariablesImpl();
            }
        }
    }

    protected void setWatchesInVariablesImpl() {
        if (this.mySession == null) {
            return;
        }
        this.removeContent("VariablesContent");
        this.removeContent("WatchesContent");
        this.addVariablesAndWatches(this.mySession);
        XDebugSessionTab.attachViewToSession(this.mySession, this.myViews.get("VariablesContent"));
        XDebugSessionTab.attachViewToSession(this.mySession, this.myViews.get("WatchesContent"));
        this.myUi.selectAndFocus(this.myUi.findContent("VariablesContent"), true, false);
        this.rebuildViews();
    }

    @Deprecated
    public static void showWatchesView(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            XDebugSessionTab.$$$reportNull$$$0(17);
        }
        XDebugSessionTab.showWatchesView(MonolithSessionProxyKt.asProxy(session));
    }

    public static void showWatchesView(@NotNull XDebugSessionProxy session) {
        XDebugSessionTab tab;
        if (session == null) {
            XDebugSessionTab.$$$reportNull$$$0(18);
        }
        if ((tab = (XDebugSessionTab)session.getSessionTab()) == null) {
            return;
        }
        tab.showView(tab.getWatchesContentId());
    }

    @Deprecated
    public static void showFramesView(@Nullable XDebugSessionImpl session) {
        if (session == null) {
            return;
        }
        XDebugSessionTab.showFramesView(MonolithSessionProxyKt.asProxy(session));
    }

    @ApiStatus.Internal
    public static void showFramesView(@Nullable XDebugSessionProxy session) {
        if (session == null) {
            return;
        }
        XDebugSessionTab tab = (XDebugSessionTab)session.getSessionTab();
        if (tab == null) {
            return;
        }
        tab.showView(tab.getFramesContentId());
    }

    void showView(String viewId) {
        this.toFront(false, null);
        Content content = this.findOrRestoreContentIfNeeded(viewId);
        if (content != null) {
            this.myUi.selectAndFocus(content, false, false);
        }
    }

    public void toFront(boolean focus, @Nullable Runnable onShowCallback) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            RunContentManager manager;
            ToolWindow toolWindow;
            if (this.myRunContentDescriptor != null && (toolWindow = (manager = RunContentManager.getInstance((Project)this.myProject)).getToolWindowByDescriptor(this.myRunContentDescriptor)) != null) {
                if (!toolWindow.isVisible()) {
                    toolWindow.show(() -> {
                        if (onShowCallback != null) {
                            onShowCallback.run();
                        }
                        this.computeWatches();
                    });
                }
                manager.selectRunContent(this.myRunContentDescriptor);
            }
        });
        if (focus) {
            ApplicationManager.getApplication().invokeLater(() -> {
                boolean stealFocus = Registry.is((String)"debugger.mayBringFrameToFrontOnBreakpoint");
                ProjectUtil.focusProjectWindow((Project)this.myProject, (boolean)stealFocus);
            });
        }
    }

    protected void computeWatches() {
        if (this.myWatchesView != null) {
            this.myWatchesView.computeWatches();
        }
    }

    @NotNull
    protected String getWatchesContentId() {
        return this.myWatchesInVariables ? "VariablesContent" : "WatchesContent";
    }

    @NotNull
    protected String getFramesContentId() {
        return "FrameContent";
    }

    protected void registerView(String contentId, @NotNull XDebugView view) {
        if (view == null) {
            XDebugSessionTab.$$$reportNull$$$0(19);
        }
        this.myViews.put(contentId, view);
        Disposer.register((Disposable)this.myRunContentDescriptor, (Disposable)view);
    }

    private void removeContent(String contentId) {
        this.myUi.removeContent(this.findOrRestoreContentIfNeeded(contentId), true);
        this.unregisterView(contentId);
    }

    protected void unregisterView(String contentId) {
        XDebugView view = this.myViews.remove(contentId);
        if (view != null) {
            Disposer.dispose((Disposable)view);
        }
    }

    @Nullable
    public Content findOrRestoreContentIfNeeded(@NotNull String contentId) {
        RunnerContentUi contentUi;
        RunnerLayoutUi runnerLayoutUi;
        if (contentId == null) {
            XDebugSessionTab.$$$reportNull$$$0(20);
        }
        if ((runnerLayoutUi = this.myUi) instanceof RunnerLayoutUiImpl) {
            RunnerLayoutUiImpl o = (RunnerLayoutUiImpl)runnerLayoutUi;
            v0 = o.getContentUI();
        } else {
            v0 = contentUi = null;
        }
        if (contentUi != null) {
            return contentUi.findOrRestoreContentIfNeeded(contentId);
        }
        return this.myUi.findContent(contentId);
    }

    @ApiStatus.Internal
    public void onPause(boolean pausedByUser, boolean topFramePositionAbsent) {
        if (!pausedByUser) {
            return;
        }
        if (XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isShowDebuggerOnBreakpoint()) {
            this.toFront(true, null);
        }
        if (topFramePositionAbsent) {
            this.showView(this.getFramesContentId());
        }
        this.getUi().attractBy("breakpoint");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/XDebugSessionTab";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/XDebugSessionTab";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariablesContent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createWatchesContent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createFramesContent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createThreadsContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addVariablesAndWatches";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createVariablesContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createWatchesContent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "attachToSession";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initToolbars";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "attachViewToSession";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showWatchesView";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerView";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findOrRestoreContentIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

