/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.AbstractToggleUseSoftWrapsAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ErrorStripeEditorCustomization;
import com.intellij.ui.Expandable;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class XDebuggerEditorBase
implements Expandable {
    public static final Key<Boolean> XDEBUGGER_EDITOR_KEY = Key.create((String)"is.xdebugger.editor");
    private final Project myProject;
    private final XDebuggerEditorsProvider myDebuggerEditorsProvider;
    @NotNull
    private final EvaluationMode myMode;
    @Nullable
    private final String myHistoryId;
    @Nullable
    private XSourcePosition mySourcePosition;
    private int myHistoryIndex;
    @Nullable
    private PsiElement myContext;
    private final LanguageChooser myLanguageChooser;
    private final JLabel myExpandButton;
    private JBPopup myExpandedPopup;
    private Runnable myExpandHandler;
    private static final String SOFT_WRAPS_KEY = "XDebuggerExpressionEditor_Use_Soft_Wraps";

    protected XDebuggerEditorBase(Project project, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @NotNull EvaluationMode mode, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition) {
        if (debuggerEditorsProvider == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(0);
        }
        if (mode == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(1);
        }
        this(project, debuggerEditorsProvider, mode, historyId, sourcePosition, null);
    }

    XDebuggerEditorBase(Project project, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @NotNull EvaluationMode mode, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, @Nullable PsiElement psiContext) {
        if (debuggerEditorsProvider == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(3);
        }
        this.myHistoryIndex = -1;
        this.myLanguageChooser = new LanguageChooser();
        this.myExpandButton = new JLabel(AllIcons.General.ExpandComponent);
        this.myProject = project;
        this.myDebuggerEditorsProvider = debuggerEditorsProvider;
        this.myMode = mode;
        this.myHistoryId = historyId;
        this.mySourcePosition = sourcePosition;
        this.myContext = psiContext;
        this.myExpandButton.setToolTipText(KeymapUtil.createTooltipText((String)IdeBundle.message((String)"action.expand", (Object[])new Object[0]), (String)"ExpandExpandableComponent"));
        this.myExpandButton.setCursor(Cursor.getPredefinedCursor(12));
        this.myExpandButton.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        this.myExpandButton.setDisabledIcon(AllIcons.General.ExpandComponent);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                XDebuggerEditorBase.this.expand();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$1", "onClick"));
            }
        }.installOn((Component)this.myExpandButton);
        this.myExpandButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                XDebuggerEditorBase.this.myExpandButton.setIcon(AllIcons.General.ExpandComponentHover);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                XDebuggerEditorBase.this.myExpandButton.setIcon(AllIcons.General.ExpandComponent);
            }
        });
    }

    private CompletableFuture<@NotNull @Unmodifiable Collection<Language>> getSupportedLanguages() {
        XDebuggerEditorsProvider editorsProvider = this.getEditorsProvider();
        if (this.myContext != null && editorsProvider instanceof XDebuggerEditorsProviderBase) {
            XDebuggerEditorsProviderBase base = (XDebuggerEditorsProviderBase)editorsProvider;
            return CompletableFuture.completedFuture(base.getSupportedLanguages(this.myContext));
        }
        return editorsProvider.getSupportedLanguagesAsync(this.myProject, this.mySourcePosition);
    }

    protected JComponent decorate(JComponent component, boolean multiline, boolean showEditor) {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel();
        BorderLayoutPanel factoryPanel = JBUI.Panels.simplePanel();
        factoryPanel.add((Component)this.myLanguageChooser, multiline ? "North" : "Center");
        panel2.add((Component)factoryPanel, (Object)"West");
        if (!multiline && showEditor) {
            component = this.addExpand(component, false);
        }
        panel2.addToCenter((Component)component);
        if (multiline) {
            JBLabel adLabel = new JBLabel(XDebuggerEditorBase.getAdText(), 4);
            adLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            adLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
            panel2.addToBottom((Component)adLabel);
        }
        return panel2;
    }

    protected JComponent addChooser(JComponent component) {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)component);
        panel2.setBackground((Color)JBColor.lazy(() -> Objects.requireNonNullElse(component.getBackground(), UIUtil.getPanelBackground())));
        panel2.addToRight((Component)this.myLanguageChooser);
        return panel2;
    }

    protected JComponent addExpand(final JComponent component, boolean inheritBackground) {
        BorderLayoutPanel panel2;
        if (inheritBackground) {
            panel2 = new BorderLayoutPanel(){

                public Color getBackground() {
                    return component.getBackground();
                }
            };
        } else {
            panel2 = JBUI.Panels.simplePanel();
            panel2.setOpaque(false);
        }
        panel2.addToCenter((Component)component);
        panel2.addToRight((Component)this.myExpandButton);
        return panel2;
    }

    public JComponent getLanguageChooser() {
        return this.myLanguageChooser;
    }

    public void setContext(@Nullable PsiElement context) {
        if (this.myContext != context) {
            this.myContext = context;
            this.setExpression(this.getExpression());
        }
    }

    public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
        if (this.mySourcePosition != sourcePosition) {
            this.mySourcePosition = sourcePosition;
            XExpression expression = this.getExpression();
            if (XDebuggerUtilImpl.isEmptyExpression(expression) && expression.getLanguage() != null) {
                expression = XExpressionImpl.changeLanguage(expression, null);
            }
            this.setExpression(expression);
        }
    }

    @NotNull
    public EvaluationMode getMode() {
        EvaluationMode evaluationMode = this.myMode;
        if (evaluationMode == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(4);
        }
        return evaluationMode;
    }

    @Nullable
    public abstract Editor getEditor();

    public abstract JComponent getComponent();

    public JComponent getEditorComponent() {
        return this.getComponent();
    }

    protected abstract void doSetText(XExpression var1);

    public void setExpression(@Nullable XExpression text) {
        Language language;
        if (text == null) {
            XExpression xExpression = text = this.getMode() == EvaluationMode.EXPRESSION ? XExpressionImpl.EMPTY_EXPRESSION : XExpressionImpl.EMPTY_CODE_FRAGMENT;
        }
        if ((language = text.getLanguage()) == null) {
            if (this.myContext != null) {
                language = this.myContext.getLanguage();
            }
            if (language == null && this.mySourcePosition != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)this.mySourcePosition.getFile());
            }
            if (language == null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)this.getEditorsProvider().getFileType());
            }
            text = new XExpressionImpl(text.getExpression(), language, text.getCustomInfo(), text.getMode());
        }
        this.myLanguageChooser.requestUpdate(language);
        this.doSetText(text);
    }

    public void setEnabled(boolean enable) {
        this.myLanguageChooser.setEnabled(enable);
    }

    public abstract XExpression getExpression();

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    public void requestFocusInEditor() {
        JComponent preferredFocusedComponent = this.getPreferredFocusedComponent();
        if (preferredFocusedComponent != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)preferredFocusedComponent, true);
        }
    }

    public abstract void selectAll();

    protected void onHistoryChanged() {
    }

    public List<XExpression> getRecentExpressions() {
        if (this.myHistoryId != null) {
            return XDebuggerHistoryManager.getInstance(this.myProject).getRecentExpressions(this.myHistoryId);
        }
        return Collections.emptyList();
    }

    public void saveTextInHistory() {
        this.saveTextInHistory(this.getExpression());
    }

    private void saveTextInHistory(XExpression text) {
        if (this.myHistoryId != null) {
            boolean update = XDebuggerHistoryManager.getInstance(this.myProject).addRecentExpression(this.myHistoryId, text);
            this.myHistoryIndex = -1;
            if (update) {
                this.onHistoryChanged();
            }
        }
    }

    @NotNull
    protected FileType getFileType(@NotNull XExpression expression) {
        FileType fileType;
        if (expression == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(5);
        }
        if ((fileType = LanguageUtil.getLanguageFileType((Language)expression.getLanguage())) != null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                XDebuggerEditorBase.$$$reportNull$$$0(6);
            }
            return fileType2;
        }
        FileType fileType3 = this.getEditorsProvider().getFileType();
        if (fileType3 == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(7);
        }
        return fileType3;
    }

    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myDebuggerEditorsProvider;
    }

    public final Project getProject() {
        return this.myProject;
    }

    protected Document createDocument(XExpression text) {
        if (this.myProject.isDefault()) {
            return new DocumentImpl(text.getExpression());
        }
        XDebuggerEditorsProvider provider = this.getEditorsProvider();
        if (this.myContext != null && provider instanceof XDebuggerEditorsProviderBase) {
            return ((XDebuggerEditorsProviderBase)provider).createDocument(this.myProject, text, this.myContext, this.myMode);
        }
        return provider.createDocument(this.myProject, text, this.mySourcePosition, this.myMode);
    }

    public boolean canGoBackward() {
        return this.myHistoryIndex < this.getRecentExpressions().size() - 1;
    }

    public boolean canGoForward() {
        return this.myHistoryIndex > 0;
    }

    public void goBackward() {
        List<XExpression> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex < expressions.size() - 1) {
            ++this.myHistoryIndex;
            this.setExpression(expressions.get(this.myHistoryIndex));
        }
    }

    public void goForward() {
        List<XExpression> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex > 0) {
            --this.myHistoryIndex;
            this.setExpression(expressions.get(this.myHistoryIndex));
        }
    }

    public static void foldNewLines(EditorEx editor) {
        WriteIntentReadAction.run(() -> {
            editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
            editor.reinitSettings();
            FoldingModelEx foldingModel = editor.getFoldingModel();
            CharSequence text = editor.getDocument().getCharsSequence();
            foldingModel.runBatchFoldingOperation(() -> {
                int start2;
                foldingModel.clearFoldRegions();
                for (start2 = 0; start2 < text.length() && Character.isWhitespace(text.charAt(start2)); ++start2) {
                }
                if (start2 > 0) {
                    foldingModel.createFoldRegion(0, start2, "", null, true);
                }
                for (int i = start2; i < text.length(); ++i) {
                    int j;
                    if (text.charAt(i) != '\n') continue;
                    for (j = i + 1; j < text.length() && Character.isWhitespace(text.charAt(j)); ++j) {
                    }
                    foldingModel.createFoldRegion(i, j, "\u23ce", null, true);
                }
            });
        });
    }

    protected void prepareEditor(EditorEx editor) {
        editor.putUserData(EditorImpl.DISABLE_REMOVE_ON_DROP, (Object)Boolean.TRUE);
        editor.putUserData(XDEBUGGER_EDITOR_KEY, (Object)Boolean.TRUE);
    }

    protected final void setExpandable(Editor editor) {
        editor.getContentComponent().putClientProperty(Expandable.class, this);
    }

    public void expand() {
        if (this.myExpandedPopup != null || !this.getComponent().isEnabled()) {
            return;
        }
        if (this.myExpandHandler != null) {
            this.myExpandHandler.run();
            return;
        }
        XDebuggerExpressionEditor expressionEditor = new XDebuggerExpressionEditor(this, this.myProject, this.myDebuggerEditorsProvider, this.myHistoryId, this.mySourcePosition, this.getExpression(), true, true, false, this.myContext){

            @Override
            protected JComponent decorate(JComponent component, boolean multiline, boolean showEditor) {
                return component;
            }
        };
        EditorTextField editorTextField = (EditorTextField)expressionEditor.getEditorComponent();
        editorTextField.addSettingsProvider(this::prepareEditor);
        editorTextField.addSettingsProvider(this::setExpandable);
        editorTextField.setFont(editorTextField.getFont().deriveFont((float)this.getEditor().getColorsScheme().getEditorFontSize()));
        JComponent component = expressionEditor.getComponent();
        component.setPreferredSize(new Dimension(0, 100));
        this.myExpandedPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(component, expressionEditor.getPreferredFocusedComponent()).setMayBeParent(true).setFocusable(true).setResizable(true).setRequestFocus(true).setLocateByContent(true).setStretchToOwnerWidth(true).setCancelOnWindowDeactivation(false).setAdText(XDebuggerEditorBase.getAdText()).setKeyboardActions(Collections.singletonList(Pair.create(event -> {
            this.collapse();
            Window window = ComponentUtil.getWindow((Component)this.getComponent());
            if (window != null) {
                window.dispatchEvent(new KeyEvent(this.getComponent(), 401, System.currentTimeMillis(), 2, 10, '\r'));
            }
        }, (Object)KeyStroke.getKeyStroke(10, 2)))).setCancelCallback(() -> (Boolean)WriteIntentReadAction.compute(() -> {
            this.setExpression(expressionEditor.getExpression());
            this.requestFocusInEditor();
            Editor baseEditor = this.getEditor();
            if (baseEditor != null) {
                XDebuggerEditorBase.foldNewLines((EditorEx)baseEditor);
                Editor newEditor = expressionEditor.getEditor();
                if (newEditor != null) {
                    XDebuggerEditorBase.copyCaretPosition(newEditor, baseEditor);
                    PropertiesComponent.getInstance().setValue(SOFT_WRAPS_KEY, newEditor.getSoftWrapModel().isSoftWrappingEnabled());
                }
            }
            this.myExpandedPopup = null;
            return true;
        })).createPopup();
        this.myExpandedPopup.show(new RelativePoint((Component)this.getComponent(), new Point(0, 0)));
        EditorEx editor = (EditorEx)expressionEditor.getEditor();
        XDebuggerEditorBase.copyCaretPosition(this.getEditor(), (Editor)editor);
        editor.getSettings().setUseSoftWraps(this.isUseSoftWraps());
        XDebuggerEditorBase.addCollapseButton(editor, this::collapse);
        expressionEditor.requestFocusInEditor();
    }

    public void setExpandHandler(Runnable handler) {
        this.myExpandHandler = handler;
    }

    public void addCollapseButton(final Runnable handler) {
        JComponent component = this.getEditorComponent();
        if (component instanceof EditorTextField) {
            ((EditorTextField)component).addSettingsProvider(editor -> {
                editor.getContentComponent().putClientProperty(Expandable.class, new Expandable(){

                    public void expand() {
                    }

                    public void collapse() {
                        handler.run();
                    }

                    public boolean isExpanded() {
                        return true;
                    }
                });
                XDebuggerEditorBase.addCollapseButton(editor, handler);
            });
        }
    }

    private static void addCollapseButton(EditorEx editor, final Runnable handler) {
        ErrorStripeEditorCustomization.DISABLED.customize(editor);
        JScrollPane pane = editor.getScrollPane();
        pane.setVerticalScrollBarPolicy(22);
        pane.getVerticalScrollBar().add("JB_SCROLL_BAR_LEADING_COMPONENT", new JLabel(AllIcons.General.CollapseComponent){
            {
                super(arg0);
                this.setToolTipText(KeymapUtil.createTooltipText((String)IdeBundle.message((String)"action.collapse", (Object[])new Object[0]), (String)"CollapseExpandableComponent"));
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent event) {
                        this.setIcon(AllIcons.General.CollapseComponentHover);
                    }

                    @Override
                    public void mouseExited(MouseEvent event) {
                        this.setIcon(AllIcons.General.CollapseComponent);
                    }

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        handler.run();
                    }
                });
            }
        });
    }

    @NlsContexts.Label
    @NotNull
    private static String getAdText() {
        String string = XDebuggerBundle.message((String)"xdebugger.evaluate.history.navigate.ad", (Object[])new Object[]{NlsMessages.formatAndList(Arrays.asList(KeymapUtil.getKeystrokeText((KeyStroke)KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.MOVE_DOWN)), KeymapUtil.getKeystrokeText((KeyStroke)KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.MOVE_UP))))});
        if (string == null) {
            XDebuggerEditorBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void copyCaretPosition(@Nullable Editor source, @Nullable Editor destination) {
        if (source != null && destination != null) {
            destination.getCaretModel().moveToOffset(source.getCaretModel().getOffset());
        }
    }

    public void collapse() {
        if (this.myExpandedPopup != null) {
            this.myExpandedPopup.cancel();
        }
    }

    public boolean isExpanded() {
        return this.myExpandedPopup != null;
    }

    public boolean isUseSoftWraps() {
        return PropertiesComponent.getInstance().getBoolean(SOFT_WRAPS_KEY, true);
    }

    public void setUseSoftWraps(boolean use) {
        PropertiesComponent.getInstance().setValue(SOFT_WRAPS_KEY, use);
        Editor editor = this.getEditor();
        if (editor != null) {
            AbstractToggleUseSoftWrapsAction.toggleSoftWraps((Editor)editor, null, (boolean)use);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerEditorsProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private class LanguageChooser
    extends JLabel {
        static final Color ENABLED_COLOR = new Color(0x787878);
        static final Color DISABLED_COLOR = new JBColor(0xB2B2B2, 6053215);
        private Collection<Language> myLanguages = Collections.emptyList();
        private WeakReference<ListPopup> myPopup;

        LanguageChooser() {
            this.setHorizontalTextPosition(2);
            this.setIconTextGap(0);
            this.setToolTipText(XDebuggerBundle.message((String)"xdebugger.evaluate.language.hint", (Object[])new Object[0]));
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setBorder((Border)JBUI.Borders.emptyRight((int)2));
            Icon dropdownIcon = AllIcons.General.Dropdown;
            int width = dropdownIcon.getIconWidth();
            dropdownIcon = IconUtil.cropIcon((Icon)dropdownIcon, (Rectangle)new Rectangle(width / 2, 0, width - width / 2, dropdownIcon.getIconHeight()));
            LayeredIcon icon = (LayeredIcon)JBUIScale.scaleIcon((JBScalableIcon)new LayeredIcon(1));
            icon.setIcon(dropdownIcon, 0, 0, -5);
            this.setIcon((Icon)icon);
            this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (LanguageChooser.this.isEnabled()) {
                        ListPopup oldPopup = (ListPopup)SoftReference.dereference(LanguageChooser.this.myPopup);
                        if (oldPopup != null && !oldPopup.isDisposed()) {
                            oldPopup.cancel();
                            LanguageChooser.this.myPopup = null;
                            return true;
                        }
                        ListPopup popup2 = LanguageChooser.this.createLanguagePopup();
                        popup2.showUnderneathOf((Component)LanguageChooser.this);
                        LanguageChooser.this.myPopup = new WeakReference<ListPopup>(popup2);
                        return true;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$LanguageChooser$1", "onClick"));
                }
            }.installOn((Component)this);
        }

        @Override
        public Color getForeground() {
            return this.isEnabled() ? ENABLED_COLOR : DISABLED_COLOR;
        }

        ListPopup createLanguagePopup() {
            DefaultActionGroup actions = new DefaultActionGroup();
            for (final Language language : this.myLanguages) {
                actions.add(new AnAction(language.getDisplayName(), null, language.getAssociatedFileType().getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        XDebuggerEditorBase.this.setExpression(XExpressionImpl.changeLanguage(XDebuggerEditorBase.this.getExpression(), language));
                        XDebuggerEditorBase.this.requestFocusInEditor();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$LanguageChooser$2", "actionPerformed"));
                    }
                });
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)XDebuggerEditorBase.this.getComponent());
            return JBPopupFactory.getInstance().createActionGroupPopup(XDebuggerBundle.message((String)"debugger.editor.choose.language", (Object[])new Object[0]), (ActionGroup)actions, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        }

        void requestUpdate(Language currentLanguage) {
            ReadAction.nonBlocking(() -> XDebuggerEditorBase.this.getSupportedLanguages()).inSmartMode(XDebuggerEditorBase.this.myProject).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService()).onSuccess(future -> future.thenAccept(languages -> ApplicationManager.getApplication().invokeLater(() -> {
                boolean many = languages.size() > 1;
                this.myLanguages = languages;
                if (currentLanguage != null) {
                    this.setVisible(many);
                }
                this.setVisible(this.isVisible() || many);
                if (currentLanguage != null && currentLanguage.getAssociatedFileType() != null) {
                    this.setText(currentLanguage.getDisplayName());
                }
            }, ModalityState.any())));
        }
    }
}

