/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.attach.dialog;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachToProcessDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a'\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\"\u0010\f\u001a\u00020\u00012\b\b\u0001\u0010\r\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a:\u0010\u000e\u001a\u00020\u00012\b\b\u0001\u0010\r\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0003\u00a8\u0006\u0012"}, d2={"getProcessName", "", "Lcom/intellij/openapi/util/NlsSafe;", "textToTruncate", "fontMetrics", "Ljava/awt/FontMetrics;", "maxWidth", "", "getComponentFont", "Ljava/awt/Font;", "component", "Ljavax/swing/JComponent;", "truncateDescription", "initDescription", "findBestTruncateLength", "minTextBound", "maxEndBound", "ellipsisWidth", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nAttachDialogUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachDialogUtils.kt\ncom/intellij/xdebugger/impl/ui/attach/dialog/AttachDialogUtilsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,51:1\n13#2:52\n*S KotlinDebug\n*F\n+ 1 AttachDialogUtils.kt\ncom/intellij/xdebugger/impl/ui/attach/dialog/AttachDialogUtilsKt\n*L\n21#1:52\n*E\n"})
public final class AttachDialogUtilsKt {
    @NotNull
    public static final String getProcessName(@NlsSafe @NotNull String textToTruncate, @NotNull FontMetrics fontMetrics, int maxWidth) {
        Intrinsics.checkNotNullParameter((Object)textToTruncate, (String)"textToTruncate");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        if (((CharSequence)textToTruncate).length() == 0) {
            return "";
        }
        try {
            if (maxWidth > 0 && fontMetrics.stringWidth(textToTruncate) > maxWidth) {
                return AttachDialogUtilsKt.truncateDescription(textToTruncate, fontMetrics, maxWidth);
            }
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AttachToProcessDialog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
        return textToTruncate;
    }

    @NotNull
    public static final Font getComponentFont(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Font font = component.getFont();
        if (font == null) {
            font = StartupUiUtil.getLabelFont();
        }
        return font;
    }

    @ApiStatus.Internal
    @NlsSafe
    @NotNull
    public static final String truncateDescription(@NlsSafe @NotNull String initDescription, @NotNull FontMetrics fontMetrics, int maxWidth) {
        Intrinsics.checkNotNullParameter((Object)initDescription, (String)"initDescription");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        if (fontMetrics.stringWidth(initDescription) <= maxWidth) {
            return initDescription;
        }
        int ellipsisWidth = fontMetrics.charWidth('\u2026');
        return AttachDialogUtilsKt.findBestTruncateLength(initDescription, fontMetrics, maxWidth, 0, initDescription.length() - 1, ellipsisWidth) + "\u2026";
    }

    @NlsSafe
    private static final String findBestTruncateLength(@NlsSafe String initDescription, FontMetrics fontMetrics, int maxWidth, int minTextBound, int maxEndBound, int ellipsisWidth) {
        if (minTextBound >= maxEndBound) {
            String truncatedDescription = StringsKt.take((String)initDescription, (int)(minTextBound + 1));
            if (fontMetrics.stringWidth(truncatedDescription) + ellipsisWidth > maxWidth) {
                return StringsKt.take((String)initDescription, (int)minTextBound);
            }
            return truncatedDescription;
        }
        int middle = (minTextBound + maxEndBound) / 2;
        if (fontMetrics.stringWidth(StringsKt.take((String)initDescription, (int)(middle + 1))) + ellipsisWidth > maxWidth) {
            return AttachDialogUtilsKt.findBestTruncateLength(initDescription, fontMetrics, maxWidth, minTextBound, middle - 1, ellipsisWidth);
        }
        return AttachDialogUtilsKt.findBestTruncateLength(initDescription, fontMetrics, maxWidth, middle + 1, maxEndBound, ellipsisWidth);
    }
}

