/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.platform.debugger.impl.shared.SplitDebuggerAction;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XInspectDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.util.XDebugMonolithUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowReferringObjectsAction
extends XDebuggerTreeActionBase
implements SplitDebuggerAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowReferringObjectsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowReferringObjectsAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        presentation.setVisible(presentation.isEnabled());
    }

    @Override
    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (node == null) {
            ShowReferringObjectsAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ShowReferringObjectsAction.$$$reportNull$$$0(3);
        }
        return ((XValue)node.getValueContainer()).getReferrersProvider() != null;
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        if (nodeName == null) {
            ShowReferringObjectsAction.$$$reportNull$$$0(4);
        }
        XDebuggerTree tree = node.getTree();
        XSourcePosition position = tree.getSourcePosition();
        XValueMarkers<?, ?> markers = tree.getValueMarkers();
        XDebugSessionProxy session = DebuggerUIUtil.getSessionProxy(e);
        if (session == null) {
            return;
        }
        XValue xValue = (XValue)node.getValueContainer();
        DialogWrapper dialog2 = ShowReferringObjectsAction.createReferringObjectsDialog(xValue, session, nodeName, position, markers);
        if (dialog2 != null) {
            dialog2.show();
        }
    }

    @Nullable
    private static DialogWrapper createReferringObjectsDialog(XValue xValue, XDebugSessionProxy session, @NotNull String nodeName, XSourcePosition position, XValueMarkers<?, ?> markers) {
        XReferrersProvider referrersProvider;
        if (nodeName == null) {
            ShowReferringObjectsAction.$$$reportNull$$$0(5);
        }
        if ((referrersProvider = xValue.getReferrersProvider()) != null) {
            DialogWrapper dialog2;
            XValue referringObjectsRoot = referrersProvider.getReferringObjectsValue();
            XDebugSessionImpl xDebugSession = XDebugMonolithUtils.findSessionById(session.getId());
            if (xDebugSession != null && referringObjectsRoot instanceof ReferrersTreeCustomizer) {
                ReferrersTreeCustomizer referrersTreeCustomizer = (ReferrersTreeCustomizer)referringObjectsRoot;
                dialog2 = referrersTreeCustomizer.getDialog(xDebugSession, nodeName, position, markers);
            } else {
                dialog2 = new XInspectDialog(session.getProject(), session.getEditorsProvider(), position, nodeName, referringObjectsRoot, markers, session, false);
                dialog2.setTitle(XDebuggerBundle.message((String)"showReferring.dialog.title", (Object[])new Object[]{nodeName}));
            }
            return dialog2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/actions/ShowReferringObjectsAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/actions/ShowReferringObjectsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createReferringObjectsDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Experimental
    public static interface ReferrersTreeCustomizer {
        public DialogWrapper getDialog(XDebugSession var1, String var2, XSourcePosition var3, XValueMarkers<?, ?> var4);
    }
}

