/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.lang.Language;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SlowOperations;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class XDebuggerEditorsProviderBase
extends XDebuggerEditorsProvider {
    public static final Key<Boolean> DEBUGGER_FILE_KEY = Key.create((String)"debugger.file");

    @Override
    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(2);
        }
        PsiElement context = null;
        if (sourcePosition != null) {
            context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
        }
        Document document = this.createDocument(project, expression, context, mode);
        if (document == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(3);
        }
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable PsiElement context, @NotNull EvaluationMode mode) {
        PsiFile codeFragment;
        if (project == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(5);
        }
        if (mode == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(6);
        }
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-304707, EA-597817, EA-832153, ...");){
            codeFragment = this.createExpressionCodeFragment(project, expression, context, true);
        }
        codeFragment.putUserData(DEBUGGER_FILE_KEY, (Object)true);
        Document document = codeFragment.getViewProvider().getDocument();
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(7);
        }
        return document2;
    }

    protected abstract PsiFile createExpressionCodeFragment(@NotNull Project var1, @NotNull String var2, @Nullable PsiElement var3, boolean var4);

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull XExpression expression, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(9);
        }
        return this.createExpressionCodeFragment(project, expression.getExpression(), context, isPhysical);
    }

    @NotNull
    public @Unmodifiable Collection<Language> getSupportedLanguages(@Nullable PsiElement context) {
        if (context != null) {
            Collection<Language> collection = this.getSupportedLanguages(context.getProject(), null);
            if (collection == null) {
                XDebuggerEditorsProviderBase.$$$reportNull$$$0(10);
            }
            return collection;
        }
        List<Language> list = Collections.emptyList();
        if (list == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    protected PsiElement getContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project) {
        if (virtualFile == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(12);
        }
        if (project == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(13);
        }
        return XDebuggerUtil.getInstance().findContextElement(virtualFile, offset, project, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionCodeFragment";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContextElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 10, 11 -> new IllegalStateException(string);
        };
    }
}

