/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.mixedMode;

import com.intellij.execution.process.CompositeProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.xdebugger.mixedMode.XMixedModeProcessesConfiguration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0014J\b\u0010\u0016\u001a\u00020\tH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/xdebugger/mixedMode/XMixedModeProcessHandler;", "Lcom/intellij/execution/process/CompositeProcessHandler;", "highLevelProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "lowLevelProcessHandler", "config", "Lcom/intellij/xdebugger/mixedMode/XMixedModeProcessesConfiguration;", "beforeFinish", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/execution/process/ProcessHandler;Lcom/intellij/execution/process/ProcessHandler;Lcom/intellij/xdebugger/mixedMode/XMixedModeProcessesConfiguration;Lkotlin/jvm/functions/Function0;)V", "high", "getHigh", "()Lcom/intellij/execution/process/ProcessHandler;", "low", "getLow", "startNotifyHandler", "handler", "detachIsDefault", "", "destroyProcessImpl", "detachProcessImpl", "intellij.platform.debugger"})
@ApiStatus.Internal
public final class XMixedModeProcessHandler
extends CompositeProcessHandler {
    @NotNull
    private final XMixedModeProcessesConfiguration config;
    @NotNull
    private final Function0<Unit> beforeFinish;

    public XMixedModeProcessHandler(@NotNull ProcessHandler highLevelProcessHandler, @NotNull ProcessHandler lowLevelProcessHandler, @NotNull XMixedModeProcessesConfiguration config, @NotNull Function0<Unit> beforeFinish) {
        Intrinsics.checkNotNullParameter((Object)highLevelProcessHandler, (String)"highLevelProcessHandler");
        Intrinsics.checkNotNullParameter((Object)lowLevelProcessHandler, (String)"lowLevelProcessHandler");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(beforeFinish, (String)"beforeFinish");
        Object[] objectArray = new ProcessHandler[]{highLevelProcessHandler, lowLevelProcessHandler};
        super(CollectionsKt.listOf((Object[])objectArray));
        this.config = config;
        this.beforeFinish = beforeFinish;
    }

    private final ProcessHandler getHigh() {
        return (ProcessHandler)this.getHandlers().get(0);
    }

    private final ProcessHandler getLow() {
        return (ProcessHandler)this.getHandlers().get(1);
    }

    protected void startNotifyHandler(@NotNull ProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (handler.isStartNotified()) {
            return;
        }
        handler.startNotify();
    }

    public boolean detachIsDefault() {
        return this.getHigh().detachIsDefault() && this.getLow().detachIsDefault();
    }

    protected void destroyProcessImpl() {
        boolean bothWantDestroy;
        this.beforeFinish.invoke();
        if (this.config.getOnlyLowDetaches()) {
            boolean bl = this.getLow().detachIsDefault();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.getLow().detachProcess();
            return;
        }
        boolean bl = bothWantDestroy = !this.getLow().detachIsDefault() && !this.getHigh().detachIsDefault();
        if (bothWantDestroy) {
            super.destroyProcessImpl();
            return;
        }
        Pair pair = this.getLow().detachIsDefault() ? new Pair((Object)this.getLow(), (Object)this.getHigh()) : new Pair((Object)this.getHigh(), (Object)this.getLow());
        ProcessHandler handlerWantsDetach = (ProcessHandler)pair.component1();
        ProcessHandler handlerWantsDestroy = (ProcessHandler)pair.component2();
        handlerWantsDetach.detachProcess();
        handlerWantsDestroy.destroyProcess();
    }

    protected void detachProcessImpl() {
        this.beforeFinish.invoke();
        if (this.config.getOnlyLowDetaches()) {
            boolean bl = this.getLow().detachIsDefault();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.getLow().detachProcess();
            return;
        }
        super.detachProcessImpl();
    }
}

