/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XAlternativeSourceHandler;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionEventsProvider;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XDropFrameHandler;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.mixedMode.XMixedModeDebugProcessExtension;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class XDebugProcess {
    @NotNull
    private final XDebugSession mySession;
    private ProcessHandler myProcessHandler;

    protected XDebugProcess(@NotNull XDebugSession session) {
        if (session == null) {
            XDebugProcess.$$$reportNull$$$0(0);
        }
        this.mySession = session;
    }

    @NotNull
    public final XDebugSession getSession() {
        XDebugSession xDebugSession = this.mySession;
        if (xDebugSession == null) {
            XDebugProcess.$$$reportNull$$$0(1);
        }
        return xDebugSession;
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        if (XBreakpointHandler.EMPTY_ARRAY == null) {
            XDebugProcess.$$$reportNull$$$0(2);
        }
        return XBreakpointHandler.EMPTY_ARRAY;
    }

    @NotNull
    public abstract XDebuggerEditorsProvider getEditorsProvider();

    public void sessionInitialized() {
    }

    public void startPausing() {
    }

    @Deprecated
    public void startStepOver() {
        throw new AbstractMethodError();
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.startStepOver();
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.startStepInto(context);
    }

    @Deprecated
    public void startStepInto() {
        throw new AbstractMethodError();
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.startStepInto();
    }

    @Deprecated
    public void startStepOut() {
        throw new AbstractMethodError();
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.startStepOut();
    }

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return null;
    }

    @ApiStatus.Experimental
    @Nullable
    public XDropFrameHandler getDropFrameHandler() {
        return null;
    }

    @ApiStatus.Experimental
    @Nullable
    public XAlternativeSourceHandler getAlternativeSourceHandler() {
        return null;
    }

    public void stop() {
        throw new AbstractMethodError();
    }

    @NotNull
    public Promise<Object> stopAsync() {
        this.stop();
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            XDebugProcess.$$$reportNull$$$0(3);
        }
        return promise;
    }

    @Deprecated
    public void resume() {
        throw new AbstractMethodError();
    }

    public void resume(@Nullable XSuspendContext context) {
        this.resume();
    }

    @Deprecated
    public void runToPosition(@NotNull XSourcePosition position) {
        if (position == null) {
            XDebugProcess.$$$reportNull$$$0(4);
        }
        throw new AbstractMethodError();
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            XDebugProcess.$$$reportNull$$$0(5);
        }
        this.runToPosition(position);
    }

    public boolean checkCanPerformCommands() {
        return true;
    }

    public boolean checkCanInitBreakpoints() {
        return true;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return null;
    }

    @NotNull
    public final ProcessHandler getProcessHandler() {
        if (this.myProcessHandler == null) {
            this.myProcessHandler = this.doGetProcessHandler();
            if (this.myProcessHandler == null) {
                this.myProcessHandler = new DefaultDebugProcessHandler();
            }
        }
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            XDebugProcess.$$$reportNull$$$0(6);
        }
        return processHandler;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(this.getSession().getProject()).getConsole();
        if (consoleView == null) {
            XDebugProcess.$$$reportNull$$$0(7);
        }
        return consoleView;
    }

    @Nullable
    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return null;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            XDebugProcess.$$$reportNull$$$0(8);
        }
        if (topToolbar == null) {
            XDebugProcess.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            XDebugProcess.$$$reportNull$$$0(10);
        }
    }

    @Nls
    public String getCurrentStateMessage() {
        return this.mySession.isStopped() ? XDebuggerBundle.message("debugger.state.message.disconnected", new Object[0]) : XDebuggerBundle.message("debugger.state.message.connected", new Object[0]);
    }

    @Nullable
    public HyperlinkListener getCurrentStateHyperlinkListener() {
        return null;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(this){};
    }

    public boolean isValuesCustomSorted() {
        return false;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame == null ? null : frame.getEvaluator();
    }

    @ApiStatus.Internal
    public XDebugSessionEventsProvider getSessionEventsProvider() {
        return null;
    }

    public boolean isLibraryFrameFilterSupported() {
        return false;
    }

    public void logStack(@NotNull XSuspendContext suspendContext, @NotNull XDebugSession session) {
        if (suspendContext == null) {
            XDebugProcess.$$$reportNull$$$0(11);
        }
        if (session == null) {
            XDebugProcess.$$$reportNull$$$0(12);
        }
        XDebuggerUtil.getInstance().logStack(suspendContext, session);
    }

    @ApiStatus.Experimental
    public boolean dependsOnPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            XDebugProcess.$$$reportNull$$$0(13);
        }
        return false;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public XMixedModeDebugProcessExtension getMixedModeDebugProcessExtension() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/XDebugProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/XDebugProcess";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stopAsync";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logStack";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnPlugin";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

