/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.platform.diagnostic.telemetry.AsyncSpanExporter;
import com.intellij.platform.diagnostic.telemetry.exporters.JaegerJsonSpanExporter;
import com.intellij.platform.diagnostic.telemetry.exporters.JaegerJsonSpanExporterKt;
import com.intellij.platform.diagnostic.telemetry.exporters.KeyValue;
import com.intellij.platform.diagnostic.telemetry.exporters.ReentrantMutexKt;
import com.intellij.platform.diagnostic.telemetry.exporters.ScopeSpans;
import com.intellij.platform.diagnostic.telemetry.exporters.Span;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00110\u0011H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001f\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010 J\u000e\u0010\"\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/JaegerJsonSpanExporter;", "Lcom/intellij/platform/diagnostic/telemetry/AsyncSpanExporter;", "file", "Ljava/nio/file/Path;", "serviceName", "", "serviceVersion", "serviceNamespace", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getServiceName", "()Ljava/lang/String;", "getServiceVersion", "getServiceNamespace", "fileChannel", "Ljava/nio/channels/FileChannel;", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "lock", "Lkotlinx/coroutines/sync/Mutex;", "initWriter", "kotlin.jvm.PlatformType", "export", "", "spans", "", "Lio/opentelemetry/sdk/trace/data/SpanData;", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "flushOtlp", "scopeSpans", "Lcom/intellij/platform/diagnostic/telemetry/exporters/ScopeSpans;", "shutdown", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "flush", "reset", "intellij.platform.diagnostic.telemetry.exporters"})
@ApiStatus.Internal
public final class JaegerJsonSpanExporter
implements AsyncSpanExporter {
    @NotNull
    private final String serviceName;
    @Nullable
    private final String serviceVersion;
    @Nullable
    private final String serviceNamespace;
    @NotNull
    private final FileChannel fileChannel;
    @NotNull
    private JsonGenerator writer;
    @NotNull
    private final Mutex lock;

    public JaegerJsonSpanExporter(@NotNull Path file, @NotNull String serviceName, @Nullable String serviceVersion, @Nullable String serviceNamespace) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        this.serviceName = serviceName;
        this.serviceVersion = serviceVersion;
        this.serviceNamespace = serviceNamespace;
        this.lock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        Path parent = file.getParent();
        Files.createDirectories(parent, new FileAttribute[0]);
        FileChannel fileChannel = FileChannel.open(file, (Set<? extends OpenOption>)EnumSet.of((Enum)StandardOpenOption.CREATE, (Enum)StandardOpenOption.WRITE, (Enum)StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"open(...)");
        this.fileChannel = fileChannel;
        JsonGenerator jsonGenerator = this.initWriter();
        Intrinsics.checkNotNullExpressionValue((Object)jsonGenerator, (String)"initWriter(...)");
        this.writer = jsonGenerator;
        JaegerJsonSpanExporterKt.access$beginWriter(this.writer, this.serviceName, this.serviceVersion, this.serviceNamespace);
    }

    public /* synthetic */ JaegerJsonSpanExporter(Path path, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        this(path, string, string2, string3);
    }

    @NotNull
    public final String getServiceName() {
        return this.serviceName;
    }

    @Nullable
    public final String getServiceVersion() {
        return this.serviceVersion;
    }

    @Nullable
    public final String getServiceNamespace() {
        return this.serviceNamespace;
    }

    private final JsonGenerator initWriter() {
        return new JsonFactory().createGenerator(Channels.newOutputStream(this.fileChannel)).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, true).configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
    }

    @Nullable
    public Object export(@NotNull Collection<? extends SpanData> spans, @NotNull Continuation<? super Unit> $completion) {
        Object object = ReentrantMutexKt.withReentrantLock(this.lock, (Function1)new Function1<Continuation<? super Unit>, Object>(spans, this, null){
            int label;
            final /* synthetic */ Collection<SpanData> $spans;
            final /* synthetic */ JaegerJsonSpanExporter this$0;
            {
                this.$spans = $spans;
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        for (SpanData span : this.$spans) {
                            List events;
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStartObject();
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("traceID", span.getTraceId());
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("spanID", span.getSpanId());
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("operationName", span.getName());
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("processID", "p1");
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeNumberField("startTime", TimeUnit.NANOSECONDS.toMicros(span.getStartEpochNanos()));
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeNumberField("duration", TimeUnit.NANOSECONDS.toMicros(span.getEndEpochNanos() - span.getStartEpochNanos()));
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeNumberField("startTimeNano", span.getStartEpochNanos());
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeNumberField("durationNano", span.getEndEpochNanos() - span.getStartEpochNanos());
                            SpanContext parentContext = span.getParentSpanContext();
                            boolean hasError = span.getStatus().getStatusCode() == StatusData.error().getStatusCode();
                            Attributes attributes = span.getAttributes();
                            if (!attributes.isEmpty() || hasError) {
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeArrayFieldStart("tags");
                                if (hasError) {
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStartObject();
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("key", "otel.status_code");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("type", "string");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("value", "ERROR");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndObject();
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStartObject();
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("key", "error");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("type", "boolean");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("value", "true");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndObject();
                                }
                                JsonGenerator jsonGenerator = JaegerJsonSpanExporter.access$getWriter$p(this.this$0);
                                Intrinsics.checkNotNull((Object)attributes);
                                JaegerJsonSpanExporterKt.access$writeAttributesAsJson(jsonGenerator, attributes);
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndArray();
                            }
                            if (!(events = span.getEvents()).isEmpty()) {
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeArrayFieldStart("logs");
                                for (EventData event : events) {
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStartObject();
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeNumberField("timestamp", TimeUnit.NANOSECONDS.toMicros(event.getEpochNanos()));
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeArrayFieldStart("fields");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStartObject();
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("key", "event");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("type", "string");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("value", event.getName());
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndObject();
                                    JsonGenerator jsonGenerator = JaegerJsonSpanExporter.access$getWriter$p(this.this$0);
                                    Attributes attributes2 = event.getAttributes();
                                    Intrinsics.checkNotNullExpressionValue((Object)attributes2, (String)"getAttributes(...)");
                                    JaegerJsonSpanExporterKt.access$writeAttributesAsJson(jsonGenerator, attributes2);
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndArray();
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndObject();
                                }
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndArray();
                            }
                            if (parentContext.isValid()) {
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeArrayFieldStart("references");
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStartObject();
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("refType", "CHILD_OF");
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("traceID", parentContext.getTraceId());
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("spanID", parentContext.getSpanId());
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndObject();
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndArray();
                            }
                            JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndObject();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object flushOtlp(@NotNull Collection<ScopeSpans> scopeSpans, @NotNull Continuation<? super Unit> $completion) {
        Object object = ReentrantMutexKt.withReentrantLock(this.lock, (Function1)new Function1<Continuation<? super Unit>, Object>(this, scopeSpans, null){
            int label;
            final /* synthetic */ JaegerJsonSpanExporter this$0;
            final /* synthetic */ Collection<ScopeSpans> $scopeSpans;
            {
                this.this$0 = $receiver;
                this.$scopeSpans = $scopeSpans;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        ResultKt.throwOnFailure((Object)$result);
                        boolean bl2 = bl = !JaegerJsonSpanExporter.access$getWriter$p(this.this$0).isClosed();
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        for (ScopeSpans scopeSpan : this.$scopeSpans) {
                            for (Span span : scopeSpan.spans) {
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStartObject();
                                String traceId = HexExtensionsKt.toHexString$default((byte[])span.traceId, null, (int)1, null);
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("traceID", traceId);
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("spanID", HexExtensionsKt.toHexString$default((byte[])span.spanId, null, (int)1, null));
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("operationName", span.name);
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("processID", "p1");
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeNumberField("startTime", TimeUnit.NANOSECONDS.toMicros(span.startTimeUnixNano));
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeNumberField("duration", TimeUnit.NANOSECONDS.toMicros(span.endTimeUnixNano - span.startTimeUnixNano));
                                List<KeyValue> attributes = span.attributes;
                                if (!attributes.isEmpty()) {
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeArrayFieldStart("tags");
                                    for (KeyValue k : attributes) {
                                        JsonGenerator w = JaegerJsonSpanExporter.access$getWriter$p(this.this$0);
                                        w.writeStartObject();
                                        w.writeStringField("key", k.key);
                                        w.writeStringField("type", "string");
                                        w.writeStringField("value", k.value.string);
                                        w.writeEndObject();
                                    }
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndArray();
                                }
                                if (span.parentSpanId != null) {
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeArrayFieldStart("references");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStartObject();
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("refType", "CHILD_OF");
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("traceID", traceId);
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeStringField("spanID", HexExtensionsKt.toHexString$default((byte[])span.parentSpanId, null, (int)1, null));
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndObject();
                                    JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndArray();
                                }
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).writeEndObject();
                            }
                        }
                        JaegerJsonSpanExporter.access$getWriter$p(this.this$0).flush();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object shutdown(@NotNull Continuation<? super Unit> $completion) {
        Object object = ReentrantMutexKt.withReentrantLock(this.lock, (Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JaegerJsonSpanExporter this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ JaegerJsonSpanExporter this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Closeable closeable = JaegerJsonSpanExporter.access$getFileChannel$p(this.this$0);
                                        JaegerJsonSpanExporter jaegerJsonSpanExporter = this.this$0;
                                        Throwable throwable = null;
                                        try {
                                            FileChannel it = (FileChannel)closeable;
                                            boolean bl = false;
                                            JaegerJsonSpanExporterKt.access$closeJsonFile(JaegerJsonSpanExporter.access$getWriter$p(jaegerJsonSpanExporter));
                                            Unit unit = Unit.INSTANCE;
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object flush(@NotNull Continuation<? super Unit> $completion) {
        Object object = ReentrantMutexKt.withReentrantLock(this.lock, (Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JaegerJsonSpanExporter this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (JaegerJsonSpanExporter.access$getWriter$p(this.this$0).isClosed()) {
                            return Unit.INSTANCE;
                        }
                        this.label = 1;
                        Object object2 = InterruptibleKt.runInterruptible$default(null, () -> flush.2.invokeSuspend$lambda$0(this.this$0), (Continuation)((Continuation)this), (int)1, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            private static final FileChannel invokeSuspend$lambda$0(JaegerJsonSpanExporter this$0) {
                return (FileChannel)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileChannel>, Object>(this$0, null){
                    int label;
                    final /* synthetic */ JaegerJsonSpanExporter this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                JaegerJsonSpanExporter.access$getWriter$p(this.this$0).flush();
                                JaegerJsonSpanExporter.access$getFileChannel$p(this.this$0).write(ByteBuffer.wrap(JaegerJsonSpanExporterKt.access$getJsonEnd$p()));
                                JaegerJsonSpanExporter.access$getFileChannel$p(this.this$0).force(false);
                                return JaegerJsonSpanExporter.access$getFileChannel$p(this.this$0).position(JaegerJsonSpanExporter.access$getFileChannel$p(this.this$0).position() - (long)JaegerJsonSpanExporterKt.access$getJsonEnd$p().length);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super FileChannel> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object reset(@NotNull Continuation<? super Unit> $completion) {
        Object object = ReentrantMutexKt.withReentrantLock(this.lock, (Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JaegerJsonSpanExporter this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (JaegerJsonSpanExporter.access$getWriter$p(this.this$0).isClosed()) {
                            return Unit.INSTANCE;
                        }
                        JsonGenerator jsonGenerator = JaegerJsonSpanExporter.access$initWriter(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonGenerator, (String)"access$initWriter(...)");
                        JaegerJsonSpanExporter.access$setWriter$p(this.this$0, jsonGenerator);
                        this.label = 1;
                        Object object2 = InterruptibleKt.runInterruptible$default(null, () -> reset.2.invokeSuspend$lambda$0(this.this$0), (Continuation)((Continuation)this), (int)1, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(JaegerJsonSpanExporter this$0) {
                BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                    int label;
                    final /* synthetic */ JaegerJsonSpanExporter this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                JaegerJsonSpanExporter.access$getFileChannel$p(this.this$0).truncate(0L);
                                JaegerJsonSpanExporterKt.access$beginWriter(JaegerJsonSpanExporter.access$getWriter$p(this.this$0), this.this$0.getServiceName(), this.this$0.getServiceVersion(), this.this$0.getServiceNamespace());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                return Unit.INSTANCE;
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ JsonGenerator access$getWriter$p(JaegerJsonSpanExporter $this) {
        return $this.writer;
    }

    public static final /* synthetic */ FileChannel access$getFileChannel$p(JaegerJsonSpanExporter $this) {
        return $this.fileChannel;
    }

    public static final /* synthetic */ void access$setWriter$p(JaegerJsonSpanExporter $this, JsonGenerator jsonGenerator) {
        $this.writer = jsonGenerator;
    }

    public static final /* synthetic */ JsonGenerator access$initWriter(JaegerJsonSpanExporter $this) {
        return $this.initWriter();
    }
}

