/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters;

import com.intellij.openapi.util.io.FileSetLimiter;
import com.intellij.platform.diagnostic.telemetry.OpenTelemetryUtils;
import com.intellij.util.SystemProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001d\u0010\u0013\u001a\u00020\u00022\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/RollingFileSupplier;", "Ljava/util/function/Supplier;", "Ljava/nio/file/Path;", "basePath", "initialDataToWrite", "", "", "maxFilesToKeep", "", "<init>", "(Ljava/nio/file/Path;Ljava/util/List;I)V", "getMaxFilesToKeep", "()I", "maxSizeBeforeRoll", "", "currentPath", "get", "forceToGetNewPath", "", "init", "init$intellij_platform_diagnostic_telemetry_exporters", "generateFileForMetrics", "metricsReportingBasePath", "intellij.platform.diagnostic.telemetry.exporters"})
@ApiStatus.Internal
public final class RollingFileSupplier
implements Supplier<Path> {
    @NotNull
    private final Path basePath;
    @NotNull
    private final List<String> initialDataToWrite;
    private final int maxFilesToKeep;
    private final long maxSizeBeforeRoll;
    @Nullable
    private Path currentPath;

    public RollingFileSupplier(@NotNull Path basePath, @NotNull List<String> initialDataToWrite, int maxFilesToKeep) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter(initialDataToWrite, (String)"initialDataToWrite");
        this.basePath = basePath;
        this.initialDataToWrite = initialDataToWrite;
        this.maxFilesToKeep = maxFilesToKeep;
        this.maxSizeBeforeRoll = 0xA00000L;
    }

    public /* synthetic */ RollingFileSupplier(Path path, List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            n = SystemProperties.getIntProperty((String)"idea.diagnostic.opentelemetry.metrics.max-files-to-keep", (int)14);
        }
        this(path, list, n);
    }

    public final int getMaxFilesToKeep() {
        return this.maxFilesToKeep;
    }

    @Override
    @NotNull
    public Path get() {
        return this.get(false);
    }

    @NotNull
    public final Path get(boolean forceToGetNewPath) {
        boolean generateNewPath;
        Path path = this.currentPath;
        if (path != null) {
            boolean bl;
            Path it = path;
            boolean bl2 = false;
            try {
                bl = Files.exists(it, new LinkOption[0]) && Files.size(it) > this.maxSizeBeforeRoll;
            }
            catch (NoSuchFileException e) {
                bl = false;
            }
            v1 = bl;
        } else {
            v1 = generateNewPath = true;
        }
        if (forceToGetNewPath || generateNewPath) {
            this.currentPath = this.generateFileForMetrics(this.basePath);
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.write(this.currentPath, (Iterable<? extends CharSequence>)this.initialDataToWrite, openOptionArray);
        }
        Path path2 = this.currentPath;
        Intrinsics.checkNotNull((Object)path2);
        return path2;
    }

    public static /* synthetic */ Path get$default(RollingFileSupplier rollingFileSupplier, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return rollingFileSupplier.get(bl);
    }

    @NotNull
    public final Path init$intellij_platform_diagnostic_telemetry_exporters(@NotNull List<String> initialDataToWrite) {
        Path parentDir;
        Intrinsics.checkNotNullParameter(initialDataToWrite, (String)"initialDataToWrite");
        Path pathToWrite = this.get();
        if (!Files.exists(pathToWrite, new LinkOption[0]) && !Files.isDirectory(parentDir = pathToWrite.getParent(), new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        if (!Files.exists(pathToWrite, new LinkOption[0]) || Files.size(pathToWrite) == 0L) {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.write(pathToWrite, (Iterable<? extends CharSequence>)initialDataToWrite, openOptionArray);
        }
        return pathToWrite;
    }

    public static /* synthetic */ Path init$intellij_platform_diagnostic_telemetry_exporters$default(RollingFileSupplier rollingFileSupplier, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return rollingFileSupplier.init$intellij_platform_diagnostic_telemetry_exporters(list);
    }

    private final Path generateFileForMetrics(Path metricsReportingBasePath) {
        FileSetLimiter fileLimiterForMetrics = OpenTelemetryUtils.INSTANCE.setupFileLimiterForMetrics(metricsReportingBasePath);
        Path path = fileLimiterForMetrics.removeOldFilesBut(this.maxFilesToKeep, FileSetLimiter.DELETE_ASYNC).createNewFile();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createNewFile(...)");
        return path;
    }
}

