/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.platform.diagnostic.telemetry.AsyncSpanExporter;
import com.intellij.platform.diagnostic.telemetry.OtlpConfiguration;
import com.intellij.platform.diagnostic.telemetry.exporters.JaegerJsonSpanExporter;
import com.intellij.platform.diagnostic.telemetry.exporters.OtlpSpanExporter;
import com.intellij.platform.diagnostic.telemetry.impl.OpenTelemetryConfigurator;
import com.intellij.platform.diagnostic.telemetry.impl.OpenTelemetryExporterProvider;
import com.intellij.platform.diagnostic.telemetry.impl.PluginDescriptor_extKt;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.Resource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"normalizeTelemetryFile", "Ljava/nio/file/Path;", "file", "createSpanExporters", "", "Lcom/intellij/platform/diagnostic/telemetry/AsyncSpanExporter;", "resource", "Lio/opentelemetry/sdk/resources/Resource;", "isUnitTestMode", "", "createOpenTelemetryConfigurator", "Lcom/intellij/platform/diagnostic/telemetry/impl/OpenTelemetryConfigurator;", "intellij.platform.diagnostic.telemetry.impl"})
@SourceDebugExtension(value={"SMAP\nTelemetryManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelemetryManagerImpl.kt\ncom/intellij/platform/diagnostic/telemetry/impl/TelemetryManagerImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,271:1\n13#2:272\n*S KotlinDebug\n*F\n+ 1 TelemetryManagerImpl.kt\ncom/intellij/platform/diagnostic/telemetry/impl/TelemetryManagerImplKt\n*L\n250#1:272\n*E\n"})
public final class TelemetryManagerImplKt {
    private static final Path normalizeTelemetryFile(Path file) {
        if (file.getParent() != null && file.isAbsolute()) {
            return file;
        }
        Path path = PathManager.getLogDir().toAbsolutePath().resolve(file);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final List<AsyncSpanExporter> createSpanExporters(Resource resource, boolean isUnitTestMode) {
        List spanExporters = new ArrayList();
        String string = System.getProperty("idea.diagnostic.opentelemetry.file");
        if (string != null) {
            String traceFile = string;
            boolean bl = false;
            Path path = Path.of(traceFile, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            Path path2 = TelemetryManagerImplKt.normalizeTelemetryFile(path);
            Object object = resource.getAttribute(AttributeKey.stringKey((String)"service.name"));
            Intrinsics.checkNotNull((Object)object);
            spanExporters.add(new JaegerJsonSpanExporter(path2, (String)object, (String)resource.getAttribute(AttributeKey.stringKey((String)"service.version")), (String)resource.getAttribute(AttributeKey.stringKey((String)"service.namespace"))));
        }
        String string2 = OtlpConfiguration.getTraceEndpoint();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            spanExporters.add(new OtlpSpanExporter(it, null, 2, null));
        }
        if (isUnitTestMode) {
            return spanExporters;
        }
        for (LazyExtension item : new ExtensionPointName("com.intellij.openTelemetryExporterProvider").filterableLazySequence()) {
            PluginDescriptor pluginDescriptor = item.getPluginDescriptor();
            if (!pluginDescriptor.isBundled() && !PluginDescriptor_extKt.isAllowedToExportOT(pluginDescriptor)) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(OpenTelemetryExporterProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)new PluginException("Plugin " + pluginDescriptor.getPluginId() + " is not allowed to provide OpenTelemetryExporterProvider", pluginDescriptor.getPluginId()));
                continue;
            }
            OpenTelemetryExporterProvider openTelemetryExporterProvider = (OpenTelemetryExporterProvider)item.getInstance();
            if (openTelemetryExporterProvider == null) continue;
            spanExporters.addAll((Collection)openTelemetryExporterProvider.getSpanExporters());
        }
        return spanExporters;
    }

    static /* synthetic */ List createSpanExporters$default(Resource resource, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return TelemetryManagerImplKt.createSpanExporters(resource, bl);
    }

    private static final OpenTelemetryConfigurator createOpenTelemetryConfigurator() {
        OpenTelemetryConfigurator openTelemetryConfigurator;
        try {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
            ApplicationInfoEx appInfo = applicationInfoEx;
            String string = ApplicationNamesInfo.getInstance().getFullProductName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
            String string2 = appInfo.getBuild().asStringWithoutProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringWithoutProductCode(...)");
            String string3 = appInfo.getBuild().getProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProductCode(...)");
            openTelemetryConfigurator = OpenTelemetryConfigurator.Companion.create(string, string2, string3);
        }
        catch (Throwable e) {
            openTelemetryConfigurator = OpenTelemetryConfigurator.Companion.create("", "", "");
        }
        return openTelemetryConfigurator;
    }

    public static final /* synthetic */ OpenTelemetryConfigurator access$createOpenTelemetryConfigurator() {
        return TelemetryManagerImplKt.createOpenTelemetryConfigurator();
    }

    public static final /* synthetic */ List access$createSpanExporters(Resource resource, boolean isUnitTestMode) {
        return TelemetryManagerImplKt.createSpanExporters(resource, isUnitTestMode);
    }
}

