/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.impl.agent;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.platform.diagnostic.telemetry.impl.agent.AgentConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0014\u0010\t\u001a\u00020\n*\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/agent/TelemetryAgentProvider;", "", "<init>", "()V", "getJvmArgs", "", "", "configuration", "Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration;", "writeSettings", "", "target", "Ljava/io/File;", "intellij.platform.diagnostic.telemetry.impl"})
@ApiStatus.Internal
public final class TelemetryAgentProvider {
    @NotNull
    public static final TelemetryAgentProvider INSTANCE = new TelemetryAgentProvider();

    private TelemetryAgentProvider() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> getJvmArgs(@NotNull AgentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        File file = FileUtilRt.createTempFile((String)"otlpAgent", (String)".properties");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File configLocation = file;
        INSTANCE.writeSettings(configuration, configLocation);
        Object[] objectArray = new String[]{"-javaagent:" + ((Object)configuration.getAgentLocation()).toString(), "-Dotel.javaagent.configuration-file=" + FileUtilRt.toSystemDependentName((String)configLocation.getAbsolutePath()), "-Dotel.trace.context=" + configuration.getContext().asString(), "-Dotel.service.name=" + configuration.getServiceName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeSettings(AgentConfiguration $this$writeSettings, File target) {
        Object object = target;
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)object;
            boolean bl = false;
            Properties serializedConfig = $this$writeSettings.toJavaAgentSettings();
            serializedConfig.store(writer, "Generated by Intellij IDEA");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }
}

