/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.impl.helpers;

import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.HdrHistogram.Histogram;
import org.jetbrains.annotations.NotNull;

public final class ReentrantLockUsageMonitor
implements AutoCloseable {
    public static final int DEFAULT_SAMPLING_INTERVAL_MS = SystemProperties.getIntProperty((String)"ReentrantLockUsageMonitor.DEFAULT_SAMPLING_INTERVAL_MS", (int)500);
    private final Supplier<ReentrantLock> lockToMonitor;
    private final ScheduledFuture<?> scheduledSamplerHandle;
    private final ObservableDoubleMeasurement competingThreadsAvg;
    private final ObservableLongMeasurement competingThreads90P;
    private final ObservableLongMeasurement competingThreadsMax;
    private final BatchCallback meterHandle;
    private final Histogram competingThreadsHisto;

    public ReentrantLockUsageMonitor(@NotNull ReentrantLock toMonitor, @NotNull String measurementName, @NotNull Meter otelMeter) {
        if (toMonitor == null) {
            ReentrantLockUsageMonitor.$$$reportNull$$$0(0);
        }
        if (measurementName == null) {
            ReentrantLockUsageMonitor.$$$reportNull$$$0(1);
        }
        if (otelMeter == null) {
            ReentrantLockUsageMonitor.$$$reportNull$$$0(2);
        }
        this(() -> toMonitor, measurementName, otelMeter);
    }

    public ReentrantLockUsageMonitor(@NotNull Supplier<ReentrantLock> toMonitor, @NotNull String measurementName, @NotNull Meter otelMeter) {
        if (toMonitor == null) {
            ReentrantLockUsageMonitor.$$$reportNull$$$0(3);
        }
        if (measurementName == null) {
            ReentrantLockUsageMonitor.$$$reportNull$$$0(4);
        }
        if (otelMeter == null) {
            ReentrantLockUsageMonitor.$$$reportNull$$$0(5);
        }
        this.competingThreadsHisto = new Histogram(3);
        this.lockToMonitor = toMonitor;
        this.scheduledSamplerHandle = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::sampleLockUsage, DEFAULT_SAMPLING_INTERVAL_MS, DEFAULT_SAMPLING_INTERVAL_MS, TimeUnit.MILLISECONDS);
        this.competingThreadsAvg = otelMeter.gaugeBuilder(measurementName + ".competingThreads.avg").buildObserver();
        this.competingThreads90P = otelMeter.gaugeBuilder(measurementName + ".competingThreads.90P").ofLongs().buildObserver();
        this.competingThreadsMax = otelMeter.gaugeBuilder(measurementName + ".competingThreads.max").ofLongs().buildObserver();
        this.meterHandle = otelMeter.batchCallback(this::drainValuesToOtel, (ObservableMeasurement)this.competingThreadsAvg, new ObservableMeasurement[]{this.competingThreads90P, this.competingThreadsMax});
    }

    private synchronized void sampleLockUsage() {
        ReentrantLock lock = this.lockToMonitor.get();
        if (lock != null) {
            boolean isLocked = lock.isLocked();
            int queueLength = lock.getQueueLength();
            int competingThreads = queueLength + (isLocked ? 1 : 0);
            this.competingThreadsHisto.recordValue((long)competingThreads);
        }
    }

    private synchronized void drainValuesToOtel() {
        if (this.competingThreadsHisto.getTotalCount() > 0L) {
            this.competingThreadsAvg.record(this.competingThreadsHisto.getMean());
            this.competingThreads90P.record(this.competingThreadsHisto.getValueAtPercentile(90.0));
            this.competingThreadsMax.record(this.competingThreadsHisto.getMaxValue());
            this.competingThreadsHisto.reset();
        } else {
            this.competingThreadsAvg.record(0.0);
            this.competingThreads90P.record(0L);
            this.competingThreadsMax.record(0L);
        }
    }

    @Override
    public void close() throws Exception {
        this.scheduledSamplerHandle.cancel(false);
        this.meterHandle.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "toMonitor";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "measurementName";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "otelMeter";
                break;
            }
        }
        objectArray[1] = "com/intellij/platform/diagnostic/telemetry/impl/helpers/ReentrantLockUsageMonitor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

