/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentBase;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentContentImpl
extends DocumentContentBase
implements FileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final VirtualFile myHighlightFile;

    public FileDocumentContentImpl(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file) {
        if (document == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(1);
        }
        this(project, document, file, null);
    }

    public FileDocumentContentImpl(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file, @Nullable VirtualFile highlightFile) {
        if (document == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(2);
        }
        if (file == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(3);
        }
        super(project, document);
        this.myFile = file;
        this.myHighlightFile = highlightFile;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)this.myHighlightFile, (Object)this.myFile);
    }

    @Nullable
    public LineSeparator getLineSeparator() {
        String s = LoadTextUtil.detectLineSeparator((VirtualFile)this.myFile, (boolean)true);
        if (s == null) {
            return null;
        }
        return LineSeparator.fromString((String)s);
    }

    @Nullable
    public Charset getCharset() {
        return this.myFile.getCharset();
    }

    @Nullable
    public Boolean hasBom() {
        return this.myFile.getBOM() != null;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Nullable
    public FileType getContentType() {
        return this.myFile.getFileType();
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned) {
            DiffUtil.refreshOnFrameActivation(this.myFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/contents/FileDocumentContentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/contents/FileDocumentContentImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

