/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.combined;

import com.intellij.diff.DiffContext;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.combined.CombinedBlockId;
import com.intellij.diff.tools.combined.CombinedBlockProducer;
import com.intellij.diff.tools.combined.CombinedDiffContext;
import com.intellij.diff.tools.combined.CombinedDiffModelListener;
import com.intellij.diff.tools.combined.CombinedDiffRegistry;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020%H\u0002J\u0006\u0010'\u001a\u00020%J\u0014\u0010(\u001a\u00020%2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001dJ\u0010\u0010)\u001a\u0004\u0018\u00010\u00182\u0006\u0010*\u001a\u00020\u0017J\u0010\u0010+\u001a\u0004\u0018\u00010\u001b2\u0006\u0010*\u001a\u00020\u0017J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dJ\u0014\u0010-\u001a\u00020%2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00170/J\u0014\u00100\u001a\u00020%2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00170/J\u0016\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u000204J\u001e\u00105\u001a\u00020%2\u0006\u00106\u001a\u0002072\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00170/H\u0003J \u00108\u001a\u00020\u001b2\u0006\u00106\u001a\u0002072\u0006\u0010*\u001a\u00020\u00172\u0006\u00109\u001a\u00020:H\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006<"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "ourDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "getOurDisposable", "()Lcom/intellij/openapi/util/CheckedDisposable;", "modelListeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/diff/tools/combined/CombinedDiffModelListener;", "kotlin.jvm.PlatformType", "contentLoadingQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "pendingUpdatesCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "_requests", "", "Lcom/intellij/diff/tools/combined/CombinedBlockId;", "Lcom/intellij/diff/tools/combined/CombinedBlockProducer;", "loadedRequests", "", "Lcom/intellij/diff/requests/DiffRequest;", "requests", "", "getRequests", "()Ljava/util/List;", "context", "Lcom/intellij/diff/DiffContext;", "getContext", "()Lcom/intellij/diff/DiffContext;", "cleanBlocks", "", "cleanLoadedRequests", "reload", "setBlocks", "getBlock", "blockId", "getLoadedRequest", "getLoadedRequests", "loadRequestContents", "blockIds", "", "unloadRequestContents", "addListener", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "loadRequests", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadRequest", "producer", "Lcom/intellij/diff/chains/DiffRequestProducer;", "LoadContentRequest", "intellij.platform.diff.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCombinedDiffModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedDiffModel.kt\ncom/intellij/diff/tools/combined/CombinedDiffModel\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n216#2,2:184\n1208#3,2:186\n1236#3,4:188\n774#3:192\n865#3,2:193\n*S KotlinDebug\n*F\n+ 1 CombinedDiffModel.kt\ncom/intellij/diff/tools/combined/CombinedDiffModel\n*L\n54#1:184,2\n68#1:186,2\n68#1:188,4\n83#1:192\n83#1:193,2\n*E\n"})
public final class CombinedDiffModel {
    @NotNull
    private final Project project;
    @NotNull
    private final CheckedDisposable ourDisposable;
    @NotNull
    private final EventDispatcher<CombinedDiffModelListener> modelListeners;
    @NotNull
    private final MergingUpdateQueue contentLoadingQueue;
    @NotNull
    private final AtomicInteger pendingUpdatesCount;
    @NotNull
    private Map<CombinedBlockId, ? extends CombinedBlockProducer> _requests;
    @NotNull
    private final Map<CombinedBlockId, DiffRequest> loadedRequests;
    @NotNull
    private final DiffContext context;

    public CombinedDiffModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.ourDisposable = checkedDisposable;
        EventDispatcher eventDispatcher = EventDispatcher.create(CombinedDiffModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.modelListeners = eventDispatcher;
        this.contentLoadingQueue = new MergingUpdateQueue("CombinedDiffModel", 0, true, null, (Disposable)this.ourDisposable, null, Alarm.ThreadToUse.POOLED_THREAD, null, 128, null);
        this.pendingUpdatesCount = new AtomicInteger();
        this._requests = MapsKt.emptyMap();
        this.loadedRequests = new LinkedHashMap();
        this.context = new CombinedDiffContext(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CheckedDisposable getOurDisposable() {
        return this.ourDisposable;
    }

    @NotNull
    public final List<CombinedBlockProducer> getRequests() {
        return CollectionsKt.toList((Iterable)this._requests.values());
    }

    @NotNull
    public final DiffContext getContext() {
        return this.context;
    }

    public final void cleanBlocks() {
        this.cleanLoadedRequests();
    }

    private final void cleanLoadedRequests() {
        Map<CombinedBlockId, DiffRequest> $this$forEach$iv = this.loadedRequests;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CombinedBlockId, DiffRequest>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CombinedBlockId, DiffRequest> element$iv;
            Map.Entry<CombinedBlockId, DiffRequest> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().onAssigned(false);
        }
        this.loadedRequests.clear();
    }

    public final void reload() {
        Map previouslyLoaded = MapsKt.toMap(this.loadedRequests);
        this.cleanLoadedRequests();
        if (!previouslyLoaded.isEmpty()) {
            this.loadRequestContents(previouslyLoaded.keySet());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setBlocks(@NotNull List<? extends CombinedBlockProducer> requests) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        this.cleanLoadedRequests();
        Iterable iterable = requests;
        CombinedDiffModel combinedDiffModel = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            CombinedBlockProducer combinedBlockProducer = (CombinedBlockProducer)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        combinedDiffModel._requests = destination$iv$iv;
        ((CombinedDiffModelListener)this.modelListeners.getMulticaster()).onModelReset();
    }

    @Nullable
    public final CombinedBlockProducer getBlock(@NotNull CombinedBlockId blockId) {
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        return this._requests.get(blockId);
    }

    @Nullable
    public final DiffRequest getLoadedRequest(@NotNull CombinedBlockId blockId) {
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        return this.loadedRequests.get(blockId);
    }

    @NotNull
    public final List<DiffRequest> getLoadedRequests() {
        return CollectionsKt.toList((Iterable)this.loadedRequests.values());
    }

    /*
     * WARNING - void declaration
     */
    public final void loadRequestContents(@NotNull Collection<? extends CombinedBlockId> blockIds) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(blockIds, (String)"blockIds");
        Iterable $this$filter$iv = blockIds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CombinedBlockId it = (CombinedBlockId)element$iv$iv;
            boolean bl = false;
            if (!(!this.loadedRequests.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notLoadedBlockIds = (List)destination$iv$iv;
        if (!((Collection)notLoadedBlockIds).isEmpty()) {
            this.contentLoadingQueue.queue((Update)new LoadContentRequest(notLoadedBlockIds));
        }
    }

    public final void unloadRequestContents(@NotNull Collection<? extends CombinedBlockId> blockIds) {
        Intrinsics.checkNotNullParameter(blockIds, (String)"blockIds");
        Map unloadedRequests = new LinkedHashMap();
        int loadedRequestsLimit = CombinedDiffRegistry.INSTANCE.getMaxBlockCountInMemory();
        for (CombinedBlockId combinedBlockId : blockIds) {
            DiffRequest unloadedRequest;
            if (loadedRequestsLimit >= 0 && loadedRequestsLimit >= this.loadedRequests.size() || this.loadedRequests.remove(combinedBlockId) == null) continue;
            unloadedRequests.put(combinedBlockId, unloadedRequest);
        }
        if (!unloadedRequests.isEmpty()) {
            ((CombinedDiffModelListener)this.modelListeners.getMulticaster()).onRequestContentsUnloaded(unloadedRequests);
        }
    }

    public final void addListener(@NotNull CombinedDiffModelListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.modelListeners.addListener((EventListener)listener, disposable);
    }

    @RequiresBackgroundThread
    private final void loadRequests(ProgressIndicator indicator, Collection<? extends CombinedBlockId> blockIds) {
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)((Disposable)this.ourDisposable), () -> CombinedDiffModel.loadRequests$lambda$0(blockIds, this, indicator), (ProgressIndicator)indicator);
    }

    @RequiresBackgroundThread
    private final DiffRequest loadRequest(ProgressIndicator indicator, CombinedBlockId blockId, DiffRequestProducer producer) {
        DiffRequest diffRequest = producer.process((UserDataHolder)this.context, indicator);
        Intrinsics.checkNotNullExpressionValue((Object)diffRequest, (String)"process(...)");
        DiffRequest request = diffRequest;
        request.putUserData(DiffUserDataKeysEx.EDITORS_HIDE_TITLE, (Object)true);
        this.loadedRequests.put(blockId, request);
        return request;
    }

    private static final void loadRequests$lambda$0(Collection $blockIds, CombinedDiffModel this$0, ProgressIndicator $indicator) {
        for (CombinedBlockId blockId : $blockIds) {
            CombinedBlockProducer requestProducer;
            ProgressManager.checkCanceled();
            if (this$0.loadedRequests.containsKey(blockId) || this$0._requests.get(blockId) == null) continue;
            DiffRequest loadedRequest = this$0.loadRequest($indicator, blockId, requestProducer.getProducer());
            ActionsKt.runInEdt$default(null, () -> CombinedDiffModel.loadRequests$lambda$0$0(this$0, blockId, loadedRequest), (int)1, null);
        }
    }

    private static final Unit loadRequests$lambda$0$0(CombinedDiffModel this$0, CombinedBlockId $blockId, DiffRequest $loadedRequest) {
        ((CombinedDiffModelListener)this$0.modelListeners.getMulticaster()).onRequestsLoaded($blockId, $loadedRequest);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffModel$LoadContentRequest;", "Lcom/intellij/util/ui/update/Update;", "blockIds", "", "Lcom/intellij/diff/tools/combined/CombinedBlockId;", "<init>", "(Lcom/intellij/diff/tools/combined/CombinedDiffModel;Ljava/util/Collection;)V", "indicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "getIndicator", "()Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "run", "", "canEat", "", "update", "setRejected", "intellij.platform.diff.impl"})
    @SourceDebugExtension(value={"SMAP\nCombinedDiffModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedDiffModel.kt\ncom/intellij/diff/tools/combined/CombinedDiffModel$LoadContentRequest\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,183:1\n37#2,2:184\n*S KotlinDebug\n*F\n+ 1 CombinedDiffModel.kt\ncom/intellij/diff/tools/combined/CombinedDiffModel$LoadContentRequest\n*L\n133#1:184,2\n*E\n"})
    private final class LoadContentRequest
    extends Update {
        @NotNull
        private final Collection<CombinedBlockId> blockIds;
        @NotNull
        private final EmptyProgressIndicator indicator;

        public LoadContentRequest(Collection<? extends CombinedBlockId> blockIds) {
            Intrinsics.checkNotNullParameter(blockIds, (String)"blockIds");
            Collection<? extends CombinedBlockId> $this$toTypedArray$iv = blockIds;
            boolean $i$f$toTypedArray = false;
            Collection<? extends CombinedBlockId> thisCollection$iv = $this$toTypedArray$iv;
            CombinedBlockId[] combinedBlockIdArray = thisCollection$iv.toArray(new CombinedBlockId[0]);
            super((Object)new ComparableObject.Impl((Object[])Arrays.copyOf(combinedBlockIdArray, combinedBlockIdArray.length)), CombinedDiffModel.this.pendingUpdatesCount.incrementAndGet());
            this.blockIds = blockIds;
            this.indicator = new EmptyProgressIndicator();
        }

        @NotNull
        public final EmptyProgressIndicator getIndicator() {
            return this.indicator;
        }

        public void run() {
            CombinedDiffModel.this.loadRequests((ProgressIndicator)this.indicator, this.blockIds);
            CombinedDiffModel.this.pendingUpdatesCount.decrementAndGet();
        }

        public boolean canEat(@NotNull Update update) {
            Intrinsics.checkNotNullParameter((Object)update, (String)"update");
            return update instanceof LoadContentRequest && this.getPriority() >= update.getPriority();
        }

        public void setRejected() {
            super.setRejected();
            CombinedDiffModel.this.pendingUpdatesCount.decrementAndGet();
            this.indicator.cancel();
        }
    }
}

