/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.AlignedDiffModel;
import com.intellij.diff.tools.simple.SimpleAlignedDiffModel;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffModel;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffChangedRangeProvider;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideContentPanel;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SimpleDiffViewer
extends TwosideTextDiffViewer {
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    protected final StatusPanel myStatusPanel;
    @NotNull
    protected SimpleDiffModel myModel;
    @NotNull
    private final AlignedDiffModel myAlignedDiffModel;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final ModifierProvider myModifierProvider;
    @NotNull
    protected final TwosideTextDiffProvider myTextDiffProvider;
    protected boolean aligningViewModeSupported;

    public SimpleDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            SimpleDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request);
        this.myModel = new SimpleDiffModel(this);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.aligningViewModeSupported = true;
        this.mySyncScrollable = new MySyncScrollable();
        this.myAlignedDiffModel = new SimpleAlignedDiffModel(this);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.getProject(), this.getEditors(), this.myContentPanel, (Disposable)this);
        this.myModifierProvider = new ModifierProvider();
        this.myTextDiffProvider = DiffUtil.createTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, (Disposable)this);
        for (Side side : Side.values()) {
            DiffUtil.installLineConvertor(this.getEditor(side), this.getContent(side), this.myFoldingModel, side.getIndex());
        }
    }

    @Override
    @RequiresEdt
    protected void onInit() {
        ThreadingAssertions.assertEventDispatchThread();
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter());
        this.myModifierProvider.init();
    }

    @Override
    protected void onDispose() {
        Disposer.dispose((Disposable)this.myAlignedDiffModel);
        super.onDispose();
    }

    @ApiStatus.Internal
    protected void setModel(@NotNull SimpleDiffModel model) {
        if (model == null) {
            SimpleDiffViewer.$$$reportNull$$$0(2);
        }
        this.myModel = model;
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new MyToggleAutoScrollAction());
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new MyToggleAutoScrollAction());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new ReplaceSelectedChangesAction(Side.LEFT));
        group.add((AnAction)new AppendSelectedChangesAction(Side.LEFT));
        group.add((AnAction)new ReplaceSelectedChangesAction(Side.RIGHT));
        group.add((AnAction)new AppendSelectedChangesAction(Side.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleDiffViewer.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @RequiresEdt
    protected void processContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    @RequiresEdt
    protected void updateContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
        super.updateContextHints();
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @NotNull
    protected SimpleDiffChangeUi createUi(@NotNull SimpleDiffChange change) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(6);
        }
        return new SimpleDiffChangeUi(this, change);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (this.myTextDiffProvider.noFitnessForParticularPurposePromised()) {
            return new FoldingModelSupport.Settings(TextDiffSettingsHolder.CONTEXT_RANGE_MODES[TextDiffSettingsHolder.CONTEXT_RANGE_MODES.length - 1], true);
        }
        FoldingModelSupport.Settings settings2 = settings;
        if (settings2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(7);
        }
        return settings2;
    }

    @NotNull
    public FoldingModelSupport getFoldingModel() {
        MyFoldingModel myFoldingModel = this.myFoldingModel;
        if (myFoldingModel == null) {
            SimpleDiffViewer.$$$reportNull$$$0(8);
        }
        return myFoldingModel;
    }

    @ApiStatus.Internal
    public boolean needAlignChanges() {
        if (!this.aligningViewModeSupported || this.myTextDiffProvider.noFitnessForParticularPurposePromised()) {
            return false;
        }
        return this.myAlignedDiffModel.needAlignChanges();
    }

    @NotNull
    public TwosideTextDiffProvider getTextDiffProvider() {
        TwosideTextDiffProvider twosideTextDiffProvider = this.myTextDiffProvider;
        if (twosideTextDiffProvider == null) {
            SimpleDiffViewer.$$$reportNull$$$0(9);
        }
        return twosideTextDiffProvider;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        if (indicator == null) {
            SimpleDiffViewer.$$$reportNull$$$0(10);
        }
        try {
            runnable = this.computeDifferences(indicator);
        }
        catch (DiffTooBigException e) {
            Runnable runnable2 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable2 == null) {
                SimpleDiffViewer.$$$reportNull$$$0(12);
            }
            return runnable2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable3 = this.applyNotification(DiffNotifications.createError());
            if (runnable3 == null) {
                SimpleDiffViewer.$$$reportNull$$$0(13);
            }
            return runnable3;
        }
        if (runnable == null) {
            SimpleDiffViewer.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        boolean isContentsEqual;
        if (indicator == null) {
            SimpleDiffViewer.$$$reportNull$$$0(14);
        }
        indicator.checkCanceled();
        Document document1 = this.getContent1().getDocument();
        Document document2 = this.getContent2().getDocument();
        CharSequence[] texts = (CharSequence[])ReadAction.compute(() -> new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()});
        List<LineFragment> lineFragments = this.myTextDiffProvider.compare(texts[0], texts[1], indicator);
        boolean bl = isContentsEqual = (lineFragments == null || lineFragments.isEmpty()) && StringUtil.equals((CharSequence)texts[0], (CharSequence)texts[1]);
        if (lineFragments == null) {
            Runnable runnable = this.apply(null, isContentsEqual);
            if (runnable == null) {
                SimpleDiffViewer.$$$reportNull$$$0(15);
            }
            return runnable;
        }
        ArrayList<SimpleDiffChange> changes = new ArrayList<SimpleDiffChange>();
        for (LineFragment fragment : lineFragments) {
            changes.add(new SimpleDiffChange(changes.size(), fragment));
        }
        Runnable runnable = this.apply(changes, isContentsEqual);
        if (runnable == null) {
            SimpleDiffViewer.$$$reportNull$$$0(16);
        }
        return runnable;
    }

    @NotNull
    protected Runnable apply(@Nullable List<? extends SimpleDiffChange> changes, boolean isContentsEqual) {
        List nonSkipped = changes != null ? ContainerUtil.filter(changes, it -> !it.isSkipped()) : null;
        FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(nonSkipped, this.getFoldingModelSettings());
        Runnable runnable = () -> {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            if (isContentsEqual && !DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.DISABLE_CONTENTS_EQUALS_NOTIFICATION, new UserDataHolder[]{this.myContext, this.myRequest})) {
                this.myPanel.addNotification(TextDiffViewerUtil.createEqualContentsNotification(this.getContents()));
            }
            this.myModel.setChanges(ContainerUtil.notNullize((List)changes), isContentsEqual);
            if (this.needAlignChanges()) {
                this.myAlignedDiffModel.realignChanges();
            }
            WriteIntentReadAction.run(() -> this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings()));
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDivider();
            this.myStatusPanel.update();
        };
        if (runnable == null) {
            SimpleDiffViewer.$$$reportNull$$$0(17);
        }
        return runnable;
    }

    @NotNull
    protected Runnable applyNotification(@Nullable JComponent notification) {
        Runnable runnable = () -> {
            this.clearDiffPresentation();
            this.myFoldingModel.destroy();
            if (notification != null) {
                this.myPanel.addNotification(notification);
            }
        };
        if (runnable == null) {
            SimpleDiffViewer.$$$reportNull$$$0(18);
        }
        return runnable;
    }

    protected void clearDiffPresentation() {
        this.myModel.clear();
        this.myAlignedDiffModel.clear();
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.myContentPanel.repaintDivider();
        this.myStatusPanel.update();
    }

    @Override
    @RequiresEdt
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            SimpleDiffViewer.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertEventDispatchThread();
        super.onBeforeDocumentChange(e);
        List documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        Side side = Side.fromValue((List)documents, (Object)e.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        this.myModel.handleBeforeDocumentChange(side, e);
    }

    @RequiresEdt
    public boolean scrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        if (scrollToPolicy == null) {
            SimpleDiffViewer.$$$reportNull$$$0(20);
        }
        ThreadingAssertions.assertEventDispatchThread();
        SimpleDiffChange targetChange = scrollToPolicy.select(this.getNonSkippedDiffChanges(this.getCurrentSide()));
        if (targetChange == null) {
            targetChange = scrollToPolicy.select(this.getDiffChanges());
        }
        if (targetChange == null) {
            return false;
        }
        this.scrollToChange(targetChange, false);
        return true;
    }

    private void scrollToChange(@NotNull SimpleDiffChange change, boolean animated) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(21);
        }
        int line1 = change.getStartLine(Side.LEFT);
        int line2 = change.getStartLine(Side.RIGHT);
        int endLine1 = change.getEndLine(Side.LEFT);
        int endLine2 = change.getEndLine(Side.RIGHT);
        DiffUtil.moveCaret((Editor)this.getEditor1(), line1);
        DiffUtil.moveCaret((Editor)this.getEditor2(), line2);
        if (ClientId.isCurrentlyUnderLocalId()) {
            this.getSyncScrollSupport().makeVisible(this.getCurrentSide(), line1, endLine1, line2, endLine2, animated);
        } else {
            this.getCurrentEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        ChangedLinesIterator changedLinesIterator;
        int line;
        if (context == null) {
            SimpleDiffViewer.$$$reportNull$$$0(22);
        }
        if ((line = context.contextMatchCheck((Iterator)(changedLinesIterator = new ChangedLinesIterator()))) == -1) {
            AllLinesIterator allLinesIterator = new AllLinesIterator((Document)this.getEditor(Side.RIGHT).getDocument());
            line = context.contextMatchCheck((Iterator)allLinesIterator);
        }
        if (line == -1) {
            return false;
        }
        this.scrollToLine(Side.RIGHT, line);
        return true;
    }

    @NotNull
    public List<SimpleDiffChange> getDiffChanges() {
        List<SimpleDiffChange> list = this.myModel.getChanges();
        if (list == null) {
            SimpleDiffViewer.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private @Unmodifiable List<SimpleDiffChange> getNonSkippedDiffChanges(Side side) {
        List list = ContainerUtil.filter(this.myModel.getChanges(side), it -> !it.isSkipped());
        if (list == null) {
            SimpleDiffViewer.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable() {
        SyncScrollSupport.SyncScrollable syncScrollable = this.mySyncScrollable;
        if (syncScrollable == null) {
            SimpleDiffViewer.$$$reportNull$$$0(25);
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected StatusPanel getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            SimpleDiffViewer.$$$reportNull$$$0(26);
        }
        return statusPanel;
    }

    @NotNull
    public KeyboardModifierListener getModifierProvider() {
        ModifierProvider modifierProvider = this.myModifierProvider;
        if (modifierProvider == null) {
            SimpleDiffViewer.$$$reportNull$$$0(27);
        }
        return modifierProvider;
    }

    @Override
    @NotNull
    public SyncScrollSupport.TwosideSyncScrollSupport getSyncScrollSupport() {
        SyncScrollSupport.TwosideSyncScrollSupport twosideSyncScrollSupport = super.getSyncScrollSupport();
        if (twosideSyncScrollSupport == null) {
            SimpleDiffViewer.$$$reportNull$$$0(28);
        }
        return twosideSyncScrollSupport;
    }

    protected boolean isEditable(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(29);
        }
        return DiffUtil.isEditable((Editor)this.getEditor(side));
    }

    public boolean isAligningViewModeSupported() {
        return this.aligningViewModeSupported && !this.myTextDiffProvider.noFitnessForParticularPurposePromised();
    }

    boolean isDiffForLocalChanges() {
        boolean isLastWithLocal = DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, new UserDataHolder[]{this.myContext});
        return isLastWithLocal && !this.isEditable(Side.LEFT) && this.isEditable(Side.RIGHT);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleDiffViewer.$$$reportNull$$$0(30);
        }
        if (request == null) {
            SimpleDiffViewer.$$$reportNull$$$0(31);
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    protected boolean isSomeChangeSelected(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(32);
        }
        if (this.getDiffChanges().isEmpty()) {
            return false;
        }
        EditorEx editor = this.getEditor(side);
        return DiffUtil.isSomeRangeSelected((Editor)editor, (Condition<? super BitSet>)((Condition)lines -> ContainerUtil.exists(this.getDiffChanges(), change -> SimpleDiffViewer.isChangeSelected(change, lines, side))));
    }

    @RequiresEdt
    @NotNull
    protected @Unmodifiable List<SimpleDiffChange> getSelectedChanges(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(33);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorEx editor = this.getEditor(side);
        BitSet lines = DiffUtil.getSelectedLines((Editor)editor);
        List list = ContainerUtil.filter(this.getDiffChanges(), change -> SimpleDiffViewer.isChangeSelected(change, lines, side));
        if (list == null) {
            SimpleDiffViewer.$$$reportNull$$$0(34);
        }
        return list;
    }

    private static boolean isChangeSelected(SimpleDiffChange change, @NotNull BitSet lines, @NotNull Side side) {
        if (lines == null) {
            SimpleDiffViewer.$$$reportNull$$$0(35);
        }
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(36);
        }
        int line1 = change.getStartLine(side);
        int line2 = change.getEndLine(side);
        return DiffUtil.isSelectedByLine(lines, line1, line2);
    }

    @RequiresEdt
    @Nullable
    protected SimpleDiffChange getSelectedChange(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(37);
        }
        ThreadingAssertions.assertEventDispatchThread();
        int caretLine = this.getEditor((Side)side).getCaretModel().getLogicalPosition().line;
        for (SimpleDiffChange change : this.getDiffChanges()) {
            int line2;
            int line1 = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(caretLine, line1, line2 = change.getEndLine(side))) continue;
            return change;
        }
        return null;
    }

    @RequiresWriteLock
    public void replaceChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(38);
        }
        if (sourceSide == null) {
            SimpleDiffViewer.$$$reportNull$$$0(39);
        }
        ThreadingAssertions.assertWriteAccess();
        if (!change.isValid()) {
            return;
        }
        Side outputSide = sourceSide.other();
        boolean isLocalChangeRevert = sourceSide == Side.LEFT && this.isDiffForLocalChanges();
        TextDiffViewerUtil.applyModification((Document)this.getEditor(outputSide).getDocument(), change.getStartLine(outputSide), change.getEndLine(outputSide), (Document)this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide), isLocalChangeRevert);
        this.myModel.destroyChange(change);
    }

    @RequiresWriteLock
    public void appendChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(40);
        }
        if (sourceSide == null) {
            SimpleDiffViewer.$$$reportNull$$$0(41);
        }
        ThreadingAssertions.assertWriteAccess();
        if (!change.isValid()) {
            return;
        }
        if (change.getStartLine(sourceSide) == change.getEndLine(sourceSide)) {
            return;
        }
        Side outputSide = sourceSide.other();
        DiffUtil.applyModification((Document)this.getEditor(outputSide).getDocument(), change.getEndLine(outputSide), change.getEndLine(outputSide), (Document)this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        this.myModel.destroyChange(change);
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public PrevNextDifferenceIterable getDifferenceIterable() {
        return this.myPrevNextDifferenceIterable;
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            SimpleDiffViewer.$$$reportNull$$$0(42);
        }
        super.uiDataSnapshot(sink);
        SimpleDiffChange change = this.getSelectedChange(this.getCurrentSide());
        if (change != null) {
            sink.set(DiffDataKeys.CURRENT_CHANGE_RANGE, (Object)new LineRange(change.getStartLine(this.getCurrentSide()), change.getEndLine(this.getCurrentSide())));
        }
        sink.set(DiffDataKeys.EDITOR_CHANGED_RANGE_PROVIDER, (Object)new MyChangedRangeProvider());
    }

    @Nullable
    @Nls
    protected String getStatusTextMessage() {
        if (this.myTextDiffProvider.isHighlightingDisabled()) {
            return DiffBundle.message((String)"diff.highlighting.disabled.text", (Object[])new Object[0]);
        }
        List<SimpleDiffChange> allChanges = this.myModel.getAllChanges();
        return DiffUtil.getStatusText(allChanges.size(), ContainerUtil.count(allChanges, it -> it.isExcluded()), this.myModel.isContentsEqual());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 9, 11, 12, 13, 15, 16, 17, 18, 23, 24, 25, 26, 27, 28, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer";
                break;
            }
            case 6: 
            case 21: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollToPolicy";
                break;
            }
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextDiffProvider";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDifferences";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "applyNotification";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffChanges";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonSkippedDiffChanges";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollable";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierProvider";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollSupport";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 34: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createUi";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeDifferences";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "scrollToChange";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToContext";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isSomeChangeSelected";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChanges";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isChangeSelected";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChange";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 9, 11, 12, 13, 15, 16, 17, 18, 23, 24, 25, 26, 27, 28, 34 -> new IllegalStateException(string);
        };
    }

    private final class MyInitialScrollHelper
    extends TwosideTextDiffViewer.MyInitialScrollPositionHelper {
        private MyInitialScrollHelper() {
            super(SimpleDiffViewer.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return SimpleDiffViewer.this.scrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return SimpleDiffViewer.this.scrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToContext(this.myNavigationContext);
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        private MySyncScrollable() {
        }

        @Override
        public boolean isSyncScrollEnabled() {
            if (SimpleDiffViewer.this.myTextDiffProvider.noFitnessForParticularPurposePromised()) {
                return false;
            }
            return SimpleDiffViewer.this.getTextSettings().isEnableSyncScroll() || SimpleDiffViewer.this.getTextSettings().isEnableAligningChangesMode();
        }

        @Override
        public boolean forceSyncVerticalScroll() {
            return SimpleDiffViewer.this.needAlignChanges();
        }

        @Override
        @NotNull
        public Range getRange(@NotNull Side baseSide, int line) {
            if (baseSide == null) {
                MySyncScrollable.$$$reportNull$$$0(0);
            }
            if (SimpleDiffViewer.this.getDiffChanges().isEmpty()) {
                Range range = MySyncScrollable.idRange(line);
                if (range == null) {
                    MySyncScrollable.$$$reportNull$$$0(1);
                }
                return range;
            }
            Range range = super.getRange(baseSide, line);
            if (range == null) {
                MySyncScrollable.$$$reportNull$$$0(2);
            }
            return range;
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                MySyncScrollable.$$$reportNull$$$0(3);
            }
            if (!helper.process(0, 0)) {
                return;
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.getDiffChanges()) {
                if (!helper.process(diffChange.getStartLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT))) {
                    return;
                }
                if (helper.process(diffChange.getEndLine(Side.LEFT), diffChange.getEndLine(Side.RIGHT))) continue;
                return;
            }
            helper.process(DiffUtil.getLineCount((Document)SimpleDiffViewer.this.getEditor1().getDocument()), DiffUtil.getLineCount((Document)SimpleDiffViewer.this.getEditor2().getDocument()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseSide";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRange";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processHelper";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<SimpleDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<SimpleDiffChange> getChanges() {
            List<SimpleDiffChange> list = SimpleDiffViewer.this.getNonSkippedDiffChanges(SimpleDiffViewer.this.getCurrentSide());
            if (list == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = SimpleDiffViewer.this.getCurrentEditor();
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull SimpleDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return change.getStartLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected int getEndLine(@NotNull SimpleDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return change.getEndLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected void scrollToChange(@NotNull SimpleDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(4);
            }
            SimpleDiffViewer.this.scrollToChange(change, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "scrollToChange";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            return SimpleDiffViewer.this.getStatusTextMessage();
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable;
        private final TwosideContentPanel myContentPanel;

        MyFoldingModel(@Nullable Project project, @NotNull List<? extends EditorEx> editors, @NotNull TwosideContentPanel contentPanel2, @NotNull Disposable disposable) {
            if (editors == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (contentPanel2 == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                MyFoldingModel.$$$reportNull$$$0(2);
            }
            super(project, editors.toArray(new EditorEx[0]), disposable);
            this.myPaintable = new FoldingModelSupport.MyPaintable(this, 0, 1);
            this.myContentPanel = contentPanel2;
        }

        @Override
        protected void repaintSeparators() {
            this.myContentPanel.repaint();
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<? extends SimpleDiffChange> changes, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                MyFoldingModel.$$$reportNull$$$0(4);
            }
            if (divider == null) {
                MyFoldingModel.$$$reportNull$$$0(5);
            }
            this.myPaintable.paintOnDivider(gg, divider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gg";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createState";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintOnDivider";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ModifierProvider
    extends KeyboardModifierListener {
        public void init() {
            this.init(SimpleDiffViewer.this.myPanel, (Disposable)SimpleDiffViewer.this);
        }

        @Override
        public void onModifiersChanged() {
            SimpleDiffViewer.this.myModel.updateGutterActions(false);
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter {
        private MyDividerPainter() {
        }

        @Override
        @DirtyUI
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                MyDividerPainter.$$$reportNull$$$0(0);
            }
            if (divider == null) {
                MyDividerPainter.$$$reportNull$$$0(1);
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, SimpleDiffViewer.this.getEditor1().getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor((Editor)SimpleDiffViewer.this.getEditor1()));
            gg.fill(gg.getClipBounds());
            SimpleDiffViewer.this.myModel.paintPolygons(gg, divider);
            SimpleDiffViewer.this.myFoldingModel.paintOnDivider(gg, divider);
            gg.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "divider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter";
            objectArray[2] = "paint";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction() {
            super(SimpleDiffViewer.this.getTextSettings(), SimpleDiffViewer.this.myFoldingModel);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleExpandByDefaultAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (e.getPresentation().isVisible() && SimpleDiffViewer.this.myTextDiffProvider.noFitnessForParticularPurposePromised()) {
                e.getPresentation().setVisible(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyToggleExpandByDefaultAction", "update"));
        }
    }

    protected class MyToggleAutoScrollAction
    extends TextDiffViewerUtil.ToggleAutoScrollAction {
        public MyToggleAutoScrollAction() {
            super(SimpleDiffViewer.this.getTextSettings());
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleAutoScrollAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (e.getPresentation().isVisible() && SimpleDiffViewer.this.myTextDiffProvider.noFitnessForParticularPurposePromised()) {
                e.getPresentation().setVisible(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyToggleAutoScrollAction", "update"));
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        MyReadOnlyLockAction() {
            super(SimpleDiffViewer.this.getContext(), SimpleDiffViewer.this.getEditableEditors());
        }

        @Override
        protected void doApply(boolean readOnly) {
            super.doApply(readOnly);
            SimpleDiffViewer.this.myModel.updateGutterActions(true);
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        ReplaceSelectedChangesAction(Side focusedSide) {
            if (focusedSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other());
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
        }

        @Override
        @NotNull
        protected String getText(@NotNull Side side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(1);
            }
            String string = SimpleDiffChangeUi.getApplyActionText(SimpleDiffViewer.this, this.myModifiedSide.other());
            if (string == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(3);
            }
            return DiffUtil.getArrowIcon(this.myModifiedSide.other());
        }

        @Override
        protected void apply(@NotNull List<? extends SimpleDiffChange> changes) {
            if (changes == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(4);
            }
            for (SimpleDiffChange simpleDiffChange : changes) {
                SimpleDiffViewer.this.replaceChange(simpleDiffChange, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        AppendSelectedChangesAction(Side focusedSide) {
            if (focusedSide == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other());
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")).getShortcutSet());
        }

        @Override
        @NotNull
        protected String getText(@NotNull Side side) {
            if (side == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(1);
            }
            String string = this.isBothEditable() ? DiffBundle.message((String)"action.presentation.diff.append.to.the.side.text", (Object[])new Object[]{this.myModifiedSide.getIndex()}) : DiffBundle.message((String)"action.presentation.diff.append.text", (Object[])new Object[0]);
            if (string == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(3);
            }
            return DiffUtil.getArrowDownIcon(this.myModifiedSide.other());
        }

        @Override
        protected void apply(@NotNull List<? extends SimpleDiffChange> changes) {
            if (changes == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(4);
            }
            for (SimpleDiffChange simpleDiffChange : changes) {
                SimpleDiffViewer.this.appendChange(simpleDiffChange, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ChangedLinesIterator
    extends BufferedLineIterator {
        private int myIndex = 0;

        private ChangedLinesIterator() {
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < SimpleDiffViewer.this.getDiffChanges().size();
        }

        @Override
        public void loadNextBlock() {
            SimpleDiffChange change = SimpleDiffViewer.this.getDiffChanges().get(this.myIndex);
            ++this.myIndex;
            int line1 = change.getStartLine(Side.RIGHT);
            int line2 = change.getEndLine(Side.RIGHT);
            DocumentEx document = SimpleDiffViewer.this.getEditor(Side.RIGHT).getDocument();
            for (int i = line1; i < line2; ++i) {
                int offset1 = document.getLineStartOffset(i);
                int offset2 = document.getLineEndOffset(i);
                CharSequence text = document.getImmutableCharSequence().subSequence(offset1, offset2);
                this.addLine(i, text);
            }
        }
    }

    private class MyChangedRangeProvider
    implements DiffChangedRangeProvider {
        private MyChangedRangeProvider() {
        }

        @Override
        public @Unmodifiable @Nullable List<TextRange> getChangedRanges(@NotNull Editor editor) {
            Side side;
            if (editor == null) {
                MyChangedRangeProvider.$$$reportNull$$$0(0);
            }
            if ((side = Side.fromValue(SimpleDiffViewer.this.getEditors(), (Object)editor)) == null) {
                return null;
            }
            return ContainerUtil.map(SimpleDiffViewer.this.getNonSkippedDiffChanges(side), change -> DiffUtil.getLinesRange(editor.getDocument(), change.getStartLine(side), change.getEndLine(side)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyChangedRangeProvider", "getChangedRanges"));
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends SelectedChangesActionBase {
        @NotNull
        protected final Side myModifiedSide;

        ApplySelectedChangesActionBase(Side modifiedSide) {
            if (modifiedSide == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            this.myModifiedSide = modifiedSide;
        }

        @Override
        protected boolean isVisible(@NotNull Side side) {
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            if (!SimpleDiffViewer.this.isEditable(this.myModifiedSide)) {
                return false;
            }
            return !this.isBothEditable() || side == this.myModifiedSide.other();
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull Side side, @NotNull List<? extends SimpleDiffChange> changes) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(3);
            }
            if (changes == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(4);
            }
            if (!SimpleDiffViewer.this.isEditable(this.myModifiedSide)) {
                return;
            }
            String title = DiffBundle.message((String)"message.use.selected.changes.command", (Object[])new Object[]{e.getPresentation().getText()});
            DiffUtil.executeWriteCommand((Document)SimpleDiffViewer.this.getEditor(this.myModifiedSide).getDocument(), e.getProject(), title, () -> this.apply(changes));
        }

        protected boolean isBothEditable() {
            return SimpleDiffViewer.this.isEditable(Side.LEFT) && SimpleDiffViewer.this.isEditable(Side.RIGHT);
        }

        @RequiresWriteLock
        protected abstract void apply(@NotNull List<? extends SimpleDiffChange> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedSide";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doPerform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected abstract class SelectedChangesActionBase
    extends DumbAwareAction {
        protected SelectedChangesActionBase() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleDiffViewer.this.getEditors(), (Object)editor);
            if (side == null || !this.isVisible(side)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setText(this.getText(side));
            e.getPresentation().setIcon(this.getIcon(side));
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(SimpleDiffViewer.this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleDiffViewer.this.getEditors(), (Object)editor);
            if (side == null) {
                return;
            }
            List<SimpleDiffChange> selectedChanges = SimpleDiffViewer.this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, side, ContainerUtil.reverse(selectedChanges));
        }

        protected abstract boolean isVisible(@NotNull Side var1);

        @Nls
        @NotNull
        protected abstract String getText(@NotNull Side var1);

        @Nullable
        protected abstract Icon getIcon(@NotNull Side var1);

        @RequiresWriteLock
        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull Side var2, @NotNull List<? extends SimpleDiffChange> var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$SelectedChangesActionBase";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$SelectedChangesActionBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

