/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileDiffElement
extends DiffElement<VirtualFile> {
    private static final Logger LOGGER = Logger.getInstance(VirtualFileDiffElement.class);
    private final VirtualFile myFile;
    protected final VirtualFile myDiffRoot;

    public VirtualFileDiffElement(@NotNull VirtualFile file, @Nullable VirtualFile diffRoot) {
        if (file == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.myDiffRoot = diffRoot;
    }

    public VirtualFileDiffElement(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(1);
        }
        this(file, null);
    }

    public String getPath() {
        return this.myFile.getPresentableUrl();
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String getPresentablePath() {
        return this.getPath();
    }

    public long getSize() {
        return this.myFile.getLength();
    }

    public long getTimeStamp() {
        return this.myFile.getTimeStamp();
    }

    public boolean isContainer() {
        return this.myFile.isDirectory();
    }

    public VirtualFile getDiffRoot() {
        return this.myDiffRoot;
    }

    @Nullable
    public Navigatable getNavigatable(@Nullable Project project) {
        if (project == null || project.isDefault() || !this.myFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(project, this.myFile);
    }

    public VirtualFileDiffElement[] getChildren() {
        if (this.myFile.is(VFileProperty.SYMLINK)) {
            return new VirtualFileDiffElement[0];
        }
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<VirtualFileDiffElement> elements = new ArrayList<VirtualFileDiffElement>();
        for (VirtualFile file : files) {
            if (FileTypeManager.getInstance().isFileIgnored(file) || !file.isValid()) continue;
            elements.add(new VirtualFileDiffElement(file, this.myDiffRoot));
        }
        return elements.toArray(new VirtualFileDiffElement[0]);
    }

    public byte @Nullable [] getContent() throws IOException {
        return (byte[])ReadAction.compute(() -> this.myFile.contentsToByteArray());
    }

    @Nullable
    public InputStream getContentStream() throws IOException {
        return DiffUtil.getFileInputStream(this.myFile);
    }

    public VirtualFile getValue() {
        return this.myFile;
    }

    public Icon getIcon() {
        return this.isContainer() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)this.myFile);
    }

    public Callable<DiffElement<VirtualFile>> getElementChooser(Project project) {
        return () -> {
            FileChooserDescriptor descriptor = this.getChooserDescriptor();
            VirtualFile[] result = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)this.getValue());
            return result.length == 1 ? VirtualFileDiffElement.createElement(result[0], this.myDiffRoot) : null;
        };
    }

    @NotNull
    public static VirtualFileDiffElement createElement(VirtualFile file, VirtualFile diffRoot) {
        VirtualFile jar;
        if (file.getFileType() instanceof ArchiveFileType && file.getFileSystem() != JarFileSystem.getInstance() && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(file)) != null) {
            return new VirtualFileDiffElement(jar, diffRoot);
        }
        return new VirtualFileDiffElement(file, diffRoot);
    }

    public String getFilterablePath() {
        if (this.myDiffRoot == null) {
            return super.getFilterablePath();
        }
        String path = this.myFile.getPath();
        if (this.myFile.equals(this.myDiffRoot)) {
            return path;
        }
        String rootPath = this.myDiffRoot.getPath();
        String relativePath = path;
        if (path.startsWith(rootPath) && rootPath.length() + 1 <= path.length()) {
            String rawRelativePath = path.substring(rootPath.length());
            relativePath = rawRelativePath.startsWith("!") ? rawRelativePath.substring(2) : rawRelativePath.substring(1);
        }
        return relativePath;
    }

    protected FileChooserDescriptor getChooserDescriptor() {
        return new FileChooserDescriptor(true, true, true, true, false, false).withExtensionFilter((FileType)ArchiveFileType.INSTANCE);
    }

    public boolean isOperationsEnabled() {
        return this.myFile.getFileSystem() instanceof LocalFileSystem;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myFile.getCharset();
        if (charset == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(3);
        }
        return charset;
    }

    public FileType getFileType() {
        return this.myFile.getFileType();
    }

    public VirtualFileDiffElement copyTo(DiffElement<VirtualFile> container, String relativePath) {
        try {
            File src = new File(this.myFile.getPath());
            Path targetPath = Paths.get(((VirtualFile)container.getValue()).getPath(), relativePath, src.getName());
            File trg = targetPath.toFile();
            FileUtil.copy((File)src, (File)trg);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(trg);
            if (virtualFile != null) {
                VirtualFile diffRoot = container instanceof VirtualFileDiffElement ? ((VirtualFileDiffElement)container).getDiffRoot() : null;
                return new VirtualFileDiffElement(virtualFile, diffRoot);
            }
        }
        catch (InvalidPathException e) {
            LOGGER.error((Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean delete() {
        try {
            this.myFile.delete((Object)this);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void refresh(boolean userInitiated) {
        VirtualFileDiffElement.refreshFile(userInitiated, this.myFile);
    }

    public static void refreshFile(boolean userInitiated, VirtualFile virtualFile) {
        if (userInitiated) {
            ArrayList<Document> docsToSave = new ArrayList<Document>();
            FileDocumentManager manager = FileDocumentManager.getInstance();
            for (Document document : manager.getUnsavedDocuments()) {
                VirtualFile file = manager.getFile(document);
                if (file == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)false)) continue;
                docsToSave.add(document);
            }
            if (!docsToSave.isEmpty()) {
                WriteAction.runAndWait(() -> {
                    for (Document document : docsToSave) {
                        manager.saveDocument(document);
                    }
                });
            }
            ModalityState modalityState = ProgressManager.getInstance().getProgressIndicator().getModalityState();
            VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
            RefreshQueue.getInstance().refresh(false, true, null, modalityState, new VirtualFile[]{virtualFile});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/diff/VirtualFileDiffElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/diff/VirtualFileDiffElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

