/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffRangeUtil;
import com.intellij.diff.util.LinesRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\f\b\u0002\u0018\u0000 >2\u00020\u0001:\u0003<=>B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001c\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u0010\u001d\u001a\u00020\fJ?\u0010\u001e\u001a\u00020\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032'\u0010 \u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001c0\u0003\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u001f0!H\u0002J\u0018\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0018\u0010(\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001cH\u0002J9\u0010)\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032!\u0010*\u001a\u001d\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u001f0!H\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010\u001c2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u0010/\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u00101\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0016\u00102\u001a\u0002032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0003H\u0002J6\u00104\u001a\u0002032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0003H\u0002J \u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u000203H\u0002J\u001e\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u001c2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0003H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006?"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher;", "", "handlers", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "forceMergeNearbyBlocks", "", "<init>", "(Ljava/util/List;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/tools/util/text/LineOffsets;Lcom/intellij/diff/tools/util/text/LineOffsets;Z)V", "getHandlers", "()Ljava/util/List;", "getText1", "()Ljava/lang/CharSequence;", "getText2", "getLineOffsets1", "()Lcom/intellij/diff/tools/util/text/LineOffsets;", "getLineOffsets2", "getForceMergeNearbyBlocks", "()Z", "refresh", "Lcom/intellij/openapi/vcs/ex/BlocksRefresher$Result;", "blocks", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "fastRefresh", "processMergeableGroups", "", "processGroup", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "group", "shouldMergeBlocks", "block1", "block2", "isWhitespaceOnlySeparated", "processMergedBlocks", "processBlock", "Lcom/intellij/openapi/vcs/ex/BlocksRefresher$MergedBlock;", "merged", "mergeBlocks", "refreshMergedBlock", "mergedBlock", "refreshBlock", "block", "calcSize", "", "calcNonWhitespaceSize", "isWhitespaceLine", "text", "lineOffsets", "line", "onRangeRefreshed", "before", "after", "Result", "MergedBlock", "Companion", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nDocumentTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/BlocksRefresher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1363:1\n1374#2:1364\n1460#2,5:1365\n1563#2:1370\n1634#2,3:1371\n1869#2,2:1374\n1761#2,3:1376\n*S KotlinDebug\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/BlocksRefresher\n*L\n1122#1:1364\n1122#1:1365,5\n1163#1:1370\n1163#1:1371,3\n1201#1:1374,2\n1024#1:1376,3\n*E\n"})
final class BlocksRefresher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DocumentTracker.Handler> handlers;
    @NotNull
    private final CharSequence text1;
    @NotNull
    private final CharSequence text2;
    @NotNull
    private final LineOffsets lineOffsets1;
    @NotNull
    private final LineOffsets lineOffsets2;
    private final boolean forceMergeNearbyBlocks;
    private static final int NEARBY_BLOCKS_LINES = 30;

    public BlocksRefresher(@NotNull List<? extends DocumentTracker.Handler> handlers, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, boolean forceMergeNearbyBlocks) {
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkNotNullParameter((Object)lineOffsets2, (String)"lineOffsets2");
        this.handlers = handlers;
        this.text1 = text1;
        this.text2 = text2;
        this.lineOffsets1 = lineOffsets1;
        this.lineOffsets2 = lineOffsets2;
        this.forceMergeNearbyBlocks = forceMergeNearbyBlocks;
    }

    @NotNull
    public final List<DocumentTracker.Handler> getHandlers() {
        return this.handlers;
    }

    @NotNull
    public final CharSequence getText1() {
        return this.text1;
    }

    @NotNull
    public final CharSequence getText2() {
        return this.text2;
    }

    @NotNull
    public final LineOffsets getLineOffsets1() {
        return this.lineOffsets1;
    }

    @NotNull
    public final LineOffsets getLineOffsets2() {
        return this.lineOffsets2;
    }

    public final boolean getForceMergeNearbyBlocks() {
        return this.forceMergeNearbyBlocks;
    }

    @NotNull
    public final Result refresh(@NotNull List<DocumentTracker.Block> blocks, boolean fastRefresh) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        ArrayList newBlocks = new ArrayList();
        this.processMergeableGroups(blocks, (Function1<? super List<DocumentTracker.Block>, Unit>)((Function1)arg_0 -> BlocksRefresher.refresh$lambda$0(this, newBlocks, fastRefresh, arg_0)));
        return new Result(newBlocks);
    }

    private final void processMergeableGroups(List<DocumentTracker.Block> blocks, Function1<? super List<DocumentTracker.Block>, Unit> processGroup) {
        int i;
        if (blocks.isEmpty()) {
            return;
        }
        int blockStart = 0;
        for (i = 0; i < blocks.size() - 1; ++i) {
            if (this.shouldMergeBlocks(blocks.get(i), blocks.get(i + 1))) continue;
            processGroup.invoke(blocks.subList(blockStart, i + 1));
            blockStart = i + 1;
        }
        processGroup.invoke(blocks.subList(blockStart, i + 1));
    }

    private final boolean shouldMergeBlocks(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        if (this.forceMergeNearbyBlocks && block2.getRange().start2 - block1.getRange().end2 < 30) {
            return true;
        }
        return this.isWhitespaceOnlySeparated(block1, block2);
    }

    private final boolean isWhitespaceOnlySeparated(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        int end;
        LinesRange range1 = DiffRangeUtil.getLinesRange((LineOffsets)this.lineOffsets1, (int)block1.getRange().start1, (int)block1.getRange().end1, (boolean)false);
        LinesRange range2 = DiffRangeUtil.getLinesRange((LineOffsets)this.lineOffsets1, (int)block2.getRange().start1, (int)block2.getRange().end1, (boolean)false);
        int start = range1.getEndOffset();
        return TrimUtil.trimStart((CharSequence)this.text1, (int)start, (int)(end = range2.getStartOffset())) == end;
    }

    private final void processMergedBlocks(List<DocumentTracker.Block> group, Function1<? super MergedBlock, Unit> processBlock) {
        boolean bl;
        boolean bl2 = bl = !group.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        DocumentTracker.Block merged = null;
        List original = new ArrayList();
        for (DocumentTracker.Block block : group) {
            if (merged == null) {
                merged = block;
                ((Collection)original).add(block);
                continue;
            }
            DocumentTracker.Block newMerged = this.mergeBlocks(merged, block);
            if (newMerged != null) {
                merged = newMerged;
                ((Collection)original).add(block);
                continue;
            }
            processBlock.invoke((Object)new MergedBlock(merged, CollectionsKt.toList((Iterable)original)));
            original.clear();
            merged = block;
            ((Collection)original).add(merged);
        }
        DocumentTracker.Block block = merged;
        Intrinsics.checkNotNull(block);
        processBlock.invoke((Object)new MergedBlock(block, CollectionsKt.toList((Iterable)original)));
    }

    private final DocumentTracker.Block mergeBlocks(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        boolean isDirty = block1.isDirty$intellij_platform_diff_impl() || block2.isDirty$intellij_platform_diff_impl();
        boolean isTooBig = block1.isTooBig$intellij_platform_diff_impl() || block2.isTooBig$intellij_platform_diff_impl();
        Range range = new Range(block1.getRange().start1, block2.getRange().end1, block1.getRange().start2, block2.getRange().end2);
        DocumentTracker.Block merged = new DocumentTracker.Block(range, isDirty, isTooBig);
        for (DocumentTracker.Handler handler : this.handlers) {
            boolean success = handler.mergeRanges(block1, block2, merged);
            if (success) continue;
            return null;
        }
        return merged;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocumentTracker.Block> refreshMergedBlock(MergedBlock mergedBlock, boolean fastRefresh) {
        int newTotalSize;
        int newSize;
        void $this$flatMapTo$iv$iv;
        List<DocumentTracker.Block> freshBlocks = this.refreshBlock(mergedBlock.getMerged(), fastRefresh);
        if (mergedBlock.getOriginal().size() == 1) {
            return freshBlocks;
        }
        if (!this.forceMergeNearbyBlocks) {
            return freshBlocks;
        }
        Iterable $this$flatMap$iv = mergedBlock.getOriginal();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DocumentTracker.Block block = (DocumentTracker.Block)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = block.isDirty$intellij_platform_diff_impl() ? this.refreshBlock(block, fastRefresh) : CollectionsKt.listOf((Object)block);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List nonMergedFreshBlocks = (List)destination$iv$iv;
        int oldSize = this.calcNonWhitespaceSize(this.text1, this.text2, this.lineOffsets1, this.lineOffsets2, nonMergedFreshBlocks);
        if (oldSize < (newSize = this.calcNonWhitespaceSize(this.text1, this.text2, this.lineOffsets1, this.lineOffsets2, freshBlocks))) {
            return nonMergedFreshBlocks;
        }
        if (oldSize > newSize) {
            return freshBlocks;
        }
        int oldTotalSize = this.calcSize(nonMergedFreshBlocks);
        if (oldTotalSize <= (newTotalSize = this.calcSize(freshBlocks))) {
            return nonMergedFreshBlocks;
        }
        return freshBlocks;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocumentTracker.Block> refreshBlock(DocumentTracker.Block block, boolean fastRefresh) {
        void $this$mapTo$iv$iv;
        if (block.getRange().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        FairDiffIterable iterable = null;
        boolean isTooBig = false;
        if (block.isTooBig$intellij_platform_diff_impl() && fastRefresh) {
            iterable = RangesBuilder.fastCompareLines(block.getRange(), this.text1, this.text2, this.lineOffsets1, this.lineOffsets2);
            isTooBig = true;
        } else {
            FairDiffIterable realIterable = RangesBuilder.tryCompareLines(block.getRange(), this.text1, this.text2, this.lineOffsets1, this.lineOffsets2);
            if (realIterable != null) {
                iterable = realIterable;
                isTooBig = false;
            } else {
                iterable = RangesBuilder.fastCompareLines(block.getRange(), this.text1, this.text2, this.lineOffsets1, this.lineOffsets2);
                isTooBig = true;
            }
        }
        Iterable $this$map$iv = iterable.iterateChanges();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Range range = (Range)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DocumentTracker.Block(DocumentTrackerKt.access$shiftRange((Range)it, block.getRange().start1, block.getRange().start2), false, isTooBig));
        }
        return (List)destination$iv$iv;
    }

    private final int calcSize(List<DocumentTracker.Block> blocks) {
        int result = 0;
        for (DocumentTracker.Block block : blocks) {
            result += block.getRange().end1 - block.getRange().start1;
            result += block.getRange().end2 - block.getRange().start2;
        }
        return result;
    }

    private final int calcNonWhitespaceSize(CharSequence text1, CharSequence text2, LineOffsets lineOffsets1, LineOffsets lineOffsets2, List<DocumentTracker.Block> blocks) {
        int result = 0;
        for (DocumentTracker.Block block : blocks) {
            int line;
            int n = block.getRange().end1;
            for (line = block.getRange().start1; line < n; ++line) {
                if (this.isWhitespaceLine(text1, lineOffsets1, line)) continue;
                ++result;
            }
            n = block.getRange().end2;
            for (line = block.getRange().start2; line < n; ++line) {
                if (this.isWhitespaceLine(text2, lineOffsets2, line)) continue;
                ++result;
            }
        }
        return result;
    }

    private final boolean isWhitespaceLine(CharSequence text, LineOffsets lineOffsets, int line) {
        int end;
        int start = lineOffsets.getLineStart(line);
        return TrimUtil.trimStart((CharSequence)text, (int)start, (int)(end = lineOffsets.getLineEnd(line))) == end;
    }

    private final void onRangeRefreshed(DocumentTracker.Block before, List<DocumentTracker.Block> after) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.onRangeRefreshed(before, after);
        }
    }

    private static final Unit refresh$lambda$0(BlocksRefresher this$0, ArrayList $newBlocks, boolean $fastRefresh, List group) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Iterable $this$any$iv = group;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
                    boolean bl2 = false;
                    if (!it.isDirty$intellij_platform_diff_impl()) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this$0.processMergedBlocks(group, (Function1<? super MergedBlock, Unit>)((Function1)arg_0 -> BlocksRefresher.refresh$lambda$0$1(this$0, $fastRefresh, $newBlocks, arg_0)));
        } else {
            $newBlocks.addAll(group);
        }
        return Unit.INSTANCE;
    }

    private static final Unit refresh$lambda$0$1(BlocksRefresher this$0, boolean $fastRefresh, ArrayList $newBlocks, MergedBlock mergedBlock) {
        Intrinsics.checkNotNullParameter((Object)mergedBlock, (String)"mergedBlock");
        List<DocumentTracker.Block> freshBlocks = this$0.refreshMergedBlock(mergedBlock, $fastRefresh);
        this$0.onRangeRefreshed(mergedBlock.getMerged(), freshBlocks);
        $newBlocks.addAll((Collection)freshBlocks);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher$Companion;", "", "<init>", "()V", "NEARBY_BLOCKS_LINES", "", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher$MergedBlock;", "", "merged", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "original", "", "<init>", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "getMerged", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getOriginal", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
    public static final class MergedBlock {
        @NotNull
        private final DocumentTracker.Block merged;
        @NotNull
        private final List<DocumentTracker.Block> original;

        public MergedBlock(@NotNull DocumentTracker.Block merged, @NotNull List<DocumentTracker.Block> original) {
            Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
            Intrinsics.checkNotNullParameter(original, (String)"original");
            this.merged = merged;
            this.original = original;
        }

        @NotNull
        public final DocumentTracker.Block getMerged() {
            return this.merged;
        }

        @NotNull
        public final List<DocumentTracker.Block> getOriginal() {
            return this.original;
        }

        @NotNull
        public final DocumentTracker.Block component1() {
            return this.merged;
        }

        @NotNull
        public final List<DocumentTracker.Block> component2() {
            return this.original;
        }

        @NotNull
        public final MergedBlock copy(@NotNull DocumentTracker.Block merged, @NotNull List<DocumentTracker.Block> original) {
            Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
            Intrinsics.checkNotNullParameter(original, (String)"original");
            return new MergedBlock(merged, original);
        }

        public static /* synthetic */ MergedBlock copy$default(MergedBlock mergedBlock, DocumentTracker.Block block, List list, int n, Object object) {
            if ((n & 1) != 0) {
                block = mergedBlock.merged;
            }
            if ((n & 2) != 0) {
                list = mergedBlock.original;
            }
            return mergedBlock.copy(block, list);
        }

        @NotNull
        public String toString() {
            return "MergedBlock(merged=" + this.merged + ", original=" + this.original + ")";
        }

        public int hashCode() {
            int result = this.merged.hashCode();
            result = result * 31 + ((Object)this.original).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MergedBlock)) {
                return false;
            }
            MergedBlock mergedBlock = (MergedBlock)other;
            if (!Intrinsics.areEqual((Object)this.merged, (Object)mergedBlock.merged)) {
                return false;
            }
            return Intrinsics.areEqual(this.original, mergedBlock.original);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher$Result;", "", "newBlocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "<init>", "(Ljava/util/List;)V", "getNewBlocks", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
    public static final class Result {
        @NotNull
        private final List<DocumentTracker.Block> newBlocks;

        public Result(@NotNull List<DocumentTracker.Block> newBlocks) {
            Intrinsics.checkNotNullParameter(newBlocks, (String)"newBlocks");
            this.newBlocks = newBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getNewBlocks() {
            return this.newBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component1() {
            return this.newBlocks;
        }

        @NotNull
        public final Result copy(@NotNull List<DocumentTracker.Block> newBlocks) {
            Intrinsics.checkNotNullParameter(newBlocks, (String)"newBlocks");
            return new Result(newBlocks);
        }

        public static /* synthetic */ Result copy$default(Result result, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = result.newBlocks;
            }
            return result.copy(list);
        }

        @NotNull
        public String toString() {
            return "Result(newBlocks=" + this.newBlocks + ")";
        }

        public int hashCode() {
            return ((Object)this.newBlocks).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            return Intrinsics.areEqual(this.newBlocks, result.newBlocks);
        }
    }
}

