/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.BlockI;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.LineTracker;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 Z2\u00020\u0001:\tRSTUVWXYZB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000bH\u0007J\u001f\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u0002H#\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%\u00a2\u0006\u0002\u0010&J\u0006\u0010*\u001a\u00020\u0015J\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0007J\u001a\u0010/\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0%H\u0087\b\u00f8\u0001\u0000J\"\u0010/\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0%H\u0087\b\u00f8\u0001\u0000J\u000e\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020-J\u0018\u00102\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u00103\u001a\u00020\u0003H\u0007J\u001a\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u00152\b\b\u0002\u00106\u001a\u00020\u0015H\u0007J\u0018\u0010.\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u00107\u001a\u000201H\u0002J\b\u00108\u001a\u00020\u001aH\u0007J\u0010\u00108\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0002J$\u00109\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020<0;H\u0007JM\u00109\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020<0;2'\u0010=\u001a#\u0012\u0004\u0012\u00020?\u0012\u0013\u0012\u00110@\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(C\u0012\u0004\u0012\u00020\u001a0>H\u0007J$\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010,\u001a\u00020-2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020<0;J\u001e\u0010F\u001a\b\u0012\u0004\u0012\u00020?0\u001e2\u0006\u0010G\u001a\u00020?2\u0006\u0010H\u001a\u00020IH\u0002J\u001c\u0010J\u001a\u00020\u001a2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020M0LH\u0007J$\u0010N\u001a\u00020\u00152\u0006\u0010O\u001a\u0002012\u0006\u0010P\u001a\u0002012\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020?0\u001eJ\u0016\u0010N\u001a\u00020\u00152\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020?0\u001eH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010(\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006["}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "Lcom/intellij/openapi/Disposable;", "document1", "Lcom/intellij/openapi/editor/Document;", "document2", "LOCK", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;)V", "handlers", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "value", "getDocument1", "()Lcom/intellij/openapi/editor/Document;", "getDocument2", "tracker", "Lcom/intellij/openapi/vcs/ex/LineTracker;", "freezeHelper", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeHelper;", "isDisposed", "", "documentListener1", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$MyDocumentListener;", "documentListener2", "dispose", "", "addHandler", "newHandler", "blocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getBlocks", "()Ljava/util/List;", "readLock", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "writeLock", "isLockHeldByCurrentThread", "()Z", "isFrozen", "freeze", "side", "Lcom/intellij/diff/util/Side;", "unfreeze", "doFrozen", "getContent", "", "replaceDocument", "newDocument", "refreshDirty", "fastRefresh", "forceInFrozen", "oldText", "updateFrozenContentIfNeeded", "partiallyApplyBlocks", "condition", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "consumer", "Lkotlin/Function2;", "Lcom/intellij/diff/util/Range;", "", "Lkotlin/ParameterName;", "name", "shift", "getContentWithPartiallyAppliedBlocks", "", "toIncludedRanges", "range", "exclusionState", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState$Partial;", "recreateBlocks", "map", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;", "setFrozenState", "content1", "content2", "lineRanges", "MyApplicationListener", "MyDocumentListener", "FreezeHelper", "FreezeData", "Lock", "Handler", "Block", "BlockData", "Companion", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nDocumentTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker\n+ 2 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$Lock\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1363:1\n134#1,3:1370\n134#1,8:1373\n139#1,3:1381\n125#1,17:1385\n134#1,3:1404\n139#1,3:1409\n544#2:1364\n540#2:1365\n544#2:1366\n540#2:1367\n544#2:1368\n544#2:1369\n540#2:1384\n544#2:1402\n544#2:1407\n544#2:1408\n544#2:1422\n544#2:1423\n544#2:1424\n13#3:1403\n1374#4:1412\n1460#4,5:1413\n1563#4:1418\n1634#4,3:1419\n*S KotlinDebug\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker\n*L\n125#1:1370,3\n126#1:1373,8\n125#1:1381,3\n155#1:1385,17\n246#1:1404,3\n246#1:1409,3\n87#1:1364\n100#1:1365\n101#1:1366\n105#1:1367\n111#1:1368\n118#1:1369\n144#1:1384\n173#1:1402\n247#1:1407\n264#1:1408\n311#1:1422\n323#1:1423\n339#1:1424\n192#1:1403\n280#1:1412\n280#1:1413,5\n288#1:1418\n288#1:1419,3\n*E\n"})
public final class DocumentTracker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lock LOCK;
    @NotNull
    private final List<Handler> handlers;
    @NotNull
    private Document document1;
    @NotNull
    private Document document2;
    @NotNull
    private final LineTracker tracker;
    @NotNull
    private final FreezeHelper freezeHelper;
    private boolean isDisposed;
    @NotNull
    private final MyDocumentListener documentListener1;
    @NotNull
    private final MyDocumentListener documentListener2;
    @NotNull
    private static final Logger LOG;

    public DocumentTracker(@NotNull Document document1, @NotNull Document document2, @NotNull Lock LOCK) {
        List list;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)document1, (String)"document1");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document2");
        Intrinsics.checkNotNullParameter((Object)LOCK, (String)"LOCK");
        this.LOCK = LOCK;
        this.handlers = new ArrayList();
        this.document1 = document1;
        this.document2 = document2;
        this.freezeHelper = new FreezeHelper();
        this.documentListener1 = new MyDocumentListener(Side.LEFT, document1);
        this.documentListener2 = new MyDocumentListener(Side.RIGHT, document2);
        boolean bl2 = bl = !Intrinsics.areEqual((Object)document1, (Object)document2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (document1.getImmutableCharSequence() == document2.getImmutableCharSequence()) {
            list = CollectionsKt.emptyList();
        } else {
            CharSequence charSequence = document1.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            CharSequence charSequence2 = document2.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
            list = CollectionsKt.toList((Iterable)RangesBuilder.compareLines(charSequence, charSequence2, RangesBuilder.getLineOffsets(document1), RangesBuilder.getLineOffsets(document2)).iterateChanges());
        }
        List changes = list;
        this.tracker = new LineTracker(this.handlers, changes);
        Application application = ApplicationManager.getApplication();
        application.addApplicationListener((ApplicationListener)new MyApplicationListener(), (Disposable)this);
    }

    public /* synthetic */ DocumentTracker(Document document, Document document2, Lock lock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            lock = new Lock();
        }
        this(document, document2, lock);
    }

    @NotNull
    public final Document getDocument1() {
        return this.document1;
    }

    @NotNull
    public final Document getDocument2() {
        return this.document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public void dispose() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            this.tracker.destroy();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @RequiresEdt
    public final void addHandler(@NotNull Handler newHandler) {
        Intrinsics.checkNotNullParameter((Object)newHandler, (String)"newHandler");
        this.handlers.add(newHandler);
    }

    @NotNull
    public final List<Block> getBlocks() {
        return this.tracker.getBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readLock(@NotNull Function0<? extends T> task) {
        Object object;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            object = task.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T writeLock(@NotNull Function0<? extends T> task) {
        Object object;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            object = task.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public final boolean isLockHeldByCurrentThread() {
        return this.LOCK.isHeldByCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFrozen() {
        Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.freezeHelper.isFrozen();
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void freeze(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            this.freezeHelper.freeze(side);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void unfreeze(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            this.freezeHelper.unfreeze(side);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void doFrozen(@NotNull Function0<Unit> task) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        boolean $i$f$doFrozen = false;
        DocumentTracker documentTracker = this;
        Side side$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv.freeze(side$iv);
        try {
            void this_$iv2;
            boolean bl = false;
            DocumentTracker documentTracker2 = this;
            Side side$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv2.freeze(side$iv2);
            try {
                boolean bl2 = false;
                task.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this_$iv2.unfreeze(side$iv2);
                InlineMarker.finallyEnd((int)1);
            }
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this_$iv.unfreeze(side$iv);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void doFrozen(@NotNull Side side, @NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        boolean $i$f$doFrozen = false;
        this.freeze(side);
        try {
            task.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.unfreeze(side);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CharSequence getContent(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            CharSequence frozenContent = this.freezeHelper.getFrozenContent(side);
            if (frozenContent != null) {
                CharSequence charSequence = frozenContent;
                return charSequence;
            }
            CharSequence charSequence = RangesBuilder.get(side, this.document1, this.document2).getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            CharSequence charSequence2 = charSequence;
            return charSequence2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void replaceDocument(@NotNull Side side, @NotNull Document newDocument) {
        void this_$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)newDocument, (String)"newDocument");
        boolean bl2 = bl = !this.LOCK.isHeldByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        DocumentTracker this_$iv = this;
        boolean $i$f$doFrozen = false;
        DocumentTracker documentTracker = this_$iv;
        Side side$iv$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv$iv.freeze(side$iv$iv);
        try {
            void this_$iv$iv2;
            boolean bl3 = false;
            DocumentTracker documentTracker2 = this_$iv;
            Side side$iv$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv$iv2.freeze(side$iv$iv2);
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                if (side.isLeft()) {
                    this.documentListener1.switchDocument(newDocument);
                    this.document1 = newDocument;
                } else {
                    this.documentListener2.switchDocument(newDocument);
                    this.document2 = newDocument;
                }
            }
            finally {
                this_$iv$iv2.unfreeze(side$iv$iv2);
            }
        }
        finally {
            this_$iv$iv.unfreeze(side$iv$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void refreshDirty(boolean fastRefresh, boolean forceInFrozen) {
        if (this.isDisposed) {
            return;
        }
        if (!forceInFrozen && this.freezeHelper.isFrozen()) {
            return;
        }
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            if (this.tracker.isDirty() && !((Collection)this.getBlocks()).isEmpty() && StringUtil.equals((CharSequence)this.document1.getImmutableCharSequence(), (CharSequence)this.document2.getImmutableCharSequence())) {
                this.tracker.setRanges(CollectionsKt.emptyList(), false);
                return;
            }
            try {
                CharSequence charSequence = this.document1.getImmutableCharSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
                CharSequence charSequence2 = this.document2.getImmutableCharSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
                this.tracker.refreshDirty(charSequence, charSequence2, RangesBuilder.getLineOffsets(this.document1), RangesBuilder.getLineOffsets(this.document2), fastRefresh);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(DocumentTracker.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("document1: " + this.document1 + ", document2: " + this.document2 + ", isFrozen1: " + this.freezeHelper.isFrozen(Side.LEFT) + ", isFrozen2: " + this.freezeHelper.isFrozen(Side.RIGHT) + ", isBulk1: " + this.document1.isInBulkUpdate() + ", isBulk2: " + this.document2.isInBulkUpdate(), e);
                this.tracker.resetTrackerState(DiffUtil.getLineCount(this.document1), DiffUtil.getLineCount(this.document2));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void refreshDirty$default(DocumentTracker documentTracker, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        documentTracker.refreshDirty(bl, bl2);
    }

    private final void unfreeze(Side side, CharSequence oldText) {
        boolean bl = this.LOCK.isHeldByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.isDisposed) {
            return;
        }
        Document newText = RangesBuilder.get(side, this.document1, this.document2);
        CharSequence charSequence = newText.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        FairDiffIterable iterable = RangesBuilder.compareLines(oldText, charSequence, RangesBuilder.getLineOffsets(oldText), RangesBuilder.getLineOffsets(newText));
        if (iterable.changes().hasNext()) {
            this.tracker.rangesChanged(side, iterable);
        }
    }

    @RequiresEdt
    public final void updateFrozenContentIfNeeded() {
        this.updateFrozenContentIfNeeded(Side.LEFT);
        this.updateFrozenContentIfNeeded(Side.RIGHT);
        this.refreshDirty(false, true);
    }

    private final void updateFrozenContentIfNeeded(Side side) {
        boolean bl = this.LOCK.isHeldByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!this.freezeHelper.isFrozen(side)) {
            return;
        }
        CharSequence charSequence = this.freezeHelper.getFrozenContent(side);
        Intrinsics.checkNotNull((Object)charSequence);
        this.unfreeze(side, charSequence);
        CharSequence charSequence2 = RangesBuilder.get(side, this.document1, this.document2).getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
        this.freezeHelper.setFrozenContent(side, charSequence2);
    }

    @RequiresEdt
    public final void partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super Block, ? extends RangeExclusionState> condition) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        this.partiallyApplyBlocks(side, condition, (Function2<? super Range, ? super Integer, Unit>)((Function2)DocumentTracker::partiallyApplyBlocks$lambda$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super Block, ? extends RangeExclusionState> condition, @NotNull Function2<? super Range, ? super Integer, Unit> consumer) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.isDisposed) {
            return;
        }
        Side otherSide = side.other();
        Document document = RangesBuilder.get(side, this.document1, this.document2);
        Document otherDocument = RangesBuilder.get(otherSide, this.document1, this.document2);
        DocumentTracker documentTracker = this;
        Side side$iv = side;
        boolean $i$f$doFrozen = false;
        this_$iv.freeze(side$iv);
        try {
            List<Range> list;
            boolean bl = false;
            Lock this_$iv2 = this.LOCK;
            boolean $i$f$write = false;
            java.util.concurrent.locks.Lock lock = this_$iv2.getMyLock();
            lock.lock();
            try {
                boolean bl2 = false;
                this.updateFrozenContentIfNeeded();
                list = this.tracker.partiallyApplyBlocks(side, condition);
            }
            finally {
                lock.unlock();
            }
            List<Range> appliedRanges = list;
            int shift = 0;
            for (Range range : appliedRanges) {
                DiffUtil.applyModification(document, RangesBuilder.start(range, side) + shift, RangesBuilder.end(range, side) + shift, otherDocument, RangesBuilder.start(range, otherSide), RangesBuilder.end(range, otherSide));
                consumer.invoke((Object)range, (Object)shift);
                shift += DocumentTrackerKt.access$getRangeDelta(range, side);
            }
            Lock this_$iv3 = this.LOCK;
            boolean $i$f$write2 = false;
            java.util.concurrent.locks.Lock lock2 = this_$iv3.getMyLock();
            lock2.lock();
            try {
                boolean bl3 = false;
                CharSequence charSequence = document.getImmutableCharSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
                this.freezeHelper.setFrozenContent(side, charSequence);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }
        finally {
            this_$iv.unfreeze(side$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getContentWithPartiallyAppliedBlocks(@NotNull Side side, @NotNull Function1<? super Block, ? extends RangeExclusionState> condition) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        if (this.isDisposed) {
            return null;
        }
        Side otherSide = side.other();
        CharSequence content = this.getContent(side);
        CharSequence otherContent = this.getContent(otherSide);
        LineOffsets lineOffsets = RangesBuilder.getLineOffsets(content);
        LineOffsets otherLineOffsets = RangesBuilder.getLineOffsets(otherContent);
        Iterable $this$flatMap$iv = this.tracker.getBlocks();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<Range> list;
            Block block = (Block)element$iv$iv;
            boolean bl = false;
            RangeExclusionState exclusionState = (RangeExclusionState)condition.invoke((Object)block);
            RangeExclusionState rangeExclusionState = exclusionState;
            if (Intrinsics.areEqual((Object)rangeExclusionState, (Object)RangeExclusionState.Included.INSTANCE)) {
                list = CollectionsKt.listOf((Object)block.getRange());
            } else if (Intrinsics.areEqual((Object)rangeExclusionState, (Object)RangeExclusionState.Excluded.INSTANCE)) {
                list = CollectionsKt.emptyList();
            } else if (rangeExclusionState instanceof RangeExclusionState.Partial) {
                list = this.toIncludedRanges(block.getRange(), (RangeExclusionState.Partial)exclusionState);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void range;
            list$iv$iv = (Range)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Range(RangesBuilder.start((Range)range, side), RangesBuilder.end((Range)range, side), RangesBuilder.start((Range)range, otherSide), RangesBuilder.end((Range)range, otherSide)));
        }
        List ranges = (List)destination$iv$iv;
        return DiffUtil.applyModification(content, lineOffsets, otherContent, otherLineOffsets, ranges);
    }

    private final List<Range> toIncludedRanges(Range range, RangeExclusionState.Partial exclusionState) {
        List result = new ArrayList();
        exclusionState.iterateIncludedDeletionRanges(range, (Function1<? super Range, Unit>)((Function1)arg_0 -> DocumentTracker.toIncludedRanges$lambda$0(result, arg_0)));
        exclusionState.iterateIncludedAdditionRanges(range, (Function1<? super Range, Unit>)((Function1)arg_0 -> DocumentTracker.toIncludedRanges$lambda$1(result, arg_0)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final void recreateBlocks(@NotNull Map<Range, ? extends BlockData> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            Object object = new Comparator(){

                public final int compare(T a, T b) {
                    Range it = (Range)a;
                    boolean bl = false;
                    it = (Range)b;
                    Comparable comparable = Integer.valueOf(it.start1);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.start1));
                }
            };
            object = new Comparator((Comparator)object){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        Range it = (Range)a;
                        boolean bl = false;
                        it = (Range)b;
                        Comparable comparable = Integer.valueOf(it.end1);
                        bl = false;
                        n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.end1));
                    }
                    return n;
                }
            };
            object = new Comparator((Comparator)object){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        Range it = (Range)a;
                        boolean bl = false;
                        it = (Range)b;
                        Comparable comparable = Integer.valueOf(it.start2);
                        bl = false;
                        n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.start2));
                    }
                    return n;
                }
            };
            this.tracker.setRanges(CollectionsKt.sortedWith((Iterable)CollectionsKt.toList((Iterable)map.keySet()), (Comparator)new Comparator((Comparator)object){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        Range it = (Range)a;
                        boolean bl = false;
                        it = (Range)b;
                        Comparable comparable = Integer.valueOf(it.end2);
                        bl = false;
                        n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.end2));
                    }
                    return n;
                }
            }), false);
            for (Block block : this.tracker.getBlocks()) {
                block.setData(map.get(block.getRange()));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFrozenState(@NotNull CharSequence content1, @NotNull CharSequence content2, @NotNull List<Range> lineRanges) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)content1, (String)"content1");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content2");
        Intrinsics.checkNotNullParameter(lineRanges, (String)"lineRanges");
        boolean bl2 = bl = this.freezeHelper.isFrozen(Side.LEFT) && this.freezeHelper.isFrozen(Side.RIGHT);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.isDisposed) {
            return false;
        }
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl3 = false;
            if (!RangesBuilder.isValidRanges(content1, content2, RangesBuilder.getLineOffsets(content1), RangesBuilder.getLineOffsets(content2), lineRanges)) {
                boolean bl4 = false;
                return bl4;
            }
            this.freezeHelper.setFrozenContent(Side.LEFT, content1);
            this.freezeHelper.setFrozenContent(Side.RIGHT, content2);
            this.tracker.setRanges(lineRanges, true);
            boolean bl5 = true;
            return bl5;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final boolean setFrozenState(@NotNull List<Range> lineRanges) {
        boolean bl;
        Intrinsics.checkNotNullParameter(lineRanges, (String)"lineRanges");
        if (this.isDisposed) {
            return false;
        }
        boolean bl2 = bl = this.freezeHelper.isFrozen(Side.LEFT) && this.freezeHelper.isFrozen(Side.RIGHT);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl3 = false;
            CharSequence content1 = this.getContent(Side.LEFT);
            CharSequence content2 = this.getContent(Side.RIGHT);
            if (!RangesBuilder.isValidRanges(content1, content2, RangesBuilder.getLineOffsets(content1), RangesBuilder.getLineOffsets(content2), lineRanges)) {
                boolean bl4 = false;
                return bl4;
            }
            this.tracker.setRanges(lineRanges, true);
            boolean bl5 = true;
            return bl5;
        }
        finally {
            lock.unlock();
        }
    }

    private static final Unit partiallyApplyBlocks$lambda$0(Range range, int n) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit toIncludedRanges$lambda$0(List $result, Range deletedRange) {
        Intrinsics.checkNotNullParameter((Object)deletedRange, (String)"deletedRange");
        ((Collection)$result).add(deletedRange);
        return Unit.INSTANCE;
    }

    private static final Unit toIncludedRanges$lambda$1(List $result, Range addedRange) {
        Intrinsics.checkNotNullParameter((Object)addedRange, (String)"addedRange");
        ((Collection)$result).add(addedRange);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(DocumentTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "Lcom/intellij/openapi/vcs/ex/BlockI;", "range", "Lcom/intellij/diff/util/Range;", "isDirty", "", "isTooBig", "<init>", "(Lcom/intellij/diff/util/Range;ZZ)V", "getRange", "()Lcom/intellij/diff/util/Range;", "isDirty$intellij_platform_diff_impl", "()Z", "isTooBig$intellij_platform_diff_impl", "data", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;", "getData", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;", "setData", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;)V", "start", "", "getStart", "()I", "end", "getEnd", "vcsStart", "getVcsStart", "vcsEnd", "getVcsEnd", "intellij.platform.diff.impl"})
    public static final class Block
    implements BlockI {
        @NotNull
        private final Range range;
        private final boolean isDirty;
        private final boolean isTooBig;
        @Nullable
        private BlockData data;

        public Block(@NotNull Range range, boolean isDirty, boolean isTooBig) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.range = range;
            this.isDirty = isDirty;
            this.isTooBig = isTooBig;
        }

        @NotNull
        public final Range getRange() {
            return this.range;
        }

        public final boolean isDirty$intellij_platform_diff_impl() {
            return this.isDirty;
        }

        public final boolean isTooBig$intellij_platform_diff_impl() {
            return this.isTooBig;
        }

        @Nullable
        public final BlockData getData() {
            return this.data;
        }

        public final void setData(@Nullable BlockData blockData) {
            this.data = blockData;
        }

        @Override
        public int getStart() {
            return this.range.start2;
        }

        @Override
        public int getEnd() {
            return this.range.end2;
        }

        @Override
        public int getVcsStart() {
            return this.range.start1;
        }

        @Override
        public int getVcsEnd() {
            return this.range.end1;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0003\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;", "", "Empty", "intellij.platform.diff.impl"})
    public static interface BlockData {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData$Empty;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;", "<init>", "()V", "intellij.platform.diff.impl"})
        public static final class Empty
        implements BlockData {
            @NotNull
            public static final Empty INSTANCE = new Empty();

            private Empty() {
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeData;", "", "textBeforeFreeze", "", "counter", "", "<init>", "(Ljava/lang/CharSequence;I)V", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/editor/Document;)V", "data", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeData;Ljava/lang/CharSequence;)V", "getTextBeforeFreeze", "()Ljava/lang/CharSequence;", "getCounter", "()I", "setCounter", "(I)V", "intellij.platform.diff.impl"})
    private static final class FreezeData {
        @NotNull
        private final CharSequence textBeforeFreeze;
        private int counter;

        public FreezeData(@NotNull CharSequence textBeforeFreeze, int counter) {
            Intrinsics.checkNotNullParameter((Object)textBeforeFreeze, (String)"textBeforeFreeze");
            this.textBeforeFreeze = textBeforeFreeze;
            this.counter = counter;
        }

        @NotNull
        public final CharSequence getTextBeforeFreeze() {
            return this.textBeforeFreeze;
        }

        public final int getCounter() {
            return this.counter;
        }

        public final void setCounter(int n) {
            this.counter = n;
        }

        public FreezeData(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            CharSequence charSequence = document.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            this(charSequence, 0);
        }

        public FreezeData(@NotNull FreezeData data, @NotNull CharSequence textBeforeFreeze) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)textBeforeFreeze, (String)"textBeforeFreeze");
            this(textBeforeFreeze, data.counter);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeHelper;", "", "<init>", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;)V", "data1", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeData;", "data2", "isFrozen", "", "side", "Lcom/intellij/diff/util/Side;", "freeze", "", "unfreeze", "getData", "setData", "data", "getFrozenContent", "", "setFrozenContent", "newContent", "onFreeze", "onUnfreeze", "intellij.platform.diff.impl"})
    @SourceDebugExtension(value={"SMAP\nDocumentTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$FreezeHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1363:1\n1869#2,2:1364\n1869#2,2:1366\n1869#2,2:1368\n1869#2,2:1370\n*S KotlinDebug\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$FreezeHelper\n*L\n509#1:1364,2\n513#1:1366,2\n517#1:1368,2\n521#1:1370,2\n*E\n"})
    private final class FreezeHelper {
        @Nullable
        private FreezeData data1;
        @Nullable
        private FreezeData data2;

        public final boolean isFrozen(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return this.getData(side) != null;
        }

        public final boolean isFrozen() {
            return this.isFrozen(Side.LEFT) || this.isFrozen(Side.RIGHT);
        }

        public final void freeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            boolean wasFrozen = this.isFrozen();
            FreezeData data = this.getData(side);
            if (data == null) {
                data = new FreezeData(RangesBuilder.get(side, DocumentTracker.this.getDocument1(), DocumentTracker.this.getDocument2()));
                this.setData(side, data);
                FreezeData freezeData = data;
                int n = freezeData.getCounter();
                freezeData.setCounter(n + 1);
                if (wasFrozen) {
                    this.onFreeze();
                }
                this.onFreeze(side);
            } else {
                FreezeData freezeData = data;
                int n = freezeData.getCounter();
                freezeData.setCounter(n + 1);
            }
        }

        public final void unfreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            FreezeData data = this.getData(side);
            if (data == null || data.getCounter() == 0) {
                FreezeData freezeData = this.data1;
                FreezeData freezeData2 = this.data2;
                LOG.error("DocumentTracker is not freezed: " + side + ", " + (freezeData != null ? freezeData.getCounter() : -1) + ", " + (freezeData2 != null ? freezeData2.getCounter() : -1));
                return;
            }
            FreezeData freezeData = data;
            int n = freezeData.getCounter();
            freezeData.setCounter(n + -1);
            if (data.getCounter() == 0) {
                DocumentTracker.this.unfreeze(side, data.getTextBeforeFreeze());
                this.setData(side, null);
                DocumentTracker.refreshDirty$default(DocumentTracker.this, false, false, 2, null);
                this.onUnfreeze(side);
                if (!this.isFrozen()) {
                    this.onUnfreeze();
                }
            }
        }

        private final FreezeData getData(Side side) {
            return RangesBuilder.get(side, this.data1, this.data2);
        }

        private final void setData(Side side, FreezeData data) {
            if (side.isLeft()) {
                this.data1 = data;
            } else {
                this.data2 = data;
            }
        }

        @Nullable
        public final CharSequence getFrozenContent(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            FreezeData freezeData = this.getData(side);
            return freezeData != null ? freezeData.getTextBeforeFreeze() : null;
        }

        public final void setFrozenContent(@NotNull Side side, @NotNull CharSequence newContent) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
            FreezeData freezeData = this.getData(side);
            Intrinsics.checkNotNull((Object)freezeData);
            this.setData(side, new FreezeData(freezeData, newContent));
        }

        private final void onFreeze(Side side) {
            Iterable $this$forEach$iv = DocumentTracker.this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Handler it = (Handler)element$iv;
                boolean bl = false;
                it.onFreeze(side);
            }
        }

        private final void onUnfreeze(Side side) {
            Iterable $this$forEach$iv = DocumentTracker.this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Handler it = (Handler)element$iv;
                boolean bl = false;
                it.onUnfreeze(side);
            }
        }

        private final void onFreeze() {
            Iterable $this$forEach$iv = DocumentTracker.this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Handler it = (Handler)element$iv;
                boolean bl = false;
                it.onFreeze();
            }
        }

        private final void onUnfreeze() {
            Iterable $this$forEach$iv = DocumentTracker.this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Handler it = (Handler)element$iv;
                boolean bl = false;
                it.onUnfreeze();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\u001e\u0010\b\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "", "onRangeRefreshed", "", "before", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "after", "", "onRangesChanged", "onRangeShifted", "mergeRanges", "", "block1", "block2", "merged", "afterBulkRangeChange", "isDirty", "onFreeze", "side", "Lcom/intellij/diff/util/Side;", "onUnfreeze", "intellij.platform.diff.impl"})
    public static interface Handler {
        default public void onRangeRefreshed(@NotNull Block before, @NotNull List<Block> after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter(after, (String)"after");
        }

        default public void onRangesChanged(@NotNull List<Block> before, @NotNull Block after) {
            Intrinsics.checkNotNullParameter(before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        }

        default public void onRangeShifted(@NotNull Block before, @NotNull Block after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        }

        default public boolean mergeRanges(@NotNull Block block1, @NotNull Block block2, @NotNull Block merged) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
            return true;
        }

        default public void afterBulkRangeChange(boolean isDirty) {
        }

        default public void onFreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        }

        default public void onUnfreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        }

        default public void onFreeze() {
        }

        default public void onUnfreeze() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ%\u0010\r\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "", "<init>", "()V", "myLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getMyLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "read", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "write", "isHeldByCurrentThread", "", "()Z", "intellij.platform.diff.impl"})
    @ApiStatus.Internal
    public static final class Lock {
        @NotNull
        private final ReentrantLock myLock = new ReentrantLock();

        @NotNull
        public final ReentrantLock getMyLock() {
            return this.myLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T read(@NotNull Function0<? extends T> task) {
            Object object;
            Intrinsics.checkNotNullParameter(task, (String)"task");
            boolean $i$f$read = false;
            java.util.concurrent.locks.Lock lock = this.getMyLock();
            lock.lock();
            try {
                object = task.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                lock.unlock();
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T write(@NotNull Function0<? extends T> task) {
            Object object;
            Intrinsics.checkNotNullParameter(task, (String)"task");
            boolean $i$f$write = false;
            java.util.concurrent.locks.Lock lock = this.getMyLock();
            lock.lock();
            try {
                object = task.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                lock.unlock();
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        public final boolean isHeldByCurrentThread() {
            return this.myLock.isHeldByCurrentThread();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "<init>", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;)V", "afterWriteActionFinished", "", "action", "", "intellij.platform.diff.impl"})
    private final class MyApplicationListener
    implements ApplicationListener {
        public void afterWriteActionFinished(@NotNull Object action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            DocumentTracker.refreshDirty$default(DocumentTracker.this, true, false, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J:\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "side", "Lcom/intellij/diff/util/Side;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;Lcom/intellij/diff/util/Side;Lcom/intellij/openapi/editor/Document;)V", "getSide", "()Lcom/intellij/diff/util/Side;", "line1", "", "line2", "switchDocument", "", "newDocument", "beforeDocumentChange", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "bulkUpdateStarting", "bulkUpdateFinished", "getAffectedRange", "Lkotlin/Triple;", "oldLine2", "newLine2", "isNewlineBefore", "", "isNewlineAfter", "intellij.platform.diff.impl"})
    @SourceDebugExtension(value={"SMAP\nDocumentTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$MyDocumentListener\n+ 2 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$Lock\n*L\n1#1,1363:1\n544#2:1364\n*S KotlinDebug\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$MyDocumentListener\n*L\n399#1:1364\n*E\n"})
    private final class MyDocumentListener
    implements DocumentListener {
        @NotNull
        private final Side side;
        @NotNull
        private Document document;
        private int line1;
        private int line2;

        public MyDocumentListener(@NotNull Side side, Document document) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            this.side = side;
            this.document = document;
            this.document.addDocumentListener((DocumentListener)this, (Disposable)DocumentTracker.this);
            if (this.document.isInBulkUpdate()) {
                DocumentTracker.this.freeze(this.side);
            }
        }

        @NotNull
        public final Side getSide() {
            return this.side;
        }

        public final void switchDocument(@NotNull Document newDocument) {
            Intrinsics.checkNotNullParameter((Object)newDocument, (String)"newDocument");
            this.document.removeDocumentListener((DocumentListener)this);
            if (this.document.isInBulkUpdate()) {
                DocumentTracker.this.unfreeze(this.side);
            }
            this.document = newDocument;
            newDocument.addDocumentListener((DocumentListener)this, (Disposable)DocumentTracker.this);
            if (newDocument.isInBulkUpdate()) {
                DocumentTracker.this.freeze(this.side);
            }
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (DocumentTracker.this.isDisposed || DocumentTracker.this.freezeHelper.isFrozen(this.side)) {
                return;
            }
            this.line1 = this.document.getLineNumber(e.getOffset());
            this.line2 = e.getOldLength() == 0 ? this.line1 + 1 : this.document.getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void documentChanged(@NotNull DocumentEvent e) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (DocumentTracker.this.isDisposed || DocumentTracker.this.freezeHelper.isFrozen(this.side)) {
                return;
            }
            int newLine2 = 0;
            newLine2 = e.getNewLength() == 0 ? this.line1 + 1 : this.document.getLineNumber(e.getOffset() + e.getNewLength()) + 1;
            Triple<Integer, Integer, Integer> triple = this.getAffectedRange(this.line1, this.line2, newLine2, e);
            int startLine = ((Number)triple.component1()).intValue();
            int afterLength = ((Number)triple.component2()).intValue();
            int beforeLength = ((Number)triple.component3()).intValue();
            Lock lock = DocumentTracker.this.LOCK;
            DocumentTracker documentTracker = DocumentTracker.this;
            boolean $i$f$write = false;
            java.util.concurrent.locks.Lock lock2 = this_$iv.getMyLock();
            lock2.lock();
            try {
                boolean bl = false;
                documentTracker.tracker.rangeChanged(this.side, startLine, beforeLength, afterLength);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        public void bulkUpdateStarting(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            DocumentTracker.this.freeze(this.side);
        }

        public void bulkUpdateFinished(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            DocumentTracker.this.unfreeze(this.side);
        }

        private final Triple<Integer, Integer, Integer> getAffectedRange(int line1, int oldLine2, int newLine2, DocumentEvent e) {
            int afterLength = newLine2 - line1;
            int beforeLength = oldLine2 - line1;
            if (e.getOldLength() == 0 && e.getNewLength() != 0) {
                if (StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && this.isNewlineBefore(e)) {
                    return new Triple((Object)line1, (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
                if (StringUtil.startsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && this.isNewlineAfter(e)) {
                    return new Triple((Object)(line1 + 1), (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
            }
            if (e.getOldLength() != 0 && e.getNewLength() == 0) {
                if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && this.isNewlineBefore(e)) {
                    return new Triple((Object)line1, (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
                if (StringUtil.startsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && this.isNewlineAfter(e)) {
                    return new Triple((Object)(line1 + 1), (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
            }
            return new Triple((Object)line1, (Object)afterLength, (Object)beforeLength);
        }

        private final boolean isNewlineBefore(DocumentEvent e) {
            if (e.getOffset() == 0) {
                return true;
            }
            return e.getDocument().getImmutableCharSequence().charAt(e.getOffset() - 1) == '\n';
        }

        private final boolean isNewlineAfter(DocumentEvent e) {
            if (e.getOffset() + e.getNewLength() == e.getDocument().getImmutableCharSequence().length()) {
                return true;
            }
            return e.getDocument().getImmutableCharSequence().charAt(e.getOffset() + e.getNewLength()) == '\n';
        }
    }
}

